/*
 * Decompiled with CFR 0.152.
 */
package org.joni.encoding.specific;

import org.joni.IntHolder;
import org.joni.encoding.MultiByteEncoding;
import org.joni.encoding.specific.ASCIIEncoding;

public final class BIG5Encoding
extends MultiByteEncoding {
    static final boolean[] BIG5_CAN_BE_TRAIL_TABLE = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false};
    static final int[] Big5EncLen = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1};
    public static final BIG5Encoding INSTANCE = new BIG5Encoding();

    protected BIG5Encoding() {
        super(Big5EncLen, ASCIIEncoding.AsciiCtypeTable);
    }

    public String toString() {
        return "Big5";
    }

    public int maxLength() {
        return 2;
    }

    public int minLength() {
        return 1;
    }

    public boolean isFixedWidth() {
        return false;
    }

    public int mbcToCode(byte[] bytes, int p, int end) {
        return this.mbnMbcToCode(bytes, p, end);
    }

    public int codeToMbcLength(int code) {
        return this.mb2CodeToMbcLength(code);
    }

    public int codeToMbc(int code, byte[] bytes, int p) {
        return this.mb2CodeToMbc(code, bytes, p);
    }

    public int mbcCaseFold(int flag, byte[] bytes, IntHolder pp, int end, byte[] lower) {
        return this.mbnMbcCaseFold(flag, bytes, pp, end, lower);
    }

    public boolean isCodeCType(int code, int ctype) {
        return this.mb2IsCodeCType(code, ctype);
    }

    private static boolean isBig5MbFirst(int b) {
        return Big5EncLen[b] > 1;
    }

    private static boolean isBig5MbTrail(int b) {
        return BIG5_CAN_BE_TRAIL_TABLE[b];
    }

    public int leftAdjustCharHead(byte[] bytes, int p, int end) {
        int len;
        if (end <= p) {
            return end;
        }
        int p_ = end;
        if (BIG5Encoding.isBig5MbTrail(bytes[p_] & 0xFF)) {
            while (p_ > p) {
                if (BIG5Encoding.isBig5MbFirst(bytes[--p_] & 0xFF)) continue;
                ++p_;
                break;
            }
        }
        if (p_ + (len = this.length(bytes[p_])) > end) {
            return p_;
        }
        return (p_ += len) + (end - p_ & 0xFFFFFFFE);
    }

    public int[] ctypeCodeRange(int ctype, IntHolder sbOut) {
        return null;
    }

    public boolean isReverseMatchAllowed(byte[] bytes, int p, int end) {
        int c = bytes[p] & 0xFF;
        return BIG5Encoding.isBig5MbTrail(c);
    }
}

