/*******************************************************************************
 * Copyright (c) 2000, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.ui.synchronize.RefreshParticipantJob.IChangeDescription;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;

/**
 * An event describing the lifecycle of a {@link Subscriber#refresh(IResource[], int, IProgressMonitor)} operation.
 * <p>
 * This interface is not intended to be implemented by clients.
 * </p>
 * @see Subscriber
 * @see IRefreshSubscriberListener
 * @since 3.0
 */
public interface IRefreshEvent {	
	/**
	 * Status code indicating that the refresh has changes to the selected
	 * resources that were refreshed.
	 */
	public static final int STATUS_CHANGES = 1;
	
	/**
	 * Status code indicating that the refresh didn't find changes on the selected
	 * resources that were refreshed.
	 */
	public static final int STATUS_NO_CHANGES = 2;
	
	/**
	 * Constant which identifies this event as generated by a scheduled refresh.
	 * @see #getRefreshType()
	 */
	public static final int SCHEDULED_REFRESH = 1; 
	
	/**
	 * Constant which identifies the event as a refresh initiated by a user.
	 * @see #getRefreshType() 
	 */
	public static final int USER_REFRESH = 2;
	
	/**
	 * Returns the type of this event. The returned value will be one of <code>SCHEDULED_REFRESH</code>, 
	 * <code>USER_REFRESH</code>.
	 *
	 * @return the type of this event
	 * @see #SCHEDULED_REFRESH
	 * @see #USER_REFRESH
	 */
	public int getRefreshType();
	
	/**
	 * The participant that was refreshed.
	 * 
	 * @return the participant that was refreshed.
	 */
	public ISynchronizeParticipant getParticipant();
	
	/**
	 * Return a description of the changes found.
	 * 
	 * @return a description of the changes found
	 */
	public IChangeDescription getChangeDescription();
	
	/**
	 * The time, in milliseconds, at which the refresh was started. 
	 * 
	 * @return the time, in milliseconds, at which the refresh was started.
	 */
	public long getStartTime();
	
	/**
	 * The time, in milliseconds, at which the refresh was completed. 
	 * 
	 * @return the time, in milliseconds, at which the refresh was completed.
	 */
	public long getStopTime();
	
	/**
	 * Returns the status of the refresh operation. This can be used to determine if the
	 * refresh completed successfully, with an error, or was canceled.
	 * 
	 * @return the status of the refresh operation.
	 */
	public IStatus getStatus();

	/**
	 * Set whether this event is being presented in a progress view link
	 * @param isLink 
	 */
	public void setIsLink(boolean isLink);
	
	/**
	 * Return whether this event is being displayed in a link.
	 * @return whether this event is being displayed in a link
	 */
	public boolean isLink();
}
