/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal.swt;

import org.eclipse.jface.internal.databinding.provisional.BindingException;
import org.eclipse.jface.internal.databinding.provisional.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.observable.ObservableTracker;
import org.eclipse.jface.internal.databinding.provisional.observable.list.AbstractObservableList;

public abstract class SWTObservableList
extends AbstractObservableList {
    public void add(int index, Object element) {
        int size = this.doGetSize();
        if (index < 0 || index > size) {
            index = size;
        }
        String[] newItems = new String[size + 1];
        System.arraycopy(this.getItems(), 0, newItems, 0, index);
        newItems[index] = (String)element;
        System.arraycopy(this.getItems(), index, newItems, index + 1, size - index);
        this.setItems(newItems);
        this.fireListChange(Diffs.createListDiff(Diffs.createListDiffEntry(index, true, element)));
    }

    public int doGetSize() {
        return this.getItemCount();
    }

    public Object get(int index) {
        this.getterCalled();
        return this.getItem(index);
    }

    public Object getElementType() {
        return String.class;
    }

    protected abstract String getItem(int var1);

    protected abstract int getItemCount();

    protected abstract String[] getItems();

    private void getterCalled() {
        ObservableTracker.getterCalled(this);
    }

    public Object remove(int index) {
        this.getterCalled();
        int size = this.doGetSize();
        if (index < 0 || index > size - 1) {
            throw new BindingException("Request to remove an element out of the collection bounds");
        }
        String[] newItems = new String[size - 1];
        String oldElement = this.getItem(index);
        if (newItems.length > 0) {
            System.arraycopy(this.getItems(), 0, newItems, 0, index);
            if (size - 1 > index) {
                System.arraycopy(this.getItems(), index + 1, newItems, index, size - index - 1);
            }
        }
        this.setItems(newItems);
        this.fireListChange(Diffs.createListDiff(Diffs.createListDiffEntry(index, false, oldElement)));
        return oldElement;
    }

    public Object set(int index, Object element) {
        String oldElement = this.getItem(index);
        this.setItem(index, (String)element);
        this.fireListChange(Diffs.createListDiff(Diffs.createListDiffEntry(index, false, oldElement), Diffs.createListDiffEntry(index, true, element)));
        return oldElement;
    }

    protected abstract void setItem(int var1, String var2);

    protected abstract void setItems(String[] var1);
}

