/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.internal.databinding.internal.beans.ListenerSupport;
import org.eclipse.jface.internal.databinding.provisional.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.observable.set.ObservableSet;
import org.eclipse.jface.util.Assert;

public class JavaBeanObservableSet
extends ObservableSet {
    private final Object object;
    private PropertyChangeListener collectionListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (!JavaBeanObservableSet.this.updating && JavaBeanObservableSet.this.descriptor.getName().equals(event.getPropertyName())) {
                HashSet newElements = new HashSet(Arrays.asList(JavaBeanObservableSet.this.getValues()));
                HashSet addedElements = new HashSet(newElements);
                HashSet removedElements = new HashSet(JavaBeanObservableSet.this.wrappedSet);
                removedElements.removeAll(newElements);
                addedElements.removeAll(JavaBeanObservableSet.this.wrappedSet);
                JavaBeanObservableSet.this.wrappedSet = newElements;
                JavaBeanObservableSet.this.fireSetChange(Diffs.createSetDiff(addedElements, removedElements));
            }
        }
    };
    private boolean updating = false;
    private PropertyDescriptor descriptor;
    private ListenerSupport collectionListenSupport = new ListenerSupport(this.collectionListener);

    public JavaBeanObservableSet(Object object, PropertyDescriptor descriptor, Class elementType) {
        super(new HashSet(), descriptor.getPropertyType());
        this.object = object;
        this.descriptor = descriptor;
        this.wrappedSet.addAll((Collection)Arrays.asList(this.getValues()));
    }

    protected void firstListenerAdded() {
        this.collectionListenSupport.hookListener(this.object);
    }

    protected void lastListenerRemoved() {
        if (this.collectionListenSupport != null) {
            this.collectionListenSupport.dispose();
        }
    }

    private Object primGetValues() {
        try {
            Method readMethod = this.descriptor.getReadMethod();
            if (!readMethod.isAccessible()) {
                readMethod.setAccessible(true);
            }
            return readMethod.invoke(this.object, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        Assert.isTrue((boolean)false, (String)"Could not read collection values");
        return null;
    }

    private Object[] getValues() {
        Collection list;
        Object[] values = null;
        Object result = this.primGetValues();
        values = this.descriptor.getPropertyType().isArray() ? (Object[])result : ((list = (Collection)result) != null ? list.toArray() : new Object[]{});
        return values;
    }
}

