/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class FormColors {
    public static final String TITLE = "org.eclipse.ui.forms.TITLE";
    public static final String BORDER = "org.eclipse.ui.forms.BORDER";
    public static final String SEPARATOR = "org.eclipse.ui.forms.SEPARATOR";
    public static final String TB_BG = "org.eclipse.ui.forms.TB_BG";
    public static final String TB_FG = "org.eclipse.ui.forms.TB_FG";
    public static final String TB_GBG = "org.eclipse.ui.forms.TB_GBG";
    public static final String TB_BORDER = "org.eclipse.ui.forms.TB_BORDER";
    public static final String TB_TOGGLE = "org.eclipse.ui.forms.TB_TOGGLE";
    public static final String TB_TOGGLE_HOVER = "org.eclipse.ui.forms.TB_TOGGLE_HOVER";
    protected Map colorRegistry = new HashMap(10);
    protected Color background;
    protected Color foreground;
    private boolean shared;
    protected Display display;
    protected Color border;
    private static final RGB WHITE = new RGB(255, 255, 255);
    private static final RGB BLACK = new RGB(0, 0, 0);

    public FormColors(Display display) {
        this.display = display;
        this.initialize();
    }

    public Display getDisplay() {
        return this.display;
    }

    protected void initialize() {
        this.background = this.display.getSystemColor(25);
        this.foreground = this.display.getSystemColor(24);
        this.initializeColorTable();
        this.updateBorderColor();
    }

    protected void initializeColorTable() {
        this.createTitleColor();
        this.createTwistieColors();
        this.createColor(SEPARATOR, this.getColor(TITLE).getRGB());
        RGB borderRGB = this.getSystemColor(35);
        this.createColor(BORDER, FormColors.blend(borderRGB, BLACK, 80));
    }

    public void initializeSectionToolBarColors() {
        if (this.getColor(TB_BG) != null) {
            return;
        }
        this.createTitleBarGradientColors();
        this.createTitleBarOutlineColors();
    }

    public RGB getSystemColor(int code) {
        return this.getDisplay().getSystemColor(code).getRGB();
    }

    public Color createColor(String key, RGB rgb) {
        return this.createColor(key, rgb.red, rgb.green, rgb.blue);
    }

    public Color getInactiveBackground() {
        String key = "__ncbg__";
        Color color = this.getColor(key);
        if (color == null) {
            RGB sel = this.getSystemColor(26);
            RGB ncbg = FormColors.blend(sel, this.getSystemColor(1), 5);
            color = this.createColor(key, ncbg);
        }
        return color;
    }

    public Color createColor(String key, int r, int g, int b) {
        Color c = new Color((Device)this.display, r, g, b);
        Color prevC = (Color)this.colorRegistry.get(key);
        if (prevC != null) {
            prevC.dispose();
        }
        this.colorRegistry.put(key, c);
        return c;
    }

    protected void updateBorderColor() {
        if (this.isWhiteBackground()) {
            this.border = this.getColor(BORDER);
        } else {
            this.border = this.display.getSystemColor(22);
            Color bg = this.getImpliedBackground();
            if (this.border.getRed() == bg.getRed() && this.border.getGreen() == bg.getGreen() && this.border.getBlue() == bg.getBlue()) {
                this.border = this.display.getSystemColor(17);
            }
        }
    }

    public void setBackground(Color bg) {
        this.background = bg;
        this.updateBorderColor();
    }

    public void setForeground(Color fg) {
        this.foreground = fg;
    }

    public Color getBackground() {
        return this.background;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Color getBorderColor() {
        return this.border;
    }

    public boolean isWhiteBackground() {
        Color bg = this.getImpliedBackground();
        return bg.getRed() == 255 && bg.getGreen() == 255 && bg.getBlue() == 255;
    }

    public Color getColor(String key) {
        return (Color)this.colorRegistry.get(key);
    }

    public void dispose() {
        Iterator e = this.colorRegistry.values().iterator();
        while (e.hasNext()) {
            ((Color)e.next()).dispose();
        }
        this.colorRegistry = null;
    }

    public void markShared() {
        this.shared = true;
    }

    public boolean isShared() {
        return this.shared;
    }

    public static RGB blend(RGB c1, RGB c2, int ratio) {
        int r = FormColors.blend(c1.red, c2.red, ratio);
        int g = FormColors.blend(c1.green, c2.green, ratio);
        int b = FormColors.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    public static boolean testAnyPrimaryColor(RGB rgb, int from, int to) {
        if (FormColors.testPrimaryColor(rgb.red, from, to)) {
            return true;
        }
        if (FormColors.testPrimaryColor(rgb.green, from, to)) {
            return true;
        }
        return FormColors.testPrimaryColor(rgb.blue, from, to);
    }

    public static boolean testTwoPrimaryColors(RGB rgb, int from, int to) {
        int total = 0;
        if (FormColors.testPrimaryColor(rgb.red, from, to)) {
            ++total;
        }
        if (FormColors.testPrimaryColor(rgb.green, from, to)) {
            ++total;
        }
        if (FormColors.testPrimaryColor(rgb.blue, from, to)) {
            ++total;
        }
        return total >= 2;
    }

    private static int blend(int v1, int v2, int ratio) {
        int b = (ratio * v1 + (100 - ratio) * v2) / 100;
        return Math.min(255, b);
    }

    private Color getImpliedBackground() {
        if (this.getBackground() != null) {
            return this.getBackground();
        }
        return this.getDisplay().getSystemColor(22);
    }

    private static boolean testPrimaryColor(int value, int from, int to) {
        return value > from && value < to;
    }

    private void createTitleColor() {
        RGB rgb = this.getSystemColor(26);
        if (FormColors.testTwoPrimaryColors(rgb, 120, 151)) {
            rgb = FormColors.blend(rgb, BLACK, 80);
        } else if (FormColors.testTwoPrimaryColors(rgb, 150, 256)) {
            rgb = FormColors.blend(rgb, BLACK, 50);
        }
        this.createColor(TITLE, rgb);
    }

    private void createTwistieColors() {
        RGB rgb = this.getColor(TITLE).getRGB();
        this.createColor(TB_TOGGLE, rgb);
        rgb = FormColors.blend(rgb, WHITE, 70);
        if (FormColors.testTwoPrimaryColors(rgb, 215, 226)) {
            rgb = FormColors.blend(rgb, BLACK, 90);
        } else if (FormColors.testTwoPrimaryColors(rgb, 225, 256)) {
            rgb = FormColors.blend(rgb, BLACK, 95);
        }
        this.createColor(TB_TOGGLE_HOVER, rgb);
    }

    private void createTitleBarGradientColors() {
        RGB tbBg = this.getSystemColor(32);
        Color bg = this.getImpliedBackground();
        RGB formBackground = bg.getRGB();
        tbBg = FormColors.blend(formBackground, tbBg, 77);
        if (this.isWhiteBackground()) {
            if (FormColors.testTwoPrimaryColors(tbBg, 241, 256)) {
                tbBg = FormColors.blend(tbBg, BLACK, 90);
            } else if (FormColors.testTwoPrimaryColors(tbBg, 0, 231)) {
                if (FormColors.testAnyPrimaryColor(tbBg, 214, 231)) {
                    tbBg = FormColors.blend(tbBg, WHITE, 95);
                } else if (FormColors.testAnyPrimaryColor(tbBg, 199, 215)) {
                    tbBg = FormColors.blend(tbBg, WHITE, 90);
                }
            }
        } else if (FormColors.testTwoPrimaryColors(tbBg, 209, 256)) {
            if (FormColors.testAnyPrimaryColor(tbBg, 210, 236)) {
                tbBg = FormColors.blend(tbBg, BLACK, 60);
            } else if (FormColors.testAnyPrimaryColor(tbBg, 235, 256)) {
                tbBg = FormColors.blend(tbBg, BLACK, 20);
            }
        }
        this.createColor(TB_BG, tbBg);
        RGB tbGbg = FormColors.blend(formBackground, tbBg, 50);
        this.createColor(TB_GBG, tbGbg);
    }

    private void createTitleBarOutlineColors() {
        RGB tbBorder = this.getSystemColor(35);
        if (this.isWhiteBackground()) {
            if (FormColors.testTwoPrimaryColors(tbBorder, 215, 256)) {
                if (FormColors.testAnyPrimaryColor(tbBorder, 215, 226)) {
                    tbBorder = FormColors.blend(tbBorder, BLACK, 90);
                } else if (FormColors.testAnyPrimaryColor(tbBorder, 225, 256)) {
                    tbBorder = FormColors.blend(tbBorder, BLACK, 70);
                }
            } else if (FormColors.testTwoPrimaryColors(tbBorder, 0, 186)) {
                if (FormColors.testAnyPrimaryColor(tbBorder, 175, 186)) {
                    tbBorder = FormColors.blend(tbBorder, WHITE, 95);
                } else if (FormColors.testTwoPrimaryColors(tbBorder, 154, 176)) {
                    tbBorder = FormColors.blend(tbBorder, WHITE, 90);
                } else if (FormColors.testTwoPrimaryColors(tbBorder, 124, 155)) {
                    tbBorder = FormColors.blend(tbBorder, WHITE, 80);
                }
            }
        } else if (FormColors.testTwoPrimaryColors(tbBorder, 200, 256)) {
            tbBorder = FormColors.blend(tbBorder, BLACK, 50);
        }
        this.createColor(TB_BORDER, tbBorder);
    }
}

