/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.xhtml;

import org.eclipse.help.internal.FilterableHelpElement;
import org.eclipse.help.internal.FilterableUAElement;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.xhtml.UAContentFilterProcessor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class UIContentFilterProcessor
extends UAContentFilterProcessor {
    public boolean isFilteredIn(String filter, String value, boolean isPositive) {
        boolean filtered_in = false;
        if (filter.equals("category")) {
            filtered_in = UIContentFilterProcessor.filterByCategory(value);
        } else if (filter.equals("activity")) {
            filtered_in = UIContentFilterProcessor.filterByActivity(value);
        } else {
            return super.isFilteredIn(filter, value, isPositive);
        }
        return isPositive ? filtered_in : !filtered_in;
    }

    public boolean isFilteredIn(FilterableUAElement element) {
        if (element instanceof FilterableHelpElement && !HelpBasePlugin.getActivitySupport().isFilteringEnabled()) {
            return true;
        }
        return super.isFilteredIn(element);
    }

    private static boolean filterByCategory(String categoryId) {
        IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
        IActivityManager activityManager = workbenchActivitySupport.getActivityManager();
        if (!activityManager.getCategory(categoryId).isDefined()) {
            return false;
        }
        boolean categoryIsEnabled = WorkbenchActivityHelper.isEnabled((IActivityManager)activityManager, (String)categoryId);
        return categoryIsEnabled;
    }

    private static boolean filterByActivity(String activityId) {
        IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
        IActivityManager activityManager = workbenchActivitySupport.getActivityManager();
        if (!activityManager.getActivity(activityId).isDefined()) {
            return false;
        }
        boolean activityIsEnabled = activityManager.getActivity(activityId).isEnabled();
        return activityIsEnabled;
    }
}

