/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.CategoryEvent;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandEvent;
import org.eclipse.core.commands.CommandManagerEvent;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ICategoryListener;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.core.commands.ICommandManagerListener;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.IExecutionListenerWithChecks;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.IParameterTypeListener;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.ParameterTypeEvent;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.SerializationException;
import org.eclipse.core.commands.common.HandleObjectManager;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.ListenerList;

public final class CommandManager
extends HandleObjectManager
implements ICategoryListener,
ICommandListener,
IParameterTypeListener {
    public static final String AUTOGENERATED_CATEGORY_ID = "org.eclipse.core.commands.categories.autogenerated";
    static final char ESCAPE_CHAR = '%';
    static final char ID_VALUE_CHAR = '=';
    static final char PARAMETER_END_CHAR = ')';
    static final char PARAMETER_SEPARATOR_CHAR = ',';
    static final char PARAMETER_START_CHAR = '(';
    private final Map categoriesById = new HashMap();
    private final Set definedCategoryIds = new HashSet();
    private final Set definedParameterTypeIds = new HashSet();
    private IExecutionListener executionListener = null;
    private ListenerList executionListeners = null;
    private final Map helpContextIdsByHandler = new WeakHashMap();
    private final Map parameterTypesById = new HashMap();

    private static final String unescape(String escapedText) throws SerializationException {
        StringBuffer buffer = null;
        int i = 0;
        while (i < escapedText.length()) {
            block8: {
                block9: {
                    char c;
                    block7: {
                        c = escapedText.charAt(i);
                        if (c == '%') break block7;
                        if (buffer != null) {
                            buffer.append(c);
                        }
                        break block8;
                    }
                    if (buffer == null) {
                        buffer = new StringBuffer(escapedText.substring(0, i));
                    }
                    if (++i >= escapedText.length()) break block9;
                    c = escapedText.charAt(i);
                    switch (c) {
                        case '%': 
                        case '(': 
                        case ')': 
                        case ',': 
                        case '=': {
                            buffer.append(c);
                            break block8;
                        }
                        default: {
                            throw new SerializationException("Invalid character '" + c + "' in escape sequence");
                        }
                    }
                }
                throw new SerializationException("Unexpected termination of escape sequence");
            }
            ++i;
        }
        if (buffer == null) {
            return escapedText;
        }
        return buffer.toString();
    }

    public final void addCommandManagerListener(ICommandManagerListener listener) {
        this.addListenerObject(listener);
    }

    public final void addExecutionListener(IExecutionListener listener) {
        if (listener == null) {
            throw new NullPointerException("Cannot add a null execution listener");
        }
        if (this.executionListeners == null) {
            this.executionListeners = new ListenerList(1);
            this.executionListener = new ExecutionListener();
            for (Command command : this.handleObjectsById.values()) {
                command.addExecutionListener(this.executionListener);
            }
        }
        this.executionListeners.add((Object)listener);
    }

    public final void categoryChanged(CategoryEvent categoryEvent) {
        if (categoryEvent.isDefinedChanged()) {
            Category category = categoryEvent.getCategory();
            String categoryId = category.getId();
            boolean categoryIdAdded = category.isDefined();
            if (categoryIdAdded) {
                this.definedCategoryIds.add(categoryId);
            } else {
                this.definedCategoryIds.remove(categoryId);
            }
            if (this.isListenerAttached()) {
                this.fireCommandManagerChanged(new CommandManagerEvent(this, null, false, false, categoryId, categoryIdAdded, true));
            }
        }
    }

    public final void commandChanged(CommandEvent commandEvent) {
        if (commandEvent.isDefinedChanged()) {
            Command command = commandEvent.getCommand();
            String commandId = command.getId();
            boolean commandIdAdded = command.isDefined();
            if (commandIdAdded) {
                this.definedHandleObjects.add(command);
            } else {
                this.definedHandleObjects.remove(command);
            }
            if (this.isListenerAttached()) {
                this.fireCommandManagerChanged(new CommandManagerEvent(this, commandId, commandIdAdded, true, null, false, false));
            }
        }
    }

    public final void defineUncategorizedCategory(String name, String description) {
        Category category = this.getCategory(AUTOGENERATED_CATEGORY_ID);
        category.define(name, description);
    }

    public final ParameterizedCommand deserialize(String serializedParameterizedCommand) throws NotDefinedException, SerializationException {
        String serializedParameters;
        String commandIdEscaped;
        int lparenPosition = this.unescapedIndexOf(serializedParameterizedCommand, '(');
        if (lparenPosition == -1) {
            commandIdEscaped = serializedParameterizedCommand;
            serializedParameters = null;
        } else {
            commandIdEscaped = serializedParameterizedCommand.substring(0, lparenPosition);
            if (serializedParameterizedCommand.charAt(serializedParameterizedCommand.length() - 1) != ')') {
                throw new SerializationException("Parentheses must be balanced in serialized ParameterizedCommand");
            }
            serializedParameters = serializedParameterizedCommand.substring(lparenPosition + 1, serializedParameterizedCommand.length() - 1);
        }
        String commandId = CommandManager.unescape(commandIdEscaped);
        Command command = this.getCommand(commandId);
        IParameter[] parameters = command.getParameters();
        Parameterization[] parameterizations = this.getParameterizations(serializedParameters, parameters);
        return new ParameterizedCommand(command, parameterizations);
    }

    private final void fireCommandManagerChanged(CommandManagerEvent event) {
        if (event == null) {
            throw new NullPointerException();
        }
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ICommandManagerListener listener = (ICommandManagerListener)listeners[i];
            listener.commandManagerChanged(event);
            ++i;
        }
    }

    public final Command[] getAllCommands() {
        return this.handleObjectsById.values().toArray(new Command[this.handleObjectsById.size()]);
    }

    public final Category getCategory(String categoryId) {
        if (categoryId == null) {
            return this.getCategory(AUTOGENERATED_CATEGORY_ID);
        }
        this.checkId(categoryId);
        Category category = (Category)this.categoriesById.get(categoryId);
        if (category == null) {
            category = new Category(categoryId);
            this.categoriesById.put(categoryId, category);
            category.addCategoryListener(this);
        }
        return category;
    }

    public final Command getCommand(String commandId) {
        this.checkId(commandId);
        Command command = (Command)this.handleObjectsById.get(commandId);
        if (command == null) {
            command = new Command(commandId);
            this.handleObjectsById.put(commandId, command);
            command.addCommandListener(this);
            if (this.executionListener != null) {
                command.addExecutionListener(this.executionListener);
            }
        }
        return command;
    }

    public final Category[] getDefinedCategories() {
        Category[] categories = new Category[this.definedCategoryIds.size()];
        Iterator categoryIdItr = this.definedCategoryIds.iterator();
        int i = 0;
        while (categoryIdItr.hasNext()) {
            String categoryId = (String)categoryIdItr.next();
            categories[i++] = this.getCategory(categoryId);
        }
        return categories;
    }

    public final Set getDefinedCategoryIds() {
        return Collections.unmodifiableSet(this.definedCategoryIds);
    }

    public final Set getDefinedCommandIds() {
        return this.getDefinedHandleObjectIds();
    }

    public final Command[] getDefinedCommands() {
        return this.definedHandleObjects.toArray(new Command[this.definedHandleObjects.size()]);
    }

    public final Set getDefinedParameterTypeIds() {
        return Collections.unmodifiableSet(this.definedParameterTypeIds);
    }

    public final ParameterType[] getDefinedParameterTypes() {
        ParameterType[] parameterTypes = new ParameterType[this.definedParameterTypeIds.size()];
        Iterator iterator = this.definedParameterTypeIds.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            String parameterTypeId = (String)iterator.next();
            parameterTypes[i++] = this.getParameterType(parameterTypeId);
        }
        return parameterTypes;
    }

    public final String getHelpContextId(Command command) throws NotDefinedException {
        String helpContextId;
        if (!command.isDefined()) {
            throw new NotDefinedException("The command is not defined. " + command.getId());
        }
        IHandler handler = command.getHandler();
        if (handler != null && (helpContextId = (String)this.helpContextIdsByHandler.get(handler)) != null) {
            return helpContextId;
        }
        return command.getHelpContextId();
    }

    private final Parameterization[] getParameterizations(String serializedParameters, IParameter[] parameters) throws SerializationException {
        int commaPosition;
        if (serializedParameters == null || serializedParameters.length() == 0) {
            return null;
        }
        if (parameters == null || parameters.length == 0) {
            return null;
        }
        ArrayList<Parameterization> paramList = new ArrayList<Parameterization>();
        block0: do {
            String parameterValue;
            String parameterId;
            String idEqualsValue;
            if ((commaPosition = this.unescapedIndexOf(serializedParameters, ',')) == -1) {
                idEqualsValue = serializedParameters;
            } else {
                idEqualsValue = serializedParameters.substring(0, commaPosition);
                serializedParameters = serializedParameters.substring(commaPosition + 1);
            }
            int equalsPosition = this.unescapedIndexOf(idEqualsValue, '=');
            if (equalsPosition == -1) {
                parameterId = CommandManager.unescape(idEqualsValue);
                parameterValue = null;
            } else {
                parameterId = CommandManager.unescape(idEqualsValue.substring(0, equalsPosition));
                parameterValue = CommandManager.unescape(idEqualsValue.substring(equalsPosition + 1));
            }
            int i = 0;
            while (i < parameters.length) {
                IParameter parameter = parameters[i];
                if (parameter.getId().equals(parameterId)) {
                    paramList.add(new Parameterization(parameter, parameterValue));
                    continue block0;
                }
                ++i;
            }
        } while (commaPosition != -1);
        return paramList.toArray(new Parameterization[paramList.size()]);
    }

    public final ParameterType getParameterType(String parameterTypeId) {
        this.checkId(parameterTypeId);
        ParameterType parameterType = (ParameterType)this.parameterTypesById.get(parameterTypeId);
        if (parameterType == null) {
            parameterType = new ParameterType(parameterTypeId);
            this.parameterTypesById.put(parameterTypeId, parameterType);
            parameterType.addListener(this);
        }
        return parameterType;
    }

    public final void parameterTypeChanged(ParameterTypeEvent parameterTypeEvent) {
        if (parameterTypeEvent.isDefinedChanged()) {
            ParameterType parameterType = parameterTypeEvent.getParameterType();
            String parameterTypeId = parameterType.getId();
            boolean parameterTypeIdAdded = parameterType.isDefined();
            if (parameterTypeIdAdded) {
                this.definedParameterTypeIds.add(parameterTypeId);
            } else {
                this.definedParameterTypeIds.remove(parameterTypeId);
            }
            this.fireCommandManagerChanged(new CommandManagerEvent(this, parameterTypeId, parameterTypeIdAdded, true));
        }
    }

    public final void removeCommandManagerListener(ICommandManagerListener listener) {
        this.removeListenerObject(listener);
    }

    public final void removeExecutionListener(IExecutionListener listener) {
        if (listener == null) {
            throw new NullPointerException("Cannot remove a null listener");
        }
        if (this.executionListeners == null) {
            return;
        }
        this.executionListeners.remove((Object)listener);
        if (this.executionListeners.isEmpty()) {
            this.executionListeners = null;
            for (Command command : this.handleObjectsById.values()) {
                command.removeExecutionListener(this.executionListener);
            }
            this.executionListener = null;
        }
    }

    public final void setHandlersByCommandId(Map handlersByCommandId) {
        Iterator commandIdItr = handlersByCommandId.keySet().iterator();
        while (commandIdItr.hasNext()) {
            this.getCommand((String)commandIdItr.next());
        }
        for (Command command : this.handleObjectsById.values()) {
            String commandId = command.getId();
            Object value = handlersByCommandId.get(commandId);
            if (value instanceof IHandler) {
                command.setHandler((IHandler)value);
                continue;
            }
            command.setHandler(null);
        }
    }

    public final void setHelpContextId(IHandler handler, String helpContextId) {
        if (handler == null) {
            throw new NullPointerException("The handler cannot be null");
        }
        if (helpContextId == null) {
            this.helpContextIdsByHandler.remove(handler);
        } else {
            this.helpContextIdsByHandler.put(handler, helpContextId);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final int unescapedIndexOf(String escapedText, char ch) {
        pos = escapedText.indexOf(ch);
        if (pos != 0) ** GOTO lbl7
        return pos;
lbl-1000:
        // 1 sources

        {
            if (escapedText.charAt(pos - 1) != '%') {
                return pos;
            }
            pos = escapedText.indexOf(ch, pos + 1);
lbl7:
            // 2 sources

            ** while (pos != -1)
        }
lbl8:
        // 1 sources

        return pos;
    }

    private final class ExecutionListener
    implements IExecutionListenerWithChecks {
        private ExecutionListener() {
        }

        public void notDefined(String commandId, NotDefinedException exception) {
            if (CommandManager.this.executionListeners != null) {
                Object[] listeners = CommandManager.this.executionListeners.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    Object object = listeners[i];
                    if (object instanceof IExecutionListenerWithChecks) {
                        IExecutionListenerWithChecks listener = (IExecutionListenerWithChecks)object;
                        listener.notDefined(commandId, exception);
                    }
                    ++i;
                }
            }
        }

        public void notEnabled(String commandId, NotEnabledException exception) {
            if (CommandManager.this.executionListeners != null) {
                Object[] listeners = CommandManager.this.executionListeners.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    Object object = listeners[i];
                    if (object instanceof IExecutionListenerWithChecks) {
                        IExecutionListenerWithChecks listener = (IExecutionListenerWithChecks)object;
                        listener.notEnabled(commandId, exception);
                    }
                    ++i;
                }
            }
        }

        public final void notHandled(String commandId, NotHandledException exception) {
            if (CommandManager.this.executionListeners != null) {
                Object[] listeners = CommandManager.this.executionListeners.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    Object object = listeners[i];
                    if (object instanceof IExecutionListener) {
                        IExecutionListener listener = (IExecutionListener)object;
                        listener.notHandled(commandId, exception);
                    }
                    ++i;
                }
            }
        }

        public final void postExecuteFailure(String commandId, ExecutionException exception) {
            if (CommandManager.this.executionListeners != null) {
                Object[] listeners = CommandManager.this.executionListeners.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    Object object = listeners[i];
                    if (object instanceof IExecutionListener) {
                        IExecutionListener listener = (IExecutionListener)object;
                        listener.postExecuteFailure(commandId, exception);
                    }
                    ++i;
                }
            }
        }

        public final void postExecuteSuccess(String commandId, Object returnValue) {
            if (CommandManager.this.executionListeners != null) {
                Object[] listeners = CommandManager.this.executionListeners.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    Object object = listeners[i];
                    if (object instanceof IExecutionListener) {
                        IExecutionListener listener = (IExecutionListener)object;
                        listener.postExecuteSuccess(commandId, returnValue);
                    }
                    ++i;
                }
            }
        }

        public final void preExecute(String commandId, ExecutionEvent event) {
            if (CommandManager.this.executionListeners != null) {
                Object[] listeners = CommandManager.this.executionListeners.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    Object object = listeners[i];
                    if (object instanceof IExecutionListener) {
                        IExecutionListener listener = (IExecutionListener)object;
                        listener.preExecute(commandId, event);
                    }
                    ++i;
                }
            }
        }
    }
}

