/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.memory.provisional.AbstractAsyncTableRendering;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.renderings.MemorySegment;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;

public class AsyncTableRenderingCellModifier
implements ICellModifier {
    private boolean editActionInvoked = false;
    private AbstractAsyncTableRendering fRendering;
    private boolean fMBSupportsValueModification = false;

    public AsyncTableRenderingCellModifier(AbstractAsyncTableRendering rendering) {
        this.fRendering = rendering;
        Job job = new Job("AsyncTableRenderingCellModifier"){

            protected IStatus run(IProgressMonitor monitor) {
                AsyncTableRenderingCellModifier.this.fMBSupportsValueModification = AsyncTableRenderingCellModifier.this.fRendering.getMemoryBlock().supportsValueModification();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public boolean canModify(Object element, String property) {
        MemorySegment line;
        boolean canModify;
        block11: {
            block10: {
                block9: {
                    block8: {
                        canModify = true;
                        if (element instanceof MemorySegment) break block8;
                        return false;
                    }
                    if (this.editActionInvoked) break block9;
                    return false;
                }
                if (this.isValueModificationSupported()) break block10;
                return false;
            }
            line = (MemorySegment)((Object)element);
            if (!"address".equals(property)) break block11;
            return false;
        }
        try {
            int addressableSize = this.getAddressableSize();
            int offset = Integer.valueOf(property, 16) * addressableSize;
            MemoryByte[] bytes = line.getBytes(offset, this.fRendering.getBytesPerColumn());
            int i = 0;
            while (i < bytes.length) {
                if (!bytes[i].isWritable()) {
                    canModify = false;
                }
                ++i;
            }
            return canModify;
        }
        catch (NumberFormatException numberFormatException) {
            canModify = false;
            return canModify;
        }
    }

    private int getAddressableSize() {
        int addressableSize = this.fRendering.getAddressableSize();
        if (addressableSize < 1) {
            addressableSize = 1;
        }
        return addressableSize;
    }

    public Object getValue(Object element, String property) {
        if (!(element instanceof MemorySegment)) {
            return null;
        }
        MemorySegment line = (MemorySegment)((Object)element);
        try {
            if ("address".equals(property)) {
                return line.getAddress();
            }
            int offset = Integer.valueOf(property, 16) * this.getAddressableSize();
            MemoryByte[] memory = line.getBytes(offset, this.fRendering.getBytesPerColumn());
            offset = Integer.valueOf(property, 16);
            BigInteger address = line.getAddress().add(BigInteger.valueOf(offset));
            return this.fRendering.getString(this.fRendering.getRenderingId(), address, memory);
        }
        catch (NumberFormatException numberFormatException) {
            return "00";
        }
    }

    public void modify(Object element, final String property, final Object value) {
        MemorySegment segment = null;
        if (element instanceof TableItem) {
            Object data = ((TableItem)element).getData();
            if (data != null && data instanceof MemorySegment) {
                segment = (MemorySegment)((Object)data);
            }
        } else if (element instanceof MemorySegment) {
            segment = (MemorySegment)((Object)element);
        }
        if (segment == null) {
            return;
        }
        if (!(value instanceof String)) {
            return;
        }
        final MemorySegment line = segment;
        Job job = new Job("Set Values"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IMemoryBlock memoryBlk = AsyncTableRenderingCellModifier.this.fRendering.getMemoryBlock();
                    int lineOffset = Integer.valueOf(property, 16);
                    BigInteger offset = AsyncTableRenderingCellModifier.this.getOffset(memoryBlk, line.getAddress(), lineOffset);
                    byte[] bytes = null;
                    String oldValue = (String)AsyncTableRenderingCellModifier.this.getValue((Object)line, property);
                    if (!oldValue.equals(value)) {
                        int offsetToLine = Integer.valueOf(property, 16) * AsyncTableRenderingCellModifier.this.getAddressableSize();
                        MemoryByte[] oldArray = line.getBytes(offsetToLine, AsyncTableRenderingCellModifier.this.fRendering.getBytesPerColumn());
                        BigInteger address = line.getAddress();
                        address = address.add(BigInteger.valueOf(offsetToLine));
                        bytes = AsyncTableRenderingCellModifier.this.fRendering.getBytes(AsyncTableRenderingCellModifier.this.fRendering.getRenderingId(), address, oldArray, (String)value);
                        if (bytes == null) {
                            return Status.OK_STATUS;
                        }
                        if (bytes.length == 0) {
                            return Status.OK_STATUS;
                        }
                        if (bytes.length <= oldArray.length) {
                            boolean changed = false;
                            int i = 0;
                            while (i < bytes.length) {
                                if (bytes[i] != oldArray[i].getValue()) {
                                    changed = true;
                                    break;
                                }
                                ++i;
                            }
                            if (!changed) {
                                return Status.OK_STATUS;
                            }
                        }
                    } else {
                        return Status.OK_STATUS;
                    }
                    byte[] newByteValues = bytes;
                    if (memoryBlk instanceof IMemoryBlockExtension) {
                        ((IMemoryBlockExtension)memoryBlk).setValue(offset, newByteValues);
                    } else {
                        memoryBlk.setValue(offset.longValue(), newByteValues);
                    }
                }
                catch (DebugException e) {
                    MemoryViewUtil.openError(DebugUIMessages.MemoryViewCellModifier_failure_title, DebugUIMessages.MemoryViewCellModifier_failed, (Exception)((Object)e));
                }
                catch (NumberFormatException numberFormatException) {
                    MemoryViewUtil.openError(DebugUIMessages.MemoryViewCellModifier_failure_title, String.valueOf(DebugUIMessages.MemoryViewCellModifier_failed) + "\n" + DebugUIMessages.MemoryViewCellModifier_data_is_invalid, null);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private BigInteger getOffset(IMemoryBlock memory, BigInteger lineAddress, int lineOffset) throws DebugException {
        BigInteger memoryAddr = memory instanceof IMemoryBlockExtension ? ((IMemoryBlockExtension)memory).getBigBaseAddress() : BigInteger.valueOf(memory.getStartAddress());
        if (memoryAddr == null) {
            memoryAddr = new BigInteger("0");
        }
        return lineAddress.subtract(memoryAddr).add(BigInteger.valueOf(lineOffset));
    }

    public void setEditActionInvoked(boolean editActionInvoked) {
        this.editActionInvoked = editActionInvoked;
    }

    private boolean isValueModificationSupported() {
        return this.fMBSupportsValueModification;
    }
}

