/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.internal.model.PluginParser;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.model.Factory;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.core.runtime.model.PluginModel;
import org.eclipse.core.runtime.model.PluginRegistryModel;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class RegistryLoader {
    private Factory factory;
    private boolean debug = false;
    private long lastTick = System.currentTimeMillis();

    private RegistryLoader(Factory factory, boolean debug) {
        this.debug = debug;
        this.factory = factory;
    }

    private void debug(String msg) {
        long thisTick = System.currentTimeMillis();
        System.out.println("RegistryLoader: " + msg + " [+" + (thisTick - this.lastTick) + "ms]");
        this.lastTick = thisTick;
    }

    private String[] getPathMembers(URL path) {
        String[] list = null;
        String protocol = path.getProtocol();
        if (protocol.equals("file")) {
            list = new File(path.getFile()).list();
        }
        return list == null ? new String[]{} : list;
    }

    private boolean parseProblem(String message) {
        this.factory.error((IStatus)new Status(2, "org.eclipse.core.runtime", 1, message, null));
        return true;
    }

    private PluginRegistryModel parseRegistry(URL[] pluginPath) {
        long startTick = System.currentTimeMillis();
        PluginRegistryModel result = this.processManifestFiles(pluginPath);
        if (InternalPlatform.DEBUG) {
            long endTick = System.currentTimeMillis();
            this.debug("Parsed Registry: " + (endTick - startTick) + "ms");
        }
        return result;
    }

    public static PluginRegistryModel parseRegistry(URL[] pluginPath, Factory factory, boolean debug) {
        return new RegistryLoader(factory, debug).parseRegistry(pluginPath);
    }

    private PluginModel processManifestFile(URL manifest) {
        InputStream is = null;
        try {
            is = manifest.openStream();
        }
        catch (IOException iOException) {
            if (this.debug) {
                this.debug("No plugin found for: " + manifest);
            }
            return null;
        }
        PluginModel result = null;
        try {
            try {
                InputSource in = new InputSource(is);
                in.setSystemId(manifest.getFile());
                result = new PluginParser(this.factory).parsePlugin(in);
            }
            finally {
                is.close();
            }
        }
        catch (SAXParseException sAXParseException) {
            this.factory.error((IStatus)new Status(2, "org.eclipse.core.runtime", 1, NLS.bind((String)Messages.parse_errorProcessing, (Object)manifest), null));
        }
        catch (Exception e) {
            this.factory.error((IStatus)new Status(2, "org.eclipse.core.runtime", 1, NLS.bind((String)Messages.parse_errorProcessing, (Object)(manifest + ":  " + e.getMessage())), null));
        }
        return result;
    }

    private PluginRegistryModel processManifestFiles(URL[] pluginPath) {
        PluginRegistryModel result = this.factory.createPluginRegistry();
        int i = 0;
        while (i < pluginPath.length) {
            this.processPluginPathEntry(result, pluginPath[i]);
            ++i;
        }
        return result;
    }

    private void processPluginPathEntry(PluginRegistryModel registry, URL location) {
        if (this.debug) {
            this.debug("Path - " + location);
        }
        if (location.getFile().endsWith("/")) {
            String[] members = this.getPathMembers(location);
            int j = 0;
            while (j < members.length) {
                boolean found = false;
                try {
                    found = this.processPluginPathFile(registry, new URL(location, String.valueOf(members[j]) + "/plugin.xml"));
                    if (!found) {
                        found = this.processPluginPathFile(registry, new URL(location, String.valueOf(members[j]) + "/fragment.xml"));
                    }
                }
                catch (MalformedURLException malformedURLException) {}
                if (this.debug) {
                    this.debug(found ? "Processed - " : "Processed (not found) - " + members[j]);
                }
                ++j;
            }
        } else {
            boolean found = this.processPluginPathFile(registry, location);
            if (this.debug) {
                this.debug(found ? "Processed - " : "Processed (not found) - " + location);
            }
        }
    }

    private boolean processPluginPathFile(PluginRegistryModel registry, URL location) {
        PluginModel entry = this.processManifestFile(location);
        if (entry == null) {
            return false;
        }
        if (!this.requiredPluginModel(entry, location)) {
            entry = null;
            return false;
        }
        entry.setVersion(this.getQualifiedVersion(entry, location));
        if (entry instanceof PluginDescriptorModel) {
            if (entry.getId() == null || entry.getVersion() == null) {
                return this.parseProblem(NLS.bind((String)Messages.parse_nullPluginIdentifier, (Object)location));
            }
            if (registry.getPlugin(entry.getId(), entry.getVersion()) != null) {
                return this.parseProblem(NLS.bind((String)Messages.parse_duplicatePlugin, (Object)entry.getId(), (Object)location));
            }
            registry.addPlugin((PluginDescriptorModel)entry);
        } else {
            if (entry.getId() == null || entry.getVersion() == null) {
                return this.parseProblem(NLS.bind((String)Messages.parse_nullFragmentIdentifier, (Object)location));
            }
            if (entry instanceof PluginFragmentModel) {
                registry.addFragment((PluginFragmentModel)entry);
            } else {
                return this.parseProblem(NLS.bind((String)Messages.parse_unknownEntry, (Object)location));
            }
        }
        String url = location.toString();
        url = url.substring(0, 1 + url.lastIndexOf(47));
        entry.setRegistry(registry);
        entry.setLocation(url);
        return true;
    }

    /*
     * Loose catch block
     */
    private String getQualifiedVersion(PluginModel entry, URL base) {
        String string;
        InputStream is;
        block22: {
            PluginVersionIdentifier v;
            String qualifier;
            block20: {
                String string2;
                block21: {
                    block18: {
                        String string3;
                        block19: {
                            if (entry == null || entry.getVersion() == null || entry.getId() == null) {
                                return null;
                            }
                            is = null;
                            URL manifest = null;
                            manifest = new URL(base, "buildmanifest.properties");
                            Properties props = new Properties();
                            is = manifest.openStream();
                            props.load(is);
                            String key = "plugin@" + entry.getId();
                            qualifier = props.getProperty(key);
                            if (qualifier != null) break block18;
                            string3 = entry.getVersion();
                            if (is == null) break block19;
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                        return string3;
                    }
                    v = new PluginVersionIdentifier(entry.getVersion());
                    if (v.getQualifierComponent().equals("")) break block20;
                    string2 = entry.getVersion();
                    if (is == null) break block21;
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                return string2;
            }
            string = new PluginVersionIdentifier(v.getMajorComponent(), v.getMinorComponent(), v.getServiceComponent(), qualifier).toString();
            if (is == null) break block22;
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return string;
        catch (Exception exception) {
            String string4;
            block23: {
                try {
                    string4 = entry.getVersion();
                    if (is == null) break block23;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            return string4;
        }
    }

    private boolean requiredPluginModel(PluginModel plugin, URL location) {
        int versionLength;
        String name = plugin.getName();
        String id = plugin.getId();
        String version = plugin.getVersion();
        int nameLength = name == null ? 0 : name.length();
        int idLength = id == null ? 0 : id.length();
        int n = versionLength = version == null ? 0 : version.length();
        if (nameLength <= 0) {
            this.parseProblem(NLS.bind((String)Messages.parse_missingPluginName, (Object)location));
            return false;
        }
        if (idLength <= 0) {
            this.parseProblem(NLS.bind((String)Messages.parse_missingPluginId, (Object)location));
            return false;
        }
        if (versionLength <= 0) {
            this.parseProblem(NLS.bind((String)Messages.parse_missingPluginVersion, (Object)location));
            return false;
        }
        if (plugin instanceof PluginFragmentModel) {
            int pNameVersion;
            String pluginName = ((PluginFragmentModel)plugin).getPlugin();
            String pluginVersion = ((PluginFragmentModel)plugin).getPluginVersion();
            int pNameLength = pluginName == null ? 0 : pluginName.length();
            int n2 = pNameVersion = pluginVersion == null ? 0 : pluginVersion.length();
            if (pNameLength <= 0) {
                this.parseProblem(NLS.bind((String)Messages.parse_missingFPName, (Object)location));
                return false;
            }
            if (pNameVersion <= 0) {
                this.parseProblem(NLS.bind((String)Messages.parse_missingFPVersion, (Object)location));
                return false;
            }
        }
        return true;
    }
}

