/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.core.resources.IStorage;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.refactoring.nls.AccessorClassReference;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSHintHelper;
import org.eclipse.jdt.internal.corext.refactoring.nls.PropertyFileDocumentModel;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertyKeyHyperlinkDetector;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class NLSKeyHyperlink
implements IHyperlink {
    private IRegion fRegion;
    private AccessorClassReference fAccessorClassReference;
    private IEditorPart fEditor;
    private final String fKeyName;

    public NLSKeyHyperlink(IRegion region, String keyName, AccessorClassReference ref, IEditorPart editor) {
        Assert.isNotNull((Object)region);
        Assert.isNotNull((Object)keyName);
        Assert.isNotNull((Object)ref);
        Assert.isNotNull((Object)editor);
        this.fRegion = region;
        this.fKeyName = keyName;
        this.fAccessorClassReference = ref;
        this.fEditor = editor;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public void open() {
        IEditorPart editor;
        IStorage propertiesFile = null;
        try {
            ITypeBinding typeBinding = this.fAccessorClassReference.getBinding();
            propertiesFile = NLSHintHelper.getResourceBundle(typeBinding.getJavaElement().getJavaProject(), this.fAccessorClassReference);
        }
        catch (JavaModelException javaModelException) {}
        if (propertiesFile == null) {
            this.showErrorInStatusLine(this.fEditor, JavaEditorMessages.Editor_OpenPropertiesFile_error_fileNotFound_dialogMessage);
            return;
        }
        try {
            editor = EditorUtility.openInEditor(propertiesFile, true);
        }
        catch (PartInitException partInitException) {
            this.handleOpenPropertiesFileFailed(propertiesFile);
            return;
        }
        catch (JavaModelException javaModelException) {
            this.handleOpenPropertiesFileFailed(propertiesFile);
            return;
        }
        if (editor instanceof ITextEditor) {
            IRegion region = null;
            boolean found = false;
            IEditorInput editorInput = editor.getEditorInput();
            IDocument document = ((ITextEditor)editor).getDocumentProvider().getDocument((Object)editorInput);
            if (document != null) {
                FindReplaceDocumentAdapter finder = new FindReplaceDocumentAdapter(document);
                PropertyKeyHyperlinkDetector detector = new PropertyKeyHyperlinkDetector((ITextEditor)editor);
                String key = PropertyFileDocumentModel.unwindEscapeChars(this.fKeyName);
                int offset = document.getLength() - 1;
                try {
                    while (!found && offset >= 0) {
                        region = finder.find(offset, key, false, true, false, false);
                        if (region == null) {
                            offset = -1;
                            continue;
                        }
                        IHyperlink[] hyperlinks = detector.detectHyperlinks(null, region, false);
                        if (hyperlinks != null) {
                            int i = 0;
                            while (i < hyperlinks.length) {
                                IRegion hyperlinkRegion = hyperlinks[i].getHyperlinkRegion();
                                found = key.equals(document.get(hyperlinkRegion.getOffset(), hyperlinkRegion.getLength()));
                                ++i;
                            }
                        } else if (document instanceof IDocumentExtension3) {
                            ITypedRegion partition = null;
                            partition = ((IDocumentExtension3)document).getPartition("___pf_partitioning", region.getOffset(), false);
                            found = "__dftl_partition_content_type".equals(partition.getType()) && key.equals(document.get(partition.getOffset(), partition.getLength()).trim());
                        }
                        offset = offset == region.getOffset() ? -1 : region.getOffset();
                    }
                }
                catch (BadLocationException badLocationException) {
                    found = false;
                }
                catch (BadPartitioningException badPartitioningException) {
                    found = false;
                }
            }
            if (found) {
                EditorUtility.revealInEditor(editor, region);
            } else {
                EditorUtility.revealInEditor(editor, 0, 0);
                this.showErrorInStatusLine(editor, Messages.format(JavaEditorMessages.Editor_OpenPropertiesFile_error_keyNotFound, this.fKeyName));
            }
        }
    }

    private void showErrorInStatusLine(IEditorPart editor, final String message) {
        Display display = this.fEditor.getSite().getShell().getDisplay();
        display.beep();
        final IEditorStatusLine statusLine = (IEditorStatusLine)editor.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    statusLine.setMessage(true, message, null);
                }
            });
        }
    }

    private void handleOpenPropertiesFileFailed(IStorage propertiesFile) {
        this.showErrorInStatusLine(this.fEditor, Messages.format(JavaEditorMessages.Editor_OpenPropertiesFile_error_openEditor_dialogMessage, propertiesFile.getFullPath().toOSString()));
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return null;
    }
}

