/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CreateCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MultiStateCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.PullUpRefactoringProcessor;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextEditBasedChangeManager;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditCopier;
import org.eclipse.text.edits.TextEditGroup;

public final class ExtractSupertypeProcessor
extends PullUpRefactoringProcessor {
    private static final String ATTRIBUTE_EXTRACT = "extract";
    private static final String ATTRIBUTE_TYPES = "types";
    private static final String ID_EXTRACT_SUPERTYPE = "org.eclipse.jdt.ui.extract.superclass";
    private static final GroupCategorySet SET_EXTRACT_SUPERTYPE = new GroupCategorySet(new GroupCategory("org.eclipse.jdt.internal.corext.extractSupertype", RefactoringCoreMessages.ExtractSupertypeProcessor_category_name, RefactoringCoreMessages.ExtractSupertypeProcessor_category_description));
    private final Map fLayerChanges = new HashMap();
    private IType[] fPossibleCandidates = new IType[0];
    private String fSuperSource;
    private String fTypeName = "";
    private IType[] fTypesToExtract = new IType[0];

    public ExtractSupertypeProcessor(IMember[] members, CodeGenerationSettings settings) {
        super(members, settings, true);
        IType declaring;
        if (members != null && (declaring = this.getDeclaringType()) != null) {
            this.fTypesToExtract = new IType[]{declaring};
        }
    }

    protected final RefactoringStatus checkDeclaringSuperTypes(IProgressMonitor monitor) throws JavaModelException {
        return new RefactoringStatus();
    }

    protected CompilationUnitRewrite getCompilationUnitRewrite(Map rewrites, ICompilationUnit unit) {
        Assert.isNotNull((Object)rewrites);
        Assert.isNotNull((Object)unit);
        CompilationUnitRewrite rewrite = (CompilationUnitRewrite)rewrites.get(unit);
        if (rewrite == null) {
            rewrite = new CompilationUnitRewrite(this.fOwner, unit);
            rewrite.rememberContent();
            rewrites.put(unit, rewrite);
        }
        return rewrite;
    }

    public RefactoringStatus checkExtractedCompilationUnit() {
        RefactoringStatus status = new RefactoringStatus();
        ICompilationUnit cu = this.getDeclaringType().getCompilationUnit();
        if (this.fTypeName == null || "".equals(this.fTypeName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_Choose_name);
        }
        status.merge(Checks.checkTypeName(this.fTypeName));
        if (status.hasFatalError()) {
            return status;
        }
        status.merge(Checks.checkCompilationUnitName(JavaModelUtil.getRenamedCUName(cu, this.fTypeName)));
        if (status.hasFatalError()) {
            return status;
        }
        status.merge(Checks.checkCompilationUnitNewName(cu, this.fTypeName));
        return status;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.ExtractSupertypeProcessor_checking);
            status.merge(this.checkExtractedCompilationUnit());
            if (status.hasFatalError()) {
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            RefactoringStatus refactoringStatus = super.checkFinalConditions((IProgressMonitor)new SubProgressMonitor(monitor, 1), context);
            return refactoringStatus;
        }
        finally {
            monitor.done();
        }
    }

    public IType computeExtractedType(String name) {
        if (name != null && !name.equals("")) {
            IType declaring = this.getDeclaringType();
            try {
                ICompilationUnit[] units = declaring.getPackageFragment().getCompilationUnits(this.fOwner);
                String newName = JavaModelUtil.getRenamedCUName(declaring.getCompilationUnit(), name);
                ICompilationUnit result = null;
                int index = 0;
                while (index < units.length) {
                    if (units[index].getElementName().equals(newName)) {
                        result = units[index];
                    }
                    ++index;
                }
                if (result != null) {
                    IType type = result.getType(name);
                    this.setDestinationType(type);
                    return type;
                }
            }
            catch (JavaModelException exception) {
                JavaPlugin.log(exception);
            }
        }
        return null;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            HashMap<String, String> arguments = new HashMap<String, String>();
            String project = null;
            IType declaring = this.getDeclaringType();
            IJavaProject javaProject = declaring.getJavaProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            int flags = 589830;
            try {
                if (declaring.isLocal() || declaring.isAnonymous()) {
                    flags |= 0x40000;
                }
            }
            catch (JavaModelException exception) {
                JavaPlugin.log(exception);
            }
            String description = Messages.format(RefactoringCoreMessages.ExtractSupertypeProcessor_descriptor_description_short, this.fTypeName);
            String header = Messages.format(RefactoringCoreMessages.ExtractSupertypeProcessor_descriptor_description, new String[]{JavaElementLabels.getElementLabel((IJavaElement)this.fDestinationType, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getElementLabel((IJavaElement)this.fCachedDeclaringType, JavaElementLabels.ALL_FULLY_QUALIFIED)});
            JavaRefactoringDescriptorComment comment = new JavaRefactoringDescriptorComment(this, header);
            IType[] types = this.getTypesToExtract();
            String[] settings = new String[types.length];
            int index = 0;
            while (index < settings.length) {
                settings[index] = JavaElementLabels.getElementLabel((IJavaElement)types[index], JavaElementLabels.ALL_FULLY_QUALIFIED);
                ++index;
            }
            comment.addSetting(JavaRefactoringDescriptorComment.createCompositeSetting(RefactoringCoreMessages.ExtractSupertypeProcessor_subtypes_pattern, settings));
            comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractSupertypeProcessor_refactored_element_pattern, JavaElementLabels.getElementLabel((IJavaElement)this.fDestinationType, JavaElementLabels.ALL_FULLY_QUALIFIED)));
            settings = new String[this.fMembersToMove.length];
            index = 0;
            while (index < settings.length) {
                settings[index] = JavaElementLabels.getElementLabel((IJavaElement)this.fMembersToMove[index], JavaElementLabels.ALL_FULLY_QUALIFIED);
                ++index;
            }
            comment.addSetting(JavaRefactoringDescriptorComment.createCompositeSetting(RefactoringCoreMessages.ExtractInterfaceProcessor_extracted_members_pattern, settings));
            this.addSuperTypeSettings(comment, true);
            JavaRefactoringDescriptor descriptor = new JavaRefactoringDescriptor(ID_EXTRACT_SUPERTYPE, project, description, comment.asString(), arguments, flags);
            arguments.put("name", this.fTypeName);
            arguments.put("input", descriptor.elementToHandle((IJavaElement)this.getDeclaringType()));
            arguments.put("replace", Boolean.valueOf(this.fReplace).toString());
            arguments.put("instanceof", Boolean.valueOf(this.fInstanceOf).toString());
            arguments.put("stubs", Boolean.valueOf(this.fCreateMethodStubs).toString());
            arguments.put(ATTRIBUTE_EXTRACT, new Integer(this.fMembersToMove.length).toString());
            int offset = 0;
            while (offset < this.fMembersToMove.length) {
                arguments.put("element" + (offset + 1), descriptor.elementToHandle((IJavaElement)this.fMembersToMove[offset]));
                ++offset;
            }
            arguments.put("delete", new Integer(this.fDeletedMethods.length).toString());
            offset = 0;
            while (offset < this.fDeletedMethods.length) {
                arguments.put("element" + (offset + this.fMembersToMove.length + 1), descriptor.elementToHandle((IJavaElement)this.fDeletedMethods[offset]));
                ++offset;
            }
            arguments.put("abstract", new Integer(this.fAbstractMethods.length).toString());
            offset = 0;
            while (offset < this.fAbstractMethods.length) {
                arguments.put("element" + (offset + this.fMembersToMove.length + this.fDeletedMethods.length + 1), descriptor.elementToHandle((IJavaElement)this.fAbstractMethods[offset]));
                ++offset;
            }
            arguments.put(ATTRIBUTE_TYPES, new Integer(this.fTypesToExtract.length).toString());
            offset = 0;
            while (offset < this.fTypesToExtract.length) {
                arguments.put("element" + (offset + this.fMembersToMove.length + this.fDeletedMethods.length + this.fAbstractMethods.length + 1), descriptor.elementToHandle((IJavaElement)this.fTypesToExtract[offset]));
                ++offset;
            }
            DynamicValidationRefactoringChange change = new DynamicValidationRefactoringChange(descriptor, RefactoringCoreMessages.ExtractSupertypeProcessor_extract_supertype, (Change[])this.fChangeManager.getAllChanges());
            IFile file = ResourceUtil.getFile(declaring.getCompilationUnit());
            if (this.fSuperSource != null && this.fSuperSource.length() > 0) {
                change.add(new CreateCompilationUnitChange(declaring.getPackageFragment().getCompilationUnit(JavaModelUtil.getRenamedCUName(declaring.getCompilationUnit(), this.fTypeName)), this.fSuperSource, file.getCharset(false)));
            }
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = change;
            return dynamicValidationRefactoringChange;
        }
        finally {
            monitor.done();
            this.clearCaches();
        }
    }

    protected final RefactoringStatus createExtractedSuperType(IType superType, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)monitor);
        this.fSuperSource = null;
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing, 20);
            IType declaring = this.getDeclaringType();
            CompilationUnitRewrite declaringRewrite = new CompilationUnitRewrite(this.fOwner, declaring.getCompilationUnit());
            AbstractTypeDeclaration declaringDeclaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(declaring, declaringRewrite.getRoot());
            if (declaringDeclaration != null) {
                String name = JavaModelUtil.getRenamedCUName(declaring.getCompilationUnit(), this.fTypeName);
                ICompilationUnit original = declaring.getPackageFragment().getCompilationUnit(name);
                ICompilationUnit copy = this.getSharedWorkingCopy(original.getPrimary(), (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                this.fSuperSource = this.createSuperTypeSource(copy, superType, declaringDeclaration, status, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                if (this.fSuperSource != null) {
                    copy.getBuffer().setContents(this.fSuperSource);
                    JavaModelUtil.reconcile(copy);
                }
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    protected final void createModifiedSubType(ICompilationUnit unit, CompilationUnit root, IType extractedType, ITypeBinding extractedBinding, AbstractTypeDeclaration subDeclaration, RefactoringStatus status) {
        Assert.isNotNull((Object)unit);
        Assert.isNotNull((Object)subDeclaration);
        Assert.isNotNull((Object)extractedType);
        try {
            CompilationUnitRewrite rewrite = new CompilationUnitRewrite(this.fOwner, unit, root);
            this.createTypeSignature(rewrite, subDeclaration, extractedType, extractedBinding, (IProgressMonitor)new NullProgressMonitor());
            Document document = new Document(unit.getBuffer().getContents());
            CompilationUnitChange change = rewrite.createChange();
            if (change != null) {
                this.fLayerChanges.put(unit.getPrimary(), change);
                TextEdit edit = change.getEdit();
                if (edit != null) {
                    TextEditCopier copier = new TextEditCopier(edit);
                    TextEdit copy = copier.perform();
                    copy.apply((IDocument)document, 0);
                }
            }
            ICompilationUnit copy = this.getSharedWorkingCopy(unit, (IProgressMonitor)new NullProgressMonitor());
            copy.getBuffer().setContents(document.get());
            JavaModelUtil.reconcile(copy);
        }
        catch (CoreException exception) {
            JavaPlugin.log(exception);
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
        }
        catch (MalformedTreeException exception) {
            JavaPlugin.log(exception);
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
        }
        catch (BadLocationException exception) {
            JavaPlugin.log(exception);
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
        }
    }

    protected final void createNecessaryConstructors(CompilationUnitRewrite targetRewrite, IType superType, AbstractTypeDeclaration targetDeclaration, RefactoringStatus status) {
        ITypeBinding binding;
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)targetDeclaration);
        if (superType != null && (binding = targetDeclaration.resolveBinding()) != null && binding.isClass()) {
            IMethodBinding[] bindings = StubUtility2.getVisibleConstructors(binding, true, true);
            int deprecationCount = 0;
            int i = 0;
            while (i < bindings.length) {
                if (bindings[i].isDeprecated()) {
                    ++deprecationCount;
                }
                ++i;
            }
            ListRewrite rewrite = targetRewrite.getASTRewrite().getListRewrite((ASTNode)targetDeclaration, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
            if (rewrite != null) {
                boolean createDeprecated = deprecationCount == bindings.length;
                int i2 = 0;
                while (i2 < bindings.length) {
                    IMethodBinding curr = bindings[i2];
                    if (!curr.isDeprecated() || createDeprecated) {
                        try {
                            MethodDeclaration stub = StubUtility2.createConstructorStub(targetRewrite.getCu(), targetRewrite.getASTRewrite(), targetRewrite.getImportRewrite(), curr, binding.getName(), 1, false, false, this.fSettings);
                            if (stub != null) {
                                rewrite.insertLast((ASTNode)stub, null);
                            }
                        }
                        catch (CoreException exception) {
                            JavaPlugin.log(exception);
                            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
                        }
                    }
                    ++i2;
                }
            }
        }
    }

    protected final String createSuperTypeSource(ICompilationUnit extractedWorkingCopy, IType superType, AbstractTypeDeclaration declaringDeclaration, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        String source;
        block11: {
            Assert.isNotNull((Object)extractedWorkingCopy);
            Assert.isNotNull((Object)declaringDeclaration);
            Assert.isNotNull((Object)status);
            Assert.isNotNull((Object)monitor);
            source = null;
            try {
                monitor.beginTask("", 2);
                monitor.setTaskName(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing);
                IType declaring = this.getDeclaringType();
                String delimiter = StubUtility.getLineDelimiterUsed(extractedWorkingCopy.getJavaProject());
                String typeComment = null;
                String fileComment = null;
                if (this.fSettings.createComments) {
                    ITypeParameter[] parameters = declaring.getTypeParameters();
                    String[] names = new String[parameters.length];
                    int index = 0;
                    while (index < parameters.length) {
                        names[index] = parameters[index].getElementName();
                        ++index;
                    }
                    typeComment = CodeGeneration.getTypeComment(extractedWorkingCopy, this.fTypeName, names, delimiter);
                    fileComment = CodeGeneration.getFileComment(extractedWorkingCopy, delimiter);
                }
                StringBuffer buffer = new StringBuffer(64);
                this.createTypeDeclaration(extractedWorkingCopy, superType, declaringDeclaration, typeComment, buffer, status, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                String imports = this.createTypeImports(extractedWorkingCopy, monitor);
                source = this.createTypeTemplate(extractedWorkingCopy, imports, fileComment, "", buffer.toString());
                if (source == null) {
                    if (!declaring.getPackageFragment().isDefaultPackage()) {
                        if (imports.length() > 0) {
                            buffer.insert(0, imports);
                        }
                        buffer.insert(0, "package " + declaring.getPackageFragment().getElementName() + ";");
                    }
                    source = buffer.toString();
                }
                Document document = new Document(source);
                TextEdit edit = CodeFormatterUtil.format2(8, source, 0, delimiter, extractedWorkingCopy.getJavaProject().getOptions(true));
                if (edit == null) break block11;
                try {
                    edit.apply((IDocument)document, 2);
                }
                catch (MalformedTreeException exception) {
                    JavaPlugin.log(exception);
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
                }
                catch (BadLocationException exception) {
                    JavaPlugin.log(exception);
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
                }
                source = document.get();
            }
            finally {
                monitor.done();
            }
        }
        return source;
    }

    protected final void createTypeDeclaration(ICompilationUnit extractedWorkingCopy, IType superType, AbstractTypeDeclaration declaringDeclaration, String comment, StringBuffer buffer, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)extractedWorkingCopy);
        Assert.isNotNull((Object)declaringDeclaration);
        Assert.isNotNull((Object)buffer);
        Assert.isNotNull((Object)status);
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing);
            IJavaProject project = extractedWorkingCopy.getJavaProject();
            String delimiter = StubUtility.getLineDelimiterUsed(project);
            if (comment != null && !"".equals(comment)) {
                buffer.append(comment);
                buffer.append(delimiter);
            }
            buffer.append("public");
            if (superType != null && Flags.isAbstract((int)superType.getFlags())) {
                buffer.append(' ');
                buffer.append("abstract ");
            }
            buffer.append(' ');
            buffer.append("class ");
            buffer.append(this.fTypeName);
            if (superType != null && !"java.lang.Object".equals(superType.getFullyQualifiedName())) {
                buffer.append(' ');
                if (superType.isInterface()) {
                    buffer.append("implements ");
                } else {
                    buffer.append("extends ");
                }
                buffer.append(superType.getElementName());
            }
            buffer.append(" {");
            buffer.append(delimiter);
            buffer.append(delimiter);
            buffer.append('}');
            String string = buffer.toString();
            extractedWorkingCopy.getBuffer().setContents(string);
            Document document = new Document(string);
            CompilationUnitRewrite targetRewrite = new CompilationUnitRewrite(this.fOwner, extractedWorkingCopy);
            AbstractTypeDeclaration targetDeclaration = (AbstractTypeDeclaration)targetRewrite.getRoot().types().get(0);
            this.createTypeParameters(targetRewrite, superType, declaringDeclaration, targetDeclaration);
            this.createTypeSignature(targetRewrite, superType, declaringDeclaration, targetDeclaration);
            this.createNecessaryConstructors(targetRewrite, superType, targetDeclaration, status);
            TextEdit edit = targetRewrite.createChange().getEdit();
            try {
                edit.apply((IDocument)document, 2);
            }
            catch (MalformedTreeException exception) {
                JavaPlugin.log(exception);
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
            }
            catch (BadLocationException exception) {
                JavaPlugin.log(exception);
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
            }
            buffer.setLength(0);
            buffer.append(document.get());
        }
        finally {
            monitor.done();
        }
    }

    protected final void createTypeParameters(CompilationUnitRewrite targetRewrite, IType subType, AbstractTypeDeclaration sourceDeclaration, AbstractTypeDeclaration targetDeclaration) {
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)sourceDeclaration);
        Assert.isNotNull((Object)targetDeclaration);
        if (sourceDeclaration instanceof TypeDeclaration) {
            TypeParameter parameter2 = null;
            ListRewrite rewrite = targetRewrite.getASTRewrite().getListRewrite((ASTNode)targetDeclaration, TypeDeclaration.TYPE_PARAMETERS_PROPERTY);
            for (TypeParameter parameter2 : ((TypeDeclaration)sourceDeclaration).typeParameters()) {
                ASTNode node = ASTNode.copySubtree((AST)targetRewrite.getAST(), (ASTNode)parameter2);
                rewrite.insertLast(node, null);
            }
        }
    }

    protected final void createTypeSignature(CompilationUnitRewrite subRewrite, AbstractTypeDeclaration declaration, IType extractedType, ITypeBinding extractedBinding, IProgressMonitor monitor) throws JavaModelException {
        Assert.isNotNull((Object)subRewrite);
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)extractedType);
        Assert.isNotNull((Object)monitor);
        try {
            ITypeParameter[] parameters;
            monitor.beginTask(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing, 10);
            AST ast = subRewrite.getAST();
            Type type = null;
            if (extractedBinding != null) {
                type = subRewrite.getImportRewrite().addImport(extractedBinding, ast);
            } else {
                subRewrite.getImportRewrite().addImport(extractedType.getFullyQualifiedName('.'));
                type = ast.newSimpleType((Name)ast.newSimpleName(extractedType.getElementName()));
            }
            subRewrite.getImportRemover().registerAddedImport(extractedType.getFullyQualifiedName('.'));
            if (type != null && (parameters = extractedType.getTypeParameters()).length > 0) {
                ParameterizedType parameterized = ast.newParameterizedType(type);
                int index = 0;
                while (index < parameters.length) {
                    parameterized.typeArguments().add(ast.newSimpleType((Name)ast.newSimpleName(parameters[index].getElementName())));
                    ++index;
                }
                type = parameterized;
            }
            ASTRewrite rewriter = subRewrite.getASTRewrite();
            if (type != null && declaration instanceof TypeDeclaration) {
                TypeDeclaration extended = (TypeDeclaration)declaration;
                Type superClass = extended.getSuperclassType();
                if (superClass != null) {
                    rewriter.replace((ASTNode)superClass, (ASTNode)type, (TextEditGroup)subRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.ExtractSupertypeProcessor_add_supertype, SET_EXTRACT_SUPERTYPE));
                } else {
                    rewriter.set((ASTNode)extended, (StructuralPropertyDescriptor)TypeDeclaration.SUPERCLASS_TYPE_PROPERTY, (Object)type, (TextEditGroup)subRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.ExtractSupertypeProcessor_add_supertype, SET_EXTRACT_SUPERTYPE));
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    protected final void createTypeSignature(CompilationUnitRewrite targetRewrite, IType superType, AbstractTypeDeclaration declaringDeclaration, AbstractTypeDeclaration targetDeclaration) {
        TypeDeclaration declaration;
        Type superclassType;
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)declaringDeclaration);
        Assert.isNotNull((Object)targetDeclaration);
        if (declaringDeclaration instanceof TypeDeclaration && (superclassType = (declaration = (TypeDeclaration)declaringDeclaration).getSuperclassType()) != null) {
            Type type = null;
            ITypeBinding binding = superclassType.resolveBinding();
            if (binding != null) {
                type = targetRewrite.getImportRewrite().addImport(binding, targetRewrite.getAST());
                targetRewrite.getImportRemover().registerAddedImports(type);
            }
            if (type != null && targetDeclaration instanceof TypeDeclaration) {
                TypeDeclaration extended = (TypeDeclaration)targetDeclaration;
                Type targetSuperType = extended.getSuperclassType();
                if (targetSuperType != null) {
                    targetRewrite.getASTRewrite().replace((ASTNode)targetSuperType, (ASTNode)type, null);
                } else {
                    targetRewrite.getASTRewrite().set((ASTNode)extended, (StructuralPropertyDescriptor)TypeDeclaration.SUPERCLASS_TYPE_PROPERTY, (Object)type, null);
                }
            }
        }
    }

    public final RefactoringStatus createWorkingCopyLayer(IProgressMonitor monitor) {
        IType declaring;
        RefactoringStatus status;
        block19: {
            Assert.isNotNull((Object)monitor);
            status = new RefactoringStatus();
            monitor.beginTask(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing, 70);
            status.merge(super.createWorkingCopyLayer((IProgressMonitor)new SubProgressMonitor(monitor, 10)));
            declaring = this.getDeclaringType();
            status.merge(this.createExtractedSuperType(this.getDeclaringSuperTypeHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 10)).getSuperclass(declaring), (IProgressMonitor)new SubProgressMonitor(monitor, 10)));
            if (!status.hasFatalError()) break block19;
            RefactoringStatus refactoringStatus = status;
            monitor.done();
            return refactoringStatus;
        }
        try {
            try {
                AbstractTypeDeclaration extractDeclaration;
                IType extractedType = this.computeExtractedType(this.fTypeName);
                this.setDestinationType(extractedType);
                ArrayList<IType> subTypes = new ArrayList<IType>((Collection)Arrays.asList(this.fTypesToExtract));
                if (!subTypes.contains(declaring)) {
                    subTypes.add(declaring);
                }
                HashMap<ICompilationUnit, ArrayList<IType>> unitToTypes = new HashMap<ICompilationUnit, ArrayList<IType>>(subTypes.size());
                HashSet<ICompilationUnit> units = new HashSet<ICompilationUnit>(subTypes.size());
                int index = 0;
                while (index < subTypes.size()) {
                    IType type = (IType)subTypes.get(index);
                    ICompilationUnit unit = type.getCompilationUnit();
                    units.add(unit);
                    ArrayList<IType> collection = (ArrayList<IType>)unitToTypes.get(unit);
                    if (collection == null) {
                        collection = new ArrayList<IType>(2);
                        unitToTypes.put(unit, collection);
                    }
                    collection.add(type);
                    ++index;
                }
                HashMap<IJavaProject, ArrayList<ICompilationUnit>> projectToUnits = new HashMap<IJavaProject, ArrayList<ICompilationUnit>>();
                Collection collection = null;
                IJavaProject project2 = null;
                ICompilationUnit current2 = null;
                for (ICompilationUnit current2 : units) {
                    project2 = current2.getJavaProject();
                    collection = (ArrayList<ICompilationUnit>)projectToUnits.get(project2);
                    if (collection == null) {
                        collection = new ArrayList<ICompilationUnit>();
                        projectToUnits.put(project2, (ArrayList<ICompilationUnit>)collection);
                    }
                    collection.add(current2);
                }
                ITypeBinding[] extractBindings = new ITypeBinding[1];
                ASTParser extractParser = ASTParser.newParser((int)3);
                extractParser.setWorkingCopyOwner(this.fOwner);
                extractParser.setResolveBindings(true);
                extractParser.setProject(project2);
                extractParser.setSource(extractedType.getCompilationUnit());
                CompilationUnit extractUnit = (CompilationUnit)extractParser.createAST((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                if (extractUnit != null && (extractDeclaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(extractedType, extractUnit)) != null) {
                    extractBindings[0] = extractDeclaration.resolveBinding();
                }
                ASTParser parser = ASTParser.newParser((int)3);
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 30);
                try {
                    Set keySet = projectToUnits.keySet();
                    subMonitor.beginTask("", keySet.size());
                    subMonitor.setTaskName(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing);
                    for (IJavaProject project2 : keySet) {
                        collection = (Collection)projectToUnits.get(project2);
                        parser.setWorkingCopyOwner(this.fOwner);
                        parser.setResolveBindings(true);
                        parser.setProject(project2);
                        parser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)project2));
                        SubProgressMonitor subsubMonitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 1);
                        try {
                            subsubMonitor.beginTask("", collection.size());
                            subsubMonitor.setTaskName(RefactoringCoreMessages.ExtractSupertypeProcessor_preparing);
                            parser.createASTs(collection.toArray(new ICompilationUnit[collection.size()]), new String[0], new ASTRequestor((IProgressMonitor)subsubMonitor, unitToTypes, extractedType, extractBindings, status){
                                private final /* synthetic */ IProgressMonitor val$subsubMonitor;
                                private final /* synthetic */ Map val$unitToTypes;
                                private final /* synthetic */ IType val$extractedType;
                                private final /* synthetic */ ITypeBinding[] val$extractBindings;
                                private final /* synthetic */ RefactoringStatus val$status;
                                {
                                    this.val$subsubMonitor = iProgressMonitor;
                                    this.val$unitToTypes = map;
                                    this.val$extractedType = iType;
                                    this.val$extractBindings = iTypeBindingArray;
                                    this.val$status = refactoringStatus;
                                }

                                public final void acceptAST(ICompilationUnit unit, CompilationUnit node) {
                                    try {
                                        try {
                                            Collection types = (Collection)this.val$unitToTypes.get(unit);
                                            if (types != null) {
                                                for (IType currentType : types) {
                                                    AbstractTypeDeclaration currentDeclaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(currentType, node);
                                                    if (currentDeclaration == null) continue;
                                                    ExtractSupertypeProcessor.this.createModifiedSubType(unit, node, this.val$extractedType, this.val$extractBindings[0], currentDeclaration, this.val$status);
                                                }
                                            }
                                        }
                                        catch (CoreException exception) {
                                            JavaPlugin.log(exception);
                                            this.val$status.merge(RefactoringStatus.createFatalErrorStatus((String)exception.getLocalizedMessage()));
                                        }
                                    }
                                    finally {
                                        this.val$subsubMonitor.worked(1);
                                    }
                                }

                                public final void acceptBinding(String key, IBinding binding) {
                                }
                            }, (IProgressMonitor)subsubMonitor);
                        }
                        finally {
                            subsubMonitor.done();
                        }
                    }
                }
                finally {
                    subMonitor.done();
                }
            }
            catch (CoreException exception) {
                JavaPlugin.log(exception);
                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception_on_layer));
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            monitor.done();
        }
        return status;
    }

    public IType[] getCandidateTypes(RefactoringStatus status, IProgressMonitor monitor) {
        IType declaring;
        Assert.isNotNull((Object)monitor);
        if ((this.fPossibleCandidates == null || this.fPossibleCandidates.length == 0) && (declaring = this.getDeclaringType()) != null) {
            try {
                try {
                    monitor.beginTask(RefactoringCoreMessages.ExtractSupertypeProcessor_computing_possible_types, 10);
                    IType superType = this.getDeclaringSuperTypeHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)).getSuperclass(declaring);
                    if (superType != null) {
                        this.fPossibleCandidates = superType.newTypeHierarchy(this.fOwner, (IProgressMonitor)new SubProgressMonitor(monitor, 9, 2)).getSubtypes(superType);
                        LinkedList list = new LinkedList(Arrays.asList(this.fPossibleCandidates));
                        HashSet<String> names = new HashSet<String>();
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            IType type = (IType)iterator.next();
                            if (type.isReadOnly() || type.isBinary() || type.isAnonymous() || !type.isClass() || names.contains(type.getFullyQualifiedName())) {
                                iterator.remove();
                                continue;
                            }
                            names.add(type.getFullyQualifiedName());
                        }
                        this.fPossibleCandidates = list.toArray(new IType[list.size()]);
                    }
                }
                catch (JavaModelException exception) {
                    JavaPlugin.log(exception);
                }
            }
            finally {
                monitor.done();
            }
        }
        return this.fPossibleCandidates;
    }

    public Object[] getElements() {
        return new Object[]{this.getDeclaringType()};
    }

    public IType getExtractedType() {
        return this.getDestinationType();
    }

    public String getTypeName() {
        return this.fTypeName;
    }

    public IType[] getTypesToExtract() {
        return this.fTypesToExtract;
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        if (arguments instanceof JavaRefactoringArguments) {
            IJavaElement element;
            String attribute;
            IType type;
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String name = extended.getAttribute("name");
            if (name == null || "".equals(name)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
            }
            this.fTypeName = name;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                IJavaElement element2 = JavaRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element2 == null || element2.getElementType() != 7) {
                    return ScriptableRefactoring.createInputFatalStatus(element2, this.getRefactoring().getName(), ID_EXTRACT_SUPERTYPE);
                }
                type = null;
                ICompilationUnit unit = ((IType)element2).getCompilationUnit();
                if (unit != null && unit.exists()) {
                    try {
                        ICompilationUnit copy = this.getSharedWorkingCopy(unit, (IProgressMonitor)new NullProgressMonitor());
                        IJavaElement[] elements = copy.findElements(element2);
                        if (elements != null && elements.length == 1 && elements[0] instanceof IType && elements[0].exists()) {
                            type = (IType)elements[0];
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
                if (type == null) {
                    return ScriptableRefactoring.createInputFatalStatus(element2, this.getRefactoring().getName(), ID_EXTRACT_SUPERTYPE);
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fCachedDeclaringType = type;
            String stubs = extended.getAttribute("stubs");
            if (stubs == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "stubs"));
            }
            this.fCreateMethodStubs = Boolean.valueOf(stubs);
            String instance = extended.getAttribute("instanceof");
            if (instance == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "instanceof"));
            }
            this.fInstanceOf = Boolean.valueOf(instance);
            String replace = extended.getAttribute("replace");
            if (replace == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "replace"));
            }
            this.fReplace = Boolean.valueOf(replace);
            int extractCount = 0;
            int abstractCount = 0;
            int deleteCount = 0;
            int typeCount = 0;
            String value = extended.getAttribute("abstract");
            if (value != null && !"".equals(value)) {
                try {
                    abstractCount = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "abstract"));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "abstract"));
            }
            value = extended.getAttribute("delete");
            if (value != null && !"".equals(value)) {
                try {
                    deleteCount = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "delete"));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "delete"));
            }
            value = extended.getAttribute(ATTRIBUTE_EXTRACT);
            if (value != null && !"".equals(value)) {
                try {
                    extractCount = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_EXTRACT));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_EXTRACT));
            }
            value = extended.getAttribute(ATTRIBUTE_TYPES);
            if (value != null && !"".equals(value)) {
                try {
                    typeCount = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_TYPES));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_TYPES));
            }
            RefactoringStatus status = new RefactoringStatus();
            ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>();
            int index = 0;
            while (index < extractCount) {
                attribute = "element" + (index + 1);
                handle = extended.getAttribute(attribute);
                if (handle != null && !"".equals(handle)) {
                    element = JavaRefactoringDescriptor.handleToElement(this.fOwner, extended.getProject(), handle, false);
                    if (element == null || !element.exists()) {
                        status.merge(ScriptableRefactoring.createInputWarningStatus(element, this.getRefactoring().getName(), ID_EXTRACT_SUPERTYPE));
                    } else {
                        elements.add(element);
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                }
                ++index;
            }
            this.fMembersToMove = elements.toArray(new IMember[elements.size()]);
            elements = new ArrayList();
            index = 0;
            while (index < deleteCount) {
                attribute = "element" + (extractCount + index + 1);
                handle = extended.getAttribute(attribute);
                if (handle != null && !"".equals(handle)) {
                    element = JavaRefactoringDescriptor.handleToElement(this.fOwner, extended.getProject(), handle, false);
                    if (element == null || !element.exists()) {
                        status.merge(ScriptableRefactoring.createInputWarningStatus(element, this.getRefactoring().getName(), ID_EXTRACT_SUPERTYPE));
                    } else {
                        elements.add(element);
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                }
                ++index;
            }
            this.fDeletedMethods = elements.toArray(new IMethod[elements.size()]);
            elements = new ArrayList();
            index = 0;
            while (index < abstractCount) {
                attribute = "element" + (extractCount + abstractCount + index + 1);
                handle = extended.getAttribute(attribute);
                if (handle != null && !"".equals(handle)) {
                    element = JavaRefactoringDescriptor.handleToElement(this.fOwner, extended.getProject(), handle, false);
                    if (element == null || !element.exists()) {
                        status.merge(ScriptableRefactoring.createInputWarningStatus(element, this.getRefactoring().getName(), ID_EXTRACT_SUPERTYPE));
                    } else {
                        elements.add(element);
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                }
                ++index;
            }
            this.fAbstractMethods = elements.toArray(new IMethod[elements.size()]);
            elements = new ArrayList();
            index = 0;
            while (index < typeCount) {
                attribute = "element" + (extractCount + abstractCount + deleteCount + index + 1);
                handle = extended.getAttribute(attribute);
                if (handle != null && !"".equals(handle)) {
                    element = JavaRefactoringDescriptor.handleToElement(this.fOwner, extended.getProject(), handle, false);
                    if (element == null || !element.exists()) {
                        status.merge(ScriptableRefactoring.createInputFatalStatus(element, this.getRefactoring().getName(), ID_EXTRACT_SUPERTYPE));
                    } else {
                        elements.add(element);
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                }
                ++index;
            }
            this.fTypesToExtract = elements.toArray(new IType[elements.size()]);
            IJavaProject project = null;
            if (this.fMembersToMove.length > 0) {
                project = this.fMembersToMove[0].getJavaProject();
            }
            this.fSettings = JavaPreferencesSettings.getCodeGenerationSettings(project);
            if (!status.isOK()) {
                return status;
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        return new RefactoringStatus();
    }

    /*
     * WARNING - void declaration
     */
    protected void registerChanges(TextEditBasedChangeManager manager) throws CoreException {
        try {
            void var6_10;
            ICompilationUnit extractedUnit = this.getExtractedType().getCompilationUnit().getPrimary();
            ICompilationUnit unit22 = null;
            CompilationUnitRewrite rewrite = null;
            for (ICompilationUnit unit22 : this.fCompilationUnitRewrites.keySet()) {
                if (unit22.getPrimary().equals(extractedUnit) || (rewrite = (CompilationUnitRewrite)this.fCompilationUnitRewrites.get(unit22)) == null) continue;
                CompilationUnitChange compilationUnitChange = (CompilationUnitChange)((Object)this.fLayerChanges.get(unit22.getPrimary()));
                CompilationUnitChange rewriteChange = rewrite.createChange();
                if (rewriteChange != null && compilationUnitChange != null) {
                    MultiStateCompilationUnitChange change = new MultiStateCompilationUnitChange(rewriteChange.getName(), unit22);
                    change.addChange((TextChange)compilationUnitChange);
                    change.addChange((TextChange)rewriteChange);
                    this.fLayerChanges.remove(unit22.getPrimary());
                    manager.manage(unit22, (TextEditBasedChange)change);
                    continue;
                }
                if (compilationUnitChange != null) {
                    manager.manage(unit22, (TextEditBasedChange)compilationUnitChange);
                    this.fLayerChanges.remove(unit22.getPrimary());
                    continue;
                }
                if (rewriteChange == null) continue;
                manager.manage(unit22, (TextEditBasedChange)rewriteChange);
            }
            for (Map.Entry entry : this.fLayerChanges.entrySet()) {
                manager.manage((ICompilationUnit)entry.getKey(), (TextEditBasedChange)entry.getValue());
            }
            ICompilationUnit[] units = manager.getAllCompilationUnits();
            boolean bl = false;
            while (var6_10 < units.length) {
                if (units[var6_10].getPath().equals((Object)extractedUnit.getPath())) {
                    manager.remove(units[var6_10]);
                }
                ++var6_10;
            }
        }
        finally {
            this.fLayerChanges.clear();
        }
    }

    public void resetChanges() {
        this.fLayerChanges.clear();
    }

    protected void rewriteTypeOccurrences(final TextEditBasedChangeManager manager, final CompilationUnitRewrite sourceRewrite, ICompilationUnit copy, final Set replacements, final RefactoringStatus status, final IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 20);
            monitor.setTaskName(RefactoringCoreMessages.ExtractSupertypeProcessor_checking);
            final IType declaring = this.getDeclaringType();
            final ICompilationUnit destinationUnit = this.getDestinationType().getCompilationUnit();
            IJavaProject project = declaring.getJavaProject();
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setWorkingCopyOwner(this.fOwner);
            parser.setResolveBindings(true);
            parser.setProject(project);
            parser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)project));
            parser.createASTs(new ICompilationUnit[]{copy}, new String[0], new ASTRequestor(){

                public final void acceptAST(ICompilationUnit unit, CompilationUnit node) {
                    block8: {
                        try {
                            TextEdit edit;
                            TextEditBasedChange change;
                            ITypeBinding subBinding;
                            IType subType = (IType)JavaModelUtil.findInCompilationUnit(unit, (IJavaElement)declaring);
                            AbstractTypeDeclaration subDeclaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(subType, node);
                            if (subDeclaration == null || (subBinding = subDeclaration.resolveBinding()) == null) break block8;
                            String name = null;
                            ITypeBinding superBinding = null;
                            ITypeBinding[] superBindings = Bindings.getAllSuperTypes(subBinding);
                            int index = 0;
                            while (index < superBindings.length) {
                                name = superBindings[index].getName();
                                if (name.startsWith(ExtractSupertypeProcessor.this.fDestinationType.getElementName())) {
                                    superBinding = superBindings[index];
                                }
                                ++index;
                            }
                            if (superBinding == null) break block8;
                            ExtractSupertypeProcessor.this.solveSuperTypeConstraints(unit, node, subType, subBinding, superBinding, (IProgressMonitor)new SubProgressMonitor(monitor, 14), status);
                            if (!status.hasFatalError()) {
                                ExtractSupertypeProcessor.this.rewriteTypeOccurrences(manager, (ASTRequestor)this, sourceRewrite, unit, node, replacements, status, (IProgressMonitor)new SubProgressMonitor(monitor, 3));
                            }
                            if (!manager.containsChangesIn(destinationUnit) || !((change = manager.get(destinationUnit)) instanceof TextChange) || (edit = ((TextChange)change).getEdit()) == null) break block8;
                            Document document = new Document(destinationUnit.getBuffer().getContents());
                            try {
                                edit.apply((IDocument)document, 2);
                            }
                            catch (MalformedTreeException exception) {
                                JavaPlugin.log(exception);
                                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception));
                            }
                            catch (BadLocationException exception) {
                                JavaPlugin.log(exception);
                                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception));
                            }
                            ExtractSupertypeProcessor.this.fSuperSource = document.get();
                            manager.remove(destinationUnit);
                        }
                        catch (JavaModelException exception) {
                            JavaPlugin.log(exception);
                            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractSupertypeProcessor_unexpected_exception));
                        }
                    }
                }

                public final void acceptBinding(String key, IBinding binding) {
                }
            }, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    public void setTypeName(String name) {
        Assert.isNotNull((Object)name);
        this.fTypeName = name;
    }

    public void setTypesToExtract(IType[] types) {
        Assert.isNotNull((Object)types);
        this.fTypesToExtract = types;
    }
}

