/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tracker;

public class PopupDialog
extends Window {
    private static final String DIALOG_ORIGIN_X = "DIALOG_X_ORIGIN";
    private static final String DIALOG_ORIGIN_Y = "DIALOG_Y_ORIGIN";
    private static final String DIALOG_WIDTH = "DIALOG_WIDTH";
    private static final String DIALOG_HEIGHT = "DIALOG_HEIGHT";
    private static final String DIALOG_USE_PERSISTED_BOUNDS = "DIALOG_USE_PERSISTED_BOUNDS";
    public static final int HOVER_SHELLSTYLE = 540680;
    public static final int INFOPOPUP_SHELLSTYLE = 8;
    public static final int INFOPOPUPRESIZE_SHELLSTYLE = 16;
    public static final int POPUP_MARGINWIDTH = 0;
    public static final int POPUP_MARGINHEIGHT = 0;
    public static final int POPUP_VERTICALSPACING = 1;
    public static final int POPUP_HORIZONTALSPACING = 1;
    private static final int BORDER_THICKNESS = 1;
    private ToolBar toolBar = null;
    private MenuManager menuManager = null;
    private Control dialogArea;
    private Label titleLabel;
    private Label infoLabel;
    private Control titleSeparator;
    private Control infoSeparator;
    private Image menuImage;
    private Image disabledMenuImage = null;
    private Font infoFont;
    private Font titleFont;
    private boolean listenToDeactivate;
    private boolean listenToParentDeactivate;
    private Listener parentDeactivateListener;
    private boolean takeFocusOnOpen = false;
    private boolean showDialogMenu = false;
    private boolean showPersistAction = false;
    private boolean persistBounds = false;
    private String titleText;
    private String infoText;

    public PopupDialog(Shell parent, int shellStyle, boolean takeFocusOnOpen, boolean persistBounds, boolean showDialogMenu, boolean showPersistAction, String titleText, String infoText) {
        super(parent);
        this.setShellStyle(shellStyle);
        this.takeFocusOnOpen = takeFocusOnOpen;
        this.showDialogMenu = showDialogMenu;
        this.showPersistAction = showPersistAction;
        this.titleText = titleText;
        this.infoText = infoText;
        this.setBlockOnOpen(false);
        this.persistBounds = persistBounds;
        this.initializeWidgetState();
    }

    protected void configureShell(Shell shell) {
        int border;
        Display display = shell.getDisplay();
        shell.setBackground(display.getSystemColor(2));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = border = (this.getShellStyle() & 8) == 0 ? 0 : 1;
        layout.marginWidth = border;
        shell.setLayout((Layout)layout);
        shell.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                if (PopupDialog.this.listenToDeactivate && event.widget == PopupDialog.this.getShell() && PopupDialog.this.getShell().getShells().length == 0) {
                    PopupDialog.this.close();
                } else {
                    PopupDialog.this.listenToDeactivate = true;
                }
            }
        });
        shell.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == PopupDialog.this.getShell() && PopupDialog.this.getShell().getShells().length == 0) {
                    PopupDialog.this.listenToDeactivate = true;
                    PopupDialog.this.listenToParentDeactivate = !"carbon".equals(SWT.getPlatform());
                }
            }
        });
        if ((this.getShellStyle() & 0x4000) != 0 && shell.getParent() != null) {
            this.parentDeactivateListener = new Listener(){

                public void handleEvent(Event event) {
                    if (PopupDialog.this.listenToParentDeactivate) {
                        PopupDialog.this.close();
                    } else {
                        PopupDialog.this.listenToParentDeactivate = PopupDialog.this.listenToDeactivate;
                    }
                }
            };
            shell.getParent().addListener(27, this.parentDeactivateListener);
        }
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                PopupDialog.this.handleDispose();
            }
        });
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 1;
        layout.horizontalSpacing = 1;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        if (this.hasTitleArea()) {
            this.createTitleMenuArea(composite);
            this.titleSeparator = this.createHorizontalSeparator(composite);
        }
        this.dialogArea = this.createDialogArea(composite);
        if (this.dialogArea.getLayoutData() == null) {
            this.dialogArea.setLayoutData((Object)new GridData(1808));
        }
        if (this.hasInfoArea()) {
            this.infoSeparator = this.createHorizontalSeparator(composite);
            this.createInfoTextArea(composite);
        }
        this.applyColors(composite);
        this.applyFonts(composite);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 1;
        layout.horizontalSpacing = 1;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        return composite;
    }

    protected Control getFocusControl() {
        return this.dialogArea;
    }

    protected void setTabOrder(Composite composite) {
    }

    protected boolean hasTitleArea() {
        return this.titleText != null || this.showDialogMenu;
    }

    protected boolean hasInfoArea() {
        return this.infoText != null;
    }

    protected Control createTitleMenuArea(Composite parent) {
        Composite titleAreaComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 1;
        layout.horizontalSpacing = 1;
        titleAreaComposite.setLayout((Layout)layout);
        titleAreaComposite.setLayoutData((Object)new GridData(768));
        this.createTitleControl(titleAreaComposite);
        if (this.showDialogMenu) {
            this.createDialogMenu(titleAreaComposite);
        }
        return titleAreaComposite;
    }

    protected Control createTitleControl(Composite parent) {
        this.titleLabel = new Label(parent, 0);
        GridData gd = new GridData(768);
        if (!this.showDialogMenu) {
            gd.horizontalSpan = 2;
        }
        this.titleLabel.setLayoutData((Object)gd);
        Font font = this.titleLabel.getFont();
        FontData[] fontDatas = font.getFontData();
        int i = 0;
        while (i < fontDatas.length) {
            fontDatas[i].setStyle(1);
            ++i;
        }
        this.titleFont = new Font((Device)this.titleLabel.getDisplay(), fontDatas);
        this.titleLabel.setFont(this.titleFont);
        if (this.titleText != null) {
            this.titleLabel.setText(this.titleText);
        }
        return this.titleLabel;
    }

    protected Control createInfoTextArea(Composite parent) {
        this.infoLabel = new Label(parent, 131072);
        this.infoLabel.setText(this.infoText);
        Font font = this.infoLabel.getFont();
        FontData[] fontDatas = font.getFontData();
        int i = 0;
        while (i < fontDatas.length) {
            fontDatas[i].setHeight(fontDatas[i].getHeight() * 9 / 10);
            ++i;
        }
        this.infoFont = new Font((Device)this.infoLabel.getDisplay(), fontDatas);
        this.infoLabel.setFont(this.infoFont);
        GridData gd = new GridData(802);
        this.infoLabel.setLayoutData((Object)gd);
        this.infoLabel.setForeground(parent.getDisplay().getSystemColor(17));
        return this.infoLabel;
    }

    private Control createHorizontalSeparator(Composite parent) {
        Label separator = new Label(parent, 259);
        separator.setLayoutData((Object)new GridData(768));
        return separator;
    }

    private void createDialogMenu(Composite parent) {
        this.toolBar = new ToolBar(parent, 0x800000);
        ToolItem viewMenuButton = new ToolItem(this.toolBar, 8, 0);
        this.toolBar.setLayoutData((Object)new GridData(128));
        this.menuImage = ImageDescriptor.createFromFile(PopupDialog.class, "images/popup_menu.gif").createImage();
        this.disabledMenuImage = ImageDescriptor.createFromFile(PopupDialog.class, "images/popup_menu_disabled.gif").createImage();
        viewMenuButton.setImage(this.menuImage);
        viewMenuButton.setDisabledImage(this.disabledMenuImage);
        viewMenuButton.setToolTipText(JFaceResources.getString("PopupDialog.menuTooltip"));
        viewMenuButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PopupDialog.this.showDialogMenu();
            }
        });
        viewMenuButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PopupDialog.this.menuImage.dispose();
                PopupDialog.this.menuImage = null;
                PopupDialog.this.disabledMenuImage.dispose();
                PopupDialog.this.disabledMenuImage = null;
            }
        });
    }

    protected void fillDialogMenu(IMenuManager dialogMenu) {
        dialogMenu.add(new GroupMarker("SystemMenuStart"));
        dialogMenu.add(new MoveAction());
        dialogMenu.add(new ResizeAction());
        if (this.showPersistAction) {
            dialogMenu.add(new PersistBoundsAction());
        }
        dialogMenu.add(new Separator("SystemMenuEnd"));
    }

    private void performTrackerAction(int style) {
        Shell shell = this.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Tracker tracker = new Tracker(shell.getDisplay(), style);
        tracker.setStippled(true);
        Rectangle[] r = new Rectangle[]{shell.getBounds()};
        tracker.setRectangles(r);
        boolean oldListenToDeactivate = this.listenToDeactivate;
        this.listenToDeactivate = false;
        if (tracker.open() && shell != null && !shell.isDisposed()) {
            shell.setBounds(tracker.getRectangles()[0]);
        }
        this.listenToDeactivate = oldListenToDeactivate;
    }

    protected void showDialogMenu() {
        if (!this.showDialogMenu) {
            return;
        }
        if (this.menuManager == null) {
            this.menuManager = new MenuManager();
            this.fillDialogMenu(this.menuManager);
        }
        this.listenToDeactivate = !"gtk".equals(SWT.getPlatform());
        Menu menu = this.menuManager.createContextMenu((Control)this.getShell());
        Rectangle bounds = this.toolBar.getBounds();
        Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
        topLeft = this.getShell().toDisplay(topLeft);
        menu.setLocation(topLeft.x, topLeft.y);
        menu.setVisible(true);
    }

    protected void setInfoText(String text) {
        this.infoText = text;
        if (this.infoLabel != null) {
            this.infoLabel.setText(text);
        }
    }

    protected void setTitleText(String text) {
        this.titleText = text;
        if (this.titleLabel != null) {
            this.titleLabel.setText(text);
        }
    }

    protected boolean getPersistBounds() {
        return this.persistBounds;
    }

    public int open() {
        Shell shell = this.getShell();
        if (shell == null || shell.isDisposed()) {
            shell = null;
            this.create();
            shell = this.getShell();
        }
        this.adjustBounds();
        this.constrainShellSize();
        this.setTabOrder((Composite)this.getContents());
        this.listenToDeactivate = false;
        this.listenToParentDeactivate = false;
        if (this.takeFocusOnOpen) {
            shell.open();
            this.getFocusControl().setFocus();
        } else {
            shell.setVisible(true);
        }
        return 0;
    }

    public boolean close() {
        if (this.getShell() == null || this.getShell().isDisposed()) {
            return true;
        }
        this.saveDialogBounds(this.getShell());
        this.initializeWidgetState();
        if (this.parentDeactivateListener != null) {
            this.getShell().getParent().removeListener(27, this.parentDeactivateListener);
            this.parentDeactivateListener = null;
        }
        return super.close();
    }

    protected IDialogSettings getDialogSettings() {
        return null;
    }

    protected void saveDialogBounds(Shell shell) {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            Point shellLocation = shell.getLocation();
            Point shellSize = shell.getSize();
            Shell parent = this.getParentShell();
            if (parent != null) {
                Point parentLocation = parent.getLocation();
                shellLocation.x -= parentLocation.x;
                shellLocation.y -= parentLocation.y;
            }
            if (this.persistBounds) {
                String prefix = this.getClass().getName();
                settings.put(String.valueOf(prefix) + DIALOG_ORIGIN_X, shellLocation.x);
                settings.put(String.valueOf(prefix) + DIALOG_ORIGIN_Y, shellLocation.y);
                settings.put(String.valueOf(prefix) + DIALOG_WIDTH, shellSize.x);
                settings.put(String.valueOf(prefix) + DIALOG_HEIGHT, shellSize.y);
            }
            if (this.showPersistAction && this.showDialogMenu) {
                settings.put(String.valueOf(this.getClass().getName()) + DIALOG_USE_PERSISTED_BOUNDS, this.persistBounds);
            }
        }
    }

    protected Point getInitialSize() {
        IDialogSettings settings;
        Point result = super.getInitialSize();
        if (this.persistBounds && (settings = this.getDialogSettings()) != null) {
            try {
                int width = settings.getInt(String.valueOf(this.getClass().getName()) + DIALOG_WIDTH);
                int height = settings.getInt(String.valueOf(this.getClass().getName()) + DIALOG_HEIGHT);
                result = new Point(width, height);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    protected void adjustBounds() {
    }

    protected Point getInitialLocation(Point initialSize) {
        IDialogSettings settings;
        Point result = super.getInitialLocation(initialSize);
        if (this.persistBounds && (settings = this.getDialogSettings()) != null) {
            try {
                int x = settings.getInt(String.valueOf(this.getClass().getName()) + DIALOG_ORIGIN_X);
                int y = settings.getInt(String.valueOf(this.getClass().getName()) + DIALOG_ORIGIN_Y);
                result = new Point(x, y);
                Shell parent = this.getParentShell();
                if (parent != null) {
                    Point parentLocation = parent.getLocation();
                    result.x += parentLocation.x;
                    result.y += parentLocation.y;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    private void applyColors(Composite composite) {
        this.applyForegroundColor(this.getShell().getDisplay().getSystemColor(28), (Control)composite, this.getForegroundColorExclusions());
        this.applyBackgroundColor(this.getShell().getDisplay().getSystemColor(29), (Control)composite, this.getBackgroundColorExclusions());
    }

    private void applyFonts(Composite composite) {
        Dialog.applyDialogFont((Control)composite);
    }

    private void applyForegroundColor(Color color, Control control, List exclusions) {
        if (!exclusions.contains(control)) {
            control.setForeground(color);
        }
        if (control instanceof Composite) {
            Control[] children = ((Composite)control).getChildren();
            int i = 0;
            while (i < children.length) {
                this.applyForegroundColor(color, children[i], exclusions);
                ++i;
            }
        }
    }

    private void applyBackgroundColor(Color color, Control control, List exclusions) {
        if (!exclusions.contains(control)) {
            control.setBackground(color);
        }
        if (control instanceof Composite) {
            Control[] children = ((Composite)control).getChildren();
            int i = 0;
            while (i < children.length) {
                this.applyBackgroundColor(color, children[i], exclusions);
                ++i;
            }
        }
    }

    protected void applyForegroundColor(Color color, Control control) {
        this.applyForegroundColor(color, control, this.getForegroundColorExclusions());
    }

    protected void applyBackgroundColor(Color color, Control control) {
        this.applyBackgroundColor(color, control, this.getBackgroundColorExclusions());
    }

    protected List getForegroundColorExclusions() {
        ArrayList<Object> list = new ArrayList<Object>(3);
        if (this.infoLabel != null) {
            list.add(this.infoLabel);
        }
        if (this.titleSeparator != null) {
            list.add(this.titleSeparator);
        }
        if (this.infoSeparator != null) {
            list.add(this.infoSeparator);
        }
        return list;
    }

    protected List getBackgroundColorExclusions() {
        ArrayList<Control> list = new ArrayList<Control>(2);
        if (this.titleSeparator != null) {
            list.add(this.titleSeparator);
        }
        if (this.infoSeparator != null) {
            list.add(this.infoSeparator);
        }
        return list;
    }

    private void initializeWidgetState() {
        IDialogSettings settings;
        this.menuManager = null;
        this.dialogArea = null;
        this.titleLabel = null;
        this.titleSeparator = null;
        this.infoSeparator = null;
        this.infoLabel = null;
        this.toolBar = null;
        if (this.showDialogMenu && this.showPersistAction && (settings = this.getDialogSettings()) != null) {
            this.persistBounds = settings.getBoolean(String.valueOf(this.getClass().getName()) + DIALOG_USE_PERSISTED_BOUNDS);
        }
    }

    private void handleDispose() {
        if (this.infoFont != null && !this.infoFont.isDisposed()) {
            this.infoFont.dispose();
        }
        this.infoFont = null;
        if (this.titleFont != null && !this.titleFont.isDisposed()) {
            this.titleFont.dispose();
        }
        this.titleFont = null;
    }

    private class MoveAction
    extends Action {
        MoveAction() {
            super(JFaceResources.getString("PopupDialog.move"), 1);
        }

        public void run() {
            PopupDialog.this.performTrackerAction(0);
        }
    }

    private class ResizeAction
    extends Action {
        ResizeAction() {
            super(JFaceResources.getString("PopupDialog.resize"), 1);
        }

        public void run() {
            PopupDialog.this.performTrackerAction(16);
        }
    }

    private class PersistBoundsAction
    extends Action {
        PersistBoundsAction() {
            super(JFaceResources.getString("PopupDialog.persistBounds"), 2);
            this.setChecked(PopupDialog.this.persistBounds);
        }

        public void run() {
            PopupDialog.this.persistBounds = this.isChecked();
        }
    }
}

