/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.builders;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.pde.internal.core.IFeatureModelDelta;
import org.eclipse.pde.internal.core.IFeatureModelListener;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;

public class FeatureRebuilder
implements IFeatureModelListener,
IPluginModelListener,
Preferences.IPropertyChangeListener {
    private boolean fAutoBuilding;
    private boolean fLastJobPending = false;
    private Preferences fResourcesPreferences = ResourcesPlugin.getPlugin().getPluginPreferences();

    public FeatureRebuilder() {
        this.fAutoBuilding = this.fResourcesPreferences.getBoolean("description.autobuilding");
    }

    public void start() {
        PDECore.getDefault().getFeatureModelManager().addFeatureModelListener(this);
        PDECore.getDefault().getModelManager().addPluginModelListener(this);
        this.fResourcesPreferences.addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
    }

    public void stop() {
        this.fResourcesPreferences.removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
        PDECore.getDefault().getFeatureModelManager().removeFeatureModelListener(this);
        PDECore.getDefault().getModelManager().removePluginModelListener(this);
    }

    public void modelsChanged(IFeatureModelDelta delta) {
        if ((1 & delta.getKind()) != 0 || (2 & delta.getKind()) != 0) {
            this.buildWorkspaceFeatures();
        }
    }

    public void modelsChanged(PluginModelDelta delta) {
        if ((1 & delta.getKind()) != 0 || (2 & delta.getKind()) != 0) {
            this.buildWorkspaceFeatures();
        }
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if (!event.getProperty().equals("description.autobuilding")) {
            return;
        }
        boolean wasAutoBuilding = this.fAutoBuilding;
        this.fAutoBuilding = this.fResourcesPreferences.getBoolean("description.autobuilding");
        if (!wasAutoBuilding && this.fAutoBuilding) {
            this.buildWorkspaceFeatures();
        }
    }

    private synchronized void buildWorkspaceFeatures() {
        if (this.fLastJobPending) {
            return;
        }
        if (!this.fAutoBuilding) {
            return;
        }
        Job buildJob = new Job(PDECoreMessages.FeatureConsistencyTrigger_JobName){

            public boolean belongsTo(Object family) {
                return ResourcesPlugin.FAMILY_AUTO_BUILD == family;
            }

            protected IStatus run(IProgressMonitor monitor) {
                if (!FeatureRebuilder.this.fAutoBuilding) {
                    return Status.OK_STATUS;
                }
                try {
                    try {
                        IFeatureModel[] workspaceFeatures = PDECore.getDefault().getWorkspaceModelManager().getFeatureModels();
                        monitor.beginTask("", workspaceFeatures.length);
                        int i = 0;
                        while (i < workspaceFeatures.length) {
                            IResource res = workspaceFeatures[i].getUnderlyingResource();
                            if (res == null) {
                                monitor.worked(1);
                            } else {
                                IProject projectToBuild = res.getProject();
                                if (!projectToBuild.isOpen()) {
                                    monitor.worked(1);
                                } else {
                                    if (monitor.isCanceled()) {
                                        throw new OperationCanceledException();
                                    }
                                    try {
                                        if (projectToBuild.hasNature("org.eclipse.pde.FeatureNature")) {
                                            projectToBuild.build(6, "org.eclipse.pde.FeatureBuilder", null, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                        } else {
                                            monitor.worked(1);
                                        }
                                    }
                                    catch (CoreException coreException) {}
                                }
                            }
                            ++i;
                        }
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        this.fLastJobPending = true;
        buildJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void aboutToRun(IJobChangeEvent event) {
                super.aboutToRun(event);
                FeatureRebuilder.this.fLastJobPending = false;
                event.getJob().removeJobChangeListener((IJobChangeListener)this);
            }

            public void done(IJobChangeEvent event) {
                super.done(event);
                FeatureRebuilder.this.fLastJobPending = false;
            }
        });
        buildJob.schedule(200L);
    }
}

