/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.net.URI;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class LinkDescription {
    private URI localLocation;
    private IPath path;
    private int type;

    public LinkDescription() {
        this.path = Path.EMPTY;
        this.type = -1;
    }

    public LinkDescription(IResource linkedResource, URI location) {
        Assert.isNotNull((Object)linkedResource);
        Assert.isNotNull((Object)location);
        this.type = linkedResource.getType();
        this.path = linkedResource.getProjectRelativePath();
        this.localLocation = location;
    }

    public boolean equals(Object o) {
        if (o.getClass() != LinkDescription.class) {
            return false;
        }
        LinkDescription other = (LinkDescription)o;
        return this.localLocation.equals(other.localLocation) && this.type == other.type;
    }

    public URI getLocationURI() {
        return this.localLocation;
    }

    public IPath getProjectRelativePath() {
        return this.path;
    }

    public int getType() {
        return this.type;
    }

    public int hashCode() {
        return this.type + this.localLocation.hashCode();
    }

    public void setLocationURI(URI location) {
        this.localLocation = location;
    }

    public void setPath(IPath path) {
        this.path = path;
    }

    public void setType(int type) {
        this.type = type;
    }
}

