/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model.loader;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.loader.ModelLoaderUtil;
import org.eclipse.ui.internal.intro.impl.model.loader.SharedConfigExtensionsManager;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.eclipse.ui.internal.intro.impl.util.Util;

public class BaseExtensionPointManager {
    protected static final String CONFIG = "org.eclipse.ui.intro.config";
    protected static final String CONFIG_EXTENSION = "org.eclipse.ui.intro.configExtension";
    protected static final String ATT_CONFIG_INTRO_ID = "introId";
    protected static final String ATT_CONFIG_EXTENSION_CONFIG_ID = "configId";
    protected static final String ATT_ID = "id";
    protected Hashtable introModels = new Hashtable();
    protected IExtensionRegistry registry = Platform.getExtensionRegistry();
    protected SharedConfigExtensionsManager sharedConfigExtensionsManager;

    protected BaseExtensionPointManager() {
    }

    protected IntroModelRoot loadModel(String attributeName, String attributeValue) {
        IConfigurationElement introConfig;
        long start = 0L;
        if (Log.logPerformance) {
            start = System.currentTimeMillis();
        }
        if ((introConfig = this.getIntroConfig(attributeName, attributeValue)) != null) {
            String configId = introConfig.getAttribute(ATT_ID);
            IConfigurationElement[] introConfigExtensions = null;
            introConfigExtensions = configId == null ? new IConfigurationElement[]{} : this.getIntroConfigExtensions(ATT_CONFIG_EXTENSION_CONFIG_ID, configId);
            if (Log.logPerformance) {
                Util.logPerformanceTime("BEGIN:  quering registry for configs took: ", start);
            }
            IntroModelRoot model = new IntroModelRoot(introConfig, introConfigExtensions);
            model.loadModel();
            this.addCachedModel(model.getId(), model);
            this.loadSharedConfigExtensions();
            if (Log.logPerformance) {
                Util.logPerformanceTime("loading Intro Model (quering registry/creating & resolving model) took: ", start);
            }
            return model;
        }
        return null;
    }

    protected IConfigurationElement getIntroConfig(String attrributeName, String attributeValue) {
        IConfigurationElement[] configElements = this.registry.getConfigurationElementsFor(CONFIG);
        IConfigurationElement config = this.getConfigurationFromAttribute(configElements, attrributeName, attributeValue);
        if (config == null) {
            Log.warning("No Intro configuration found with " + attrributeName + " of value = " + attributeValue);
        }
        return config;
    }

    protected IConfigurationElement[] getIntroConfigExtensions(String attrributeName, String attributeValue) {
        IConfigurationElement[] configExtensionElements = this.registry.getConfigurationElementsFor(CONFIG_EXTENSION);
        IConfigurationElement[] configExtensions = this.getConfigurationsFromAttribute(configExtensionElements, attrributeName, attributeValue);
        return configExtensions;
    }

    protected void addCachedModel(String modelId, IntroModelRoot model) {
        this.introModels.put(modelId, model);
    }

    protected IntroModelRoot getCachedModel(String configId) {
        return (IntroModelRoot)this.introModels.get(configId);
    }

    protected IConfigurationElement getConfigurationFromAttribute(IConfigurationElement[] configElements, String attributeName, String attributeValue) {
        IConfigurationElement[] filteredConfigElements = this.getConfigurationsFromAttribute(configElements, attributeName, attributeValue);
        IConfigurationElement config = ModelLoaderUtil.validateSingleContribution(filteredConfigElements, attributeName);
        return config;
    }

    protected IConfigurationElement[] getConfigurationsFromAttribute(IConfigurationElement[] configElements, String attributeName, String attributeValue) {
        Vector<IConfigurationElement> elements = new Vector<IConfigurationElement>();
        int i = 0;
        while (i < configElements.length) {
            String currentAttributeValue = configElements[i].getAttribute(attributeName);
            if (currentAttributeValue != null && currentAttributeValue.equals(attributeValue)) {
                elements.add(configElements[i]);
            }
            ++i;
        }
        Object[] filteredConfigElements = new IConfigurationElement[elements.size()];
        elements.copyInto(filteredConfigElements);
        return filteredConfigElements;
    }

    protected void loadSharedConfigExtensions() {
        this.sharedConfigExtensionsManager = new SharedConfigExtensionsManager(this.registry);
        this.sharedConfigExtensionsManager.loadSharedConfigExtensions();
    }

    public SharedConfigExtensionsManager getSharedConfigExtensionsManager() {
        return this.sharedConfigExtensionsManager;
    }

    public Hashtable getIntroModels() {
        return this.introModels;
    }
}

