/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import com.ibm.icu.text.Collator;
import java.util.TreeSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;

public abstract class NextPreviousPulldownActionDelegate
extends Action
implements IMenuCreator,
IWorkbenchWindowPulldownDelegate2 {
    private Menu fMenu;
    private IPreferenceStore fStore = EditorsPlugin.getDefault().getPreferenceStore();

    public abstract String getPreferenceKey(AnnotationPreference var1);

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        this.fillMenu(this.fMenu);
        return this.fMenu;
    }

    public Menu getMenu(Menu parent) {
        if (this.fMenu == null) {
            this.fMenu = new Menu(parent);
            this.fillMenu(this.fMenu);
        }
        return this.fMenu;
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    private void fillMenu(Menu menu) {
        IAction[] actions = this.getActionsFromDescriptors();
        int i = 0;
        while (i < actions.length) {
            ActionContributionItem item = new ActionContributionItem(actions[i]);
            item.fill(menu, -1);
            ++i;
        }
    }

    private IAction[] getActionsFromDescriptors() {
        MarkerAnnotationPreferences fMarkerAnnotationPreferences = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
        TreeSet<NavigationEnablementAction> containers = new TreeSet<NavigationEnablementAction>();
        for (AnnotationPreference preference : fMarkerAnnotationPreferences.getAnnotationPreferences()) {
            String key = preference.getShowInNextPrevDropdownToolbarActionKey();
            if (key == null || !this.fStore.getBoolean(key)) continue;
            String preferenceKey = this.getPreferenceKey(preference);
            preferenceKey = preference.getIsGoToNextNavigationTargetKey();
            if (preferenceKey == null) continue;
            containers.add(new NavigationEnablementAction(preference.getPreferenceLabel(), this.fStore, preferenceKey));
        }
        return (IAction[])containers.toArray(new Action[containers.size()]);
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private static class NavigationEnablementAction
    extends Action
    implements Comparable {
        private IPreferenceStore fStore;
        private String fKey;
        private String fName;

        public NavigationEnablementAction(String name, IPreferenceStore store, String key) {
            super(name, 2);
            this.fStore = store;
            this.fKey = key;
            this.fName = name;
            this.setChecked(this.fStore.getBoolean(this.fKey));
        }

        public void run() {
            this.fStore.setValue(this.fKey, this.isChecked());
        }

        public int compareTo(Object o) {
            if (!(o instanceof NavigationEnablementAction)) {
                return -1;
            }
            String otherName = ((NavigationEnablementAction)o).fName;
            return Collator.getInstance().compare(this.fName, otherName);
        }
    }
}

