/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import java.io.File;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.dialogs.HistoryDialog;
import org.tigris.subversion.subclipse.ui.operations.ExportRemoteFolderOperation;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class ExportRemoteFolderDialog
extends TrayDialog {
    private ISVNRemoteResource remoteResource;
    private IWorkbenchPart targetPart;
    private Text directoryText;
    private Text revisionText;
    private Button logButton;
    private Button headButton;
    private Button revisionButton;

    public ExportRemoteFolderDialog(Shell parentShell, ISVNRemoteResource remoteResource, IWorkbenchPart targetPart) {
        super(parentShell);
        this.remoteResource = remoteResource;
        this.targetPart = targetPart;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Policy.bind("ExportRemoteFolderAction.directoryDialogText"));
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Group repositoryGroup = new Group(composite, 0);
        repositoryGroup.setText(Policy.bind("ExportRemoteFolderDialog.repository"));
        GridLayout repositoryLayout = new GridLayout();
        repositoryLayout.numColumns = 2;
        repositoryGroup.setLayout((Layout)repositoryLayout);
        data = new GridData(1808);
        repositoryGroup.setLayoutData((Object)data);
        Label urlLabel = new Label((Composite)repositoryGroup, 0);
        urlLabel.setText(Policy.bind("ExportRemoteFolderDialog.url"));
        data = new GridData();
        data.horizontalSpan = 2;
        urlLabel.setLayoutData((Object)data);
        Text urlText = new Text((Composite)repositoryGroup, 2048);
        data = new GridData();
        data.widthHint = 300;
        urlText.setLayoutData((Object)data);
        urlText.setEditable(false);
        urlText.setText(this.remoteResource.getUrl().toString());
        new Label((Composite)repositoryGroup, 0);
        Label directoryLabel = new Label((Composite)repositoryGroup, 0);
        directoryLabel.setText(Policy.bind("ExportRemoteFolderDialog.directory"));
        data = new GridData();
        data.horizontalSpan = 2;
        directoryLabel.setLayoutData((Object)data);
        this.directoryText = new Text((Composite)repositoryGroup, 2048);
        data = new GridData();
        data.widthHint = 300;
        this.directoryText.setLayoutData((Object)data);
        this.directoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportRemoteFolderDialog.this.setOkButtonStatus();
            }
        });
        Button directoryBrowseButton = new Button((Composite)repositoryGroup, 8);
        directoryBrowseButton.setText(Policy.bind("ExportRemoteFolderDialog.browse"));
        directoryBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ExportRemoteFolderDialog.this.getShell(), 8192);
                dialog.setText(Policy.bind("ExportRemoteFolderAction.directoryDialogText"));
                String directory = dialog.open();
                if (directory != null) {
                    ExportRemoteFolderDialog.this.directoryText.setText(directory);
                    ExportRemoteFolderDialog.this.setOkButtonStatus();
                }
            }
        });
        Group revisionGroup = new Group(composite, 0);
        revisionGroup.setText(Policy.bind("SwitchDialog.revision"));
        GridLayout revisionLayout = new GridLayout();
        revisionLayout.numColumns = 3;
        revisionGroup.setLayout((Layout)revisionLayout);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        revisionGroup.setLayoutData((Object)data);
        this.headButton = new Button((Composite)revisionGroup, 16);
        this.headButton.setText(Policy.bind("SwitchDialog.head"));
        data = new GridData();
        data.horizontalSpan = 3;
        this.headButton.setLayoutData((Object)data);
        this.revisionButton = new Button((Composite)revisionGroup, 16);
        this.revisionButton.setText(Policy.bind("SwitchDialog.revision"));
        this.revisionText = new Text((Composite)revisionGroup, 2048);
        data = new GridData();
        data.widthHint = 40;
        this.revisionText.setLayoutData((Object)data);
        this.revisionText.setEnabled(false);
        this.logButton = new Button((Composite)revisionGroup, 8);
        this.logButton.setText(Policy.bind("MergeDialog.showLog"));
        this.logButton.setEnabled(false);
        this.logButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportRemoteFolderDialog.this.showLog();
            }
        });
        if (SVNRevision.HEAD.equals((Object)this.remoteResource.getRevision())) {
            this.headButton.setSelection(true);
        } else {
            this.revisionButton.setSelection(true);
            this.revisionText.setText(this.remoteResource.getRevision().toString());
            this.revisionText.setEnabled(true);
            this.logButton.setEnabled(true);
        }
        this.revisionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportRemoteFolderDialog.this.setOkButtonStatus();
            }
        });
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportRemoteFolderDialog.this.revisionText.setEnabled(ExportRemoteFolderDialog.this.revisionButton.getSelection());
                ExportRemoteFolderDialog.this.logButton.setEnabled(ExportRemoteFolderDialog.this.revisionButton.getSelection());
                ExportRemoteFolderDialog.this.setOkButtonStatus();
                if (ExportRemoteFolderDialog.this.revisionButton.getSelection()) {
                    ExportRemoteFolderDialog.this.revisionText.selectAll();
                    ExportRemoteFolderDialog.this.revisionText.setFocus();
                }
            }
        };
        this.headButton.addSelectionListener((SelectionListener)listener);
        this.revisionButton.addSelectionListener((SelectionListener)listener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.export_remote_folder_dialog_context");
        this.directoryText.setFocus();
        return composite;
    }

    private void setOkButtonStatus() {
        this.getButton(0).setEnabled(this.directoryText.getText().trim().length() > 0 && (this.headButton.getSelection() || this.revisionText.getText().trim().length() > 0));
    }

    protected void showLog() {
        HistoryDialog dialog = new HistoryDialog(this.getShell(), this.remoteResource);
        if (dialog.open() == 1) {
            return;
        }
        ILogEntry[] selectedEntries = dialog.getSelectedLogEntries();
        if (selectedEntries.length == 0) {
            return;
        }
        this.revisionText.setText(Long.toString(selectedEntries[selectedEntries.length - 1].getRevision().getNumber()));
        this.setOkButtonStatus();
    }

    protected void okPressed() {
        boolean success = true;
        SVNRevision revision = null;
        if (this.headButton.getSelection()) {
            revision = SVNRevision.HEAD;
        } else {
            int revisionNumber = Integer.parseInt(this.revisionText.getText().trim());
            long revisionLong = revisionNumber;
            revision = new SVNRevision.Number(revisionLong);
        }
        File directory = new File(String.valueOf(this.directoryText.getText().trim()) + File.separator + this.remoteResource.getName());
        try {
            new ExportRemoteFolderOperation(this.targetPart, this.remoteResource, directory, revision).run();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("ExportRemoteFolderAction.directoryDialogText"), (String)e.getMessage());
            success = false;
        }
        if (!success) {
            return;
        }
        super.okPressed();
    }
}

