<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1520 $
 * $Id: index.php 1520 2007-12-10 16:56:41Z ipso $
 * $Date: 2007-12-10 08:56:41 -0800 (Mon, 10 Dec 2007) $
 */
require_once('../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');


/* We assign $title var before translation to save breadcrumb in db as english.
 * Yet string in gettext() is still found by xgettext extraction utility.
 * This construction lets us do both without duplicating the string literal.
 */
$smarty->assign('title', TTi18n::gettext($title = 'Home'));
BreadCrumb::setCrumb($title);


/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'id',
												'pref_data'
												) ) );

//Grab total number of exceptions for each severity level
$exceptions = array();

$elf = new ExceptionListFactory();
$elf->getFlaggedExceptionsByUserIdAndPayPeriodStatus( $current_user->getId(), 10 );
if ( $elf->getRecordCount() > 0 ) {
	foreach($elf as $e_obj) {
		if ( isset($exceptions[$e_obj->getColumn('severity_id')]) ) {
			$exceptions[$e_obj->getColumn('severity_id')]++;
		} else {
			$exceptions[$e_obj->getColumn('severity_id')] = 1;
		}
	}
}
unset($elf, $e_obj);
$smarty->assign_by_ref('exceptions', $exceptions);


//Grab list of recent requests
$rlf = new RequestListFactory();
$rlf->getByUserIDAndCompanyId( $current_user->getId(), $current_company->getId(), 5, 1 );
if ($rlf->getRecordCount() > 0 ) {
	$status_options = $rlf->getOptions('status');
	$type_options = $rlf->getOptions('type');

	foreach ($rlf as $r_obj) {
		$requests[] = array(
							'id' => $r_obj->getId(),
							'user_date_id' => $r_obj->getUserDateID(),
							'date_stamp' => TTDate::strtotime($r_obj->getColumn('date_stamp')),
							'status_id' => $r_obj->getStatus(),
							'status' => Misc::TruncateString( $status_options[$r_obj->getStatus()], 15 ),
							'type_id' => $r_obj->getType(),
							'type' => $type_options[$r_obj->getType()],
							'created_date' => $r_obj->getCreatedDate(),
							'deleted' => $r_obj->getDeleted()
						);
	}
}
$smarty->assign_by_ref('requests', $requests);


//Grab list of unread messages
$mlf = new MessageListFactory();
$mlf->getByUserIdAndFolder( $current_user->getId(), 10, 5, 1);
if ( $mlf->getRecordCount() > 0 ) {
	$object_name_options = $mlf->getOptions('object_name');

	$require_ack = FALSE;
	foreach ($mlf as $message) {
		//Get user info
		$ulf = new UserListFactory();

		if ( $message->isAck() == FALSE ) {
			$require_ack = TRUE;
		}

		if ( $message->getRequireAck() == TRUE ) {
			$show_ack_column = TRUE;
		}

		$messages[] = array(
							'id' => $message->getId(),
							'parent_id' => $message->getParent(),
							'object_type_id' => $message->getObjectType(),
							'object_type' => $object_name_options[$message->getObjectType()],
							'object_id' => $message->getObject(),
							'priority' => $message->getPriority(),
							'status_id' => $message->getStatus(),
							'require_ack' => $message->getRequireAck(),
							'ack_date' => $message->getAckDate(),
							'subject' => Misc::TruncateString( $message->getSubject(), 20 ),
							'body' => $message->getBody(),
							'created_date' => $message->getCreatedDate(),
							'created_by' => $message->getCreatedBy(),
							'created_by_full_name' => $ulf->getById( $message->getCreatedBy() )->getIterator()->current()->getFullName(),
							'updated_date' => $message->getUpdatedDate(),
							'updated_by' => $message->getUpdatedBy(),
							'deleted_date' => $message->getDeletedDate(),
							'deleted_by' => $message->getDeletedBy()
						);

	}
}
$smarty->assign_by_ref('messages', $messages);

//Grab requests pending authorization if they are a supervisor.
if ( $permission->Check('authorization','enabled')
		AND $permission->Check('authorization','view')
		AND $permission->Check('request','authorize') ) {

	$ulf = new UserListFactory();
	$hlf = new HierarchyListFactory();
	$hotlf = new HierarchyObjectTypeListFactory();

	//Get Hierarchy Control ID
	$request_hierarchy_id = $hotlf->getByCompanyIdAndObjectTypeId( $current_company->getId(), 50 )->getCurrent()->getHierarchyControl();
	Debug::Text('Request Hierarchy ID: '. $request_hierarchy_id, __FILE__, __LINE__, __METHOD__,10);

	//Get all levels below us.
	$request_levels = $hlf->getLevelsByHierarchyControlIdAndUserId( $request_hierarchy_id, $current_user->getId() );
	Debug::Arr( $request_levels, 'Request Levels', __FILE__, __LINE__, __METHOD__,10);

	//Get all relevant hierarchy ids
	$request_hierarchy_user_ids = $hlf->getByHierarchyControlIdAndUserIdAndLevel( $request_hierarchy_id, $current_user->getId(), 0 );
	//Debug::Arr( $request_hierarchy_user_ids, 'Request Hierarchy Ids', __FILE__, __LINE__, __METHOD__,10);

	if ( is_array($request_hierarchy_user_ids)
			AND isset($request_hierarchy_user_ids['child_level'])
			AND isset($request_hierarchy_user_ids['parent_level'])
			AND isset($request_hierarchy_user_ids['current_level']) ) {

		$rlf = new RequestListFactory();
		$rlf->getByUserIdListAndStatusAndNotAuthorized($request_hierarchy_user_ids['child_level'], 30, $request_hierarchy_user_ids['parent_level'], $request_hierarchy_user_ids['current_level'] );

		$status_options = $rlf->getOptions('status');
		$type_options = $rlf->getOptions('type');

		foreach( $rlf as $r_obj) {
			//Grab authorizations for this object.
			$pending_requests[] = array(
									'id' => $r_obj->getId(),
									'user_date_id' => $r_obj->getId(),
									'user_id' => $r_obj->getUserDateObject()->getUser(),
									'user_full_name' => $r_obj->getUserDateObject()->getUserObject()->getFullName(),
									'date_stamp' => $r_obj->getUserDateObject()->getDateStamp(),
									'type_id' => $r_obj->getType(),
									'type' => $type_options[$r_obj->getType()],
									'status_id' => $r_obj->getStatus(),
									'status' => $status_options[$r_obj->getStatus()]
												);
		}
	}
	$smarty->assign_by_ref('pending_requests', $pending_requests);
	unset($pending_requests, $request_hierarchy_id, $request_user_id, $request_node_data, $request_current_level_user_ids, $request_parent_level_user_ids, $request_child_level_user_ids );
}

$smarty->display('index.tpl');
?>