<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1371 $
 * $Id: AuthorizationList.php 1371 2007-10-30 18:03:07Z ipso $
 * $Date: 2007-10-30 11:03:07 -0700 (Tue, 30 Oct 2007) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

if ( !$permission->Check('authorization','enabled')
		OR !( $permission->Check('authorization','view') ) ) {

	$permission->Redirect( FALSE ); //Redirect
}

//Debug::setVerbosity(11);

$smarty->assign('title', TTi18n::gettext($title = 'Authorization List')); // See index.php
BreadCrumb::setCrumb($title);

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'page',
												'sort_column',
												'sort_order',
												'ids',
												'level',
												'selected_levels'
												) ) );

switch ($action) {
	case 'submit':
		Debug::Text('Submit!', __FILE__, __LINE__, __METHOD__,10);

	default:
		Debug::Text('Level: '. $level, __FILE__, __LINE__, __METHOD__,10);

		$ulf = new UserListFactory();
		$hlf = new HierarchyListFactory();
		$hotlf = new HierarchyObjectTypeListFactory();

		if ( $permission->Check('request','authorize') ) {
			//Debug::Text('Request: Selected Level: '. $selected_levels['request'], __FILE__, __LINE__, __METHOD__,10);

			//Get Hierarchy Control ID
			$request_hierarchy_id = $hotlf->getByCompanyIdAndObjectTypeId( $current_company->getId(), 50 )->getCurrent()->getHierarchyControl();
			Debug::Text('Request Hierarchy ID: '. $request_hierarchy_id, __FILE__, __LINE__, __METHOD__,10);

			//Get all levels below us.
			$request_levels = $hlf->getLevelsByHierarchyControlIdAndUserId( $request_hierarchy_id, $current_user->getId() );
			Debug::Arr( $request_levels, 'Request Levels', __FILE__, __LINE__, __METHOD__,10);

			if ( isset($selected_levels['request']) AND in_array( $selected_levels['request'], array_keys($request_levels) ) ) {
				$request_selected_level = $selected_levels['request'];
				Debug::Text(' Switching Levels to Level: '. $request_selected_level, __FILE__, __LINE__, __METHOD__,10);
			} else {
				$request_selected_level = 0;
			}
			Debug::Text( 'Request Selected Level: '. $request_selected_level, __FILE__, __LINE__, __METHOD__,10);

			//Get all relevant hierarchy ids
			$request_hierarchy_user_ids = $hlf->getByHierarchyControlIdAndUserIdAndLevel( $request_hierarchy_id, $current_user->getId(), (int)$request_selected_level );
			//Debug::Arr( $request_hierarchy_user_ids, 'Request Hierarchy Ids', __FILE__, __LINE__, __METHOD__,10);

			if ( is_array($request_hierarchy_user_ids)
					AND isset($request_hierarchy_user_ids['child_level'])
					AND isset($request_hierarchy_user_ids['parent_level'])
					AND isset($request_hierarchy_user_ids['current_level']) ) {

				$rlf = new RequestListFactory();
				//$rlf->getByUserIdListAndStatusAndNotAuthorized($request_child_level_user_ids, 30, $request_parent_level_user_ids, $request_current_level_user_ids );
				$rlf->getByUserIdListAndStatusAndNotAuthorized($request_hierarchy_user_ids['child_level'], 30, $request_hierarchy_user_ids['parent_level'], $request_hierarchy_user_ids['current_level'] );

				$status_options = $rlf->getOptions('status');
				$type_options = $rlf->getOptions('type');

				foreach( $rlf as $r_obj) {
					//Grab authorizations for this object.
					$requests[] = array(
											'id' => $r_obj->getId(),
											'user_date_id' => $r_obj->getId(),
											'user_id' => $r_obj->getUserDateObject()->getUser(),
											'user_full_name' => $r_obj->getUserDateObject()->getUserObject()->getFullName(),
											'date_stamp' => $r_obj->getUserDateObject()->getDateStamp(),
											'type_id' => $r_obj->getType(),
											'type' => $type_options[$r_obj->getType()],
											'status_id' => $r_obj->getStatus(),
											'status' => $status_options[$r_obj->getStatus()]
														);
				}
				$smarty->assign_by_ref('requests', $requests);

				if ( isset($request_levels) AND is_array($request_levels) ) {
					$smarty->assign_by_ref('request_levels', $request_levels );
					$smarty->assign_by_ref('selected_request_level', $request_selected_level);
				}
			}
		}

		if ( $permission->Check('punch','authorize') ) {
			//Debug::Text('TimeSheet: Selected Level: '. $selected_levels['timesheet'], __FILE__, __LINE__, __METHOD__,10);

			//Get Hierarchy Control ID
			$timesheet_hierarchy_id = $hotlf->getByCompanyIdAndObjectTypeId( $current_company->getId(), 90 )->getCurrent()->getHierarchyControl();
			Debug::Text('TimeSheet Hierarchy ID: '. $timesheet_hierarchy_id, __FILE__, __LINE__, __METHOD__,10);

			//Get all levels below us.
			$timesheet_levels = $hlf->getLevelsByHierarchyControlIdAndUserId( $timesheet_hierarchy_id,  $current_user->getId() );
			Debug::Arr( $timesheet_levels, 'TimeSheet Levels', __FILE__, __LINE__, __METHOD__,10);

			if ( isset($selected_levels['timesheet']) AND in_array( $selected_levels['timesheet'], array_keys($request_levels) ) ) {
				$timesheet_selected_level = $selected_levels['timesheet'];
				Debug::Text(' Switching Levels to Level: '. $request_selected_level, __FILE__, __LINE__, __METHOD__,10);
			} else {
				$timesheet_selected_level = 0;
			}
			Debug::Text( 'TimeSheet Selected Level: '. $timesheet_selected_level, __FILE__, __LINE__, __METHOD__,10);

			//Get all relevant hierarchy ids
			$timesheet_hierarchy_user_ids = $hlf->getByHierarchyControlIdAndUserIdAndLevel( $timesheet_hierarchy_id, $current_user->getId(), (int)$timesheet_selected_level );
			//Debug::Arr( $timesheet_hierarchy_user_ids, 'TimeSheet Hierarchy Ids', __FILE__, __LINE__, __METHOD__,10);

			if ( is_array($timesheet_hierarchy_user_ids)
					AND isset($timesheet_hierarchy_user_ids['child_level'])
					AND isset($timesheet_hierarchy_user_ids['parent_level'])
					AND isset($timesheet_hierarchy_user_ids['current_level']) ) {

				$pptsvlf = new PayPeriodTimeSheetVerifyListFactory();
				$pptsvlf->getByUserIdListAndStatusAndNotAuthorized($timesheet_hierarchy_user_ids['child_level'], 30, $timesheet_hierarchy_user_ids['parent_level'], $timesheet_hierarchy_user_ids['current_level']  );

				$status_options = $pptsvlf->getOptions('status');

				foreach( $pptsvlf as $pptsv_obj) {
					//Grab authorizations for this object.
					$timesheets[] = array(
											'id' => $pptsv_obj->getId(),
											'pay_period_id' => $pptsv_obj->getPayPeriod(),
											'user_id' => $pptsv_obj->getUser(),
											'user_full_name' => $pptsv_obj->getUserObject()->getFullName(),
											'pay_period_start_date' => $pptsv_obj->getPayPeriodObject()->getStartDate(),
											'pay_period_end_date' => $pptsv_obj->getPayPeriodObject()->getEndDate(),
											'status_id' => $pptsv_obj->getStatus(),
											'status' => $status_options[$pptsv_obj->getStatus()]
										);
				}
				$smarty->assign_by_ref('timesheets', $timesheets);

				if ( isset($timesheet_levels) AND is_array($timesheet_levels) ) {
					$smarty->assign_by_ref('timesheet_levels', $timesheet_levels );
					$smarty->assign_by_ref('selected_timesheet_level', $timesheet_selected_level );
				}
			}
		}

		$smarty->assign_by_ref('selected_levels', $selected_levels );

		$smarty->assign_by_ref('sort_column', $sort_column );
		$smarty->assign_by_ref('sort_order', $sort_order );

		break;
}
$smarty->display('authorization/AuthorizationList.tpl');
?>