<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2073 $
 * $Id: Redirect.class.php 2073 2008-08-22 18:41:21Z ipso $
 * $Date: 2008-08-22 11:41:21 -0700 (Fri, 22 Aug 2008) $
 */

/**
 * @package Core
 */
class Redirect {
	static function page($url = NULL) {
		if ( empty($url) AND !empty($_SERVER['HTTP_REFERER']) ) {
			$url = $_SERVER['HTTP_REFERER'];
		}

		Debug::Text('Redirect URL: '. $url, __FILE__, __LINE__, __METHOD__,11);

		if ( Debug::getVerbosity() != 11 ) {
			header("Location: $url\n\n");

			//Prevent the rest of the script from running after redirect?
			Debug::writeToLog();

			ob_clean();
			exit;
		}

		return TRUE;
	}
}
?>
