C      $Id: x12f.fm4,v 1.11 2005/04/27 06:43:54 rlaboiss Exp $
C      Demonstration program for PLplot: Bar chart example.
C
C      Copyright (C) 2004  Alan W. Irwin
C
C      This file is part of PLplot.
C
C      PLplot is free software; you can redistribute it and/or modify
C      it under the terms of the GNU General Library Public License as
C      published by the Free Software Foundation; either version 2 of the
C      License, or (at your option) any later version.
C
C      PLplot is distributed in the hope that it will be useful,
C      but WITHOUT ANY WARRANTY; without even the implied warranty of
C      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C      GNU Library General Public License for more details.
C
C      You should have received a copy of the GNU Library General Public
C      License along with PLplot; if not, write to the Free Software
C      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

      implicit none

      character*20 string
      integer i
      real*8 y0(10)
      integer PL_PARSE_FULL
      parameter(PL_PARSE_FULL = 1)
C      Process command-line arguments
      call plparseopts(PL_PARSE_FULL)

      call plinit()

      call pladv(0)
      call plvsta
      call plwind( 1980.d0, 1990.d0, 0.d0, 35.d0 )
      call plbox( 'bc', 1.d0, 0, 'bcnv', 10.d0, 0 )
      call plcol0(2)
      call pllab( 'Year', 'Widget Sales (millions)',
     &            '#frPLplot Example 12' )

      y0(1) = 5
      y0(2) = 15
      y0(3) = 12
      y0(4) = 24
      y0(5) = 28
      y0(6) = 30
      y0(7) = 20
      y0(8) = 8
      y0(9) = 12
      y0(10) = 3

      do i = 0, 9
        call plcol0(i + 1)
        call plpsty(0)
        call plfbox( dble (1980.d0+i), y0(i+1) )
        write (string, '(i8)')int(y0(i+1))
        call lalign(string)
        call plptex( dble (1980.d0+i+0.5d0), y0(i+1)+1.d0,
     &    1.d0, 0.d0, 0.5d0, string )
        write (string, '(i8)')1980+i
        call lalign(string)
        call plmtex( 'b', 1.d0, dble ((i+1)*0.1d0-0.05d0),
     &    0.5d0, string )
      enddo

C      Don't forget to call PLEND to finish off!
      call plend
      end

C      Suck up leading spaces

      subroutine lalign(string)
      implicit none
      integer i, j, k, max, len
      character*(*) string

      max = len(string)

      do i = 1, max
        if (string(i:i) .ne. ' ') then
          if (i .eq. 1) return
          k = 1
          do j = i, max
            string(k:k) = string(j:j)
            k = k + 1
          enddo
          do j = k, max
            string(j:j) = ' '
          enddo
          return
        endif
      enddo
      end

      subroutine plfbox(x0, y0)
      implicit none

      real*8 x0, y0, x(4), y(4)

      x(1) = x0
      y(1) = 0.d0
      x(2) = x0
      y(2) = y0
      x(3) = x0+1.d0
      y(3) = y0
      x(4) = x0+1.d0
      y(4) = 0.d0
      call plfill( 4, x, y )
      call plcol0(1)
      call pllsty(1)
      call plline( 4, x, y )
      end
