<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: EditRecurringSchedule.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

if ( !$permission->Check('recurring_schedule','enabled')
		OR !( $permission->Check('recurring_schedule','edit') OR $permission->Check('recurring_schedule','edit_own') OR $permission->Check('recurring_schedule','edit_child') ) ) {
	$permission->Redirect( FALSE ); //Redirect
}

//Debug::setVerbosity(11);

$title = 'Edit Recurring Schedule';
$smarty->assign('title', TTi18n::gettext('Edit Recurring Schedule'));

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'id',
												'data'
												) ) );

if ( isset($data)) {
	if ( $data['start_date'] != '' ) {
		$data['start_date'] = TTDate::parseDateTime( $data['start_date'] );
	}
	if ( $data['end_date'] != '' ) {
		$data['end_date'] = TTDate::parseDateTime( $data['end_date'] );
	}
}

//Get Permission Hierarchy Children first, as this can be used for viewing, or editing.
$filter_data = NULL;
$permission_children_ids = array();
if ( $permission->Check('recurring_schedule','view') == FALSE ) {
	$hlf = new HierarchyListFactory();
	$permission_children_ids = $hlf->getHierarchyChildrenByCompanyIdAndUserIdAndObjectTypeID( $current_company->getId(), $current_user->getId() );
	Debug::Arr($permission_children_ids,'Permission Children Ids:', __FILE__, __LINE__, __METHOD__,10);
	
	if ( $permission->Check('recurring_schedule','view_child') == FALSE ) {
		$permission_children_ids = array();
	}
	if ( $permission->Check('recurring_schedule','view_own') ) {
		$permission_children_ids[] = $current_user->getId();
	}
	
	$filter_data['permission_children_ids'] = $permission_children_ids;
}

$rscf = new RecurringScheduleControlFactory();

$action = Misc::findSubmitButton();
$action = strtolower($action);
switch ($action) {
	case 'submit':
		Debug::Text('Submit!', __FILE__, __LINE__, __METHOD__,10);

		$rscf->setId( $data['id'] );
		$rscf->setCompany( $current_company->getId() );
		$rscf->setRecurringScheduleTemplateControl( $data['template_id'] );
		$rscf->setStartWeek( $data['start_week'] );
		$rscf->setStartDate( $data['start_date'] );
		$rscf->setEndDate( $data['end_date'] );
		if ( isset($data['auto_fill']) ) {
			$rscf->setAutoFill( TRUE );
		} else {
			$rscf->setAutoFill( FALSE );
		}

		if ( $rscf->isValid() ) {
			$rscf->Save(FALSE);

			if ( isset($data['user_ids']) ) {
				$rscf->setUser( $data['user_ids'] );
			}

			if ( $rscf->isValid() ) {
				$rscf->Save();

				Redirect::Page( URLBuilder::getURL( NULL, 'RecurringScheduleControlList.php') );

				break;
			}
		}
	default:
		if ( isset($id) ) {
			BreadCrumb::setCrumb($title);

			$rsclf = new RecurringScheduleControlListFactory();
			$rsclf->getByIdAndCompanyId( $id, $current_company->getID() );

			foreach ($rsclf as $rsc_obj) {
				//Debug::Arr($station,'Department', __FILE__, __LINE__, __METHOD__,10);

				$data = array(
									'id' => $rsc_obj->getId(),
									'template_id' => $rsc_obj->getRecurringScheduleTemplateControl(),
									'start_week' => $rsc_obj->getStartWeek(),
									'start_date' => $rsc_obj->getStartDate(),
									'end_date' => $rsc_obj->getEndDate(),
									'auto_fill' => $rsc_obj->getAutoFill(),
									'user_ids' => $rsc_obj->getUser(),
									'created_date' => $rsc_obj->getCreatedDate(),
									'created_by' => $rsc_obj->getCreatedBy(),
									'updated_date' => $rsc_obj->getUpdatedDate(),
									'updated_by' => $rsc_obj->getUpdatedBy(),
									'deleted_date' => $rsc_obj->getDeletedDate(),
									'deleted_by' => $rsc_obj->getDeletedBy()
								);
			}
		} elseif ( $action != 'submit' ) {
			Debug::Text('New Schedule', __FILE__, __LINE__, __METHOD__,10);
				$data = array(
									'start_week' => 1,
									'start_date' => TTDate::getBeginWeekEpoch( TTDate::getTime() ),
									'end_date' => NULL
								);

		}

		//Select box options;
		$ulf = new UserListFactory();
		$ulf->getSearchByCompanyIdAndArrayCriteria( $current_company->getId(), $filter_data );
		$user_options = UserListFactory::getArrayByListFactory( $ulf, FALSE, TRUE );
		//$user_options = $ulf->getByCompanyIDArray( $current_company->getId(), TRUE );

		$rstclf = new RecurringScheduleTemplateControlListFactory();
		$template_options = $rstclf->getByCompanyIdArray( $current_company->getId() );

		//Select box options;
		$data['template_options'] = $template_options;
		$data['user_options'] = $user_options;

		if ( isset($data['user_ids']) AND is_array($data['user_ids']) ) {
			$tmp_user_options = $user_options;
			foreach( $data['user_ids'] as $user_id ) {
				if( isset($tmp_user_options[$user_id]) ) {
					$filter_user_options[$user_id] = $tmp_user_options[$user_id];
				}
			}
			unset($user_id);
		}
		$smarty->assign_by_ref('filter_user_options', $filter_user_options);

		//var_dump($week_rows);

		$smarty->assign_by_ref('data', $data);

		break;
}

$smarty->assign_by_ref('rscf', $rscf);

$smarty->display('schedule/EditRecurringSchedule.tpl');
?>