<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1749 $
 * $Id: EditSchedulePolicy.php 1749 2008-03-07 22:59:31Z ipso $
 * $Date: 2008-03-07 14:59:31 -0800 (Fri, 07 Mar 2008) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

if ( !$permission->Check('schedule_policy','enabled')
		OR !( $permission->Check('schedule_policy','edit') OR $permission->Check('schedule_policy','edit_own') ) ) {

	$permission->Redirect( FALSE ); //Redirect

}

$smarty->assign('title', TTi18n::gettext($title = 'Edit Schedule Policy')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'id',
												'data'
												) ) );

if ( isset($data['start_stop_window'] ) ) {
	$data['start_stop_window'] = TTDate::parseTimeUnit($data['start_stop_window']);
}

$spf = new SchedulePolicyFactory();

$action = Misc::findSubmitButton();
$action = strtolower($action);
switch ($action) {
	case 'submit':
		Debug::Text('Submit!', __FILE__, __LINE__, __METHOD__,10);

		$spf->setId( $data['id'] );
		$spf->setCompany( $current_company->getId() );
		$spf->setName( $data['name'] );
		$spf->setMealPolicyID( $data['meal_policy_id'] );
		$spf->setOverTimePolicyID( $data['over_time_policy_id'] );
		$spf->setAbsencePolicyID( $data['absence_policy_id'] );
		$spf->setStartStopWindow( $data['start_stop_window'] );

		if ( $spf->isValid() ) {
			$spf->Save();

			Redirect::Page( URLBuilder::getURL( NULL, 'SchedulePolicyList.php') );

			break;
		}

	default:
		if ( isset($id) ) {
			BreadCrumb::setCrumb($title);

			$splf = new SchedulePolicyListFactory();
			$splf->getById($id);

			foreach ($splf as $sp_obj) {
				//Debug::Arr($station,'Department', __FILE__, __LINE__, __METHOD__,10);

				$data = array(
									'id' => $sp_obj->getId(),
									'name' => $sp_obj->getName(),
									'over_time_policy_id' => $sp_obj->getOverTimePolicyID(),
									'absence_policy_id' => $sp_obj->getAbsencePolicyID(),
									'meal_policy_id' => $sp_obj->getMealPolicyID(),
									'start_stop_window' => $sp_obj->getStartStopWindow(),
									'created_date' => $sp_obj->getCreatedDate(),
									'created_by' => $sp_obj->getCreatedBy(),
									'updated_date' => $sp_obj->getUpdatedDate(),
									'updated_by' => $sp_obj->getUpdatedBy(),
									'deleted_date' => $sp_obj->getDeletedDate(),
									'deleted_by' => $sp_obj->getDeletedBy()
								);
			}
		} elseif ( $action != 'submit' ) {
			$data = array(
							'start_stop_window' => 3600
							);
		}

		$aplf = new AbsencePolicyListFactory();
		$absence_options = $aplf->getByCompanyIDArray( $current_company->getId(), TRUE );

		$otplf = new OverTimePolicyListFactory();
		$over_time_options = $otplf->getByCompanyIDArray( $current_company->getId(), TRUE, array('type_id' => '= 200') );

		$mplf = new MealPolicyListFactory();
		$meal_options = $mplf->getByCompanyIDArray( $current_company->getId(), TRUE );

		//Select box options;
		$data['over_time_options'] = $over_time_options;
		$data['absence_options'] = $absence_options;
		$data['meal_options'] = $meal_options;

		$smarty->assign_by_ref('data', $data);

		break;
}

$smarty->assign_by_ref('spf', $spf);

$smarty->display('policy/EditSchedulePolicy.tpl');
?>