<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1282 $
 * $Id: User.php 1282 2007-10-03 21:26:10Z ipso $
 * $Date: 2007-10-03 14:26:10 -0700 (Wed, 03 Oct 2007) $
 */
require_once('../../includes/global.inc.php');

$authenticate=FALSE;
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

$smarty->assign('title', TTi18n::gettext($title = '6. Administrator User')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'company_id',
												'user_data',
												'external_installer',
												) ) );

$install_obj = new Install();
if ( $install_obj->isInstallMode() == FALSE ) {
	Redirect::Page( URLBuilder::getURL(NULL, 'install.php') );
}

$uf = new UserFactory();

$action = Misc::findSubmitButton();
switch ($action) {
	case 'back':
		Debug::Text('Back', __FILE__, __LINE__, __METHOD__,10);

		Redirect::Page( URLBuilder::getURL(NULL, 'Company.php') );
		break;

	case 'next':
		//Debug::setVerbosity(11);
		Debug::Text('Submit!', __FILE__, __LINE__, __METHOD__,10);

		$uf->StartTransaction();
		$uf->setCompany( $user_data['company_id'] );
		$uf->setStatus( 10 );
		$uf->setUserName($user_data['user_name']);
		if ( !empty($user_data['password']) AND $user_data['password'] == $user_data['password2'] ) {
			$uf->setPassword($user_data['password']);
		} else {
			$uf->Validator->isTrue(	$uf->password_validator_label,
									FALSE,
									$uf->password_validator_match_msg);
		}

		$uf->setEmployeeNumber(1);
		$uf->setFirstName($user_data['first_name']);
		$uf->setLastName($user_data['last_name']);
		$uf->setWorkEmail($user_data['work_email']);

		//Get Permission Control with highest ID, assume its for Administrators
		//and use it.
		$pclf = new PermissionControlListFactory();
		$pclf->getByCompanyId( $user_data['company_id'], NULL, NULL, NULL, array('id' => 'desc' ) );
		if ( $pclf->getRecordCount() > 0 ) {
			$pc_obj = $pclf->getCurrent();
			if ( is_object($pc_obj) ) {
				Debug::Text('Adding User to Permission Control: '. $pc_obj->getId(), __FILE__, __LINE__, __METHOD__,10);
				$uf->setPermissionControl( $pc_obj->getId() );
			}
		}

		if ( $uf->isValid() ) {
			$user_id = $uf->Save();

			$uf->CommitTransaction();

			if ( $external_installer == 1 ) {
				Redirect::Page( URLBuilder::getURL( NULL, 'Done.php') );
			} else {
				Redirect::Page( URLBuilder::getURL( NULL, 'MaintenanceJobs.php') );
			}

			break;
		}
		$uf->FailTransaction();

	default:
		if ( isset($company_id) ) {
			$user_data['company_id'] = $company_id;
		}
		$smarty->assign_by_ref('user_data', $user_data);

		break;
}

$handle = @fopen('http://www.timetrex.com/'.URLBuilder::getURL( array('v' => $install_obj->getFullApplicationVersion(), 'page' => 'user'), 'pre_install.php'), "r");
@fclose($handle);

$smarty->assign_by_ref('uf', $uf);
$smarty->assign_by_ref('external_installer', $external_installer);

$smarty->display('install/User.tpl');
?>