<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2237 $
 * $Id: RoundIntervalPolicyListFactory.class.php 2237 2008-11-11 18:18:20Z ipso $
 * $Date: 2008-11-11 10:18:20 -0800 (Tue, 11 Nov 2008) $
 */

/**
 * @package Module_Policy
 */
class RoundIntervalPolicyListFactory extends RoundIntervalPolicyFactory implements IteratorAggregate {

	function getAll($limit = NULL, $page = NULL, $where = NULL, $order = NULL) {
		$query = '
					select 	*
					from	'. $this->getTable() .'
					WHERE deleted = 0';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order );

		if ($limit == NULL) {
			//Run query without limit
			$this->rs = $this->db->SelectLimit($query);
		} else {
			$this->rs = $this->db->PageExecute($query, $limit, $page);
		}

		return $this;
	}

	function getById($id, $where = NULL, $order = NULL) {
		if ( $id == '') {
			return FALSE;
		}

		$this->rs = $this->getCache($id);
		if ( $this->rs === FALSE ) {
			$ph = array(
						'id' => $id,
						);

			$query = '
						select 	*
						from	'. $this->getTable() .'
						where	id = ?
							AND deleted = 0';
			$query .= $this->getWhereSQL( $where );
			$query .= $this->getSortSQL( $order );

			$this->rs = $this->db->Execute($query, $ph);

			$this->saveCache($this->rs,$id);
		}

		return $this;
	}

	function getByIdAndCompanyId($id, $company_id, $where = NULL, $order = NULL) {
		if ( $id == '') {
			return FALSE;
		}

		if ( $company_id == '') {
			return FALSE;
		}

		$ph = array(
					'id' => $id,
					'company_id' => $company_id
					);

		$query = '
					select 	*
					from	'. $this->getTable() .'
					where	id = ?
						AND company_id = ?
						AND deleted = 0';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order );

		$this->rs = $this->db->Execute($query, $ph);

		return $this;
	}

	function getByCompanyId($id, $where = NULL, $order = NULL) {
		if ( $id == '') {
			return FALSE;
		}

		if ( $order == NULL ) {
			$order = array( 'a.punch_type_id' => 'asc', 'a.name' => 'asc' );
			$strict = FALSE;
		} else {
			$strict = TRUE;
		}

		$pgf = new PolicyGroupFactory();
		$pgripf = new PolicyGroupRoundIntervalPolicyFactory();
		$hpf = new HolidayPolicyFactory();

		$ph = array(
					'id' => $id,
					);

		$query = '
					select 	a.*,
							(
								(select count(*) from '. $pgripf->getTable() .' as x, '. $pgf->getTable() .' as w where x.policy_group_id = w.id and x.round_interval_policy_id = a.id and w.deleted = 0 )+
								(select count(*) from '. $hpf->getTable() .' as z where z.round_interval_policy_id = a.id and z.deleted = 0 )
							) as assigned_policy_groups
					from	'. $this->getTable() .' as a
					where	a.company_id = ?
						AND a.deleted = 0';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order, $strict );

		$this->rs = $this->db->Execute($query, $ph);
	}

	function getByCompanyIdArray($company_id, $include_blank = TRUE) {

		$riplf = new RoundIntervalPolicyListFactory();
		$riplf->getByCompanyId($company_id);

		if ( $include_blank == TRUE ) {
			$list[0] = '--';
		}

		foreach ($riplf as $rip_obj) {
			$list[$rip_obj->getID()] = $rip_obj->getName();
		}

		if ( isset($list) ) {
			return $list;
		}

		return FALSE;
	}

	function getByPolicyGroupUserIdAndTypeId($user_id, $type_id, $where = NULL, $order = NULL) {
		if ( $user_id == '') {
			return FALSE;
		}

		if ( $type_id == '') {
			return FALSE;
		}

		if ( $order == NULL ) {
			$order = array( 'c.punch_type_id' => 'desc' );
			$strict = FALSE;
		} else {
			$strict = TRUE;
		}

		$pgf = new PolicyGroupFactory();
		$pguf = new PolicyGroupUserFactory();
		$pgripf = new PolicyGroupRoundIntervalPolicyFactory();
		$ripf = new RoundIntervalPolicyFactory();

		$punch_type_relation_options = $ripf->getOptions('punch_type_relation');
		if ( isset($punch_type_relation_options[$type_id]) ) {
			$punch_type_ids = $punch_type_relation_options[$type_id];
			$punch_type_ids[] = $type_id;
		} else {
			return FALSE;
		}

		$ph = array(
					'user_id' => $user_id,
					);

		$query = '
					select 	c.*
					from 	'. $pguf->getTable() .' as a,
							'. $pgf->getTable() .' as ab,
							'. $pgripf->getTable() .' as b,
							'. $this->getTable() .' as c,
							'. $ripf->getTable() .' as d
					where 	a.policy_group_id = ab.id
						AND a.policy_group_id = b.policy_group_id
						AND b.round_interval_policy_id = c.id
						AND b.round_interval_policy_id = d.id
						AND a.user_id = ?
						AND c.punch_type_id in ( '. $this->getListSQL($punch_type_ids, $ph) .')
						AND ( ab.deleted = 0 AND c.deleted = 0 AND d.deleted = 0 )
						';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order, $strict );
		$query .= ' LIMIT 1';

		$this->rs = $this->db->Execute($query, $ph);

		//$this->rs = $this->db->Execute($query);

		return $this;
	}


}
?>
