C      $Id: x02f.fm4,v 1.13 2005/04/27 06:43:54 rlaboiss Exp $
C      Demonstrates multiple windows and color map 0 
C
C      Copyright (C) 2004  Alan W. Irwin
C      Copyright (C) 2005  Andrew Ross
C
C      This file is part of PLplot.
C
C      PLplot is free software; you can redistribute it and/or modify
C      it under the terms of the GNU General Library Public License as
C      published by the Free Software Foundation; either version 2 of the
C      License, or (at your option) any later version.
C
C      PLplot is distributed in the hope that it will be useful,
C      but WITHOUT ANY WARRANTY; without even the implied warranty of
C      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C      GNU Library General Public License for more details.
C
C      You should have received a copy of the GNU Library General Public
C      License along with PLplot; if not, write to the Free Software
C      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

      implicit none

      integer PL_PARSE_FULL
      parameter(PL_PARSE_FULL = 1)
C      Process command-line arguments
      call plparseopts(PL_PARSE_FULL)


C     Initialize plplot
      call plinit()

C     Run demos
      call demo1
      call demo2

      call plend

      end


C--------------------------------------------------------------------------
C     demo1
C
C     Demonstrates multiple windows and default color map 0 palette.
C--------------------------------------------------------------------------
      subroutine demo1
      implicit none
      
      call plbop

C     Divide screen into 16 regions
      call plssub(4,4)

      call draw_windows(16, 0)

      call pleop

      end 


C--------------------------------------------------------------------------
C     demo2
C
C     Demonstrates multiple windows, user-modified color map 0 palette,
C     and HLS -> RGB translation. 
C--------------------------------------------------------------------------
      subroutine demo2
      implicit none
      integer r(116), g(116), b(116)
      real*8 lmin, lmax
      parameter (lmin = 0.15d0, lmax = 0.85d0)
      integer i
      real*8 h, l, s, r1, g1, b1

      call plbop

C     Divide screen into 100 regions
      call plssub(10,10)


      do i=0,99
C     Bounds on HLS, from plhlsrgb() commentary --
C     hue		[0., 360.]	degrees
C     lightness	        [0., 1.]	magnitude
C     saturation	[0., 1.]	magnitude

C     Vary hue uniformly from left to right
         h = (360.d0/10.d0)*mod(i,10)
C     Vary lightness uniformly from top to bottom, between min and max
         l = lmin + (lmax - lmin) * (i / 10) / 9.d0
C     Use max saturation
         s = 1.d0

         call plhlsrgb(h, l, s, r1, g1, b1)
         
         r(i+17) = r1*255
         g(i+17) = g1*255
         b(i+17) = b1*255
      enddo

      do i=1,16
         call plgcol0(i-1,r(i),g(i),b(i))
      enddo

      call plscmap0(r, g, b, 116)

      call draw_windows(100, 16)

      call pleop

      end 

C--------------------------------------------------------------------------
C     draw_windows
C
C     Draws a set of numbered boxes with colors according to cmap0 entry.
C--------------------------------------------------------------------------
      subroutine draw_windows( nw, cmap0_offset )
      implicit none
      integer nw, cmap0_offset
      integer i,j
      real*8 vmin, vmax
      character*3 text
      
      
      call plschr(0.0d0, 3.5d0)
      call plfont(4)

      do i=0,nw-1
        call plcol0(i+cmap0_offset)
        write (text,'(i3)') i
        if (i .lt. 10) then
           text=text(3:3)
        elseif (i.lt.100) then
           text=text(2:3)
        endif
        call pladv(0)
        vmin = 0.1d0
        vmax = 0.9d0
        do j=1,3
          call plwid(j)
          call plvpor(vmin,vmax,vmin,vmax)
          call plwind(0.0d0, 1.0d0, 0.0d0, 1.0d0)
          call plbox('bc', 0.0d0, 0, 'bc', 0.0d0, 0)
          vmin = vmin + 0.1d0
          vmax = vmax - 0.1d0
        enddo
        call plwid(1)
        call plptex(0.5d0, 0.5d0, 1.0d0, 0.0d0, 0.5d0, text)
      enddo

      end
