/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.resources;

import java.io.IOException;
import java.util.Locale;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.resources.SaveUserDatabaseAction;
import org.apache.webapp.admin.resources.UserDatabaseForm;

public final class SetUpUserDatabaseAction
extends Action {
    private MBeanServer mserver = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.mserver == null) {
            this.mserver = ((ApplicationServlet)this.getServlet()).getServer();
        }
        MessageResources resources = this.getResources(request);
        Locale locale = this.getLocale(request);
        String objectName = request.getParameter("objectName");
        String domain = request.getParameter("domain");
        UserDatabaseForm userDatabaseForm = new UserDatabaseForm();
        userDatabaseForm.setFactory(SaveUserDatabaseAction.USERDB_FACTORY);
        userDatabaseForm.setType("org.apache.catalina.UserDatabase");
        userDatabaseForm.setDomain(domain);
        if (objectName == null) {
            userDatabaseForm.setNodeLabel(resources.getMessage(locale, "resources.actions.userdb.create"));
            userDatabaseForm.setObjectName(null);
        } else {
            userDatabaseForm.setNodeLabel(resources.getMessage(locale, "resources.actions.userdb.edit"));
            userDatabaseForm.setObjectName(objectName);
            String attribute = null;
            try {
                ObjectName oname = new ObjectName(objectName);
                attribute = "name";
                userDatabaseForm.setName((String)this.mserver.getAttribute(oname, attribute));
                attribute = "pathname";
                userDatabaseForm.setPath((String)this.mserver.getAttribute(oname, attribute));
                attribute = "description";
                userDatabaseForm.setDescription((String)this.mserver.getAttribute(oname, attribute));
            }
            catch (Exception e) {
                this.getServlet().log(resources.getMessage(locale, "users.error.attribute.get", (Object)attribute), (Throwable)e);
                response.sendError(500, resources.getMessage(locale, "users.error.attribute.get", (Object)attribute));
                return null;
            }
        }
        this.saveToken(request);
        request.setAttribute("userDatabaseForm", (Object)userDatabaseForm);
        return mapping.findForward("UserDatabase");
    }
}

