/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.resources;

import java.io.IOException;
import java.util.Locale;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.resources.EnvEntriesForm;
import org.apache.webapp.admin.resources.ResourceUtils;

public final class DeleteEnvEntriesAction
extends Action {
    private MBeanServer mserver = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.mserver == null) {
            this.mserver = ((ApplicationServlet)this.getServlet()).getServer();
        }
        MessageResources resources = this.getResources(request);
        Locale locale = this.getLocale(request);
        if (this.isCancelled(request)) {
            return mapping.findForward("List EnvEntries Setup");
        }
        if (!this.isTokenValid(request)) {
            response.sendError(400, resources.getMessage(locale, "users.error.token"));
            return null;
        }
        EnvEntriesForm envEntriesForm = (EnvEntriesForm)form;
        String[] envEntries = envEntriesForm.getEnvEntries();
        String resourcetype = envEntriesForm.getResourcetype();
        String path = envEntriesForm.getPath();
        String host = envEntriesForm.getHost();
        if (envEntries == null) {
            envEntries = new String[]{};
        }
        try {
            ObjectName dname = null;
            String[] signature = new String[]{"java.lang.String"};
            Object[] params = new String[1];
            for (int i = 0; i < envEntries.length; ++i) {
                ObjectName oname = new ObjectName(envEntries[i]);
                String domain = oname.getDomain();
                dname = ResourceUtils.getNamingResourceObjectName(domain, resourcetype, path, host);
                params[0] = oname.getKeyProperty("name");
                this.mserver.invoke(dname, "removeEnvironment", params, signature);
            }
        }
        catch (Throwable t) {
            this.getServlet().log(resources.getMessage(locale, "users.error.invoke", (Object)"removeEnvironment"), t);
            response.sendError(500, resources.getMessage(locale, "users.error.invoke", (Object)"removeEnvironment"));
            return null;
        }
        return mapping.findForward("EnvEntries List Setup");
    }
}

