<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2158 $
 * $Id: fix_hierarchy.php 2158 2008-09-15 23:26:15Z ipso $
 * $Date: 2008-09-15 16:26:15 -0700 (Mon, 15 Sep 2008) $
 */
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR .'..'. DIRECTORY_SEPARATOR .'includes'. DIRECTORY_SEPARATOR .'global.inc.php');
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR .'..'. DIRECTORY_SEPARATOR .'includes'. DIRECTORY_SEPARATOR .'CLI.inc.php');

if ( $argc < 2 OR in_array ($argv[1], array('--help', '-help', '-h', '-?') ) ) {
	$help_output = "Usage: fix_hierarchy.php [company_id] [hierarchy_id]\n";
	echo $help_output;
} else {
	//Rebuilt Hierarhcy Tree if a transaction fails using MyISAM or something
	$company_id = $argv[1];
	$hierarchy_control_id = $argv[2];

	if ( $company_id != '' AND $hierarchy_control_id != '' ) {
		$hclf = new HierarchyControlListFactory();
		$hclf->StartTransaction();
		$hclf->getById( $hierarchy_control_id );
		if ( $hclf->getRecordCount() > 0 ) {
			foreach( $hclf as $hc_obj ) {
				$query = 'select tree_id,object_id,parent_id,left_id from hierarchy_tree where tree_id = '. $hc_obj->getID() .' GROUP BY tree_id, object_id, parent_id, left_id order by left_id';
				$result = $db->Execute( $query );
				foreach( $result as $row ) {
					echo 'Tree ID: '. $row['tree_id'] .' Parent ID: '. $row['parent_id'] .' User ID: '. $row['object_id'] ."<br>\n";
					$tree_arr[] = array('parent_id' => $row['parent_id'], 'object_id' => $row['object_id'] );
				}

				$object_types = $hc_obj->getObjectType();
				$name = $hc_obj->getName();
				$description = $hc_obj->getDescription();

				$hc_obj->setDeleted(TRUE);
				$hc_obj->Save();
			}

			$hcf = new HierarchyControlFactory();
			$hcf->setCompany( $company_id );
			$hcf->setObjectType( $object_types );
			$hcf->setName( $name.' (FIXED)' );
			$hcf->setDescription( $description.' (FIXED)' );
			if ( $hcf->isValid() ) {
				$hc_id = $hcf->Save();

				foreach( $tree_arr as $key => $value ) {
					$hf = new HierarchyFactory();
					$hf->setHierarchyControl( $hc_id );
					$hf->setUser( $value['object_id'] );
					$hf->setParent( $value['parent_id'] );

					if ( $hf->isValid() ) {
						$hf->Save();
					}
				}
			} else {
				echo "Creating new Hierarchy Failed!<br\n";
			}

		}
		//$hclf->FailTransaction();
		$hclf->CommitTransaction();
	}
}
//Debug::Display();
?>
