<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: RecurringScheduleControlList.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

if ( !$permission->Check('recurring_schedule','enabled')
		OR !( $permission->Check('recurring_schedule','view') OR $permission->Check('recurring_schedule','view_own') OR $permission->Check('recurring_schedule','view_child') ) ) {
	$permission->Redirect( FALSE ); //Redirect
}

//Debug::setVerbosity(11);

$smarty->assign('title', TTi18n::gettext($title = 'Recurring Schedule List')); // See index.php
BreadCrumb::setCrumb($title);

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'page',
												'sort_column',
												'sort_order',
												'ids',
												) ) );

URLBuilder::setURL($_SERVER['SCRIPT_NAME'],
											array(
													'sort_column' => $sort_column,
													'sort_order' => $sort_order,
													'page' => $page
												) );

$sort_array = NULL;
if ( $sort_column != '' ) {
	$sort_array = array($sort_column => $sort_order);
}

$filter_data = array();
//Get Permission Hierarchy Children first, as this can be used for viewing, or editing.
$permission_children_ids = array();
if ( $permission->Check('recurring_schedule','view') == FALSE ) {
	$hlf = new HierarchyListFactory();
	$permission_children_ids = $hlf->getHierarchyChildrenByCompanyIdAndUserIdAndObjectTypeID( $current_company->getId(), $current_user->getId() );

	if ( $permission->Check('recurring_schedule','view_child') == FALSE ) {
		$permission_children_ids = array();
	}
	if ( $permission->Check('recurring_schedule','view_own') ) {
		$permission_children_ids[] = $current_user->getId();
	}

	$filter_data['permission_children_ids'] = $permission_children_ids;
}
Debug::Arr($ids,'Selected Objects', __FILE__, __LINE__, __METHOD__,10);

$action = Misc::findSubmitButton();
switch ($action) {
	case 'add':

		Redirect::Page( URLBuilder::getURL( NULL, 'EditRecurringSchedule.php', FALSE) );

		break;
	case 'delete':
	case 'undelete':
		if ( strtolower($action) == 'delete' ) {
			$delete = TRUE;
		} else {
			$delete = FALSE;
		}

		$rsclf = new RecurringScheduleControlListFactory();

		foreach ($ids as $id => $user_ids) {
			$rsclf->getByIdAndCompanyId($id, $current_company->getId() );
			foreach ($rsclf as $rsc_obj) {
				//Get all users for this schedule.
				$current_users = $rsc_obj->getUser();

				$user_diff_arr = array_diff( (array)$current_users, (array)$user_ids );
				//Debug::Arr($user_diff_arr,'User Diff:', __FILE__, __LINE__, __METHOD__,10);

				if ( is_array($user_diff_arr) AND count($user_diff_arr) == 0 ) {
					Debug::Text('No more users assigned to schedule, deleting...', __FILE__, __LINE__, __METHOD__,10);

					//No more users assigned to this schedule, delete the whole thing.
					$rsc_obj->setDeleted($delete);
				} elseif ( is_array($user_diff_arr) AND count($user_diff_arr) > 0 ) {
					Debug::Text('Still more users assigned to schedule, removing users only...', __FILE__, __LINE__, __METHOD__,10);
					//Still users assigned to this schedule, remove users from it.
					$rsc_obj->setUser( $user_diff_arr );
				}

				if ( $rsc_obj->isValid() ) {
					$rsc_obj->Save();
				}
			}
		}

		Redirect::Page( URLBuilder::getURL( NULL, 'RecurringScheduleControlList.php') );

		break;

	default:
		$rsclf = new RecurringScheduleControlListFactory();
		//$rsclf->getByCompanyId( $current_company->getId(), $current_user_prefs->getItemsPerPage(), $page, NULL, $sort_array );
		$rsclf->getSearchByCompanyIdAndArrayCriteria( $current_company->getId(), $filter_data, $current_user_prefs->getItemsPerPage(), $page, NULL, $sort_array );

		$pager = new Pager($rsclf);

		foreach ($rsclf as $rsc_obj) {
			//var_dump($rsc_obj);
			$user_id = $rsc_obj->getColumn('user_id');

			$ulf = new UserListFactory();
			$ulf->getByID( $user_id );
			if ( $ulf->getRecordCount() == 1 ) {
				$u_obj = $ulf->getCurrent();
			} else {
				//Skip this row.
				Debug::Text('Skipping Row: User ID: '. $user_id , __FILE__, __LINE__, __METHOD__,10);
				continue;
			}

			$rows[] = array(
								'id' => $rsc_obj->getId(),
								'user_id' => $user_id,
								'name' => $rsc_obj->getColumn('name'),
								'description' => $rsc_obj->getColumn('description'),
								'start_week' => $rsc_obj->getStartWeek(),
								'start_date' => $rsc_obj->getStartDate(),
								'end_date' => $rsc_obj->getEndDate(),
								'user_full_name' => $u_obj->getFullName(TRUE),

								'is_owner' => $permission->isOwner( $u_obj->getCreatedBy(), $u_obj->getId() ),
								'is_child' => $permission->isChild( $u_obj->getId(), $permission_children_ids ),

								'deleted' => $rsc_obj->getDeleted()
							);

		}
		$smarty->assign_by_ref('rows', $rows);

		$smarty->assign_by_ref('sort_column', $sort_column );
		$smarty->assign_by_ref('sort_order', $sort_order );

		$smarty->assign_by_ref('paging_data', $pager->getPageVariables() );

		break;
}
$smarty->display('schedule/RecurringScheduleControlList.tpl');
?>