<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2308 $
 * $Id: BC.class.php 2308 2008-12-22 23:06:24Z ipso $
 * $Date: 2008-12-22 15:06:24 -0800 (Mon, 22 Dec 2008) $
 */

/**
 * @package PayrollDeduction
 */
class PayrollDeduction_CA_BC extends PayrollDeduction_CA {
	function getProvincialTaxReduction() {

		$A = $this->getAnnualTaxableIncome();
		$T4 = $this->getProvincialBasicTax();
		$V1 = $this->getProvincialSurtax();
		$Y = 0;
		$S = 0;

		Debug::text('BC Specific - Province: '. $this->getProvince(), __FILE__, __LINE__, __METHOD__,10);
		if ( $this->getDate() >= strtotime('01-Jan-2009') ) {
			//Calculate S after Jan 1st 2009.
			if ( $A <= 17285 ) {
				Debug::text('S: Annual Income less than 17285', __FILE__, __LINE__, __METHOD__,10);
				if ( $T4 > 389 ) {
					$S = 389;
				} else {
					$S = $T4;
				}
			} elseif ( $A > 17285 AND $A <= 29441.25) {
				Debug::text('S: Annual Income less than 29441.25', __FILE__, __LINE__, __METHOD__,10);

				$tmp_S = bcsub( 389, bcmul( bcsub( $A, 17285 ), 0.032 ) );
				Debug::text('Tmp_S: '. $tmp_S, __FILE__, __LINE__, __METHOD__,10);

				if ( $T4 > $tmp_S ) {
					$S = $tmp_S;
				} else {
					$S = $T4;
				}
				unset($tmp_S);
			}
		} elseif ( $this->getDate() >= strtotime('01-Jan-2008') ) {
			//Calculate S after Jan 1st 2008.
			if ( $A <= 16946 ) {
				Debug::text('S: Annual Income less than 16646', __FILE__, __LINE__, __METHOD__,10);
				if ( $T4 > 381 ) {
					$S = 381;
				} else {
					$S = $T4;
				}
			} elseif ( $A > 16946 AND $A <= 28852.25) {
				Debug::text('S: Annual Income less than 28852.25', __FILE__, __LINE__, __METHOD__,10);

				$tmp_S = bcsub( 381, bcmul( bcsub( $A, 16946 ), 0.032 ) );
				Debug::text('Tmp_S: '. $tmp_S, __FILE__, __LINE__, __METHOD__,10);

				if ( $T4 > $tmp_S ) {
					$S = $tmp_S;
				} else {
					$S = $T4;
				}
				unset($tmp_S);
			}
		} elseif ( $this->getDate() >= strtotime('01-Jul-2007') ) {
			//Calculate S after Jul 1st 2007.
			if ( $A <= 16646 ) {
				Debug::text('S: Annual Income less than 16646', __FILE__, __LINE__, __METHOD__,10);
				if ( $T4 > 375 ) {
					$S = 375;
				} else {
					$S = $T4;
				}
			} elseif ( $A > 16646 AND $A <= 28364.75) {
				Debug::text('S: Annual Income less than 27062.67', __FILE__, __LINE__, __METHOD__,10);

				$tmp_S = bcsub( 375, bcmul( bcsub( $A, 16646 ), 0.032 ) );
				Debug::text('Tmp_S: '. $tmp_S, __FILE__, __LINE__, __METHOD__,10);

				if ( $T4 > $tmp_S ) {
					$S = $tmp_S;
				} else {
					$S = $T4;
				}
				unset($tmp_S);
			}
		} elseif ( $this->getDate() >= strtotime('01-Jan-2007') ) {
			//Calculate S after Jan 1st 2007.
			if ( $A <= 16646 ) {
				Debug::text('S: Annual Income less than 16646', __FILE__, __LINE__, __METHOD__,10);
				if ( $T4 > 375 ) {
					$S = 375;
				} else {
					$S = $T4;
				}
			} elseif ( $A > 16646 AND $A <= 27062.67) {
				Debug::text('S: Annual Income less than 27062.67', __FILE__, __LINE__, __METHOD__,10);

				$tmp_S = bcsub( 375, bcmul( bcsub( $A, 16646 ), 0.036 ) );
				Debug::text('Tmp_S: '. $tmp_S, __FILE__, __LINE__, __METHOD__,10);

				if ( $T4 > $tmp_S ) {
					$S = $tmp_S;
				} else {
					$S = $T4;
				}
				unset($tmp_S);
			}
		} elseif ( $this->getDate() >= strtotime('01-Jan-2006') ) {
			//Calculate S after Jan 1st 2006.
			if ( $A <= 16336 ) {
				Debug::text('S: Annual Income less than 16336', __FILE__, __LINE__, __METHOD__,10);
				if ( $T4 > 368 ) {
					$S = 368;
				} else {
					$S = $T4;
				}
			} elseif ( $A > 16336 AND $A <= 26558.22) {
				Debug::text('S: Annual Income less than 26558', __FILE__, __LINE__, __METHOD__,10);

				//$tmp_S = 368 - ( ( $A - 16336 ) * 0.036 );
				$tmp_S = bcsub( 368, bcmul( bcsub( $A, 16336 ), 0.036 ) );
				Debug::text('Tmp_S: '. $tmp_S, __FILE__, __LINE__, __METHOD__,10);

				if ( $T4 > $tmp_S ) {
					$S = $tmp_S;
				} else {
					$S = $T4;
				}
				unset($tmp_S);
			}
		} elseif ( $this->getDate() >= strtotime('01-Jul-2005') ) {
			//Calculate S after July 1st 2005.
			if ( $A <= 16000 ) {
				Debug::text('S: Annual Income less than 16000', __FILE__, __LINE__, __METHOD__,10);
				if ( $T4 > 360 ) {
					$S = 360;
				} else {
					$S = $T4;
				}
			} elseif ( $A > 16000 AND $A <= 26000) {
				Debug::text('S: Annual Income less than 26000', __FILE__, __LINE__, __METHOD__,10);

				//$tmp_S = 360 - ( ( $A - 16000 ) * 0.036 );
				$tmp_S = bcsub( 360, bcmul( bcsub( $A, 16000 ), 0.036 ) );
				Debug::text('Tmp_S: '. $tmp_S, __FILE__, __LINE__, __METHOD__,10);

				if ( $T4 > $tmp_S ) {
					$S = $tmp_S;
				} else {
					$S = $T4;
				}
				unset($tmp_S);
			}
		}

		Debug::text('aS: '. $S, __FILE__, __LINE__, __METHOD__,10);

		if ( $S < 0 ) {
			$S = 0;
		}

		Debug::text('bS: '. $S, __FILE__, __LINE__, __METHOD__,10);

		return $S;
	}
}
?>
