<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2158 $
 * $Id: HelpListFactory.class.php 2158 2008-09-15 23:26:15Z ipso $
 * $Date: 2008-09-15 16:26:15 -0700 (Mon, 15 Sep 2008) $
 */

/**
 * @package Module_Help
 */
class HelpListFactory extends HelpFactory implements IteratorAggregate {

	function getAll($limit = NULL, $page = NULL, $where = NULL, $order = NULL) {

		$strict_order = TRUE;
		if ( $order == NULL ) {
			$order = array('created_date' => 'desc');
			//$strict_order = FALSE;
		}

		$query = '
					select 	*
					from	'. $this->getTable() .'
					WHERE deleted=0';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order, $strict_order );

		if ($limit == NULL) {
			//Run query without limit
			$this->rs = $this->db->SelectLimit($query);
		} else {
			$this->rs = $this->db->PageExecute($query, $limit, $page);
		}

		return $this;
	}

	function getById($id, $where = NULL, $order = NULL) {
		if ( $id == '' ) {
			return FALSE;
		}

		$ph = array(
					'id' => $id,
					);

		$query = '
					select 	*
					from	'. $this->getTable() .'
					where	id = ?
						AND deleted=0';
		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order );

		$this->rs = $this->db->Execute($query, $ph);

		return $this;
	}

	function getByScriptNameAndGroupName($script_name, $group_name = NULL, $where = NULL, $order = NULL) {
		if ( $script_name == '' AND $group_name == '' ) {
			return FALSE;
		}

		$hgcf = new HelpGroupControlFactory();
		$hg = new HelpGroupFactory();

		$ph = array(
					'script_name' => $script_name,
					'group_name' => $group_name,
					);

		$query = '
					select 	a.*
					from	'. $this->getTable() .' as a,
							'. $hgcf->getTable() .' as b,
							'. $hg->getTable() .' as c
					where	b.id = c.help_group_control_id
							AND c.help_id = a.id
						';
		//if ( $script_name != '' ) {
			$query .= ' AND b.script_name = ?';
		//}

		//if ( $group_name != '') {
			$query .= ' AND b.name = ?';
		//}

		$query .= ' AND a.deleted=0
					AND b.deleted=0
					ORDER BY c.order_value asc';

		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order );

		$this->rs = $this->db->Execute($query, $ph);

		return $this;
	}

	function getByScriptNameAndType($script_name, $type, $where = NULL, $order = NULL) {
		if ( $script_name == '') {
			return FALSE;
		}

		if ( $type == '') {
			return FALSE;
		}

		$type_key = Option::getByValue($type, $this->getOptions('type') );
		if ($type_key !== FALSE) {
			$type = $type_key;
		}

		$hgcf = new HelpGroupControlFactory();
		$hg = new HelpGroupFactory();

		$ph = array(
					'script_name' => $script_name,
					'type_id' => $type,
					);

		$query = '
					select 	a.*, b.name as group_name
					from	'. $this->getTable() .' as a,
							'. $hgcf->getTable() .' as b,
							'. $hg->getTable() .' as c
					where	b.id = c.help_group_control_id
							AND c.help_id = a.id
							AND b.script_name = ?
							AND a.type_id = ?
							AND a.deleted=0
							AND b.deleted=0
					ORDER BY c.order_value asc
						';

		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order );

		$this->rs = $this->db->Execute($query, $ph);

		return $this;
	}

	function getByScriptNameAndTypeAndStatus($script_name, $type, $status, $where = NULL, $order = NULL) {
		if ( $script_name == '') {
			return FALSE;
		}

		if ( $type == '') {
			return FALSE;
		}

		if ( $status == '') {
			return FALSE;
		}

		$type_key = Option::getByValue($type, $this->getOptions('type') );
		if ($type_key !== FALSE) {
			$type = $type_key;
		}

		$hgcf = new HelpGroupControlFactory();
		$hg = new HelpGroupFactory();

		$ph = array(
					'script_name' => $script_name,
					'type_id' => $type,
					'status_id' => $status,
					);

		$query = '
					select 	a.*, b.name as group_name
					from	'. $this->getTable() .' as a,
							'. $hgcf->getTable() .' as b,
							'. $hg->getTable() .' as c
					where	b.id = c.help_group_control_id
							AND c.help_id = a.id
							AND b.script_name = ?
							AND a.type_id = ?
							AND a.status_id = ?
							AND a.deleted=0
							AND b.deleted=0
					ORDER BY c.order_value asc
						';

		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order );

		$this->rs = $this->db->Execute($query, $ph);

		return $this;
	}

	function getByScriptNameAndStatus($script_name, $status, $where = NULL, $order = NULL) {
		if ( $script_name == '') {
			return FALSE;
		}

		if ( $status == '') {
			return FALSE;
		}

		$status_key = Option::getByValue($status, $this->getOptions('status') );
		if ($status_key !== FALSE) {
			$status = $status_key;
		}

		$hgcf = new HelpGroupControlFactory();
		$hg = new HelpGroupFactory();

		$ph = array(
					'script_name' => $script_name,
					'status_id' => $status,
					);

		$query = '
					select 	a.*, b.name as group_name
					from	'. $this->getTable() .' as a,
							'. $hgcf->getTable() .' as b,
							'. $hg->getTable() .' as c
					where	b.id = c.help_group_control_id
							AND c.help_id = a.id
							AND b.script_name = ?
							AND a.status_id = ?
							AND a.deleted=0
							AND b.deleted=0
					ORDER BY a.type_id desc, c.order_value asc
						';

		$query .= $this->getWhereSQL( $where );
		$query .= $this->getSortSQL( $order );

		$this->rs = $this->db->Execute($query, $ph);

		return $this;
	}

	function getAllArray() {
		$hlf = new HelpListFactory();
		$hlf->getAll();

		$help_list[0] = '--';

		foreach ($hlf as $help) {
			$help_list[$help->getID()] = '('. $help->getID() .') ['. Option::getByKey($help->getType(), $help->getOptions('type') ) .'] '. $help->getHeading();
		}

		return $help_list;
	}
}
?>
