/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol;

import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.swing.tabcontrol.ComponentConverter;
import org.netbeans.swing.tabcontrol.DefaultTabDataModel;
import org.netbeans.swing.tabcontrol.LocationInformer;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.TabbedContainerUI;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbed;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.netbeans.swing.tabcontrol.plaf.DefaultTabbedContainerUI;
import org.openide.util.NbBundle;

public class TabbedContainer
extends JComponent
implements Accessible {
    public static final String TABBED_CONTAINER_UI_CLASS_ID = "TabbedContainerUI";
    public static final int TYPE_VIEW = 0;
    public static final int TYPE_EDITOR = 1;
    public static final int TYPE_SLIDING = 2;
    public static final int TYPE_TOOLBAR = 3;
    public static final String PROP_ACTIVE = "active";
    public static final String PROP_MANAGE_TAB_POSITION = "manageTabPosition";
    public static final String COMMAND_CLOSE = "close";
    public static final String COMMAND_SELECT = "select";
    public static final String COMMAND_POPUP_REQUEST = "popup";
    public static final String COMMAND_MAXIMIZE = "maximize";
    public static final String COMMAND_CLOSE_ALL = "closeAll";
    public static final String COMMAND_CLOSE_ALL_BUT_THIS = "closeAllButThis";
    public static final String COMMAND_ENABLE_AUTO_HIDE = "enableAutoHide";
    public static final String COMMAND_DISABLE_AUTO_HIDE = "disableAutoHide";
    public static final String COMMAND_TOGGLE_TRANSPARENCY = "toggleTransparency";
    private TabDataModel model;
    private final int type;
    private boolean active = false;
    private boolean initialized = false;
    private transient List<ActionListener> actionListenerList;
    public static final int CONTENT_POLICY_ADD_ALL = 1;
    public static final int CONTENT_POLICY_ADD_ON_FIRST_USE = 2;
    public static final int CONTENT_POLICY_ADD_ONLY_SELECTED = 3;
    private int contentPolicy = DEFAULT_CONTENT_POLICY;
    protected static int DEFAULT_CONTENT_POLICY = 1;
    private ComponentConverter converter = null;
    private WinsysInfoForTabbed winsysInfo = null;
    @Deprecated
    private LocationInformer locationInformer = null;
    private static final float ALPHA_TRESHOLD = 0.2f;
    private float currentAlpha = 1.0f;
    AWTEventListener awtListener = null;

    public TabbedContainer() {
        this(null, 0);
    }

    public TabbedContainer(TabDataModel tabDataModel) {
        this(tabDataModel, 0);
    }

    public TabbedContainer(int n) {
        this(null, n);
    }

    public TabbedContainer(TabDataModel tabDataModel, int n) {
        this(tabDataModel, n, (WinsysInfoForTabbed)null);
    }

    @Deprecated
    public TabbedContainer(TabDataModel tabDataModel, int n, LocationInformer locationInformer) {
        this(tabDataModel, n, (WinsysInfoForTabbed)null);
        this.locationInformer = locationInformer;
    }

    public TabbedContainer(TabDataModel tabDataModel, int n, WinsysInfoForTabbed winsysInfoForTabbed) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown UI type: " + n);
            }
        }
        if (tabDataModel == null) {
            tabDataModel = new DefaultTabDataModel();
        }
        this.model = tabDataModel;
        this.type = Boolean.getBoolean("nb.tabcontrol.alltoolbar") ? 3 : n;
        this.winsysInfo = winsysInfoForTabbed;
        this.initialized = true;
        this.updateUI();
        this.putClientProperty("viewType", new Integer(n));
    }

    public void updateUI() {
        if (!this.initialized) {
            return;
        }
        TabbedContainerUI tabbedContainerUI = null;
        String string = (String)UIManager.get(this.getUIClassID());
        if (this.getUI() != null && this.getUI().getClass().getName().equals(string) | string == null && !this.getUI().shouldReplaceUI()) {
            return;
        }
        if (string != null) {
            try {
                tabbedContainerUI = (TabbedContainerUI)UIManager.getUI(this);
            }
            catch (Error error) {
                // empty catch block
            }
        }
        if (tabbedContainerUI != null) {
            this.setUI(tabbedContainerUI);
        } else {
            this.setUI(DefaultTabbedContainerUI.createUI(this));
        }
    }

    public final int getType() {
        return this.type;
    }

    public String getUIClassID() {
        return TABBED_CONTAINER_UI_CLASS_ID;
    }

    public TabbedContainerUI getUI() {
        return (TabbedContainerUI)this.ui;
    }

    public final void setComponentConverter(ComponentConverter componentConverter) {
        List<TabData> list;
        ComponentConverter componentConverter2 = this.converter;
        this.converter = componentConverter;
        if (componentConverter2 instanceof ComponentConverter.Fixed && componentConverter instanceof ComponentConverter.Fixed && !(list = this.getModel().getTabs()).isEmpty()) {
            TabData[] tabDataArray = list.toArray(new TabData[0]);
            this.getModel().setTabs(new TabData[0]);
            this.getModel().setTabs(tabDataArray);
        }
    }

    public final ComponentConverter getComponentConverter() {
        if (this.converter != null) {
            return this.converter;
        }
        return ComponentConverter.DEFAULT;
    }

    public final void setContentPolicy(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown content policy: " + n);
            }
        }
        if (n != this.contentPolicy) {
            int n2 = this.contentPolicy;
            this.contentPolicy = n;
            this.firePropertyChange("contentPolicy", n2, n);
        }
    }

    public int getContentPolicy() {
        return this.contentPolicy;
    }

    public boolean isValidateRoot() {
        return true;
    }

    public boolean isPaintingOrigin() {
        return true;
    }

    public void setToolTipTextAt(int n, String string) {
        TabData tabData = this.getModel().getTab(n);
        if (tabData != null) {
            tabData.tip = string;
        }
    }

    public final TabDataModel getModel() {
        return this.model;
    }

    public final SingleSelectionModel getSelectionModel() {
        return this.getUI().getSelectionModel();
    }

    public final Rectangle getTabRect(int n, Rectangle rectangle) {
        return this.getUI().getTabRect(n, rectangle);
    }

    public int tabForCoordinate(Point point) {
        return this.getUI().tabForCoordinate(point);
    }

    public final void setActive(boolean bl) {
        if (bl != this.active) {
            this.active = bl;
            this.firePropertyChange(PROP_ACTIVE, !bl, bl);
        }
    }

    public final void requestAttention(int n) {
        this.getUI().requestAttention(n);
    }

    public final void cancelRequestAttention(int n) {
        this.getUI().cancelRequestAttention(n);
    }

    public final boolean requestAttention(TabData tabData) {
        boolean bl;
        int n = this.getModel().indexOf(tabData);
        boolean bl2 = bl = n >= 0;
        if (bl) {
            this.requestAttention(n);
        }
        return bl;
    }

    public final void cancelRequestAttention(TabData tabData) {
        int n = this.getModel().indexOf(tabData);
        if (n != -1) {
            this.cancelRequestAttention(n);
        }
    }

    public final boolean isActive() {
        return this.active;
    }

    public final synchronized void addActionListener(ActionListener actionListener) {
        if (this.actionListenerList == null) {
            this.actionListenerList = new ArrayList<ActionListener>();
        }
        this.actionListenerList.add(actionListener);
    }

    public final synchronized void removeActionListener(ActionListener actionListener) {
        if (this.actionListenerList != null) {
            this.actionListenerList.remove(actionListener);
            if (this.actionListenerList.isEmpty()) {
                this.actionListenerList = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void postActionEvent(TabActionEvent tabActionEvent) {
        List<ActionListener> list;
        TabbedContainer tabbedContainer = this;
        synchronized (tabbedContainer) {
            if (this.actionListenerList == null) {
                return;
            }
            list = Collections.unmodifiableList(this.actionListenerList);
        }
        for (ActionListener actionListener : list) {
            actionListener.actionPerformed(tabActionEvent);
        }
    }

    public void setIconAt(int n, Icon icon) {
        this.getModel().setIcon(n, icon);
    }

    public void setTitleAt(int n, String string) {
        this.getModel().setText(n, string);
    }

    public Image createImageOfTab(int n) {
        return this.getUI().createImageOfTab(n);
    }

    public int getTabCount() {
        return this.getModel().size();
    }

    public final void setShowCloseButton(boolean bl) {
        boolean bl2 = this.isShowCloseButton();
        if (bl != bl2) {
            this.getUI().setShowCloseButton(bl);
            this.firePropertyChange("showCloseButton", bl2, bl);
        }
    }

    public final boolean isShowCloseButton() {
        return this.getUI().isShowCloseButton();
    }

    public int indexOf(Component component) {
        int n = this.getModel().size();
        TabDataModel tabDataModel = this.getModel();
        for (int i = 0; i < n; ++i) {
            if (this.getComponentConverter().getComponent(tabDataModel.getTab(i)) != component) continue;
            return i;
        }
        return -1;
    }

    public int dropIndexOfPoint(Point point) {
        return this.getUI().dropIndexOfPoint(point);
    }

    public Shape getDropIndication(Object object, Point point) {
        int n = object instanceof Component ? this.indexOf((Component)object) : (object instanceof TabData ? this.getModel().indexOf((TabData)object) : -1);
        int n2 = this.dropIndexOfPoint(point);
        if (n2 < 0) {
            Rectangle rectangle = this.getBounds();
            rectangle.setLocation(0, 0);
            return rectangle;
        }
        if (n2 == n && n != -1) {
            return this.getUI().getExactTabIndication(n2);
        }
        return this.getUI().getInsertTabIndication(n2);
    }

    @Deprecated
    public LocationInformer getLocationInformer() {
        return this.locationInformer;
    }

    public WinsysInfoForTabbed getWinsysInfo() {
        return this.winsysInfo;
    }

    public AccessibleContext getAccessibleContext() {
        if (null == this.accessibleContext) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PAGE_TAB_LIST;
                }
            };
            this.accessibleContext.setAccessibleName(NbBundle.getMessage(TabbedContainer.class, (String)"ACS_TabbedContainer"));
            this.accessibleContext.setAccessibleDescription(NbBundle.getMessage(TabbedContainer.class, (String)"ACSD_TabbedContainer"));
        }
        return this.accessibleContext;
    }

    public boolean isTransparent() {
        return this.isSliding() && this.currentAlpha <= 0.2f;
    }

    public void setTransparent(boolean bl) {
        if (this.isSliding()) {
            float f = this.currentAlpha;
            float f2 = this.currentAlpha = bl ? 0.2f : 1.0f;
            if (f != this.currentAlpha) {
                this.repaint();
            }
        }
    }

    private AWTEventListener getAWTListener() {
        if (null == this.awtListener) {
            this.awtListener = new AWTEventListener(){

                public void eventDispatched(AWTEvent aWTEvent) {
                    KeyEvent keyEvent;
                    if (aWTEvent.getID() == 501) {
                        if (aWTEvent.getSource() instanceof Component && !SwingUtilities.isDescendingFrom((Component)aWTEvent.getSource(), TabbedContainer.this)) {
                            return;
                        }
                        if (((MouseEvent)aWTEvent).getButton() != 3) {
                            TabbedContainer.this.setTransparent(false);
                        }
                    } else if (aWTEvent.getID() == 401) {
                        KeyEvent keyEvent2 = (KeyEvent)aWTEvent;
                        if (keyEvent2.getKeyCode() == 96 && keyEvent2.isControlDown()) {
                            TabbedContainer.this.setTransparent(!TabbedContainer.this.isTransparent());
                            keyEvent2.consume();
                            return;
                        }
                        if (keyEvent2.getKeyCode() != 18 && keyEvent2.getKeyCode() != 16 && keyEvent2.getKeyCode() != 157 && keyEvent2.getKeyCode() != 17) {
                            TabbedContainer.this.setTransparent(false);
                        }
                    } else if (aWTEvent.getID() == 501) {
                        TabbedContainer.this.setTransparent(false);
                    } else if (aWTEvent.getID() == 401 && (keyEvent = (KeyEvent)aWTEvent).getKeyCode() != 18 && keyEvent.getKeyCode() != 16) {
                        TabbedContainer.this.setTransparent(false);
                    }
                }
            };
        }
        return this.awtListener;
    }

    private boolean isSliding() {
        Component component;
        boolean bl = false;
        if (this.getModel().size() == 1 && (component = this.getModel().getTab(0).getComponent()) instanceof JComponent) {
            Object object = ((JComponent)component).getClientProperty("isSliding");
            bl = null != object && object instanceof Boolean && (Boolean)object != false;
        }
        return bl;
    }

    public void addNotify() {
        super.addNotify();
        if (this.isSliding()) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.getAWTListener(), 131096L);
        }
    }

    public void removeNotify() {
        if (null != this.awtListener) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtListener);
            this.awtListener = null;
        }
        super.removeNotify();
        this.currentAlpha = 1.0f;
    }

    public void paint(Graphics graphics) {
        if (this.isSliding() && this.currentAlpha != 1.0f) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.currentAlpha));
            super.paint(graphics);
            graphics2D.setComposite(composite);
        } else {
            super.paint(graphics);
        }
    }

    static {
        String string = System.getProperty("nb.tabcontrol.contentpolicy");
        if (string != null) {
            try {
                DEFAULT_CONTENT_POLICY = Integer.parseInt(string);
                switch (DEFAULT_CONTENT_POLICY) {
                    case 1: 
                    case 2: 
                    case 3: {
                        System.err.println("Using custom content policy: " + DEFAULT_CONTENT_POLICY);
                        break;
                    }
                    default: {
                        throw new Error("Bad value for default content policy: " + string + " only values 1, 2 or 3" + "are meaningful");
                    }
                }
                System.err.println("Default content policy is " + DEFAULT_CONTENT_POLICY);
            }
            catch (Exception exception) {
                System.err.println("Error parsing default content policy: \"" + string + "\"");
            }
        }
    }
}

