/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.netbeans.modules.autoupdate.updateprovider.SimpleItem;
import org.netbeans.spi.autoupdate.UpdateItem;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoupdateInfoParser {
    public static final String INFO_NAME = "info";
    public static final String INFO_EXT = ".xml";
    public static final String INFO_FILE = "info.xml";
    public static final String INFO_DIR = "Info";
    public static final String INFO_LOCALE = "locale";
    private static final Logger ERR = Logger.getLogger("org.netbeans.modules.autoupdate.updateprovider.AutoupdateInfoParser");

    public static Map<String, UpdateItem> getUpdateItems(File file) throws IOException, SAXException {
        HashMap<String, UpdateItem> hashMap = new HashMap<String, UpdateItem>();
        Document document = AutoupdateInfoParser.getAutoupdateInfo(file);
        SimpleItem simpleItem = AutoupdateInfoParser.createSimpleItem(document, false);
        assert (!(simpleItem instanceof SimpleItem.License)) : simpleItem + " is not instanceof License.";
        UpdateItem updateItem = simpleItem.toUpdateItem(AutoupdateInfoParser.getLicenses(file), file);
        hashMap.put(simpleItem.getId(), updateItem);
        return hashMap;
    }

    public static Map<String, String> getLicenses(File file) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            Document document = AutoupdateInfoParser.getAutoupdateInfo(file);
            SimpleItem simpleItem = AutoupdateInfoParser.createSimpleItem(document, true);
            if (simpleItem != null) {
                assert (simpleItem instanceof SimpleItem.License) : simpleItem + " is instanceof License.";
                SimpleItem.License license = (SimpleItem.License)simpleItem;
                hashMap.put(license.getLicenseId(), license.getLicenseContent());
            }
        }
        catch (IOException iOException) {
            ERR.log(Level.INFO, iOException.getMessage(), iOException);
        }
        catch (SAXException sAXException) {
            ERR.log(Level.INFO, sAXException.getMessage(), sAXException);
        }
        return hashMap;
    }

    static SimpleItem createSimpleItem(Document document, boolean bl) {
        assert (document.getDocumentElement() != null) : document + " contains DocumentElement.";
        NodeList nodeList = document.getChildNodes();
        return AutoupdateInfoParser.parseUpdateItem(nodeList, bl);
    }

    static Document getAutoupdateInfo(File file) throws IOException, SAXException {
        JarFile jarFile = new JarFile(file);
        String string = Locale.getDefault().toString();
        ZipEntry zipEntry = jarFile.getEntry("Info/locale/info_" + string + INFO_EXT);
        if (zipEntry == null) {
            zipEntry = jarFile.getEntry("Info/info.xml");
        }
        if (zipEntry == null) {
            throw new IllegalArgumentException("info.xml found in file " + file);
        }
        InputSource inputSource = new InputSource(new BufferedInputStream(jarFile.getInputStream(zipEntry)));
        return XMLUtil.parse((InputSource)inputSource, (boolean)false, (boolean)false, null, (EntityResolver)org.netbeans.updater.XMLUtil.createAUResolver());
    }

    private static SimpleItem parseUpdateItem(NodeList nodeList, boolean bl) {
        SimpleItem simpleItem = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (1 != node.getNodeType()) continue;
            assert (node instanceof Element) : node + " is instanceof Element";
            String string = ((Element)node).getTagName();
            if ("module_group".equals(string)) {
                assert (false) : "module_group is not allowed in Info.xml";
                continue;
            }
            if ("module".equals(string)) {
                NodeList nodeList2 = ((Element)node).getElementsByTagName("l10n");
                NodeList nodeList3 = ((Element)node).getElementsByTagName("manifest");
                NodeList nodeList4 = ((Element)node).getElementsByTagName("license");
                if (nodeList2 != null && nodeList2.getLength() == 1) {
                    if (!bl) {
                        simpleItem = new SimpleItem.Localization(node, null);
                    }
                } else if (nodeList3 != null && nodeList3.getLength() == 1 && !bl) {
                    simpleItem = new SimpleItem.Module(node, null);
                }
                if (nodeList4 == null || nodeList4.getLength() != 1 || !bl) continue;
                simpleItem = new SimpleItem.License(nodeList4.item(0));
                continue;
            }
            if ("feature".equals(string)) {
                assert (false) : "feature is not allowed in Info.xml";
                continue;
            }
            if ("license".equals(string)) {
                if (!bl) continue;
                simpleItem = new SimpleItem.License(node);
                continue;
            }
            assert (false) : "Unknown element tag " + string;
        }
        return simpleItem;
    }
}

