/*
 * Decompiled with CFR 0.152.
 */
package tr.view.future.screen;

import au.com.thinkingrock.tr.resource.Icons;
import ca.odell.glazedlists.matchers.MatcherEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.openide.ErrorManager;
import org.openide.awt.Toolbar;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import tr.appl.Constants;
import tr.prefs.gui.GUIPrefs;
import tr.view.Window;
import tr.view.future.FutureDeleteAction;
import tr.view.future.FutureEditAction;
import tr.view.future.FutureReprocessAction;
import tr.view.future.screen.FutureNode;
import tr.view.future.screen.FutureNodeProvider;
import tr.view.future.screen.FuturesFilters;
import tr.view.future.screen.FuturesPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FuturesTopComponent
extends Window
implements FutureNodeProvider {
    public static final String PREFERRED_ID = "FuturesTopComponent";
    private static final long serialVersionUID = 1L;
    private static final Preferences prefs = Preferences.userRoot().node("ThinkingRock/sdmb");
    private static final String PREFS_KEY_SHOW_FILTERS = "show.filters";
    private static final boolean PREFS_DEF_SHOW_FILTERS = true;
    private static FuturesTopComponent instance;
    private FuturesPanel.Preferences panelPrefs;
    private transient FuturesFilters filters;
    private transient FuturesPanel panel;
    private transient InstanceContent content;
    private transient Lookup lookup;
    private transient JToolBar toolbar;
    private transient JPanel bodyPanel;
    private transient JToggleButton filtersButton;

    private FuturesTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(FuturesTopComponent.class, (String)"CTL_FuturesTopComponent"));
        this.setToolTipText(NbBundle.getMessage(FuturesTopComponent.class, (String)"TTT_FuturesTopComponent"));
        this.setIcon(Icons.SomedayMaybes.getImage());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized FuturesTopComponent getDefault() {
        if (instance == null) {
            instance = new FuturesTopComponent();
        }
        return instance;
    }

    public static synchronized FuturesTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(16, "Cannot find futures component. It will not be located properly in the window system.");
            return FuturesTopComponent.getDefault();
        }
        if (win instanceof FuturesTopComponent) {
            return (FuturesTopComponent)win;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'FuturesTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return FuturesTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    private JToolBar getToolBar() {
        if (this.toolbar == null) {
            SystemAction[] actions = new SystemAction[]{SystemAction.get(FutureEditAction.class), SystemAction.get(FutureDeleteAction.class), SystemAction.get(FutureReprocessAction.class)};
            this.toolbar = SystemAction.createToolbarPresenter((SystemAction[])actions);
            this.filtersButton = new JToggleButton(new FiltersAction());
            this.toolbar.add((Component)this.filtersButton, 0);
            this.toolbar.setUI(new Toolbar().getUI());
            this.toolbar.setFloatable(false);
            Dimension buttonSize = Constants.TOOLBAR_BUTTON_SIZE;
            for (Component component : this.toolbar.getComponents()) {
                if (!(component instanceof AbstractButton)) continue;
                component.setPreferredSize(buttonSize);
                component.setMinimumSize(buttonSize);
                component.setMaximumSize(buttonSize);
                component.setSize(buttonSize);
            }
        }
        return this.toolbar;
    }

    private FuturesFilters getFilters() {
        if (this.filters == null) {
            this.filters = new FuturesFilters();
        }
        return this.filters;
    }

    private MatcherEditor getMatcherEditor() {
        return this.getFilters().getMatcherEditor();
    }

    protected void componentOpened() {
        super.componentOpened();
        this.provide(null);
        this.removeAll();
        this.getToolBar();
        this.filtersButton.setSelected(false);
        String position = GUIPrefs.getButtonsPosition();
        if (position.equals("top")) {
            this.toolbar.setOrientation(0);
            this.add(this.toolbar, "North");
        } else if (position.equals("bottom")) {
            this.toolbar.setOrientation(0);
            this.add(this.toolbar, "South");
        } else if (position.equals("left")) {
            this.toolbar.setOrientation(1);
            this.add(this.toolbar, "West");
        } else if (position.equals("right")) {
            this.toolbar.setOrientation(1);
            this.add(this.toolbar, "East");
        }
        this.panel = new FuturesPanel(this, this.getMatcherEditor());
        this.panel.setPreferences(this.panelPrefs);
        this.bodyPanel = new JPanel(new BorderLayout());
        this.bodyPanel.add((Component)this.panel, "Center");
        this.add(this.bodyPanel, "Center");
        boolean b = prefs.getBoolean(PREFS_KEY_SHOW_FILTERS, true);
        this.filtersButton.setSelected(b);
        this.filtersButton.getAction().actionPerformed(null);
    }

    protected void componentClosed() {
        this.panelPrefs = this.panel.getPreferences();
        prefs.putBoolean(PREFS_KEY_SHOW_FILTERS, this.filtersButton.isSelected());
        super.componentClosed();
    }

    private synchronized InstanceContent getInstanceContent() {
        if (this.content == null) {
            this.content = new InstanceContent();
        }
        return this.content;
    }

    public Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = new AbstractLookup((AbstractLookup.Content)this.getInstanceContent());
        }
        return this.lookup;
    }

    @Override
    public void provide(final Collection<FutureNode> nodes) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (FuturesTopComponent.this.panel == null || nodes == null) {
                    FuturesTopComponent.this.getInstanceContent().set((Collection)Collections.EMPTY_LIST, null);
                } else {
                    FuturesTopComponent.this.getInstanceContent().set(nodes, null);
                }
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.future");
    }

    public String preferredID() {
        return PREFERRED_ID;
    }

    public Object writeReplace() {
        return new ResolvableHelper(this.panel.getPreferences(), this.filters.getSerializable());
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final FuturesPanel.Preferences prefs;
        private final Serializable rmes;

        public ResolvableHelper(FuturesPanel.Preferences prefs, Serializable rmes) {
            this.prefs = prefs;
            this.rmes = rmes;
        }

        public Object readResolve() {
            FuturesTopComponent result = FuturesTopComponent.getDefault();
            result.panelPrefs = this.prefs;
            result.filters = new FuturesFilters();
            result.filters.setSerializable(this.rmes);
            return result;
        }
    }

    private class FiltersAction
    extends AbstractAction {
        public FiltersAction() {
            super("", Icons.FiltersView);
            this.putValue("ShortDescription", NbBundle.getMessage(this.getClass(), (String)"CTL_FiltersAction"));
        }

        public void actionPerformed(ActionEvent e) {
            if (FuturesTopComponent.this.filtersButton.isSelected()) {
                FuturesTopComponent.this.bodyPanel.add(FuturesTopComponent.this.getFilters().getComponent(), "North");
            } else {
                FuturesTopComponent.this.bodyPanel.remove(FuturesTopComponent.this.getFilters().getComponent());
            }
            FuturesTopComponent.this.validate();
        }
    }
}

