/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.treetable;

import java.io.File;
import java.util.Arrays;
import java.util.Date;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemModel
extends AbstractTreeTableModel {
    private static final Integer ZERO = 0;

    public FileSystemModel() {
        this(new File(File.separator));
    }

    public FileSystemModel(File root) {
        super(root);
    }

    private boolean isValidFileNode(Object file) {
        boolean result = false;
        if (file instanceof File) {
            for (File f = (File)file; !result && f != null; f = f.getParentFile()) {
                result = f.equals(this.root);
            }
        }
        return result;
    }

    @Override
    public File getChild(Object parent, int index) {
        if (!this.isValidFileNode(parent)) {
            throw new IllegalArgumentException("parent is not a file governed by this model");
        }
        File parentFile = (File)parent;
        Object[] files = parentFile.listFiles();
        if (files != null) {
            Arrays.sort(files);
            return files[index];
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        File parentFile;
        if (parent instanceof File && (parentFile = (File)parent).isDirectory()) {
            return parentFile.listFiles().length;
        }
        return 0;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        if (column == 2) {
            return Boolean.class;
        }
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Size";
            }
            case 2: {
                return "Directory";
            }
            case 3: {
                return "Modification Date";
            }
        }
        return "Column " + column;
    }

    @Override
    public Object getValueAt(Object node, int column) {
        if (node instanceof File) {
            File file = (File)node;
            switch (column) {
                case 0: {
                    return file.getName();
                }
                case 1: {
                    return file.isFile() ? (int)file.length() : ZERO;
                }
                case 2: {
                    return file.isDirectory();
                }
                case 3: {
                    return new Date(file.lastModified());
                }
            }
        }
        return null;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof File && child instanceof File) {
            File parentFile = (File)parent;
            Object[] files = parentFile.listFiles();
            Arrays.sort(files);
            int len = files.length;
            for (int i = 0; i < len; ++i) {
                if (!((File)files[i]).equals(child)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public File getRoot() {
        return (File)this.root;
    }

    public void setRoot(File root) {
        this.root = root;
        this.modelSupport.fireNewRoot();
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof File) {
            return ((File)node).isFile();
        }
        return true;
    }
}

