/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.text.ParseException;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.UtcProperty;
import net.fortuna.ical4j.util.ParameterValidator;

public class Trigger
extends UtcProperty {
    private static final long serialVersionUID = 5049421499261722194L;
    private Dur duration;

    public Trigger() {
        super("TRIGGER");
    }

    public Trigger(ParameterList aList, String aValue) {
        super("TRIGGER", aList);
        this.setValue(aValue);
    }

    public Trigger(Dur duration) {
        super("TRIGGER");
        this.setDuration(duration);
        this.getParameters().add(Value.DURATION);
    }

    public Trigger(ParameterList aList, Dur duration) {
        super("TRIGGER", aList);
        this.setDuration(duration);
        this.getParameters().add(Value.DURATION);
    }

    public Trigger(DateTime dateTime) {
        super("TRIGGER");
        this.setDateTime(dateTime);
        this.getParameters().add(Value.DATE_TIME);
    }

    public Trigger(ParameterList aList, DateTime dateTime) {
        super("TRIGGER", aList);
        this.setDateTime(dateTime);
        this.getParameters().add(Value.DATE_TIME);
    }

    public final void validate() throws ValidationException {
        super.validate();
        Parameter relParam = this.getParameter("RELATED");
        Parameter valueParam = this.getParameter("VALUE");
        if (relParam != null || !Value.DATE_TIME.equals(valueParam)) {
            ParameterValidator.getInstance().assertOneOrLess("RELATED", this.getParameters());
            if (valueParam != null && !Value.DURATION.equals(valueParam)) {
                throw new ValidationException("Parameter [" + valueParam + "] is invalid");
            }
            if (this.getDuration() == null) {
                throw new ValidationException("Duration value not specified");
            }
        } else {
            ParameterValidator.getInstance().assertOne("VALUE", this.getParameters());
            if (valueParam != null && !Value.DATE_TIME.equals(valueParam)) {
                throw new ValidationException("Parameter [" + valueParam + "] is invalid");
            }
            if (this.getDateTime() == null) {
                throw new ValidationException("DATE-TIME value not specified");
            }
        }
    }

    public final Dur getDuration() {
        return this.duration;
    }

    public final void setValue(String aValue) {
        try {
            super.setValue(aValue);
            this.duration = null;
        }
        catch (ParseException pe) {
            this.duration = new Dur(aValue);
            super.setDateTime(null);
        }
    }

    public final String getValue() {
        if (this.duration != null) {
            return this.duration.toString();
        }
        return super.getValue();
    }

    public final void setDateTime(DateTime dateTime) {
        super.setDateTime(dateTime);
        this.duration = null;
    }

    public final void setDuration(Dur duration) {
        this.duration = duration;
        super.setDateTime(null);
    }
}

