/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.SpecialUIButton;
import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyWindowButtonUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class TinyInternalFrameTitlePane
extends BasicInternalFrameTitlePane
implements LayoutManager {
    protected boolean isPalette = false;
    private int buttonsWidth;
    static TinyWindowButtonUI iconButtonUI;
    static TinyWindowButtonUI maxButtonUI;
    static TinyWindowButtonUI closeButtonUI;

    protected void installDefaults() {
        super.installDefaults();
        this.frame.setFrameIcon(UIManager.getDefaults().getIcon("InternalFrame.icon"));
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new TinyPropertyChangeHandler();
    }

    public TinyInternalFrameTitlePane(JInternalFrame frame) {
        super(frame);
    }

    protected void paintTitleBackground(Graphics g) {
    }

    public boolean isFrameSelected() {
        return this.frame.isSelected();
    }

    public boolean isFrameMaximized() {
        return this.frame.isMaximum();
    }

    public void paintComponent(Graphics g) {
        if (Theme.frameIsTransparent[Theme.derivedStyle[Theme.style]]) {
            this.frame.setOpaque(false);
        }
        boolean leftToRight = this.frame.getComponentOrientation().isLeftToRight();
        boolean isSelected = this.frame.isSelected();
        int width = this.getWidth();
        int height = this.getHeight();
        MetalLookAndFeel.getWindowTitleInactiveForeground();
        int titleLength = 0;
        int xOffset = leftToRight ? 2 : width - 2;
        String frameTitle = this.frame.getTitle();
        Icon icon = this.frame.getFrameIcon();
        if (icon != null) {
            int iconY = Math.round((float)(height - icon.getIconHeight()) / 2.0f);
            if (!leftToRight) {
                xOffset -= icon.getIconWidth();
            }
            if (Theme.derivedStyle[Theme.style] == 1) {
                ++iconY;
            }
            icon.paintIcon(this.frame, g, xOffset, iconY);
            xOffset += leftToRight ? icon.getIconWidth() + 2 : -2;
        }
        if (frameTitle != null) {
            Font f = this.getFont();
            g.setFont(f);
            FontMetrics fm = g.getFontMetrics();
            titleLength = fm.stringWidth(frameTitle);
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent() + 1;
            if (!leftToRight) {
                xOffset -= titleLength;
            }
            if (isSelected) {
                g.setColor(Theme.frameTitleColor[Theme.style].getColor());
                g.drawString(frameTitle, xOffset, yOffset);
                xOffset += leftToRight ? titleLength + 2 : -2;
            } else {
                g.setColor(Theme.frameTitleDisabledColor[Theme.style].getColor());
                g.drawString(frameTitle, xOffset, yOffset);
                xOffset += leftToRight ? titleLength + 2 : -2;
            }
        }
    }

    protected LayoutManager createLayout() {
        return this;
    }

    protected void addSubComponents() {
        super.addSubComponents();
    }

    protected void setButtonIcons() {
    }

    protected void createButtons() {
        if (iconButtonUI == null) {
            iconButtonUI = TinyWindowButtonUI.createButtonUIForType(2);
            maxButtonUI = TinyWindowButtonUI.createButtonUIForType(1);
            closeButtonUI = TinyWindowButtonUI.createButtonUIForType(0);
        }
        this.iconButton = new SpecialUIButton(iconButtonUI);
        this.iconButton.addActionListener(this.iconifyAction);
        this.iconButton.setRolloverEnabled(true);
        this.iconButton.addMouseListener(new RolloverListener(this.iconButton, this.iconifyAction));
        this.maxButton = new SpecialUIButton(maxButtonUI);
        this.maxButton.addActionListener(this.maximizeAction);
        this.maxButton.setRolloverEnabled(true);
        this.maxButton.addMouseListener(new RolloverListener(this.maxButton, this.maximizeAction));
        this.closeButton = new SpecialUIButton(closeButtonUI);
        this.closeButton.addActionListener(this.closeAction);
        this.closeButton.setRolloverEnabled(true);
        this.closeButton.addMouseListener(new RolloverListener(this.closeButton, this.closeAction));
        this.iconButton.putClientProperty("externalFrameButton", Boolean.FALSE);
        this.maxButton.putClientProperty("externalFrameButton", Boolean.FALSE);
        this.closeButton.putClientProperty("externalFrameButton", Boolean.FALSE);
        this.iconButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.iconifyButtonAccessibleName"));
        this.maxButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.maximizeButtonAccessibleName"));
        this.closeButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.closeButtonAccessibleName"));
        if (this.frame.isSelected()) {
            this.activate();
        } else {
            this.deactivate();
        }
    }

    public void paintPalette(Graphics g) {
    }

    public void addLayoutComponent(String name, Component c) {
    }

    public void removeLayoutComponent(Component c) {
    }

    public Dimension preferredLayoutSize(Container c) {
        return this.getPreferredSize(c);
    }

    public Dimension getPreferredSize(Container c) {
        int subtitle_w;
        int title_length;
        this.isPalette = this.frame.getClientProperty("isPalette") == Boolean.TRUE;
        int width = 22;
        if (this.frame.isClosable()) {
            width += 19;
        }
        if (this.frame.isMaximizable()) {
            width += 19;
        }
        if (this.frame.isIconifiable()) {
            width += 19;
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        String frameTitle = this.frame.getTitle();
        int title_w = frameTitle != null ? fm.stringWidth(frameTitle) : 0;
        int n = title_length = frameTitle != null ? frameTitle.length() : 0;
        width = title_length > 3 ? (width += title_w < (subtitle_w = fm.stringWidth(String.valueOf(frameTitle.substring(0, 3)) + "...")) ? title_w : subtitle_w) : (width += title_w);
        int height = this.isPalette ? Theme.framePaletteTitleHeight[Theme.derivedStyle[Theme.style]] : Theme.frameInternalTitleHeight[Theme.derivedStyle[Theme.style]];
        Dimension dim = new Dimension(width, height);
        if (this.getBorder() != null) {
            Insets insets = this.getBorder().getBorderInsets(c);
            dim.height += insets.top + insets.bottom;
            dim.width += insets.left + insets.right;
        }
        return dim;
    }

    public Dimension getMinimumSize() {
        this.isPalette = this.frame.getClientProperty("isPalette") == Boolean.TRUE;
        int height = this.isPalette ? Theme.framePaletteTitleHeight[Theme.derivedStyle[Theme.style]] : Theme.frameInternalTitleHeight[Theme.derivedStyle[Theme.style]];
        return new Dimension(32, height);
    }

    public Dimension minimumLayoutSize(Container c) {
        return this.preferredLayoutSize(c);
    }

    public void setPalette(boolean b) {
        this.isPalette = b;
    }

    public boolean isPalette() {
        return this.isPalette;
    }

    public void layoutContainer(Container c) {
        int spacing;
        this.isPalette = this.frame.getClientProperty("isPalette") == Boolean.TRUE;
        boolean leftToRight = this.frame.getComponentOrientation().isLeftToRight();
        int buttonHeight = this.closeButton.getPreferredSize().height;
        int w = this.getWidth();
        int x = leftToRight ? w : 0;
        int y = (this.getHeight() - buttonHeight) / 2 + 1;
        if (Theme.derivedStyle[Theme.style] == 1) {
            ++y;
        }
        int buttonWidth = 0;
        buttonWidth = this.isPalette ? Theme.framePaletteButtonSize[Theme.derivedStyle[Theme.style]].width : Theme.frameInternalButtonSize[Theme.derivedStyle[Theme.style]].width;
        if (this.frame.isClosable()) {
            spacing = 2;
            this.closeButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
            if (!leftToRight) {
                x += buttonWidth;
            }
        }
        if (this.frame.isMaximizable()) {
            spacing = 2;
            this.maxButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
            if (!leftToRight) {
                x += buttonWidth;
            }
        }
        if (this.frame.isIconifiable()) {
            spacing = this.frame.isMaximizable() && Theme.style == 1 ? 0 : 2;
            this.iconButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
            if (!leftToRight) {
                x += buttonWidth;
            }
        }
        this.buttonsWidth = leftToRight ? w - x : x;
    }

    public void activate() {
        this.closeButton.setEnabled(true);
        this.iconButton.setEnabled(true);
        this.maxButton.setEnabled(true);
    }

    public void deactivate() {
        this.closeButton.setEnabled(false);
        this.iconButton.setEnabled(false);
        this.maxButton.setEnabled(false);
    }

    public Font getFont() {
        Font f = null;
        f = this.isPalette ? UIManager.getFont("InternalFrame.paletteTitleFont") : UIManager.getFont("InternalFrame.normalTitleFont");
        if (f == null) {
            f = new Font("SansSerife", 1, 12);
        }
        return f;
    }

    class RolloverListener
    implements MouseListener {
        JButton button;
        Action action;

        public RolloverListener(JButton b, Action a) {
            this.button = b;
            this.action = a;
        }

        public void mouseClicked(MouseEvent e) {
            this.action.actionPerformed(new ActionEvent(this, 1001, this.button.getText()));
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            this.button.getModel().setRollover(true);
            if (!this.button.isEnabled()) {
                this.button.setEnabled(true);
            }
            this.button.repaint();
        }

        public void mouseExited(MouseEvent e) {
            this.button.getModel().setRollover(false);
            if (!TinyInternalFrameTitlePane.this.frame.isSelected()) {
                this.button.setEnabled(false);
            }
            this.button.repaint();
        }
    }

    class TinyPropertyChangeHandler
    extends BasicInternalFrameTitlePane.PropertyChangeHandler {
        TinyPropertyChangeHandler() {
            super(TinyInternalFrameTitlePane.this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            if (prop.equals("selected")) {
                Boolean b = (Boolean)evt.getNewValue();
                TinyInternalFrameTitlePane.this.iconButton.putClientProperty("paintActive", b);
                TinyInternalFrameTitlePane.this.closeButton.putClientProperty("paintActive", b);
                TinyInternalFrameTitlePane.this.maxButton.putClientProperty("paintActive", b);
            }
            super.propertyChange(evt);
        }
    }
}

