/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.NewObjectWizardPanel;
import org.openide.loaders.TemplateWizardIterImpl;
import org.openide.loaders.TemplateWizardIteratorWrapper;
import org.openide.loaders.TemplateWizardPanel1;
import org.openide.loaders.TemplateWizardPanel2;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateWizard
extends WizardDescriptor {
    private static final String EA_DESCRIPTION = "templateWizardURL";
    private static final String EA_ITERATOR = "templateWizardIterator";
    @Deprecated
    private static final String EA_DESC_RESOURCE = "templateWizardDescResource";
    private static final String CUSTOM_DESCRIPTION = "instantiatingWizardURL";
    private static final String CUSTOM_ITERATOR = "instantiatingIterator";
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    static Dimension PREF_DIM = new Dimension(560, 350);
    private WizardDescriptor.Panel<WizardDescriptor> templateChooser;
    private WizardDescriptor.Panel<WizardDescriptor> targetChooser;
    private boolean showTargetChooser = true;
    private Iterator targetIterator;
    private TemplateWizardIteratorWrapper iterator;
    private DataObject template;
    private DataFolder templatesFolder;
    private String targetName = null;
    private DataFolder targetDataFolder;
    private boolean titleFormatSet = false;
    private PropertyChangeListener pcl;
    private Component lastComp;
    private Set<DataObject> newObjects = null;
    private ProgressHandle progressHandle;

    public TemplateWizard() {
        this(new TemplateWizardIteratorWrapper.InstantiatingIterator(new TemplateWizardIterImpl()));
    }

    private TemplateWizard(TemplateWizardIteratorWrapper templateWizardIteratorWrapper) {
        super((WizardDescriptor.Iterator)templateWizardIteratorWrapper);
        this.iterator = templateWizardIteratorWrapper;
        this.iterator.initialize(this);
        this.putProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
        this.putProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
        this.putProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        this.setTitle(NbBundle.getMessage(TemplateWizard.class, (String)"CTL_TemplateTitle"));
        this.setTitleFormat(new MessageFormat("{0}"));
    }

    protected TemplateWizard(Iterator iterator) {
        this();
        this.iterator.setIterator(iterator, false);
    }

    protected void initialize() {
        if (this.iterator != null) {
            this.iterator.initialize(this);
            this.newObjects = null;
        }
        super.initialize();
    }

    final void setTemplateImpl(DataObject dataObject, boolean bl) {
        DataObject dataObject2 = this.template;
        if (this.template != dataObject) {
            this.template = dataObject;
        }
        this.setTitle(this.getTitleFormat().format(new Object[]{dataObject.getNodeDelegate().getDisplayName()}));
        if (dataObject2 != this.template) {
            Iterator iterator;
            if (dataObject == null || (iterator = TemplateWizard.getIterator(dataObject)) == null) {
                iterator = this.defaultIterator();
            }
            if (iterator instanceof InstantiatingIteratorBridge) {
                WizardDescriptor.InstantiatingIterator instantiatingIterator = ((InstantiatingIteratorBridge)iterator).getOriginalIterator();
                if (instantiatingIterator instanceof WizardDescriptor.ProgressInstantiatingIterator) {
                    TemplateWizardIteratorWrapper.ProgressInstantiatingIterator progressInstantiatingIterator = new TemplateWizardIteratorWrapper.ProgressInstantiatingIterator(this.iterator.getOriginalIterImpl());
                    this.iterator = progressInstantiatingIterator;
                    this.setPanelsAndSettings(progressInstantiatingIterator, (Object)this);
                } else if (instantiatingIterator instanceof WizardDescriptor.AsynchronousInstantiatingIterator) {
                    TemplateWizardIteratorWrapper.AsynchronousInstantiatingIterator asynchronousInstantiatingIterator = new TemplateWizardIteratorWrapper.AsynchronousInstantiatingIterator(this.iterator.getOriginalIterImpl());
                    this.iterator = asynchronousInstantiatingIterator;
                    this.setPanelsAndSettings(asynchronousInstantiatingIterator, (Object)this);
                }
            }
            this.iterator.setIterator(iterator, bl);
        }
    }

    public DataObject getTemplate() {
        return this.template;
    }

    public void setTemplate(DataObject dataObject) {
        if (dataObject != null) {
            this.setTemplateImpl(dataObject, true);
        }
    }

    public void setTemplatesFolder(DataFolder dataFolder) {
        this.templatesFolder = dataFolder;
    }

    public DataFolder getTemplatesFolder() {
        FileObject fileObject;
        DataFolder dataFolder = this.templatesFolder;
        if (dataFolder == null && (fileObject = Repository.getDefault().getDefaultFileSystem().findResource("/Templates")) != null && fileObject.isFolder()) {
            return DataFolder.findFolder(fileObject);
        }
        return dataFolder;
    }

    public DataFolder getTargetFolder() throws IOException {
        if (this.targetDataFolder == null) {
            throw new IOException(NbBundle.getMessage(TemplateWizard.class, (String)"ERR_NoFilesystem"));
        }
        return this.targetDataFolder;
    }

    private void reload(DataObject dataObject) {
        Iterator iterator;
        if (dataObject == null || (iterator = TemplateWizard.getIterator(dataObject)) == null) {
            iterator = this.defaultIterator();
        }
        this.iterator.setIterator(iterator, true);
    }

    public void setTargetFolder(DataFolder dataFolder) {
        this.targetDataFolder = dataFolder;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String string) {
        this.targetName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WizardDescriptor.Panel<WizardDescriptor> templateChooser() {
        TemplateWizard templateWizard = this;
        synchronized (templateWizard) {
            if (this.templateChooser == null) {
                this.templateChooser = this.createTemplateChooser();
            }
        }
        return this.templateChooser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WizardDescriptor.Panel<WizardDescriptor> targetChooser() {
        TemplateWizard templateWizard = this;
        synchronized (templateWizard) {
            if (this.targetChooser == null) {
                this.targetChooser = this.createTargetChooser();
            }
        }
        return this.targetChooser;
    }

    final synchronized Iterator defaultIterator() {
        if (this.targetIterator == null) {
            this.targetIterator = this.createDefaultIterator();
        }
        return this.targetIterator;
    }

    protected WizardDescriptor.Panel<WizardDescriptor> createTemplateChooser() {
        return new TemplateWizardPanel1();
    }

    protected WizardDescriptor.Panel<WizardDescriptor> createTargetChooser() {
        if (this.showTargetChooser) {
            return new TemplateWizardPanel2();
        }
        return new NewObjectWizardPanel();
    }

    protected Iterator createDefaultIterator() {
        return new DefaultIterator();
    }

    public Set<DataObject> instantiate() throws IOException {
        this.showTargetChooser = true;
        return this.instantiateImpl(null, null);
    }

    public Set<DataObject> instantiate(DataObject dataObject) throws IOException {
        this.showTargetChooser = true;
        return this.instantiateImpl(dataObject, null);
    }

    public Set<DataObject> instantiate(DataObject dataObject, DataFolder dataFolder) throws IOException {
        this.showTargetChooser = false;
        return this.instantiateImpl(dataObject, dataFolder);
    }

    private ProgressHandle getProgressHandle() {
        return this.progressHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<DataObject> instantiateNewObjects(ProgressHandle progressHandle) throws IOException {
        this.progressHandle = progressHandle;
        try {
            Object object = this.getValue();
            if (object == FINISH_OPTION || object == YES_OPTION || object == OK_OPTION) {
                this.showWaitCursor();
                this.newObjects = this.handleInstantiate();
                if (this.lastComp != null) {
                    this.lastComp.removePropertyChangeListener(this.propL());
                    this.lastComp = null;
                }
            } else {
                if (this.lastComp != null) {
                    this.lastComp.removePropertyChangeListener(this.propL());
                    this.lastComp = null;
                }
                this.newObjects = null;
            }
            Object var4_3 = null;
            this.showNormalCursor();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.showNormalCursor();
            throw throwable;
        }
        return this.newObjects;
    }

    private Set<DataObject> instantiateImpl(DataObject dataObject, DataFolder dataFolder) throws IOException {
        this.showTargetChooser |= dataFolder == null;
        this.targetChooser = null;
        IllegalStateException illegalStateException = null;
        if (dataFolder != null) {
            this.setTargetFolder(dataFolder);
        }
        if (dataObject != null) {
            this.template = null;
            this.setTemplate(dataObject);
            if (this.iterator != null) {
                this.iterator.initialize(this);
            }
        } else if (this.iterator != null) {
            this.iterator.initialize(this);
            this.iterator.first();
        }
        try {
            this.updateState();
            this.setValue(null);
            final Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this);
            if (illegalStateException != null) {
                final IllegalStateException illegalStateException2 = illegalStateException;
                illegalStateException = null;
                dialog.addComponentListener(new ComponentAdapter(){

                    public void componentShown(ComponentEvent componentEvent) {
                        if (illegalStateException2.getMessage() != null) {
                            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Exception(illegalStateException2));
                        } else {
                            Exceptions.printStackTrace((Throwable)illegalStateException2);
                        }
                        dialog.removeComponentListener(this);
                    }
                });
            }
            dialog.setVisible(true);
        }
        catch (IllegalStateException illegalStateException3) {
            illegalStateException = illegalStateException3;
        }
        return this.newObjects;
    }

    private void showWaitCursor() {
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                try {
                    Frame frame = WindowManager.getDefault().getMainWindow();
                    if (frame instanceof JFrame) {
                        Component component = ((JFrame)frame).getGlassPane();
                        component.setVisible(true);
                        component.setCursor(Cursor.getPredefinedCursor(3));
                    }
                }
                catch (NullPointerException nullPointerException) {
                    Logger.getLogger(TemplateWizard.class.getName()).log(Level.WARNING, null, nullPointerException);
                }
            }
        });
    }

    private void showNormalCursor() {
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                try {
                    Frame frame = WindowManager.getDefault().getMainWindow();
                    if (frame instanceof JFrame) {
                        Component component = ((JFrame)frame).getGlassPane();
                        component.setCursor(null);
                        component.setVisible(false);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    Logger.getLogger(TemplateWizard.class.getName()).log(Level.WARNING, null, nullPointerException);
                }
            }
        });
    }

    public void setTitleFormat(MessageFormat messageFormat) {
        this.titleFormatSet = true;
        super.setTitleFormat(messageFormat);
    }

    public MessageFormat getTitleFormat() {
        if (!this.titleFormatSet) {
            this.setTitleFormat(new MessageFormat(NbBundle.getMessage(TemplateWizard.class, (String)"CTL_TemplateTitle")));
        }
        return super.getTitleFormat();
    }

    protected Set<DataObject> handleInstantiate() throws IOException {
        return this.iterator.getIterator().instantiate(this);
    }

    public static void setDescription(DataObject dataObject, URL uRL) throws IOException {
        dataObject.getPrimaryFile().setAttribute(EA_DESCRIPTION, (Object)uRL);
        dataObject.getPrimaryFile().setAttribute(CUSTOM_DESCRIPTION, (Object)uRL);
    }

    public static URL getDescription(DataObject dataObject) {
        URL uRL = (URL)dataObject.getPrimaryFile().getAttribute(CUSTOM_DESCRIPTION);
        if (uRL != null) {
            return uRL;
        }
        uRL = (URL)dataObject.getPrimaryFile().getAttribute(EA_DESCRIPTION);
        if (uRL != null) {
            return uRL;
        }
        String string = (String)dataObject.getPrimaryFile().getAttribute(EA_DESC_RESOURCE);
        if (string != null) {
            try {
                URL uRL2 = new URL("nbresloc:/" + string);
                try {
                    TemplateWizard.setDescription(dataObject, uRL2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return uRL2;
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
        }
        return null;
    }

    @Deprecated
    public static void setDescriptionAsResource(DataObject dataObject, String string) throws IOException {
        if (string != null && string.startsWith("/")) {
            Logger.getLogger(TemplateWizard.class.getName()).warning("auto-stripping leading slash from resource path in TemplateWizard.setDescriptionAsResource: " + string);
            string = string.substring(1);
        }
        dataObject.getPrimaryFile().setAttribute(EA_DESC_RESOURCE, (Object)string);
    }

    @Deprecated
    public static String getDescriptionAsResource(DataObject dataObject) {
        return (String)dataObject.getPrimaryFile().getAttribute(EA_DESC_RESOURCE);
    }

    @Deprecated
    public static void setIterator(DataObject dataObject, Iterator iterator) throws IOException {
        dataObject.getPrimaryFile().setAttribute(CUSTOM_ITERATOR, (Object)iterator);
        dataObject.getPrimaryFile().setAttribute(EA_ITERATOR, (Object)iterator);
    }

    public static Iterator getIterator(DataObject dataObject) {
        Object object = dataObject.getPrimaryFile().getAttribute(CUSTOM_ITERATOR);
        if (object == null) {
            object = dataObject.getPrimaryFile().getAttribute(EA_ITERATOR);
        }
        Iterator iterator = null;
        if (object instanceof Iterator) {
            iterator = (Iterator)object;
        }
        if (object instanceof WizardDescriptor.InstantiatingIterator) {
            iterator = new InstantiatingIteratorBridge((WizardDescriptor.InstantiatingIterator<WizardDescriptor>)((WizardDescriptor.InstantiatingIterator)object));
        }
        if (iterator != null) {
            return iterator;
        }
        return dataObject.getCookie(Iterator.class);
    }

    static boolean checkCaseInsensitiveName(FileObject fileObject, String string, String string2) {
        Enumeration enumeration = fileObject.getChildren(false);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(fileObject2.getExt()) || !string.equalsIgnoreCase(fileObject2.getName())) continue;
            return true;
        }
        return false;
    }

    protected void updateState() {
        super.updateState();
        if (this.lastComp != null) {
            this.lastComp.removePropertyChangeListener(this.propL());
        }
        this.lastComp = this.iterator.current().getComponent();
        this.lastComp.addPropertyChangeListener(this.propL());
        this.putProperty(PROP_CONTENT_SELECTED_INDEX, new Integer(this.getContentSelectedIndex()));
        if (this.getContentData() != null) {
            this.putProperty(PROP_CONTENT_DATA, this.getContentData());
        }
    }

    private String[] getContentData() {
        Object object;
        Component component = this.templateChooser().getComponent();
        if (this.iterator.current() == this.templateChooser()) {
            return (String[])((JComponent)component).getClientProperty(PROP_CONTENT_DATA);
        }
        String[] stringArray = null;
        Component component2 = this.iterator.current().getComponent();
        if (component2 instanceof JComponent && (object = ((JComponent)component2).getClientProperty(PROP_CONTENT_DATA)) instanceof String[]) {
            String[] stringArray2 = (String[])object;
            Object object2 = ((JComponent)component).getClientProperty(PROP_CONTENT_DATA);
            if (object2 instanceof String[]) {
                stringArray = new String[stringArray2.length + 1];
                stringArray[0] = ((String[])object2)[0];
                System.arraycopy(stringArray2, 0, stringArray, 1, stringArray2.length);
            } else {
                stringArray = new String[stringArray2.length];
                System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
            }
        }
        return stringArray;
    }

    private int getContentSelectedIndex() {
        Object object;
        if (this.iterator.current() == this.templateChooser()) {
            return 0;
        }
        Component component = this.iterator.current().getComponent();
        if (component instanceof JComponent && (object = ((JComponent)component).getClientProperty(PROP_CONTENT_SELECTED_INDEX)) instanceof Integer) {
            return (Integer)object + 1;
        }
        return 1;
    }

    private PropertyChangeListener propL() {
        if (this.pcl == null) {
            this.pcl = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (TemplateWizard.PROP_CONTENT_SELECTED_INDEX.equals(propertyChangeEvent.getPropertyName())) {
                        TemplateWizard.this.putProperty(TemplateWizard.PROP_CONTENT_SELECTED_INDEX, new Integer(TemplateWizard.this.getContentSelectedIndex()));
                    } else if (TemplateWizard.PROP_CONTENT_DATA.equals(propertyChangeEvent.getPropertyName()) && TemplateWizard.this.getContentData() != null) {
                        TemplateWizard.this.putProperty(TemplateWizard.PROP_CONTENT_DATA, TemplateWizard.this.getContentData());
                    }
                }
            };
        }
        return this.pcl;
    }

    final TemplateWizardIterImpl getIterImpl() {
        return this.iterator.getOriginalIterImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DefaultIterator
    implements Iterator {
        DefaultIterator() {
        }

        public String name() {
            return "";
        }

        @Override
        public Set<DataObject> instantiate(TemplateWizard templateWizard) throws IOException {
            String string = templateWizard.getTargetName();
            DataFolder dataFolder = templateWizard.getTargetFolder();
            DataObject dataObject = templateWizard.getTemplate();
            HashMap hashMap = new HashMap();
            for (Map.Entry node2 : templateWizard.getProperties().entrySet()) {
                hashMap.put("wizard." + (String)node2.getKey(), node2.getValue());
            }
            DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, string, hashMap);
            final Node node = dataObject2.getNodeDelegate();
            final Action action = node.getPreferredAction();
            if (action != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        action.actionPerformed(new ActionEvent(node, 1001, ""));
                    }
                });
            }
            return Collections.singleton(dataObject2);
        }

        @Override
        public void initialize(TemplateWizard templateWizard) {
        }

        @Override
        public void uninitialize(TemplateWizard templateWizard) {
        }

        public WizardDescriptor.Panel<WizardDescriptor> current() {
            return TemplateWizard.this.targetChooser();
        }

        public boolean hasNext() {
            return false;
        }

        public boolean hasPrevious() {
            return false;
        }

        public void nextPanel() {
            throw new NoSuchElementException();
        }

        public void previousPanel() {
            throw new NoSuchElementException();
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstantiatingIteratorBridge
    implements Iterator {
        private WizardDescriptor.InstantiatingIterator<WizardDescriptor> instantiatingIterator;

        public InstantiatingIteratorBridge(WizardDescriptor.InstantiatingIterator<WizardDescriptor> instantiatingIterator) {
            this.instantiatingIterator = instantiatingIterator;
        }

        private WizardDescriptor.InstantiatingIterator getOriginalIterator() {
            return this.instantiatingIterator;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.instantiatingIterator.addChangeListener(changeListener);
        }

        public WizardDescriptor.Panel<WizardDescriptor> current() {
            return this.instantiatingIterator.current();
        }

        public boolean hasNext() {
            return this.instantiatingIterator.hasNext();
        }

        public boolean hasPrevious() {
            return this.instantiatingIterator.hasPrevious();
        }

        public String name() {
            return this.instantiatingIterator.name();
        }

        public void nextPanel() {
            this.instantiatingIterator.nextPanel();
        }

        public void previousPanel() {
            this.instantiatingIterator.previousPanel();
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.instantiatingIterator.removeChangeListener(changeListener);
        }

        @Override
        public void initialize(TemplateWizard templateWizard) {
            this.instantiatingIterator.initialize((WizardDescriptor)templateWizard);
        }

        @Override
        public Set<DataObject> instantiate(TemplateWizard templateWizard) throws IOException {
            Set set = null;
            if (this.instantiatingIterator instanceof WizardDescriptor.ProgressInstantiatingIterator) {
                assert (templateWizard.getProgressHandle() != null) : "ProgressHandle cannot be null.";
                set = ((WizardDescriptor.ProgressInstantiatingIterator)this.instantiatingIterator).instantiate(templateWizard.getProgressHandle());
            } else {
                set = this.instantiatingIterator.instantiate();
            }
            java.util.Iterator iterator = set.iterator();
            LinkedHashSet<DataObject> linkedHashSet = new LinkedHashSet<DataObject>(set.size());
            while (iterator.hasNext()) {
                DataObject dataObject;
                Object e = iterator.next();
                assert (e != null) : "Null DataObject provided by " + this.instantiatingIterator;
                if (e instanceof DataObject) continue;
                if (e instanceof FileObject) {
                    try {
                        dataObject = DataObject.find((FileObject)e);
                        linkedHashSet.add(dataObject);
                        continue;
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        assert (false) : e;
                        continue;
                    }
                }
                if (!(e instanceof Node)) continue;
                dataObject = (DataObject)((Node)e).getCookie(DataObject.class);
                assert (dataObject != null) : e;
                linkedHashSet.add(dataObject);
            }
            return linkedHashSet;
        }

        @Override
        public void uninitialize(TemplateWizard templateWizard) {
            this.instantiatingIterator.uninitialize((WizardDescriptor)templateWizard);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Iterator
    extends WizardDescriptor.Iterator<WizardDescriptor>,
    Serializable,
    Node.Cookie {
        public Set<DataObject> instantiate(TemplateWizard var1) throws IOException;

        public void initialize(TemplateWizard var1);

        public void uninitialize(TemplateWizard var1);
    }
}

