/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.netbeans.modules.options.CategoryModel;
import org.netbeans.modules.options.ui.VariableBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class OptionsPanel
extends JPanel {
    private JPanel pCategories;
    private JPanel pCategories2;
    private JPanel pOptions;
    private CardLayout cLayout;
    private Map<String, CategoryButton> buttons = new LinkedHashMap<String, CategoryButton>();
    private final boolean isMac = UIManager.getLookAndFeel().getID().equals("Aqua");
    private Color selected = this.isMac ? new Color(221, 221, 221) : new Color(193, 210, 238);
    private Color selectedB = this.isMac ? new Color(183, 183, 183) : new Color(149, 106, 197);
    private Color highlighted = this.isMac ? new Color(221, 221, 221) : new Color(224, 232, 246);
    private Color highlightedB = new Color(152, 180, 226);
    private Color iconViewBorder = new Color(127, 157, 185);
    private ControllerListener controllerListener = new ControllerListener();
    private final Color borderMac = new Color(141, 141, 141);
    private final Font labelFontMac = new Font("Lucida Grande", 0, 10);

    private static String loc(String string) {
        return NbBundle.getMessage(OptionsPanel.class, (String)string);
    }

    public OptionsPanel() {
        this((String)null);
    }

    public OptionsPanel(String string) {
        this.initUI(string);
    }

    private String getCategoryID(String string) {
        return string == null ? CategoryModel.getInstance().getCurrentCategoryID() : string;
    }

    void initCurrentCategory(final String string) {
        boolean bl = "General".equals(this.getCategoryID(string));
        if (CategoryModel.getInstance().isLookupInitialized() || bl) {
            this.setCurrentCategory(CategoryModel.getInstance().getCategory(this.getCategoryID(string)));
            this.initActions();
        } else {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Frame[] frameArray = Frame.getFrames();
                            if (frameArray == null || frameArray.length == 0) {
                                return;
                            }
                            Frame frame = frameArray[0];
                            Cursor cursor = frame.getCursor();
                            frame.setCursor(Cursor.getPredefinedCursor(3));
                            OptionsPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                            OptionsPanel.this.setCurrentCategory(CategoryModel.getInstance().getCategory(OptionsPanel.this.getCategoryID(string)));
                            OptionsPanel.this.initActions();
                            frame.setCursor(cursor);
                            OptionsPanel.this.setCursor(cursor);
                        }
                    });
                }
            }, 500);
        }
    }

    private void setCurrentCategory(CategoryModel.Category category) {
        CategoryModel.Category category2 = CategoryModel.getInstance().getCurrent();
        if (category2 != null) {
            this.buttons.get(category2.getID()).setNormal();
        }
        if (category != null) {
            this.buttons.get(category.getID()).setSelected();
        }
        CategoryModel.getInstance().setCurrent(category);
        JComponent jComponent = category.getComponent();
        category.update(this.controllerListener, false);
        Dimension dimension = jComponent.getSize();
        if (jComponent.getParent() == null || !this.pOptions.equals(jComponent.getParent())) {
            this.pOptions.add((Component)jComponent, category.getCategoryName());
        }
        this.cLayout.show(this.pOptions, category.getCategoryName());
        this.checkSize(dimension);
        this.firePropertyChange("buranhelpCtx", null, null);
    }

    HelpCtx getHelpCtx() {
        return CategoryModel.getInstance().getHelpCtx();
    }

    void update() {
        CategoryModel.getInstance().update(this.controllerListener, true);
    }

    void save() {
        CategoryModel.getInstance().save();
    }

    void cancel() {
        CategoryModel.getInstance().cancel();
    }

    boolean dataValid() {
        return CategoryModel.getInstance().dataValid();
    }

    boolean isChanged() {
        return CategoryModel.getInstance().isChanged();
    }

    boolean needsReinit() {
        return CategoryModel.getInstance().needsReinit();
    }

    private void initUI(String string) {
        this.getAccessibleContext().setAccessibleDescription(OptionsPanel.loc("ACS_OptionsPanel"));
        this.pOptions = new JPanel();
        this.cLayout = new CardLayout();
        this.pOptions.setLayout(this.cLayout);
        this.pOptions.setPreferredSize(this.getUserSize());
        JLabel jLabel = new JLabel(OptionsPanel.loc("CTL_Loading_Options"));
        jLabel.setHorizontalAlignment(0);
        this.pOptions.add((Component)jLabel, jLabel.getText());
        this.pCategories2 = new JPanel(new GridBagLayout());
        this.pCategories2.setBackground(Color.white);
        this.pCategories2.setBorder(null);
        this.addCategoryButtons();
        this.pCategories = new JPanel(new BorderLayout());
        this.pCategories.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.lightGray));
        this.pCategories.setBackground(Color.white);
        this.pCategories.add("Center", this.pCategories2);
        this.setLayout(new BorderLayout(10, 10));
        this.pOptions.setBorder(new CompoundBorder(new VariableBorder(null, null, this.borderMac, null), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.add((Component)this.pCategories, "North");
        this.add((Component)this.pOptions, "Center");
        string = this.getCategoryID(string);
        if (string != null) {
            CategoryModel.Category category = CategoryModel.getInstance().getCategory(this.getCategoryID(string));
            CategoryButton categoryButton = this.buttons.get(string);
            if (categoryButton != null) {
                categoryButton.setSelected();
            }
        }
    }

    private void initActions() {
        if (this.getActionMap().get("PREVIOUS") == null) {
            InputMap inputMap = this.getInputMap(2);
            inputMap.put(KeyStroke.getKeyStroke(37, 0), "PREVIOUS");
            this.getActionMap().put("PREVIOUS", new PreviousAction());
            inputMap.put(KeyStroke.getKeyStroke(39, 0), "NEXT");
            this.getActionMap().put("NEXT", new NextAction());
        }
    }

    private void addCategoryButtons() {
        Iterator<CategoryButton> iterator = this.buttons.values().iterator();
        while (iterator.hasNext()) {
            this.removeButton(iterator.next());
        }
        this.pCategories2.removeAll();
        this.buttons = new LinkedHashMap<String, CategoryButton>();
        Dimension dimension = new Dimension(0, 0);
        String[] stringArray = CategoryModel.getInstance().getCategoryIDs();
        for (int i = 0; i < stringArray.length; ++i) {
            CategoryModel.Category category = CategoryModel.getInstance().getCategory(stringArray[i]);
            CategoryButton categoryButton = this.addButton(category);
            Dimension dimension2 = categoryButton.getPreferredSize();
            dimension.setSize(Math.max(dimension.getWidth(), dimension2.getWidth()), Math.max(dimension.getHeight(), dimension2.getHeight()));
        }
        iterator = this.buttons.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().setPreferredSize(dimension);
        }
        this.addFakeButton();
    }

    private CategoryButton addButton(CategoryModel.Category category) {
        int n = this.buttons.size();
        CategoryButton categoryButton = new CategoryButton(category);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(categoryButton.getDisplayedMnemonic(), 8);
        this.getInputMap(2).put(keyStroke, categoryButton);
        this.getActionMap().put(categoryButton, new SelectAction(category));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = 0;
        this.pCategories2.add((Component)categoryButton, gridBagConstraints);
        this.buttons.put(category.getID(), categoryButton);
        return categoryButton;
    }

    private void removeButton(CategoryButton categoryButton) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(categoryButton.getDisplayedMnemonic(), 8);
        this.getInputMap(2).remove(keyStroke);
        this.getActionMap().remove(categoryButton);
    }

    private void addFakeButton() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 0;
        this.pCategories2.add((Component)new JLabel(""), gridBagConstraints);
    }

    private Dimension getInitSize() {
        return new Dimension(750, 500);
    }

    Dimension getUserSize() {
        int n = NbPreferences.forModule(OptionsPanel.class).getInt("OptionsWidth", this.getInitSize().width);
        int n2 = NbPreferences.forModule(OptionsPanel.class).getInt("OptionsHeight", this.getInitSize().height);
        return new Dimension(n, n2);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Rectangle rectangle = Utilities.getUsableScreenBounds();
        return new Dimension(Math.min(dimension.width, rectangle.width - 101), Math.min(dimension.height, rectangle.height - 101));
    }

    void storeUserSize() {
        Dimension dimension = this.pOptions.getSize();
        NbPreferences.forModule(OptionsPanel.class).putInt("OptionsWidth", dimension.width);
        NbPreferences.forModule(OptionsPanel.class).putInt("OptionsHeight", dimension.height);
        this.pOptions.setPreferredSize(dimension);
    }

    private boolean checkSize(Dimension dimension) {
        boolean bl = false;
        Dimension dimension2 = this.pOptions.getPreferredSize();
        Dimension dimension3 = this.getUserSize();
        dimension = new Dimension(Math.max(dimension.width, dimension3.width), Math.max(dimension.height, dimension3.height));
        if (dimension2.width < dimension.width || dimension2.height < dimension.height) {
            Dimension dimension4 = new Dimension(Math.max(dimension2.width, dimension.width), Math.max(dimension2.height, dimension.height));
            this.pOptions.setPreferredSize(dimension4);
            Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
            this.invalidate();
            if (window != null) {
                window.pack();
            }
            bl = true;
        }
        return bl;
    }

    class CategoryButton
    extends JLabel
    implements MouseListener {
        private final CategoryModel.Category category;

        CategoryButton(CategoryModel.Category category) {
            super(category.getIcon());
            this.category = category;
            Mnemonics.setLocalizedText((JLabel)this, (String)category.getCategoryName());
            this.setDisplayedMnemonic(0);
            this.setOpaque(true);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setHorizontalAlignment(0);
            this.addMouseListener(this);
            this.setFocusable(false);
            this.setFocusTraversalKeysEnabled(false);
            this.setForeground(Color.black);
            if (OptionsPanel.this.isMac) {
                this.setFont(OptionsPanel.this.labelFontMac);
                this.setIconTextGap(2);
            }
            this.setNormal();
        }

        void setNormal() {
            if (OptionsPanel.this.isMac) {
                this.setBorder(new EmptyBorder(5, 6, 3, 6));
            } else {
                this.setBorder(new EmptyBorder(2, 4, 2, 4));
            }
            this.setBackground(Color.white);
        }

        void setSelected() {
            if (OptionsPanel.this.isMac) {
                this.setBorder(new CompoundBorder(new VariableBorder(null, OptionsPanel.this.selectedB, null, OptionsPanel.this.selectedB), BorderFactory.createEmptyBorder(5, 5, 3, 5)));
            } else {
                this.setBorder(new CompoundBorder(new CompoundBorder(new LineBorder(Color.white), new LineBorder(OptionsPanel.this.selectedB)), new EmptyBorder(0, 2, 0, 2)));
            }
            this.setBackground(OptionsPanel.this.selected);
        }

        void setHighlighted() {
            if (!OptionsPanel.this.isMac) {
                this.setBorder(new CompoundBorder(new CompoundBorder(new LineBorder(Color.white), new LineBorder(OptionsPanel.this.highlightedB)), new EmptyBorder(0, 2, 0, 2)));
                this.setBackground(OptionsPanel.this.highlighted);
            }
            if (!this.category.isHighlited()) {
                CategoryButton categoryButton;
                if (CategoryModel.getInstance().getHighlitedCategoryID() != null && (categoryButton = (CategoryButton)OptionsPanel.this.buttons.get(CategoryModel.getInstance().getHighlitedCategoryID())) != null && !categoryButton.category.isCurrent()) {
                    categoryButton.setNormal();
                }
                CategoryModel.getInstance().setHighlited(this.category, true);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!OptionsPanel.this.isMac && CategoryModel.getInstance().getCurrent() != null) {
                this.setSelected();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!this.category.isCurrent() && this.category.isHighlited() && CategoryModel.getInstance().getCurrent() != null) {
                OptionsPanel.this.setCurrentCategory(this.category);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (!this.category.isCurrent() && CategoryModel.getInstance().getCurrent() != null) {
                this.setHighlighted();
            } else {
                CategoryModel.getInstance().setHighlited(CategoryModel.getInstance().getCategory(CategoryModel.getInstance().getHighlitedCategoryID()), false);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!this.category.isCurrent() && !OptionsPanel.this.isMac && CategoryModel.getInstance().getCurrent() != null) {
                this.setNormal();
            }
        }
    }

    class ControllerListener
    implements PropertyChangeListener {
        ControllerListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            OptionsPanel.this.firePropertyChange("buran" + propertyChangeEvent.getPropertyName(), null, null);
        }
    }

    private class NextAction
    extends AbstractAction {
        private NextAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OptionsPanel.this.setCurrentCategory(CategoryModel.getInstance().getNextCategory());
        }
    }

    private class PreviousAction
    extends AbstractAction {
        private PreviousAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OptionsPanel.this.setCurrentCategory(CategoryModel.getInstance().getPreviousCategory());
        }
    }

    private class SelectAction
    extends AbstractAction {
        private CategoryModel.Category category;

        SelectAction(CategoryModel.Category category) {
            this.category = category;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OptionsPanel.this.setCurrentCategory(this.category);
        }
    }

    private class SelectCurrentAction
    extends AbstractAction {
        private SelectCurrentAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CategoryModel.Category category = CategoryModel.getInstance().getCategory(CategoryModel.getInstance().getHighlitedCategoryID());
            if (category != null) {
                OptionsPanel.this.setCurrentCategory(category);
            }
        }
    }
}

