/*
 * Decompiled with CFR 0.152.
 */
package tr.view.action.recurrence.modify;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import tr.appl.Constants;
import tr.model.action.Period;
import tr.model.action.PeriodDay;
import tr.model.action.PeriodMonth;
import tr.model.action.PeriodType;
import tr.model.action.PeriodWeek;
import tr.model.action.PeriodWeekday;
import tr.model.action.PeriodYear;
import tr.model.action.Recurrence;
import tr.swing.date.field.DateField;
import tr.view.action.recurrence.PeriodTypeComboBox;

public final class RecurrenceSubsequentPanelModify
extends JPanel {
    private Recurrence modRecurrence;
    private Date actionScheduledDate;
    private boolean basisChanged;
    private long counter;
    private Map<PeriodType, Period> mapPeriods;
    private JLabel changeMessageLabel;
    private JLabel deleteMessageLabel;
    private DateField endDateField;
    private JRadioButton endDateRadioButton;
    private JLabel endLabel;
    private JLabel endNbrLabel;
    private JRadioButton endNbrRadioButton;
    private JSpinner endNbrSpinner;
    private JRadioButton endNeverRadioButton;
    private JLabel frequencyLabel;
    private JSpinner frequencySpinner;
    private PeriodTypeComboBox periodComboBox;
    private ButtonGroup startButtonGroup;
    private ButtonGroup terminationButtonGroup;

    public RecurrenceSubsequentPanelModify() {
        this.initComponents();
    }

    public void setModel(Recurrence recurrence, Date actionScheduledDate, boolean basisChanged) {
        this.modRecurrence = recurrence;
        this.actionScheduledDate = actionScheduledDate;
        this.basisChanged = basisChanged;
        this.modRecurrence.setStartDate(actionScheduledDate);
        this.initPeriods();
        this.initPanel();
    }

    private void initPeriods() {
        this.setPeriod((Period)new PeriodWeekday());
        this.setPeriod((Period)new PeriodDay());
        this.setPeriod((Period)new PeriodWeek());
        this.setPeriod((Period)new PeriodMonth());
        this.setPeriod((Period)new PeriodYear());
        this.setPeriod(this.modRecurrence.getPeriod());
    }

    private Period getPeriod(PeriodType type) {
        if (this.mapPeriods == null) {
            this.mapPeriods = new HashMap<PeriodType, Period>();
        }
        return this.mapPeriods.get(type);
    }

    private void setPeriod(Period period) {
        if (this.mapPeriods == null) {
            this.mapPeriods = new HashMap<PeriodType, Period>();
        }
        this.mapPeriods.put(period.getType(), period);
    }

    public void initPanel() {
        this.frequencySpinner.setValue(this.modRecurrence.getFrequency());
        this.periodComboBox.setSelectedItem(this.modRecurrence.getPeriod().getType());
        this.endNbrRadioButton.setSelected(this.modRecurrence.getEndNbr() != null);
        this.endNbrSpinner.setValue(this.modRecurrence.getEndNbr() == null ? 2 : this.modRecurrence.getEndNbr());
        this.endDateRadioButton.setSelected(this.modRecurrence.getEndDate() != null);
        this.endDateField.setDate(this.modRecurrence.getEndDate());
        this.endNeverRadioButton.setSelected(!this.endNbrRadioButton.isSelected() && !this.endDateRadioButton.isSelected());
        this.modRecurrence.setStartDate(this.actionScheduledDate);
        this.changeMessageLabel.setVisible(this.basisChanged);
        this.deleteMessageLabel.setVisible(this.basisChanged);
        String dte = Constants.DATE_FORMAT_FIXED.format(this.actionScheduledDate);
        String msg = "This will delete any actions in the series dated after the selected action date (" + dte + ").";
        this.deleteMessageLabel.setText(msg);
    }

    public String getName() {
        return "Change Subsequent Recurrence";
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.frequencyLabel.setEnabled(enabled);
        this.frequencySpinner.setEnabled(enabled);
        this.periodComboBox.setEnabled(enabled);
        this.endLabel.setEnabled(enabled);
        this.endNeverRadioButton.setEnabled(enabled);
        this.endNbrRadioButton.setEnabled(enabled);
        this.endNbrSpinner.setEnabled(enabled && this.endNbrRadioButton.isSelected());
        this.endNbrLabel.setEnabled(enabled);
        this.endDateRadioButton.setEnabled(enabled);
        this.endDateField.setEnabled(enabled && this.endDateRadioButton.isSelected());
        this.deleteMessageLabel.setEnabled(enabled);
    }

    private void setEndValues() {
        if (this.endNbrRadioButton.isSelected()) {
            this.modRecurrence.setEndNbr((Integer)this.endNbrSpinner.getValue());
            this.modRecurrence.setEndDate(null);
        } else if (this.endDateRadioButton.isSelected()) {
            this.modRecurrence.setEndNbr(null);
            this.modRecurrence.setEndDate(this.endDateField.getDate());
        }
        this.stateChange();
    }

    public void stateChange() {
        this.putClientProperty("state.change", ++this.counter);
    }

    public boolean isValidForm() {
        return !this.endDateRadioButton.isSelected() || this.endDateField.getDate() != null;
    }

    private void initComponents() {
        this.terminationButtonGroup = new ButtonGroup();
        this.startButtonGroup = new ButtonGroup();
        this.frequencyLabel = new JLabel();
        this.frequencySpinner = new JSpinner();
        this.periodComboBox = new PeriodTypeComboBox();
        this.endLabel = new JLabel();
        this.endNeverRadioButton = new JRadioButton();
        this.endNbrRadioButton = new JRadioButton();
        this.endNbrSpinner = new JSpinner();
        this.endNbrLabel = new JLabel();
        this.endDateRadioButton = new JRadioButton();
        this.endDateField = new DateField();
        this.changeMessageLabel = new JLabel();
        this.deleteMessageLabel = new JLabel();
        this.setMaximumSize(new Dimension(1024, 768));
        this.setMinimumSize(new Dimension(680, 480));
        this.setPreferredSize(new Dimension(680, 480));
        Mnemonics.setLocalizedText((JLabel)this.frequencyLabel, (String)"Create subsequent action in");
        this.frequencyLabel.setMaximumSize(new Dimension(180, 23));
        this.frequencyLabel.setMinimumSize(new Dimension(180, 23));
        this.frequencyLabel.setPreferredSize(new Dimension(180, 23));
        this.frequencySpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.frequencySpinner.setMaximumSize(new Dimension(50, 23));
        this.frequencySpinner.setMinimumSize(new Dimension(50, 23));
        this.frequencySpinner.setPreferredSize(new Dimension(50, 23));
        this.frequencySpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                RecurrenceSubsequentPanelModify.this.frequencySpinnerStateChanged(evt);
            }
        });
        this.periodComboBox.setMaximumSize(new Dimension(125, 23));
        this.periodComboBox.setMinimumSize(new Dimension(125, 23));
        this.periodComboBox.setPreferredSize(new Dimension(125, 23));
        this.periodComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecurrenceSubsequentPanelModify.this.periodComboBoxActionPerformed(evt);
            }
        });
        this.endLabel.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.endLabel, (String)"Terminate");
        this.endLabel.setMaximumSize(new Dimension(100, 23));
        this.endLabel.setMinimumSize(new Dimension(100, 23));
        this.endLabel.setPreferredSize(new Dimension(100, 23));
        this.terminationButtonGroup.add(this.endNeverRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.endNeverRadioButton, (String)"never");
        this.endNeverRadioButton.setMaximumSize(new Dimension(90, 23));
        this.endNeverRadioButton.setMinimumSize(new Dimension(90, 23));
        this.endNeverRadioButton.setPreferredSize(new Dimension(90, 23));
        this.endNeverRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                RecurrenceSubsequentPanelModify.this.endNeverRadioButtonStateChanged(evt);
            }
        });
        this.terminationButtonGroup.add(this.endNbrRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.endNbrRadioButton, (String)"after");
        this.endNbrRadioButton.setMaximumSize(new Dimension(70, 23));
        this.endNbrRadioButton.setMinimumSize(new Dimension(70, 23));
        this.endNbrRadioButton.setPreferredSize(new Dimension(70, 23));
        this.endNbrRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecurrenceSubsequentPanelModify.this.endNbrRadioButtonActionPerformed(evt);
            }
        });
        this.endNbrSpinner.setModel(new SpinnerNumberModel((Number)2, Integer.valueOf(2), null, (Number)1));
        this.endNbrSpinner.setMaximumSize(new Dimension(50, 23));
        this.endNbrSpinner.setMinimumSize(new Dimension(50, 23));
        this.endNbrSpinner.setPreferredSize(new Dimension(50, 23));
        this.endNbrSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                RecurrenceSubsequentPanelModify.this.endNbrSpinnerStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.endNbrLabel, (String)"occurrences");
        this.endNbrLabel.setMaximumSize(new Dimension(35, 23));
        this.endNbrLabel.setMinimumSize(new Dimension(35, 23));
        this.endNbrLabel.setPreferredSize(new Dimension(35, 23));
        this.terminationButtonGroup.add(this.endDateRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.endDateRadioButton, (String)"after");
        this.endDateRadioButton.setMaximumSize(new Dimension(70, 23));
        this.endDateRadioButton.setMinimumSize(new Dimension(70, 23));
        this.endDateRadioButton.setPreferredSize(new Dimension(70, 23));
        this.endDateRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                RecurrenceSubsequentPanelModify.this.endDateRadioButtonStateChanged(evt);
            }
        });
        this.endDateField.setMaximumSize(new Dimension(110, 23));
        this.endDateField.setMinimumSize(new Dimension(110, 23));
        this.endDateField.setPreferredSize(new Dimension(110, 23));
        this.endDateField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                RecurrenceSubsequentPanelModify.this.endDateFieldPropertyChange(evt);
            }
        });
        this.changeMessageLabel.setFont(this.changeMessageLabel.getFont().deriveFont(this.changeMessageLabel.getFont().getStyle() | 2));
        Mnemonics.setLocalizedText((JLabel)this.changeMessageLabel, (String)"Changing recurrence type from Regular to Subsequent.");
        this.changeMessageLabel.setMaximumSize(new Dimension(45, 23));
        this.changeMessageLabel.setMinimumSize(new Dimension(45, 23));
        this.changeMessageLabel.setPreferredSize(new Dimension(45, 23));
        this.deleteMessageLabel.setFont(this.deleteMessageLabel.getFont().deriveFont(this.deleteMessageLabel.getFont().getStyle() | 2));
        this.deleteMessageLabel.setForeground(Color.red);
        Mnemonics.setLocalizedText((JLabel)this.deleteMessageLabel, (String)"This will delete of any actions in the series dated after the action date (<action-date>).");
        this.deleteMessageLabel.setMaximumSize(new Dimension(286, 23));
        this.deleteMessageLabel.setMinimumSize(new Dimension(286, 23));
        this.deleteMessageLabel.setPreferredSize(new Dimension(286, 23));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(20, 20, 20).add((Component)this.frequencyLabel, -2, -1, -2).add(1, 1, 1).add((Component)this.frequencySpinner, -2, -1, -2).addPreferredGap(0).add((Component)this.periodComboBox, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.endLabel, -2, -1, -2).addPreferredGap(1).add((Component)this.endNeverRadioButton, -2, -1, -2).addPreferredGap(0).add((Component)this.endNbrRadioButton, -2, -1, -2).addPreferredGap(0).add((Component)this.endNbrSpinner, -2, -1, -2).addPreferredGap(0).add((Component)this.endNbrLabel, -2, 94, -2).addPreferredGap(0).add((Component)this.endDateRadioButton, -2, -1, -2).addPreferredGap(0).add((Component)this.endDateField, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.changeMessageLabel, -1, 640, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.deleteMessageLabel, -1, 640, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(new Component[]{this.endDateRadioButton, this.endNbrRadioButton}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(20, 20, 20).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.periodComboBox, -2, -1, -2).add(2, (Component)this.frequencySpinner, -2, -1, -2).add(2, (Component)this.frequencyLabel, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.endLabel, -2, -1, -2).add(2, (Component)this.endNeverRadioButton, -2, -1, -2).add(2, (Component)this.endNbrRadioButton, -2, -1, -2).add(2, (Component)this.endNbrSpinner, -2, -1, -2).add(2, (Component)this.endNbrLabel, -2, -1, -2).add(2, (Component)this.endDateRadioButton, -2, -1, -2).add(2, (Component)this.endDateField, -2, -1, -2)).add(18, 18, 18).add((Component)this.changeMessageLabel, -2, -1, -2).add(0, 0, 0).add((Component)this.deleteMessageLabel, -2, -1, -2).addContainerGap(342, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.endDateField, this.endDateRadioButton, this.endLabel, this.endNbrLabel, this.endNbrRadioButton, this.endNbrSpinner, this.endNeverRadioButton}, 2);
    }

    private void periodComboBoxActionPerformed(ActionEvent evt) {
        this.modRecurrence.setPeriod(this.getPeriod((PeriodType)this.periodComboBox.getSelectedItem()));
        this.setEndValues();
        this.stateChange();
    }

    private void endNbrRadioButtonActionPerformed(ActionEvent evt) {
        this.setEndValues();
        this.setEnabled(this.isEnabled());
    }

    private void frequencySpinnerStateChanged(ChangeEvent evt) {
        this.modRecurrence.setFrequency(((Integer)this.frequencySpinner.getValue()).intValue());
        this.setEndValues();
        this.stateChange();
    }

    private void endNeverRadioButtonStateChanged(ChangeEvent evt) {
        this.setEndValues();
        this.setEnabled(this.isEnabled());
    }

    private void endNbrSpinnerStateChanged(ChangeEvent evt) {
        this.setEndValues();
    }

    private void endDateFieldPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("value")) {
            this.setEndValues();
        }
    }

    private void endDateRadioButtonStateChanged(ChangeEvent evt) {
        this.setEndValues();
        this.setEnabled(this.isEnabled());
    }
}

