/*
 * Decompiled with CFR 0.152.
 */
package tr.view.action;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;
import tr.model.action.PeriodMonth;
import tr.view.action.DaysOfMonthDialog;

public class PeriodMonthlyPanel
extends JPanel {
    private ButtonGroup buttonGroup;
    private JComboBox dayComboBox;
    private JButton daysButton;
    private JRadioButton eachRadioButton;
    private JComboBox nthComboBox;
    private JRadioButton onTheRadioButton;
    private final Dialog parent;
    private final PeriodMonth periodMonth;

    public PeriodMonthlyPanel(Dialog parent, PeriodMonth periodMonth) {
        this.parent = parent;
        this.periodMonth = periodMonth;
        this.initComponents();
        this.eachRadioButton.setSelected(periodMonth.getOption() == PeriodMonth.Option.Each);
        this.onTheRadioButton.setSelected(periodMonth.getOption() == PeriodMonth.Option.OnThe);
        this.dayComboBox.setModel(this.getDayComboModel());
        this.dayComboBox.setSelectedItem(periodMonth.getOnTheDay());
        this.nthComboBox.setModel(this.getNthComboModel());
        this.nthComboBox.setSelectedItem(periodMonth.getOnTheNth());
        this.setEnabled(true);
    }

    private String getSelectedDaysText() {
        return this.periodMonth.getSelectedDaysText();
    }

    private ComboBoxModel getDayComboModel() {
        return new DefaultComboBoxModel<PeriodMonth.OnTheDay>(PeriodMonth.OnTheDay.values());
    }

    private ComboBoxModel getNthComboModel() {
        return new DefaultComboBoxModel<PeriodMonth.OnTheNth>(PeriodMonth.OnTheNth.values());
    }

    public void notifyStartDate(Date startDate) {
        if (startDate == null) {
            return;
        }
        if (this.periodMonth.getSelectedDays().size() > 0) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        this.periodMonth.select(Integer.valueOf(calendar.get(5)));
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.daysButton.setEnabled(enabled && this.eachRadioButton.isSelected());
        this.nthComboBox.setEnabled(enabled && this.onTheRadioButton.isSelected());
        this.dayComboBox.setEnabled(enabled && this.onTheRadioButton.isSelected());
        this.eachRadioButton.setEnabled(enabled);
        this.onTheRadioButton.setEnabled(enabled);
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.eachRadioButton = new JRadioButton();
        this.daysButton = new JButton();
        this.onTheRadioButton = new JRadioButton();
        this.nthComboBox = new JComboBox();
        this.dayComboBox = new JComboBox();
        this.setMaximumSize(new Dimension(530, 26));
        this.setMinimumSize(new Dimension(528, 26));
        this.setPreferredSize(new Dimension(528, 26));
        this.buttonGroup.add(this.eachRadioButton);
        this.eachRadioButton.setText(NbBundle.getMessage(PeriodMonthlyPanel.class, (String)"months.each"));
        this.eachRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.eachRadioButton.setMaximumSize(new Dimension(64, 26));
        this.eachRadioButton.setMinimumSize(new Dimension(64, 26));
        this.eachRadioButton.setPreferredSize(new Dimension(64, 26));
        this.eachRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PeriodMonthlyPanel.this.monthsRadioButtonAction(evt);
            }
        });
        this.daysButton.setText(this.getSelectedDaysText());
        this.daysButton.setHorizontalAlignment(10);
        this.daysButton.setHorizontalTextPosition(10);
        this.daysButton.setMaximumSize(new Dimension(120, 26));
        this.daysButton.setMinimumSize(new Dimension(120, 26));
        this.daysButton.setPreferredSize(new Dimension(120, 26));
        this.daysButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PeriodMonthlyPanel.this.daysButtonAction(evt);
            }
        });
        this.buttonGroup.add(this.onTheRadioButton);
        this.onTheRadioButton.setText(NbBundle.getMessage(PeriodMonthlyPanel.class, (String)"months.on.the"));
        this.onTheRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.onTheRadioButton.setMaximumSize(new Dimension(70, 26));
        this.onTheRadioButton.setMinimumSize(new Dimension(70, 26));
        this.onTheRadioButton.setPreferredSize(new Dimension(70, 26));
        this.onTheRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PeriodMonthlyPanel.this.monthsRadioButtonAction(evt);
            }
        });
        this.nthComboBox.setMaximumSize(new Dimension(120, 26));
        this.nthComboBox.setMinimumSize(new Dimension(120, 26));
        this.nthComboBox.setPreferredSize(new Dimension(120, 26));
        this.nthComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PeriodMonthlyPanel.this.onTheNthComboAction(evt);
            }
        });
        this.dayComboBox.setMaximumSize(new Dimension(120, 26));
        this.dayComboBox.setMinimumSize(new Dimension(120, 26));
        this.dayComboBox.setPreferredSize(new Dimension(120, 26));
        this.dayComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PeriodMonthlyPanel.this.dayComboAction(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.eachRadioButton, -2, -1, -2).addPreferredGap(0).add((Component)this.daysButton, -2, -1, -2).add(18, 18, 18).add((Component)this.onTheRadioButton, -2, 72, -2).addPreferredGap(0).add((Component)this.nthComboBox, -2, -1, -2).add(0, 0, 0).add((Component)this.dayComboBox, -2, -1, -2).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.eachRadioButton, -2, -1, -2).add(2, (Component)this.daysButton, -2, -1, -2).add(2, (Component)this.onTheRadioButton, -2, -1, -2).add(2, (Component)this.nthComboBox, -2, -1, -2).add(2, (Component)this.dayComboBox, -2, -1, -2)));
    }

    private void dayComboAction(ActionEvent evt) {
        this.periodMonth.setOnTheDay((PeriodMonth.OnTheDay)this.dayComboBox.getSelectedItem());
    }

    private void onTheNthComboAction(ActionEvent evt) {
        this.periodMonth.setOnTheNth((PeriodMonth.OnTheNth)this.nthComboBox.getSelectedItem());
    }

    private void daysButtonAction(ActionEvent evt) {
        DaysOfMonthDialog dialog = new DaysOfMonthDialog(this.parent, this.daysButton);
        dialog.setPeriodMonth(this.periodMonth);
        dialog.setVisible(true);
        if (!dialog.cancelled()) {
            this.periodMonth.setSelectedDays(dialog.getSelectedDays());
            this.daysButton.setText(this.periodMonth.getSelectedDaysText());
        }
    }

    private void monthsRadioButtonAction(ActionEvent evt) {
        if (this.eachRadioButton.isSelected()) {
            this.periodMonth.setOption(PeriodMonth.Option.Each);
        } else {
            this.periodMonth.setOption(PeriodMonth.Option.OnThe);
        }
        this.setEnabled(true);
    }
}

