/*
 * Decompiled with CFR 0.152.
 */
package tr.view.action;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import tr.appl.Constants;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.action.Action;
import tr.model.action.ActionState;
import tr.model.action.ActionStateASAP;
import tr.model.action.ActionStateDelegated;
import tr.model.action.ActionStateInactive;
import tr.model.action.ActionStateScheduled;
import tr.model.action.Recurrence;
import tr.model.context.Context;
import tr.model.criteria.Value;
import tr.model.thought.Thought;
import tr.model.topic.Topic;
import tr.runtime.Email;
import tr.runtime.Open;
import tr.swing.TextArea;
import tr.swing.date.field.DateField;
import tr.swing.document.LazyDocumentListener;
import tr.swing.editorpane.HyperEditorPane;
import tr.swing.time.HourSpinner;
import tr.swing.time.MinuteSpinner;
import tr.util.Observable;
import tr.util.Observer;
import tr.util.Utils;
import tr.view.action.StatusComboBoxModel;
import tr.view.action.StatusEnum;
import tr.view.action.prefs.ActionPrefs;
import tr.view.action.recurrence.NewRecurrenceWizard;
import tr.view.action.recurrence.modify.ModifyRecurrenceWizard;
import tr.view.contexts.ContextsComboBox;
import tr.view.contexts.ContextsComboBoxModel;
import tr.view.criteria.EnergyComboBoxModel;
import tr.view.criteria.PriorityComboBoxModel;
import tr.view.criteria.TimeComboBoxModel;
import tr.view.topics.TopicsComboBox;
import tr.view.topics.TopicsComboBoxModel;

public class ActionPanel
extends JPanel
implements Observer {
    private Lookup.Result result;
    private final PropertyChangeListener descrListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (ActionPanel.this.descriptionText.hasFocus()) {
                return;
            }
            if (!ActionPanel.this.descriptionText.getText().equals(ActionPanel.this.action.getDescription())) {
                ActionPanel.this.descriptionText.setText(ActionPanel.this.action.getDescription());
            }
        }
    };
    private final PropertyChangeListener topicListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (ActionPanel.this.topicCombo.hasFocus()) {
                return;
            }
            if (!Utils.equal((Object)ActionPanel.this.action.getTopic(), (Object)ActionPanel.this.topicCombo.getSelectedItem())) {
                ActionPanel.this.topicCombo.setSelectedItem(ActionPanel.this.action.getTopic());
            }
        }
    };
    private final PropertyChangeListener contextListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (ActionPanel.this.contextsCombo.hasFocus()) {
                return;
            }
            if (!Utils.equal((Object)ActionPanel.this.action.getContext(), (Object)ActionPanel.this.contextsCombo.getSelectedItem())) {
                ActionPanel.this.contextsCombo.setSelectedItem(ActionPanel.this.action.getContext());
            }
        }
    };
    private final PropertyChangeListener doneListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (ActionPanel.this.doneCheckBox.isSelected() != ActionPanel.this.action.isDone()) {
                ActionPanel.this.doneCheckBox.setSelected(ActionPanel.this.action.isDone());
                ActionPanel.this.doneDateField.setDate(ActionPanel.this.action.getDoneDate());
                ActionPanel.this.doneDateField.setEnabled(ActionPanel.this.action.canSetDone(true));
            }
        }
    };
    private JLabel contextLabel;
    private JComboBox contextsCombo;
    private DateField createdDateField;
    private JLabel createdDateLabel;
    private JPanel criterionPanel;
    private JPanel delegatedPanel;
    private JLabel delegatedToLabel;
    private JTextField delegatedToText;
    private JLabel descriptionLabel;
    private JTextField descriptionText;
    private JCheckBox doneCheckBox;
    private DateField doneDateField;
    private DateField dueDateField;
    private JLabel dueDateLabel;
    private HourSpinner durationHourSpinner;
    private JLabel durationLabel;
    private MinuteSpinner durationMinuteSpinner;
    private JButton emailButton;
    private JComboBox energyCombo;
    private JLabel energyLabel;
    private DateField followupDateField;
    private JLabel followupLabel;
    private HyperEditorPane notesEditorPane;
    private JLabel notesLabel;
    private JComboBox priorityCombo;
    private JLabel priorityLabel;
    private JButton recurrenceButton;
    private JLabel recurrenceLabel;
    private DateField scheduledDateField;
    private HourSpinner scheduledHourSpinner;
    private JLabel scheduledLabel;
    private MinuteSpinner scheduledMinuteSpinner;
    private JPanel scheduledPanel;
    private DateField startDateField;
    private JLabel startDateLabel;
    private JComboBox statusCombo;
    private JLabel statusLabel;
    private JLabel successLabel;
    private JScrollPane successScrollPane;
    private TextArea successText;
    private JLabel thoughtLabel;
    private JTextField thoughtText;
    private JComboBox timeCombo;
    private JLabel timeLabel;
    private JComboBox topicCombo;
    private JLabel topicLabel;
    private static final String DEFAULT_DESCRIPTION = ActionPanel.getText("new.action");
    private Action action;
    private ActionStateInactive stateInactive;
    private ActionStateASAP stateASAP;
    private ActionStateDelegated stateDelegated;
    private ActionStateScheduled stateScheduled;
    private ComboBoxModel topicsModel;
    private ComboBoxModel contextsModel;
    private boolean updating;
    private DocumentListener docListenerDescription;
    private FocusAdapter focusAdapterDescription;
    private DocumentListener docListenerSuccess;
    private DocumentListener docListenerDelegatedTo;
    private DocumentListener docListenerNotes;
    private ActionListener actionListenerTopic;
    private ActionListener actionListenerContext;
    private ActionListener actionListenerRecurrence;
    private ActionListener actionListenerEmail;
    private ActionListener actionListenerStatusCombo;
    private ActionListener actionListenerPriorityCombo;
    private ActionListener actionListenerEnergyCombo;
    private ActionListener actionListenerTimeCombo;
    private ChangeListener changeListenerScheduledHour;
    private ChangeListener changeListenerScheduledMinute;
    private ChangeListener changeListenerDurationHour;
    private ChangeListener changeListenerDurationMinute;
    private HyperlinkListener notesHyperlinkListener;
    private Observer observerCriterion;
    private ActionListener doneCheckBoxActionListener;
    private PropertyChangeListener followupDatePropertyChangeListener;
    private PropertyChangeListener createdDatePropertyChangeListener;
    private PropertyChangeListener startDatePropertyChangeListener;
    private PropertyChangeListener dueDatePropertyChangeListener;
    private PropertyChangeListener doneDatePropertyChangeListener;
    private PropertyChangeListener scheduledDatePropertyChangeListener;

    public ActionPanel() {
        this.initComponents();
        this.initModel(null);
        this.result = DataLookup.instance().lookup(new Lookup.Template(Data.class));
        this.result.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                ActionPanel.this.changedData();
            }
        });
        this.changedData();
    }

    private Data getData() {
        return (Data)DataLookup.instance().lookup(Data.class);
    }

    private void changedData() {
        Data data = this.getData();
        if (data == null) {
            return;
        }
        if (this.observerCriterion == null) {
            this.observerCriterion = new Observer(){

                public void update(Observable observable, Object argument) {
                    ActionPanel.this.showHideCriteria();
                }
            };
        }
        data.getTimeCriterion().addObserver(this.observerCriterion);
        data.getEnergyCriterion().addObserver(this.observerCriterion);
        data.getPriorityCriterion().addObserver(this.observerCriterion);
    }

    public void addNotify() {
        super.addNotify();
        this.addListeners();
    }

    public void removeNotify() {
        this.removeListeners();
        super.removeNotify();
    }

    public void edit() {
        this.descriptionText.requestFocusInWindow();
    }

    public Action getModel() {
        return this.action;
    }

    public void initModel(Action action) {
        if (this.action != null) {
            this.action.removeObserver((Observer)this);
            this.action.removePropertyChangeListenter("Descr", this.descrListener);
            this.action.removePropertyChangeListenter("Topic", this.topicListener);
            this.action.removePropertyChangeListenter("Context", this.contextListener);
            this.action.removePropertyChangeListenter("Done", this.doneListener);
        }
        this.action = action;
        this.stateInactive = null;
        this.stateASAP = null;
        this.stateScheduled = null;
        this.stateDelegated = null;
        this.storeActionState();
        if (this.action != null) {
            this.action.addObserver((Observer)this);
            this.action.addPropertyChangeListenter("Descr", this.descrListener);
            this.action.addPropertyChangeListenter("Topic", this.topicListener);
            this.action.addPropertyChangeListenter("Context", this.contextListener);
            this.action.addPropertyChangeListenter("Done", this.doneListener);
        }
        this.initView();
    }

    private void initView() {
        this.updating = true;
        if (this.action == null) {
            this.descriptionText.setText("");
            this.thoughtText.setText("");
            this.successText.setText("");
            this.topicCombo.setSelectedItem(null);
            this.contextsCombo.setSelectedItem(null);
            this.statusCombo.setSelectedItem(null);
            this.followupDateField.setDate(null);
            this.scheduledDateField.setDate(null);
            this.scheduledHourSpinner.setVal(0);
            this.scheduledMinuteSpinner.setVal(0);
            this.durationHourSpinner.setVal(0);
            this.durationMinuteSpinner.setVal(0);
            this.timeCombo.setSelectedItem(null);
            this.energyCombo.setSelectedItem(null);
            this.priorityCombo.setSelectedItem(null);
            this.notesEditorPane.setText("");
            this.createdDateField.setDate(null);
            this.startDateField.setDate(null);
            this.dueDateField.setDate(null);
            this.doneCheckBox.setSelected(false);
            this.doneDateField.setDate(null);
            this.setEnabled(false);
        } else {
            ActionStateASAP state;
            this.descriptionText.setText(this.action.getDescription());
            Thought thought = this.action.getThought();
            this.thoughtText.setText(thought == null ? "" : thought.getDescription());
            this.successText.setText(this.action.getSuccess());
            this.topicCombo.setSelectedItem(this.action.getTopic());
            this.contextsCombo.setSelectedItem(this.action.getContext());
            this.statusCombo.setSelectedItem(null);
            if (this.action.isStateInactive()) {
                this.statusCombo.setSelectedItem((Object)StatusEnum.INACTIVE);
            } else if (this.action.isStateASAP()) {
                this.statusCombo.setSelectedItem((Object)StatusEnum.DO_ASAP);
                state = (ActionStateASAP)this.action.getState();
            }
            if (this.action.isStateDelegated()) {
                this.statusCombo.setSelectedItem((Object)StatusEnum.DELEGATED);
                state = (ActionStateDelegated)this.action.getState();
                this.delegatedToText.setText(state.getTo());
                this.followupDateField.setDate(state.getDate());
            } else {
                this.delegatedToText.setText("");
                this.followupDateField.setDate(null);
            }
            if (this.action.isStateScheduled()) {
                this.statusCombo.setSelectedItem((Object)StatusEnum.SCHEDULED);
                state = (ActionStateScheduled)this.action.getState();
                this.scheduledDateField.setDate(state.getDate());
                if (state.getDate() == null) {
                    this.scheduledHourSpinner.setValue((Object)new Integer(0));
                    this.scheduledMinuteSpinner.setValue((Object)new Integer(0));
                    this.durationHourSpinner.setValue((Object)new Integer(0));
                    this.durationMinuteSpinner.setValue((Object)new Integer(0));
                } else {
                    Calendar c = Calendar.getInstance();
                    c.setTime(state.getDate());
                    this.scheduledHourSpinner.setVal(c.get(11));
                    this.scheduledMinuteSpinner.setVal(c.get(12));
                    this.durationHourSpinner.setVal(state.getDurationHours());
                    this.durationMinuteSpinner.setVal(state.getDurationMinutes());
                }
            } else {
                this.scheduledDateField.setDate(null);
                this.scheduledHourSpinner.setValue((Object)new Integer(0));
                this.scheduledMinuteSpinner.setValue((Object)new Integer(0));
                this.durationHourSpinner.setValue((Object)new Integer(0));
                this.durationMinuteSpinner.setValue((Object)new Integer(0));
            }
            this.timeCombo.setSelectedItem(this.action.getTime());
            this.energyCombo.setSelectedItem(this.action.getEnergy());
            this.priorityCombo.setSelectedItem(this.action.getPriority());
            this.notesEditorPane.setText(this.action.getNotes());
            this.createdDateField.setDate(this.action.getCreated());
            this.startDateField.setDate(this.action.getStartDate());
            this.dueDateField.setDate(this.action.getDueDate());
            this.doneCheckBox.setSelected(this.action.isDone());
            this.doneDateField.setDate(this.action.getDoneDate());
            this.setEnabled(true);
        }
        boolean showSuccess = ActionPrefs.isShowSuccess();
        this.successLabel.setVisible(showSuccess);
        this.successText.setVisible(showSuccess);
        this.successScrollPane.setVisible(showSuccess);
        this.updating = false;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.descriptionLabel.setEnabled(enabled);
        this.descriptionText.setEnabled(enabled);
        this.successText.setEnabled(enabled);
        this.topicLabel.setEnabled(enabled);
        this.topicCombo.setEnabled(enabled);
        this.contextLabel.setEnabled(enabled);
        this.contextsCombo.setEnabled(enabled);
        this.statusLabel.setEnabled(enabled);
        this.statusCombo.setEnabled(enabled);
        this.delegatedPanel.setVisible(enabled && this.action.isStateDelegated());
        this.delegatedPanel.setEnabled(enabled);
        this.delegatedToLabel.setEnabled(enabled);
        this.delegatedToText.setEnabled(enabled);
        this.emailButton.setEnabled(enabled);
        this.followupLabel.setEnabled(enabled);
        this.followupDateField.setEnabled(enabled);
        this.scheduledPanel.setEnabled(enabled);
        this.scheduledLabel.setEnabled(enabled);
        this.scheduledDateField.setEnabled(enabled);
        this.scheduledHourSpinner.setEnabled(enabled);
        this.scheduledMinuteSpinner.setEnabled(enabled);
        this.durationLabel.setEnabled(enabled);
        this.durationHourSpinner.setEnabled(enabled);
        this.durationMinuteSpinner.setEnabled(enabled);
        this.scheduledPanel.setVisible(enabled && this.action.isStateScheduled());
        if (this.scheduledPanel.isVisible()) {
            this.recurrenceLabel.setEnabled(this.scheduledDateField.getDate() != null);
            this.recurrenceButton.setEnabled(this.scheduledDateField.getDate() != null);
            ActionStateScheduled state = (ActionStateScheduled)this.action.getState();
            if (state.getRecurrence() == null) {
                this.recurrenceButton.setText(ActionPanel.getText("recurrence.create"));
            } else {
                this.recurrenceButton.setText(ActionPanel.getText("recurrence.modify"));
            }
            this.startDateLabel.setVisible(false);
            this.startDateField.setVisible(false);
            this.dueDateLabel.setVisible(false);
            this.dueDateField.setVisible(false);
        } else {
            this.startDateLabel.setVisible(ActionPrefs.isShowStartDate());
            this.startDateField.setVisible(ActionPrefs.isShowStartDate());
            this.dueDateLabel.setVisible(ActionPrefs.isShowDueDate());
            this.dueDateField.setVisible(ActionPrefs.isShowDueDate());
        }
        this.notesLabel.setEnabled(enabled);
        this.notesEditorPane.setEnabled(enabled);
        this.notesEditorPane.setEditable(false);
        this.createdDateLabel.setEnabled(enabled);
        this.createdDateField.setEnabled(enabled && ActionPrefs.isEditCreateDate());
        this.startDateLabel.setEnabled(enabled);
        this.startDateField.setEnabled(enabled);
        this.dueDateLabel.setEnabled(enabled);
        this.dueDateField.setEnabled(enabled);
        this.doneCheckBox.setEnabled(enabled);
        this.doneDateField.setEnabled(enabled && this.action.canSetDone(true));
        this.showHideCriteria();
    }

    private void showHideCriteria() {
        Data data = this.getData();
        this.criterionPanel.setVisible(data.getTimeCriterion().use || data.getEnergyCriterion().use || data.getPriorityCriterion().use);
        if (this.criterionPanel.isVisible()) {
            this.timeLabel.setEnabled(data.getTimeCriterion().use);
            this.timeCombo.setEnabled(data.getTimeCriterion().use);
            this.energyLabel.setEnabled(data.getEnergyCriterion().use);
            this.energyCombo.setEnabled(data.getEnergyCriterion().use);
            this.priorityLabel.setEnabled(data.getPriorityCriterion().use);
            this.priorityCombo.setEnabled(data.getPriorityCriterion().use);
        }
    }

    public void focus() {
        this.descriptionText.requestFocusInWindow();
    }

    public void refresh() {
        this.setEnabled(this.action != null);
    }

    private void addToNotes(String text) {
        String notes = this.notesEditorPane.getText().trim();
        if (notes.contains(text)) {
            return;
        }
        if (notes.length() == 0) {
            this.notesEditorPane.setText(text);
        } else {
            this.notesEditorPane.setText(notes + "\n" + text);
        }
    }

    private void storeActionState() {
        if (this.action == null) {
            return;
        }
        if (this.action.isStateInactive()) {
            this.stateInactive = (ActionStateInactive)this.action.getState();
        } else if (this.action.isStateASAP()) {
            this.stateASAP = (ActionStateASAP)this.action.getState();
        } else if (this.action.isStateScheduled()) {
            this.stateScheduled = (ActionStateScheduled)this.action.getState();
        } else if (this.action.isStateDelegated()) {
            this.stateDelegated = (ActionStateDelegated)this.action.getState();
        }
    }

    private void hyperlink(HyperlinkEvent evt) {
        URL url = evt.getURL();
        if (url == null) {
            return;
        }
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            Open.open((URL)url);
        }
    }

    private void recurrenceActionPerformed(ActionEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        if (!this.action.isStateScheduled()) {
            return;
        }
        Recurrence recurrence = this.action.getRecurrence();
        if (recurrence == null) {
            NewRecurrenceWizard wizard = new NewRecurrenceWizard();
            wizard.start(this.action);
        } else {
            ModifyRecurrenceWizard wizard = new ModifyRecurrenceWizard();
            wizard.start(this.action);
        }
        if (this.action.getRecurrence() == null) {
            this.recurrenceButton.setText(ActionPanel.getText("recurrence.create"));
        } else {
            this.recurrenceButton.setText(ActionPanel.getText("recurrence.modify"));
        }
    }

    private void changedDurationMinutes() {
        if (this.updating || this.action == null) {
            return;
        }
        if (!this.action.isStateScheduled()) {
            return;
        }
        this.stateScheduled = (ActionStateScheduled)this.action.getState();
        if (this.stateScheduled.getDate() == null) {
            this.durationMinuteSpinner.setVal(0);
        } else {
            this.stateScheduled.setDurationMins(this.durationMinuteSpinner.getVal());
        }
    }

    private void changedDurationHours() {
        if (this.updating || this.action == null) {
            return;
        }
        if (!this.action.isStateScheduled()) {
            return;
        }
        this.stateScheduled = (ActionStateScheduled)this.action.getState();
        if (this.stateScheduled.getDate() == null) {
            this.durationHourSpinner.setVal(0);
        } else {
            this.stateScheduled.setDurationHours(this.durationHourSpinner.getVal());
        }
    }

    private void changedScheduledDate(Date date) {
        if (this.updating || this.action == null) {
            return;
        }
        if (!this.action.isStateScheduled()) {
            return;
        }
        this.stateScheduled = (ActionStateScheduled)this.action.getState();
        if (date == null) {
            this.stateScheduled.setDate(null);
            this.scheduledHourSpinner.setVal(0);
            this.scheduledMinuteSpinner.setVal(0);
            this.durationHourSpinner.setVal(0);
            this.durationMinuteSpinner.setVal(0);
            this.recurrenceLabel.setEnabled(false);
            this.recurrenceButton.setEnabled(false);
        } else {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.set(11, this.scheduledHourSpinner.getVal());
            cal.set(12, this.scheduledMinuteSpinner.getVal());
            cal.set(13, 0);
            cal.set(14, 0);
            this.stateScheduled.setDate(cal.getTime());
            this.scheduledHourSpinner.setEnabled(true);
            this.scheduledMinuteSpinner.setEnabled(true);
            this.durationHourSpinner.setEnabled(true);
            this.durationMinuteSpinner.setEnabled(true);
            this.durationLabel.setEnabled(true);
            this.recurrenceLabel.setEnabled(true);
            this.recurrenceButton.setEnabled(true);
        }
    }

    private void changedFollowupDate(Date date) {
        if (this.updating || this.action == null) {
            return;
        }
        if (this.action.isStateDelegated()) {
            this.stateDelegated = (ActionStateDelegated)this.action.getState();
            this.stateDelegated.setDate(date);
        }
    }

    private void changedPriority() {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setPriority((Value)this.priorityCombo.getSelectedItem());
    }

    private void changedTime() {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setTime((Value)this.timeCombo.getSelectedItem());
    }

    private void changedEnergy() {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setEnergy((Value)this.energyCombo.getSelectedItem());
    }

    private void changedStatus(ActionEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        StatusEnum status = (StatusEnum)((Object)this.statusCombo.getSelectedItem());
        switch (status) {
            case INACTIVE: {
                this.action.setState((ActionState)this.getStateInactive());
                break;
            }
            case DO_ASAP: {
                this.action.setState((ActionState)this.getStateASAP());
                break;
            }
            case SCHEDULED: {
                this.action.setState((ActionState)this.getStateScheduled());
                break;
            }
            case DELEGATED: {
                this.action.setState((ActionState)this.getStateDelegated());
            }
        }
        this.setEnabled(true);
    }

    private void emailActionPerformed(ActionEvent evt) {
        String to = this.delegatedToText.getText();
        if (Utilities.getOperatingSystem() == 16 && to.indexOf("@") == -1) {
            JOptionPane.showMessageDialog(null, ActionPanel.getText("ERR_EmailRequired"), "", 1);
            return;
        }
        String subject = this.descriptionText.getText();
        String body = this.notesEditorPane.getText();
        Email.email((String)to, (String)subject, (String)body);
        Date today = Calendar.getInstance().getTime();
        if (ActionPrefs.isNoteDelegateEmail()) {
            this.addToNotes(ActionPanel.getText("MSG_EmailSent") + " " + Constants.DATE_FORMAT_FIXED.format(today));
        }
    }

    private void changedScheduledHour() {
        if (this.updating || this.action == null) {
            return;
        }
        if (!this.action.isStateScheduled()) {
            return;
        }
        this.stateScheduled = (ActionStateScheduled)this.action.getState();
        if (this.stateScheduled.getDate() == null) {
            this.scheduledHourSpinner.setVal(0);
        } else {
            Calendar c = Calendar.getInstance();
            c.setTime(this.stateScheduled.getDate());
            c.set(11, this.scheduledHourSpinner.getVal());
            c.set(13, 0);
            this.stateScheduled.setDate(c.getTime());
            this.scheduledDateField.setDate(c.getTime());
        }
    }

    private void changedScheduledMinute() {
        if (this.updating || this.action == null) {
            return;
        }
        if (!this.action.isStateScheduled()) {
            return;
        }
        this.stateScheduled = (ActionStateScheduled)this.action.getState();
        if (this.stateScheduled.getDate() == null) {
            this.scheduledMinuteSpinner.setVal(0);
        } else {
            Calendar c = Calendar.getInstance();
            c.setTime(this.stateScheduled.getDate());
            c.set(12, this.scheduledMinuteSpinner.getVal());
            c.set(13, 0);
            this.stateScheduled.setDate(c.getTime());
            this.scheduledDateField.setDate(c.getTime());
        }
    }

    private void changedDoneDate(Date date) {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setDoneDate(this.doneDateField.getDate());
    }

    private void changedDone() {
        if (this.updating || this.action == null) {
            return;
        }
        if (this.action.canSetDone(this.doneCheckBox.isSelected())) {
            this.action.setDone(this.doneCheckBox.isSelected());
            this.doneDateField.setDate(this.action.getDoneDate());
            this.doneDateField.setEnabled(this.action.canSetDone(true));
        }
    }

    private void changedCreatedDate(Date date) {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setCreated(date);
    }

    private void changedStartDate(Date date) {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setStartDate(date);
    }

    private void changedDueDate(Date date) {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setDueDate(this.dueDateField.getDate());
    }

    private void changedContext(ActionEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        JComboBox combo = (JComboBox)evt.getSource();
        this.action.setContext((Context)combo.getSelectedItem());
    }

    private void changedTopic(ActionEvent evt) {
        if (this.updating || this.action == null) {
            return;
        }
        JComboBox combo = (JComboBox)evt.getSource();
        this.action.setTopic((Topic)combo.getSelectedItem());
    }

    private void descriptionTextFocusGained(FocusEvent evt) {
        if (this.descriptionText.getText().equals(DEFAULT_DESCRIPTION)) {
            this.descriptionText.setSelectionStart(0);
            this.descriptionText.setSelectionEnd(DEFAULT_DESCRIPTION.length());
        }
    }

    private ActionStateInactive getStateInactive() {
        if (this.stateInactive == null) {
            this.stateInactive = this.action.isStateInactive() ? (ActionStateInactive)this.action.getState() : new ActionStateInactive();
        }
        return this.stateInactive;
    }

    private ActionStateASAP getStateASAP() {
        if (this.stateASAP == null) {
            this.stateASAP = this.action.isStateASAP() ? (ActionStateASAP)this.action.getState() : new ActionStateASAP();
        }
        return this.stateASAP;
    }

    private ActionStateDelegated getStateDelegated() {
        if (this.stateDelegated == null) {
            this.stateDelegated = this.action.isStateDelegated() ? (ActionStateDelegated)this.action.getState() : new ActionStateDelegated();
        }
        return this.stateDelegated;
    }

    private ActionStateScheduled getStateScheduled() {
        if (this.stateScheduled == null) {
            this.stateScheduled = this.action.isStateScheduled() ? (ActionStateScheduled)this.action.getState() : new ActionStateScheduled();
        }
        return this.stateScheduled;
    }

    private void changedDescription() {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setDescription(this.descriptionText.getText());
    }

    private void changedSuccess() {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setSuccess(this.successText.getText());
    }

    private void changedDelegatedTo() {
        if (this.updating || this.action == null) {
            return;
        }
        if (this.action.isStateDelegated()) {
            this.stateDelegated = (ActionStateDelegated)this.action.getState();
            this.stateDelegated.setTo(this.delegatedToText.getText());
        }
    }

    private void changedNotes() {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setNotes(this.notesEditorPane.getText());
    }

    private static String getText(String key) {
        return NbBundle.getMessage(ActionPanel.class, (String)key);
    }

    private ComboBoxModel getTimeComboBoxModel() {
        return new TimeComboBoxModel();
    }

    private ComboBoxModel getEnergyComboBoxModel() {
        return new EnergyComboBoxModel();
    }

    private ComboBoxModel getPriorityComboBoxModel() {
        return new PriorityComboBoxModel();
    }

    public void update(Observable obs, Object arg) {
        if (this.action == null) {
            return;
        }
        if (this.action.isStateScheduled()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ActionStateScheduled ass;
                    if (!ActionPanel.this.action.isStateScheduled()) {
                        return;
                    }
                    if (!ActionPanel.this.notesEditorPane.getText().equals(ActionPanel.this.action.getNotes())) {
                        ActionPanel.this.notesEditorPane.setText(ActionPanel.this.action.getNotes());
                    }
                    if (!ActionPanel.this.successText.equals(ActionPanel.this.action.getSuccess())) {
                        ActionPanel.this.successText.setText(ActionPanel.this.action.getSuccess());
                    }
                    if ((ass = (ActionStateScheduled)ActionPanel.this.action.getState()).getDate() == null) {
                        ActionPanel.this.scheduledHourSpinner.setValue((Object)new Integer(0));
                        ActionPanel.this.scheduledMinuteSpinner.setValue((Object)new Integer(0));
                        ActionPanel.this.durationHourSpinner.setValue((Object)new Integer(0));
                        ActionPanel.this.durationMinuteSpinner.setValue((Object)new Integer(0));
                    } else {
                        Calendar c = Calendar.getInstance();
                        c.setTime(ass.getDate());
                        ActionPanel.this.scheduledHourSpinner.setVal(c.get(11));
                        ActionPanel.this.scheduledMinuteSpinner.setVal(c.get(12));
                        ActionPanel.this.durationHourSpinner.setVal(ass.getDurationHours());
                        ActionPanel.this.durationMinuteSpinner.setVal(ass.getDurationMinutes());
                        ActionPanel.this.scheduledDateField.setDate(ass.getDate());
                    }
                }
            });
        }
    }

    private void addListeners() {
        this.docListenerDescription = new LazyDocumentListener(){

            public void update() {
                ActionPanel.this.changedDescription();
            }
        };
        this.descriptionText.getDocument().addDocumentListener(this.docListenerDescription);
        this.docListenerSuccess = new LazyDocumentListener(){

            public void update() {
                ActionPanel.this.changedSuccess();
            }
        };
        this.successText.getDocument().addDocumentListener(this.docListenerSuccess);
        this.docListenerDelegatedTo = new LazyDocumentListener(){

            public void update() {
                ActionPanel.this.changedDelegatedTo();
            }
        };
        this.delegatedToText.getDocument().addDocumentListener(this.docListenerDelegatedTo);
        this.docListenerNotes = new LazyDocumentListener(){

            public void update() {
                ActionPanel.this.changedNotes();
            }
        };
        this.notesEditorPane.addDocumentListener(this.docListenerNotes);
        this.focusAdapterDescription = new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ActionPanel.this.descriptionTextFocusGained(evt);
            }
        };
        this.descriptionText.addFocusListener(this.focusAdapterDescription);
        this.actionListenerTopic = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.changedTopic(evt);
            }
        };
        this.topicCombo.addActionListener(this.actionListenerTopic);
        this.actionListenerContext = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.changedContext(evt);
            }
        };
        this.contextsCombo.addActionListener(this.actionListenerContext);
        this.scheduledDatePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ActionPanel.this.changedScheduledDate((Date)e.getNewValue());
            }
        };
        this.scheduledDateField.addPropertyChangeListener("value", this.scheduledDatePropertyChangeListener);
        this.changeListenerScheduledHour = new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ActionPanel.this.changedScheduledHour();
            }
        };
        this.scheduledHourSpinner.addChangeListener(this.changeListenerScheduledHour);
        this.changeListenerScheduledMinute = new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ActionPanel.this.changedScheduledMinute();
            }
        };
        this.scheduledMinuteSpinner.addChangeListener(this.changeListenerScheduledMinute);
        this.changeListenerDurationHour = new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ActionPanel.this.changedDurationHours();
            }
        };
        this.durationHourSpinner.addChangeListener(this.changeListenerDurationHour);
        this.changeListenerDurationMinute = new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ActionPanel.this.changedDurationMinutes();
            }
        };
        this.durationMinuteSpinner.addChangeListener(this.changeListenerDurationMinute);
        this.actionListenerRecurrence = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.recurrenceActionPerformed(evt);
            }
        };
        this.recurrenceButton.addActionListener(this.actionListenerRecurrence);
        this.actionListenerEmail = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.emailActionPerformed(evt);
            }
        };
        this.emailButton.addActionListener(this.actionListenerEmail);
        this.actionListenerStatusCombo = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.changedStatus(evt);
            }
        };
        this.statusCombo.addActionListener(this.actionListenerStatusCombo);
        this.actionListenerPriorityCombo = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.changedPriority();
            }
        };
        this.priorityCombo.addActionListener(this.actionListenerPriorityCombo);
        this.actionListenerEnergyCombo = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.changedEnergy();
            }
        };
        this.energyCombo.addActionListener(this.actionListenerEnergyCombo);
        this.actionListenerTimeCombo = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.changedTime();
            }
        };
        this.timeCombo.addActionListener(this.actionListenerTimeCombo);
        this.followupDatePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ActionPanel.this.changedFollowupDate((Date)e.getNewValue());
            }
        };
        this.followupDateField.addPropertyChangeListener("value", this.followupDatePropertyChangeListener);
        this.createdDatePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ActionPanel.this.changedCreatedDate((Date)e.getNewValue());
            }
        };
        this.createdDateField.addPropertyChangeListener("value", this.createdDatePropertyChangeListener);
        this.startDatePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ActionPanel.this.changedStartDate((Date)e.getNewValue());
            }
        };
        this.startDateField.addPropertyChangeListener("value", this.startDatePropertyChangeListener);
        this.dueDatePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ActionPanel.this.changedDueDate((Date)e.getNewValue());
            }
        };
        this.dueDateField.addPropertyChangeListener("value", this.dueDatePropertyChangeListener);
        this.doneCheckBoxActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ActionPanel.this.changedDone();
            }
        };
        this.doneCheckBox.addActionListener(this.doneCheckBoxActionListener);
        this.doneDatePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ActionPanel.this.changedDoneDate((Date)e.getNewValue());
            }
        };
        this.doneDateField.addPropertyChangeListener("value", this.doneDatePropertyChangeListener);
        this.notesHyperlinkListener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                ActionPanel.this.hyperlink(evt);
            }
        };
        this.notesEditorPane.addHyperlinkListener(this.notesHyperlinkListener);
    }

    private void removeListeners() {
        this.descriptionText.getDocument().removeDocumentListener(this.docListenerDescription);
        this.docListenerDescription = null;
        this.descriptionText.removeFocusListener(this.focusAdapterDescription);
        this.focusAdapterDescription = null;
        this.successText.getDocument().removeDocumentListener(this.docListenerSuccess);
        this.docListenerSuccess = null;
        this.contextsCombo.removeActionListener(this.actionListenerContext);
        this.actionListenerContext = null;
        this.topicCombo.removeActionListener(this.actionListenerTopic);
        this.actionListenerTopic = null;
        this.statusCombo.removeActionListener(this.actionListenerStatusCombo);
        this.actionListenerStatusCombo = null;
        this.scheduledDateField.removePropertyChangeListener(this.scheduledDatePropertyChangeListener);
        this.scheduledDatePropertyChangeListener = null;
        this.scheduledHourSpinner.removeChangeListener(this.changeListenerScheduledHour);
        this.changeListenerScheduledHour = null;
        this.scheduledMinuteSpinner.removeChangeListener(this.changeListenerScheduledMinute);
        this.changeListenerScheduledMinute = null;
        this.durationHourSpinner.removeChangeListener(this.changeListenerDurationHour);
        this.changeListenerDurationHour = null;
        this.durationMinuteSpinner.removeChangeListener(this.changeListenerDurationMinute);
        this.changeListenerDurationMinute = null;
        this.recurrenceButton.removeActionListener(this.actionListenerRecurrence);
        this.actionListenerRecurrence = null;
        this.delegatedToText.getDocument().removeDocumentListener(this.docListenerDelegatedTo);
        this.docListenerDelegatedTo = null;
        this.emailButton.removeActionListener(this.actionListenerEmail);
        this.actionListenerEmail = null;
        this.followupDateField.removePropertyChangeListener(this.followupDatePropertyChangeListener);
        this.followupDatePropertyChangeListener = null;
        this.timeCombo.removeActionListener(this.actionListenerTimeCombo);
        this.actionListenerTimeCombo = null;
        this.energyCombo.removeActionListener(this.actionListenerEnergyCombo);
        this.actionListenerEnergyCombo = null;
        this.priorityCombo.removeActionListener(this.actionListenerPriorityCombo);
        this.actionListenerPriorityCombo = null;
        this.notesEditorPane.removeDocumentListener(this.docListenerNotes);
        this.docListenerNotes = null;
        this.notesEditorPane.removeHyperlinkListener(this.notesHyperlinkListener);
        this.notesHyperlinkListener = null;
        this.createdDateField.removePropertyChangeListener(this.createdDatePropertyChangeListener);
        this.createdDatePropertyChangeListener = null;
        this.startDateField.removePropertyChangeListener(this.startDatePropertyChangeListener);
        this.startDatePropertyChangeListener = null;
        this.dueDateField.removePropertyChangeListener(this.dueDatePropertyChangeListener);
        this.dueDatePropertyChangeListener = null;
        this.doneCheckBox.removeActionListener(this.doneCheckBoxActionListener);
        this.doneCheckBoxActionListener = null;
        this.doneDateField.removePropertyChangeListener(this.doneDatePropertyChangeListener);
        this.doneDatePropertyChangeListener = null;
    }

    private void initComponents() {
        this.descriptionLabel = new JLabel();
        this.descriptionText = new JTextField();
        this.thoughtLabel = new JLabel();
        this.thoughtText = new JTextField();
        this.successLabel = new JLabel();
        this.successScrollPane = new JScrollPane();
        this.successText = new TextArea();
        this.contextLabel = new JLabel();
        this.contextsModel = new ContextsComboBoxModel(false);
        this.contextsCombo = new ContextsComboBox(this.contextsModel);
        this.topicLabel = new JLabel();
        this.topicsModel = new TopicsComboBoxModel(false);
        this.topicCombo = new TopicsComboBox(this.topicsModel);
        this.statusLabel = new JLabel();
        this.statusCombo = new JComboBox();
        this.scheduledPanel = new JPanel();
        this.scheduledLabel = new JLabel();
        this.scheduledHourSpinner = new HourSpinner();
        this.scheduledMinuteSpinner = new MinuteSpinner();
        this.durationLabel = new JLabel();
        this.durationHourSpinner = new HourSpinner();
        this.durationMinuteSpinner = new MinuteSpinner();
        this.recurrenceLabel = new JLabel();
        this.recurrenceButton = new JButton();
        this.scheduledDateField = new DateField();
        this.delegatedPanel = new JPanel();
        this.delegatedToLabel = new JLabel();
        this.delegatedToText = new JTextField();
        this.emailButton = new JButton();
        this.followupLabel = new JLabel();
        this.followupDateField = new DateField();
        this.criterionPanel = new JPanel();
        this.priorityLabel = new JLabel();
        this.energyLabel = new JLabel();
        this.energyCombo = new JComboBox();
        this.timeLabel = new JLabel();
        this.timeCombo = new JComboBox();
        this.priorityCombo = new JComboBox();
        this.notesLabel = new JLabel();
        this.notesEditorPane = new HyperEditorPane();
        this.createdDateLabel = new JLabel();
        this.startDateLabel = new JLabel();
        this.dueDateLabel = new JLabel();
        this.doneCheckBox = new JCheckBox();
        this.createdDateField = new DateField();
        this.startDateField = new DateField();
        this.dueDateField = new DateField();
        this.doneDateField = new DateField();
        this.descriptionLabel.setHorizontalAlignment(11);
        this.descriptionLabel.setText(ActionPanel.getText("LBL_Description"));
        this.descriptionLabel.setMaximumSize(new Dimension(96, 23));
        this.descriptionLabel.setMinimumSize(new Dimension(96, 23));
        this.descriptionLabel.setPreferredSize(new Dimension(96, 23));
        this.descriptionText.setMaximumSize(new Dimension(1024, 23));
        this.descriptionText.setMinimumSize(new Dimension(100, 23));
        this.descriptionText.setPreferredSize(new Dimension(200, 23));
        this.thoughtLabel.setHorizontalAlignment(11);
        this.thoughtLabel.setText(ActionPanel.getText("LBL_Thought"));
        this.thoughtLabel.setEnabled(false);
        this.thoughtLabel.setMaximumSize(new Dimension(96, 23));
        this.thoughtLabel.setMinimumSize(new Dimension(96, 23));
        this.thoughtLabel.setPreferredSize(new Dimension(96, 23));
        this.thoughtText.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.thoughtText.setText(NbBundle.getMessage(ActionPanel.class, (String)"ActionPanel.thoughtText.text"));
        this.thoughtText.setEnabled(false);
        this.thoughtText.setMaximumSize(new Dimension(1024, 23));
        this.thoughtText.setMinimumSize(new Dimension(100, 23));
        this.thoughtText.setPreferredSize(new Dimension(200, 23));
        this.successLabel.setHorizontalAlignment(11);
        this.successLabel.setText(NbBundle.getMessage(ActionPanel.class, (String)"ActionPanel.success"));
        this.successLabel.setMaximumSize(new Dimension(96, 23));
        this.successLabel.setMinimumSize(new Dimension(96, 23));
        this.successLabel.setPreferredSize(new Dimension(96, 23));
        this.successScrollPane.setMaximumSize(new Dimension(1024, 42));
        this.successScrollPane.setMinimumSize(new Dimension(100, 42));
        this.successScrollPane.setPreferredSize(new Dimension(200, 42));
        this.successText.setRows(2);
        this.successText.setMargin(new Insets(0, 4, 0, 0));
        this.successScrollPane.setViewportView((Component)this.successText);
        this.contextLabel.setHorizontalAlignment(11);
        this.contextLabel.setText(ActionPanel.getText("LBL_Context"));
        this.contextLabel.setMaximumSize(new Dimension(96, 23));
        this.contextLabel.setMinimumSize(new Dimension(96, 23));
        this.contextLabel.setPreferredSize(new Dimension(96, 23));
        this.contextsCombo.setMaximumSize(new Dimension(250, 23));
        this.contextsCombo.setMinimumSize(new Dimension(250, 23));
        this.contextsCombo.setPreferredSize(new Dimension(250, 23));
        this.contextsCombo.setMaximumRowCount(30);
        this.topicLabel.setHorizontalAlignment(11);
        this.topicLabel.setText(ActionPanel.getText("LBL_Topic"));
        this.topicCombo.setMaximumSize(new Dimension(250, 23));
        this.topicCombo.setMinimumSize(new Dimension(250, 23));
        this.topicCombo.setPreferredSize(new Dimension(250, 23));
        this.statusLabel.setHorizontalAlignment(11);
        this.statusLabel.setText(ActionPanel.getText("LBL_Status"));
        this.statusLabel.setMaximumSize(new Dimension(96, 23));
        this.statusLabel.setMinimumSize(new Dimension(96, 23));
        this.statusLabel.setPreferredSize(new Dimension(96, 23));
        this.statusCombo.setModel(new StatusComboBoxModel());
        this.statusCombo.setMaximumSize(new Dimension(150, 23));
        this.statusCombo.setMinimumSize(new Dimension(150, 23));
        this.statusCombo.setPreferredSize(new Dimension(150, 23));
        this.scheduledPanel.setMaximumSize(new Dimension(720, 26));
        this.scheduledPanel.setMinimumSize(new Dimension(720, 26));
        this.scheduledPanel.setPreferredSize(new Dimension(720, 26));
        this.scheduledLabel.setHorizontalAlignment(11);
        this.scheduledLabel.setText(ActionPanel.getText("LBL_ScheduledFor"));
        this.scheduledLabel.setMaximumSize(new Dimension(96, 23));
        this.scheduledLabel.setMinimumSize(new Dimension(96, 23));
        this.scheduledLabel.setPreferredSize(new Dimension(96, 23));
        this.scheduledHourSpinner.setMaximumSize(new Dimension(46, 23));
        this.scheduledHourSpinner.setMinimumSize(new Dimension(46, 23));
        this.scheduledHourSpinner.setPreferredSize(new Dimension(46, 23));
        this.scheduledMinuteSpinner.setMaximumSize(new Dimension(46, 23));
        this.scheduledMinuteSpinner.setMinimumSize(new Dimension(46, 23));
        this.scheduledMinuteSpinner.setPreferredSize(new Dimension(46, 23));
        this.durationLabel.setHorizontalAlignment(11);
        this.durationLabel.setText(ActionPanel.getText("LBL_Duration"));
        this.durationLabel.setMaximumSize(new Dimension(55, 23));
        this.durationLabel.setMinimumSize(new Dimension(55, 23));
        this.durationLabel.setPreferredSize(new Dimension(55, 23));
        this.durationHourSpinner.setMaximumSize(new Dimension(46, 23));
        this.durationHourSpinner.setMinimumSize(new Dimension(46, 23));
        this.durationHourSpinner.setPreferredSize(new Dimension(46, 23));
        this.durationMinuteSpinner.setMaximumSize(new Dimension(46, 23));
        this.durationMinuteSpinner.setMinimumSize(new Dimension(46, 23));
        this.durationMinuteSpinner.setPreferredSize(new Dimension(46, 23));
        this.recurrenceLabel.setHorizontalAlignment(11);
        this.recurrenceLabel.setText(ActionPanel.getText("LBL_Recurrence"));
        this.recurrenceLabel.setMaximumSize(new Dimension(69, 23));
        this.recurrenceLabel.setMinimumSize(new Dimension(69, 23));
        this.recurrenceLabel.setPreferredSize(new Dimension(69, 23));
        this.recurrenceButton.setText(NbBundle.getMessage(ActionPanel.class, (String)"recurrence.create"));
        this.recurrenceButton.setMaximumSize(new Dimension(90, 26));
        this.recurrenceButton.setMinimumSize(new Dimension(90, 26));
        this.recurrenceButton.setPreferredSize(new Dimension(90, 26));
        this.scheduledDateField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.scheduledDateField.setMaximumSize(new Dimension(120, 23));
        this.scheduledDateField.setMinimumSize(new Dimension(120, 23));
        this.scheduledDateField.setPreferredSize(new Dimension(120, 23));
        GroupLayout scheduledPanelLayout = new GroupLayout((Container)this.scheduledPanel);
        this.scheduledPanel.setLayout((LayoutManager)scheduledPanelLayout);
        scheduledPanelLayout.setHorizontalGroup((GroupLayout.Group)scheduledPanelLayout.createParallelGroup(1).add((GroupLayout.Group)scheduledPanelLayout.createSequentialGroup().add((Component)this.scheduledLabel, -2, -1, -2).add(10, 10, 10).add((Component)this.scheduledDateField, -2, -1, -2).addPreferredGap(0).add((Component)this.scheduledHourSpinner, -2, -1, -2).add(1, 1, 1).add((Component)this.scheduledMinuteSpinner, -2, -1, -2).add(18, 18, 18).add((Component)this.durationLabel, -2, -1, -2).addPreferredGap(0).add((Component)this.durationHourSpinner, -2, -1, -2).add(1, 1, 1).add((Component)this.durationMinuteSpinner, -2, -1, -2).add(18, 18, 18).add((Component)this.recurrenceLabel, -2, -1, -2).addPreferredGap(0).add((Component)this.recurrenceButton, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        scheduledPanelLayout.setVerticalGroup((GroupLayout.Group)scheduledPanelLayout.createParallelGroup(1).add((GroupLayout.Group)scheduledPanelLayout.createSequentialGroup().add(0, 0, 0).add((GroupLayout.Group)scheduledPanelLayout.createParallelGroup(4).add((Component)this.scheduledLabel, -2, -1, -2).add((Component)this.scheduledDateField, -2, -1, -2).add((Component)this.scheduledHourSpinner, -2, -1, -2).add((Component)this.scheduledMinuteSpinner, -2, -1, -2).add((Component)this.durationLabel, -2, -1, -2).add((Component)this.durationHourSpinner, -2, -1, -2).add((Component)this.durationMinuteSpinner, -2, -1, -2).add((Component)this.recurrenceLabel, -2, -1, -2).add((Component)this.recurrenceButton, -2, -1, -2))));
        this.delegatedPanel.setMaximumSize(new Dimension(720, 26));
        this.delegatedPanel.setMinimumSize(new Dimension(720, 26));
        this.delegatedPanel.setPreferredSize(new Dimension(720, 26));
        this.delegatedToLabel.setHorizontalAlignment(11);
        this.delegatedToLabel.setText(ActionPanel.getText("LBL_DelegatedTo"));
        this.delegatedToLabel.setMaximumSize(new Dimension(96, 23));
        this.delegatedToLabel.setMinimumSize(new Dimension(96, 23));
        this.delegatedToLabel.setPreferredSize(new Dimension(96, 23));
        this.delegatedToText.setMaximumSize(new Dimension(210, 23));
        this.delegatedToText.setMinimumSize(new Dimension(210, 23));
        this.delegatedToText.setPreferredSize(new Dimension(210, 23));
        this.emailButton.setText(ActionPanel.getText("LBL_Email"));
        this.emailButton.setMaximumSize(new Dimension(80, 26));
        this.emailButton.setMinimumSize(new Dimension(80, 26));
        this.emailButton.setPreferredSize(new Dimension(80, 26));
        this.followupLabel.setHorizontalAlignment(11);
        this.followupLabel.setText(ActionPanel.getText("LBL_FollowUp"));
        this.followupLabel.setMaximumSize(new Dimension(70, 23));
        this.followupLabel.setMinimumSize(new Dimension(70, 23));
        this.followupLabel.setPreferredSize(new Dimension(70, 23));
        this.followupDateField.setMaximumSize(new Dimension(110, 23));
        this.followupDateField.setMinimumSize(new Dimension(110, 23));
        this.followupDateField.setPreferredSize(new Dimension(110, 23));
        GroupLayout delegatedPanelLayout = new GroupLayout((Container)this.delegatedPanel);
        this.delegatedPanel.setLayout((LayoutManager)delegatedPanelLayout);
        delegatedPanelLayout.setHorizontalGroup((GroupLayout.Group)delegatedPanelLayout.createParallelGroup(1).add((GroupLayout.Group)delegatedPanelLayout.createSequentialGroup().add((Component)this.delegatedToLabel, -2, -1, -2).addPreferredGap(0).add((Component)this.delegatedToText, -2, 206, -2).addPreferredGap(0).add((Component)this.emailButton, -2, -1, -2).addPreferredGap(0).add((Component)this.followupLabel, -2, -1, -2).addPreferredGap(0).add((Component)this.followupDateField, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        delegatedPanelLayout.setVerticalGroup((GroupLayout.Group)delegatedPanelLayout.createParallelGroup(1).add((GroupLayout.Group)delegatedPanelLayout.createSequentialGroup().add(0, 0, 0).add((GroupLayout.Group)delegatedPanelLayout.createParallelGroup(1).add((Component)this.delegatedToText, -2, -1, -2).add((Component)this.delegatedToLabel, -2, -1, -2).add((Component)this.emailButton, -2, -1, -2).add((Component)this.followupLabel, -2, -1, -2).add((Component)this.followupDateField, -2, -1, -2)).addContainerGap()));
        this.priorityLabel.setHorizontalAlignment(11);
        this.priorityLabel.setText(ActionPanel.getText("LBL_Priority"));
        this.priorityLabel.setFocusable(false);
        this.priorityLabel.setMaximumSize(new Dimension(59, 23));
        this.priorityLabel.setMinimumSize(new Dimension(59, 23));
        this.priorityLabel.setPreferredSize(new Dimension(59, 23));
        this.energyLabel.setHorizontalAlignment(11);
        this.energyLabel.setText(ActionPanel.getText("LBL_Energy"));
        this.energyLabel.setFocusable(false);
        this.energyLabel.setMaximumSize(new Dimension(59, 23));
        this.energyLabel.setMinimumSize(new Dimension(59, 23));
        this.energyLabel.setPreferredSize(new Dimension(59, 23));
        this.energyCombo.setModel(this.getEnergyComboBoxModel());
        this.energyCombo.setMaximumSize(new Dimension(150, 23));
        this.energyCombo.setMinimumSize(new Dimension(150, 23));
        this.energyCombo.setPreferredSize(new Dimension(150, 23));
        this.timeLabel.setHorizontalAlignment(11);
        this.timeLabel.setText(ActionPanel.getText("LBL_SimpleTime"));
        this.timeLabel.setFocusable(false);
        this.timeLabel.setMaximumSize(new Dimension(59, 23));
        this.timeLabel.setMinimumSize(new Dimension(59, 23));
        this.timeLabel.setPreferredSize(new Dimension(59, 23));
        this.timeCombo.setModel(this.getTimeComboBoxModel());
        this.timeCombo.setMaximumSize(new Dimension(150, 23));
        this.timeCombo.setMinimumSize(new Dimension(150, 23));
        this.timeCombo.setPreferredSize(new Dimension(150, 23));
        this.priorityCombo.setModel(this.getPriorityComboBoxModel());
        this.priorityCombo.setMaximumSize(new Dimension(150, 23));
        this.priorityCombo.setMinimumSize(new Dimension(150, 23));
        this.priorityCombo.setPreferredSize(new Dimension(150, 23));
        GroupLayout criterionPanelLayout = new GroupLayout((Container)this.criterionPanel);
        this.criterionPanel.setLayout((LayoutManager)criterionPanelLayout);
        criterionPanelLayout.setHorizontalGroup((GroupLayout.Group)criterionPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)criterionPanelLayout.createSequentialGroup().add((Component)this.timeLabel, -2, 99, -2).addPreferredGap(0).add((Component)this.timeCombo, -2, -1, -2).add(0, 0, 0).add((Component)this.energyLabel, -2, -1, -2).addPreferredGap(0).add((Component)this.energyCombo, -2, -1, -2).add(0, 0, 0).add((Component)this.priorityLabel, -2, -1, -2).addPreferredGap(0).add((Component)this.priorityCombo, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        criterionPanelLayout.linkSize(new Component[]{this.energyLabel, this.priorityLabel}, 1);
        criterionPanelLayout.linkSize(new Component[]{this.energyCombo, this.priorityCombo, this.timeCombo}, 1);
        criterionPanelLayout.setVerticalGroup((GroupLayout.Group)criterionPanelLayout.createParallelGroup(1).add((GroupLayout.Group)criterionPanelLayout.createParallelGroup(3).add((Component)this.timeCombo, -2, -1, -2).add((Component)this.energyLabel, -2, -1, -2).add((Component)this.priorityLabel, -2, -1, -2).add((Component)this.priorityCombo, -2, -1, -2).add((Component)this.energyCombo, -2, -1, -2).add((Component)this.timeLabel, -2, -1, -2)));
        criterionPanelLayout.linkSize(new Component[]{this.energyCombo, this.priorityCombo, this.timeCombo}, 2);
        this.notesLabel.setHorizontalAlignment(11);
        this.notesLabel.setText(ActionPanel.getText("LBL_Notes"));
        this.notesLabel.setMaximumSize(new Dimension(98, 23));
        this.notesLabel.setMinimumSize(new Dimension(98, 23));
        this.notesLabel.setPreferredSize(new Dimension(98, 23));
        this.notesEditorPane.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        this.notesEditorPane.setMinimumSize(new Dimension(100, 23));
        this.createdDateLabel.setHorizontalAlignment(11);
        this.createdDateLabel.setText(ActionPanel.getText("LBL_Created"));
        this.createdDateLabel.setMaximumSize(new Dimension(96, 23));
        this.createdDateLabel.setMinimumSize(new Dimension(96, 23));
        this.createdDateLabel.setPreferredSize(new Dimension(96, 23));
        this.startDateLabel.setHorizontalAlignment(11);
        this.startDateLabel.setText(NbBundle.getMessage(ActionPanel.class, (String)"PanelAction.start"));
        this.dueDateLabel.setHorizontalAlignment(11);
        this.dueDateLabel.setText(NbBundle.getMessage(ActionPanel.class, (String)"PanelAction.due"));
        this.doneCheckBox.setText(ActionPanel.getText("LBL_Done"));
        this.doneCheckBox.setHorizontalTextPosition(10);
        this.doneCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.createdDateField.setMaximumSize(new Dimension(110, 23));
        this.createdDateField.setMinimumSize(new Dimension(110, 23));
        this.createdDateField.setPreferredSize(new Dimension(110, 23));
        this.startDateField.setMaximumSize(new Dimension(110, 23));
        this.startDateField.setMinimumSize(new Dimension(110, 23));
        this.startDateField.setPreferredSize(new Dimension(110, 23));
        this.dueDateField.setMaximumSize(new Dimension(110, 23));
        this.dueDateField.setMinimumSize(new Dimension(110, 23));
        this.dueDateField.setPreferredSize(new Dimension(110, 23));
        this.doneDateField.setMaximumSize(new Dimension(110, 23));
        this.doneDateField.setMinimumSize(new Dimension(110, 23));
        this.doneDateField.setPreferredSize(new Dimension(110, 23));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.createdDateLabel, -2, -1, -2).addPreferredGap(0).add((Component)this.createdDateField, -2, -1, -2).addPreferredGap(0).add((Component)this.startDateLabel).addPreferredGap(0).add((Component)this.startDateField, -2, -1, -2).addPreferredGap(0).add((Component)this.dueDateLabel).addPreferredGap(0).add((Component)this.dueDateField, -2, -1, -2).add(10, 10, 10).add((Component)this.doneCheckBox).addPreferredGap(0).add((Component)this.doneDateField, -2, -1, -2)).add(1, (Component)this.delegatedPanel, -2, 618, -2).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.notesLabel, -2, -1, -2).addPreferredGap(0).add((Component)this.notesEditorPane, -1, 776, Short.MAX_VALUE)).add(1, (Component)this.criterionPanel, -2, -1, -2).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.contextLabel, -1, -1, Short.MAX_VALUE).add((Component)this.statusLabel, -1, -1, Short.MAX_VALUE)).add((Component)this.successLabel, -2, -1, -2).add((Component)this.thoughtLabel, -1, -1, Short.MAX_VALUE).add((Component)this.descriptionLabel, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.statusCombo, -2, -1, -2).add((Component)this.descriptionText, -1, 776, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.successScrollPane, -2, 776, Short.MAX_VALUE).add(2, (Component)this.thoughtText, -1, 776, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.contextsCombo, -2, -1, -2).addPreferredGap(0).add((Component)this.topicLabel, -2, 44, -2).addPreferredGap(0).add((Component)this.topicCombo, -2, -1, -2).addPreferredGap(0, 222, Short.MAX_VALUE)))))).add(1, (Component)this.scheduledPanel, -2, 708, -2)).addPreferredGap(0))).addContainerGap()));
        layout.linkSize(new Component[]{this.descriptionLabel, this.successLabel, this.thoughtLabel}, 1);
        layout.linkSize(new Component[]{this.contextsCombo, this.topicCombo}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.descriptionLabel, -2, -1, -2).add((Component)this.descriptionText, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.thoughtLabel, -2, -1, -2).add((Component)this.thoughtText, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.successLabel, -2, -1, -2).add((Component)this.successScrollPane, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.contextLabel, -2, -1, -2).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.topicLabel, -2, 22, -2).add((Component)this.contextsCombo, -2, -1, -2)).add((Component)this.topicCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.statusLabel, -2, -1, -2).add((Component)this.statusCombo, -2, -1, -2)).add(4, 4, 4).add((Component)this.scheduledPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.delegatedPanel, -2, -1, -2).add(4, 4, 4).add((Component)this.criterionPanel, -2, 23, -2).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(26, 26, 26).add((Component)this.notesLabel, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add(2, 2, 2).add((Component)this.notesEditorPane, -1, 93, Short.MAX_VALUE))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.createdDateLabel, -2, -1, -2).add((Component)this.startDateLabel, -2, 22, -2).add((Component)this.dueDateLabel, -2, 22, -2).add((Component)this.doneCheckBox, -2, 22, -2)).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.startDateField, -2, -1, -2).add((Component)this.createdDateField, -2, -1, -2).add((Component)this.dueDateField, -2, -1, -2).add((Component)this.doneDateField, -2, -1, -2))).addContainerGap()));
        layout.linkSize(new Component[]{this.contextsCombo, this.topicCombo}, 2);
    }
}

