/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ObjectStreamException;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.IOEvent;
import org.netbeans.core.output2.NbIO;
import org.netbeans.core.output2.OutputTab;
import org.netbeans.core.output2.ui.AbstractOutputTab;
import org.netbeans.core.output2.ui.AbstractOutputWindow;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class OutputWindow
extends AbstractOutputWindow {
    private Controller controller;
    static OutputWindow DEFAULT = null;
    public static final String ICON_RESOURCE = "org/netbeans/core/resources/frames/output.png";
    private MouseListener activateListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent mouseEvent) {
            OutputWindow.this.requestActive();
        }
    };
    private boolean activated = false;
    private HashSet<OutputTab> hiddenTabs = null;

    public OutputWindow() {
        this(new Controller());
        this.enableEvents(4L);
        this.putClientProperty("dontActivate", Boolean.TRUE);
        this.getActionMap().put("PreviousViewAction", this.controller.prevTabAction);
        this.getActionMap().put("NextViewAction", this.controller.nextTabAction);
    }

    public void addNotify() {
        super.addNotify();
        this.pane.addMouseListener(this.activateListener);
    }

    public void removeNotify() {
        super.removeNotify();
        this.pane.removeMouseListener(this.activateListener);
    }

    protected void closeRequest(AbstractOutputTab abstractOutputTab) {
        this.controller.close(this, (OutputTab)abstractOutputTab, false);
    }

    OutputWindow(Controller controller) {
        if (Controller.LOG) {
            Controller.log("Created an output window");
        }
        this.controller = controller;
        this.setDisplayName(NbBundle.getMessage(OutputWindow.class, (String)"LBL_OUTPUT"));
        this.setName(NbBundle.getMessage(OutputWindow.class, (String)"LBL_OUTPUT"));
        this.setIcon(Utilities.loadImage((String)ICON_RESOURCE));
        this.putClientProperty("SlidingName", this.getDisplayName());
    }

    public static synchronized OutputWindow findDefault() {
        if (DEFAULT == null) {
            TopComponent topComponent = WindowManager.getDefault().findTopComponent("output");
            if (topComponent != null) {
                if (!(topComponent instanceof OutputWindow)) {
                    IllegalStateException illegalStateException = new IllegalStateException("Incorrect settings file. Unexpected class returned. Expected:" + OutputWindow.class.getName() + " Returned:" + topComponent.getClass().getName());
                    Logger.getLogger(OutputWindow.class.getName()).log(Level.WARNING, null, illegalStateException);
                    OutputWindow.getDefault();
                }
            } else {
                OutputWindow.getDefault();
            }
        }
        return DEFAULT;
    }

    public static synchronized OutputWindow getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new OutputWindow();
        }
        return DEFAULT;
    }

    public int getPersistenceType() {
        return 0;
    }

    public String preferredID() {
        return "output";
    }

    public Object readResolve() throws ObjectStreamException {
        return OutputWindow.getDefault();
    }

    public String getToolTipText() {
        return this.getDisplayName();
    }

    Controller getController() {
        return this.controller;
    }

    public void requestVisible() {
        if (Controller.LOG) {
            Controller.log("Request visible");
            Controller.logStack();
        }
        super.requestVisible();
    }

    void requestVisibleForNewTab() {
        if (Controller.LOG) {
            Controller.log("Request visible for new tab");
        }
        if (this.isOpened() && this.isShowing()) {
            if (!this.isActivated()) {
                super.requestVisible();
            }
        } else {
            if (Controller.LOG) {
                Controller.log("CALLING OPEN() ON OUTPUT WINDOW!");
            }
            this.open();
            super.requestVisible();
            if (Boolean.TRUE.equals(this.getClientProperty("isSliding"))) {
                this.requestActiveForNewTab();
            }
        }
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (Boolean.TRUE.equals(this.getClientProperty("isSliding"))) {
            this.repaint(200L);
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.hasFocus()) {
            Insets insets = this.getInsets();
            Color color = UIManager.getColor("controlShadow");
            if (color == null) {
                color = Color.GRAY;
            }
            graphics.setColor(color);
            graphics.drawRect(insets.left + 2, insets.top + 2, this.getWidth() - (insets.left + insets.right + 4), this.getHeight() - (insets.top + insets.bottom + 4));
        }
    }

    void requestActiveForNewTab() {
        this.requestActive();
    }

    public void requestActive() {
        boolean bl = this.isActivated();
        if (Controller.LOG) {
            Controller.log("Request active");
        }
        super.requestActive();
        if (!bl) {
            this.requestFocus();
        }
    }

    protected void componentActivated() {
        if (Controller.LOG) {
            Controller.log("ComponentActivated");
        }
        super.componentActivated();
        this.activated = true;
        this.controller.notifyActivated(this);
        this.requestFocus();
    }

    protected void componentDeactivated() {
        if (Controller.LOG) {
            Controller.log("ComponentDeactivated");
        }
        super.componentDeactivated();
        this.activated = false;
    }

    protected void removed(AbstractOutputTab abstractOutputTab) {
        if (Controller.LOG) {
            Controller.log("Removed tab " + abstractOutputTab);
        }
        if (Controller.LOG) {
            Controller.log("Tab has been removed.  Notifying controller.");
        }
        this.controller.notifyRemoved((OutputTab)abstractOutputTab);
    }

    protected void selectionChanged(AbstractOutputTab abstractOutputTab, AbstractOutputTab abstractOutputTab2) {
        this.controller.selectionChanged(this, (OutputTab)abstractOutputTab, (OutputTab)abstractOutputTab2);
    }

    void lineClicked(OutputTab outputTab, int n) {
        this.controller.lineClicked(this, outputTab, n);
    }

    void postPopupMenu(OutputTab outputTab, Point point, Component component) {
        this.controller.postPopupMenu(this, outputTab, point, component);
    }

    void caretEnteredLine(OutputTab outputTab, int n) {
        this.controller.caretEnteredLine(outputTab, n);
    }

    void documentChanged(OutputTab outputTab) {
        this.controller.documentChanged(this, outputTab);
    }

    void putHiddenView(OutputTab outputTab) {
        if (this.hiddenTabs == null) {
            this.hiddenTabs = new HashSet();
        }
        outputTab.putClientProperty("outputWindow", this);
        this.hiddenTabs.add(outputTab);
        if (outputTab.getParent() != null) {
            outputTab.getParent().remove(outputTab);
        }
    }

    void removeHiddenView(OutputTab outputTab) {
        this.hiddenTabs.remove(outputTab);
        outputTab.putClientProperty("outputWindow", null);
    }

    public void setSelectedTab(AbstractOutputTab abstractOutputTab) {
        if (abstractOutputTab.getParent() == null && this.hiddenTabs.contains(abstractOutputTab)) {
            this.removeHiddenView((OutputTab)abstractOutputTab);
            this.add(abstractOutputTab);
        }
        super.setSelectedTab(abstractOutputTab);
    }

    protected void updateSingletonName(String string) {
        String string2 = NbBundle.getMessage(OutputWindow.class, (String)"LBL_OUTPUT");
        if (string != null) {
            String string3 = NbBundle.getMessage(OutputWindow.class, (String)"FMT_OUTPUT", (Object[])new Object[]{string2, string});
            if (string3.indexOf("<html>") != -1) {
                string3 = Utilities.replaceString((String)string3, (String)"<html>", (String)"");
                this.setHtmlDisplayName("<html>" + string3);
            } else {
                this.setDisplayName(string3);
                this.setHtmlDisplayName(null);
            }
        } else {
            this.setDisplayName(string2);
            this.setHtmlDisplayName(null);
        }
    }

    OutputTab[] getHiddenTabs() {
        if (this.hiddenTabs != null && !this.hiddenTabs.isEmpty()) {
            OutputTab[] outputTabArray = new OutputTab[this.hiddenTabs.size()];
            return this.hiddenTabs.toArray(outputTabArray);
        }
        return new OutputTab[0];
    }

    OutputTab getTabForIO(NbIO nbIO) {
        AbstractOutputTab[] abstractOutputTabArray = this.getTabs();
        for (int i = 0; i < abstractOutputTabArray.length; ++i) {
            if (((OutputTab)abstractOutputTabArray[i]).getIO() != nbIO) continue;
            return (OutputTab)abstractOutputTabArray[i];
        }
        OutputTab[] outputTabArray = this.getHiddenTabs();
        for (int i = 0; i < outputTabArray.length; ++i) {
            if (outputTabArray[i].getIO() != nbIO) continue;
            return outputTabArray[i];
        }
        return null;
    }

    void eventDispatched(IOEvent iOEvent) {
        if (Controller.LOG) {
            Controller.log("Event received: " + iOEvent);
        }
        NbIO nbIO = iOEvent.getIO();
        int n = iOEvent.getCommand();
        boolean bl = iOEvent.getValue();
        Object object = iOEvent.getData();
        OutputTab outputTab = this.getTabForIO(nbIO);
        if (n == 11 && !iOEvent.isConsumed()) {
            iOEvent.consume();
            DEFAULT = null;
            return;
        }
        if (Controller.LOG) {
            Controller.log("Passing command to controller " + iOEvent);
        }
        this.controller.performCommand(this, outputTab, nbIO, n, bl, object);
        iOEvent.consume();
    }

    void hasSelectionChanged(OutputTab outputTab, boolean bl) {
        this.controller.hasSelectionChanged(this, outputTab, bl);
    }

    public boolean isActivated() {
        return this.activated;
    }

    void hasOutputListenersChanged(OutputTab outputTab, boolean bl) {
        this.controller.hasOutputListenersChanged(this, outputTab, bl);
    }

    void inputEof(OutputTab outputTab) {
        if (Controller.LOG) {
            Controller.log("Input EOF on " + this);
        }
        this.controller.inputEof(outputTab);
    }

    void inputSent(OutputTab outputTab, String string) {
        if (Controller.LOG) {
            Controller.log("Notifying controller input sent " + string);
        }
        this.controller.notifyInput(this, outputTab, string);
    }
}

