/*
 * Decompiled with CFR 0.152.
 */
package tr.extract;

import java.util.Collections;
import java.util.List;
import java.util.Vector;
import tr.extract.Extract;
import tr.extract.Param;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParamContext
extends Param {
    private final Extract.FormatType formatType;

    public ParamContext(String id, String display, Extract.FormatType formatType) {
        super(Param.Type.COMBOBOX, id, display);
        this.formatType = formatType;
    }

    @Override
    public List<Param.Item> getItems() {
        if (this.items == null) {
            this.initItems();
        }
        return this.items;
    }

    private void initItems() {
        this.items = new Vector();
        this.items.add(new Param.Item("All", "all"));
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        Vector contexts = data.getContextManager().list();
        Collections.sort(contexts);
        for (Context context : contexts) {
            String name = context.getName();
            name = this.formatType == Extract.FormatType.CSV ? "\"" + name.replace("\"", "\"\"") + "\"" : this.formatType.escape(name);
            this.items.add(new Param.Item(context.getName(), name));
        }
    }
}

