C      $Id: x17f.fm4,v 1.8 2006/05/27 22:02:53 hbabcock Exp $
C
C      Copyright (C) 2004  Alan W. Irwin
C
C      This file is part of PLplot.
C
C      PLplot is free software; you can redistribute it and/or modify
C      it under the terms of the GNU General Library Public License as
C      published by the Free Software Foundation; either version 2 of the
C      License, or (at your option) any later version.
C
C      PLplot is distributed in the hope that it will be useful,
C      but WITHOUT ANY WARRANTY; without even the implied warranty of
C      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C      GNU Library General Public License for more details.
C
C      You should have received a copy of the GNU Library General Public
C      License along with PLplot; if not, write to the Free Software
C      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA


C--------------------------------------------------------------------------
C      main program
C--------------------------------------------------------------------------

      program x17f
      implicit none
      integer id1, n, autoy, acc, nsteps
      parameter ( nsteps = 1000 )
      real*8 y1, y2, y3, y4, ymin, ymax, xlab, ylab
      real*8 t, tmin, tmax, tjump, dt, noise
      integer colbox, collab, colline(4), styline(4)
      character*20 legline(4)

      real*8 PI
      parameter ( PI = 3.1415926535897932384d0 )

      logical      errcode
      character*80 errmsg

      integer PL_PARSE_FULL
      parameter(PL_PARSE_FULL = 1)

C      some fortran compilers demand typing of intrinsic rand, and
C      although this is not demanded on g77 it also works there.
C      n.b. real*4 will be left alone by double2single.sed script.
      real*4 rand

C      Process command-line arguments
      call plparseopts(PL_PARSE_FULL)

C      plplot initialization

C      If db is used the plot is much more smooth. However, because of the
C      async X behaviour, one does not have a real-time scripcharter.
C
      call plsetopt('db', '')
      call plsetopt('np', '')

C      User sets up plot completely except for window and data
C      Eventually settings in place when strip chart is created will be
C      remembered so that multiple strip charts can be used simultaneously.


C      Specify some reasonable defaults for ymin and ymax
C      The plot will grow automatically if needed (but not shrink)

      ymin = -0.1d0
      ymax = 0.1d0

C      Specify initial tmin and tmax -- this determines length of window.
C      Also specify maximum jump in t
C      This can accomodate adaptive timesteps

      tmin = 0.d0
      tmax = 10.d0
C      percentage of plot to jump
      tjump = 0.3d0

C      Axes options same as plbox.
C      Only automatic tick generation and label placement allowed
C      Eventually I'll make this fancier

      colbox = 1
      collab = 3
C      pens color and line style
      styline(1) = 2
      colline(1) = 2
      styline(2) = 3
      colline(2) = 3
      styline(3) = 4
      colline(3) = 4
      styline(4) = 5
      colline(4) = 5

C      pens legend
      legline(1) = 'sum'
      legline(2) = 'sin'
      legline(3) = 'sin*noi'
      legline(4) = 'sin+noi'

C      legend position
      xlab = 0.d0
      ylab = 0.25d0

C      autoscale y
      autoy = 1
C      don't scrip, accumulate
      acc = 1

C      Initialize plplot

      call plinit()

      call pladv(0)
      call plvsta()

C      Register our error variables with PLplot
C      From here on, we're handling all errors here

C      TODO: call plsError(&errcode, errmsg)

      call plstripc(id1, 'bcnst', 'bcnstv',
     &  tmin, tmax, tjump, ymin, ymax,
     &  xlab, ylab,
     &  autoy, acc,
     &  colbox, collab,
     &  colline, styline, legline,
     &  't', ' ', 'Strip chart demo')

      errcode = .false.
      if ( errcode ) then
        write(*,*) errmsg
        stop
      endif

C      Let plplot handle errors from here on

C      TODO: call plsError(NULL, NULL)

C      autoscale y
      autoy = 0
C      accumulate
      acc = 1

C      This is to represent a loop over time
C      Let's try a random walk process

      y1 = 0.0d0
      y2 = 0.0d0
      y3 = 0.0d0
      y4 = 0.0d0
      dt = 0.1d0
C      start random number generator.
C      (This use of rand should work for g77 and Solaris and ?)
      noise = rand(1)

      do n = 1,nsteps
C        wait a little (10 ms) to simulate time elapsing.
C        g77 sleep has resolution of 1 sec so the call below is commented out
C        because it is like watching paint dry.  In any case,
C        I like the resulting speedier output when
C        you drop sleep altogether from this loop.
!        call sleep(1)

        t = dble(n) * dt
C        (This use of rand should work for g77 and Solaris and ?)
        noise = rand(0) - 0.5d0
        y1 = y1 + noise
        y2 = sin(t*PI/18.d0)
        y3 = y2 * noise
        y4 = y2 + noise/3.d0

C        There is no need for all pens to have the same number of
C        points or beeing equally time spaced.

        if ( mod(n,2) .ne. 0 ) then
          call plstripa(id1, 0, t, y1)
        endif
        if ( mod(n,3) .ne. 0 ) then
          call plstripa(id1, 1, t, y2)
        endif
        if ( mod(n,4) .ne. 0 ) then
          call plstripa(id1, 2, t, y3)
        endif
        if ( mod(n,5) .ne. 0 ) then
          call plstripa(id1, 3, t, y4)
        endif
C        use double buffer (-db on command line)
        call pleop()
      enddo

C      Destroy strip chart and it's memory

      call plstripd(id1)
      call plend()
      end
