/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.DToA;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativeWith;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;

public class ScriptRuntime {
    public static final Class BooleanClass = Kit.classOrNull("java.lang.Boolean");
    public static final Class ByteClass = Kit.classOrNull("java.lang.Byte");
    public static final Class CharacterClass = Kit.classOrNull("java.lang.Character");
    public static final Class ClassClass = Kit.classOrNull("java.lang.Class");
    public static final Class DoubleClass = Kit.classOrNull("java.lang.Double");
    public static final Class FloatClass = Kit.classOrNull("java.lang.Float");
    public static final Class IntegerClass = Kit.classOrNull("java.lang.Integer");
    public static final Class LongClass = Kit.classOrNull("java.lang.Long");
    public static final Class NumberClass = Kit.classOrNull("java.lang.Number");
    public static final Class ObjectClass = Kit.classOrNull("java.lang.Object");
    public static final Class ShortClass = Kit.classOrNull("java.lang.Short");
    public static final Class StringClass = Kit.classOrNull("java.lang.String");
    public static final Class SerializableClass = Kit.classOrNull("java.io.Serializable");
    public static final Class DateClass = Kit.classOrNull("java.util.Date");
    public static final Class ContextClass = Kit.classOrNull("org.mozilla.javascript.Context");
    public static final Class FunctionClass = Kit.classOrNull("org.mozilla.javascript.Function");
    public static final Class ScriptableClass = Kit.classOrNull("org.mozilla.javascript.Scriptable");
    public static final Class ScriptableObjectClass = Kit.classOrNull("org.mozilla.javascript.ScriptableObject");
    public static final Class UndefinedClass = Kit.classOrNull("org.mozilla.javascript.Undefined");
    public static final double NaN = Double.longBitsToDouble(9221120237041090560L);
    public static final double negativeZero = Double.longBitsToDouble(Long.MIN_VALUE);
    public static final Double NaNobj = new Double(NaN);
    private static final boolean MSJVM_BUG_WORKAROUNDS = true;
    public static final Object[] emptyArgs = new Object[0];
    public static final String[] emptyStrings = new String[0];

    protected ScriptRuntime() {
    }

    public static boolean toBoolean(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Scriptable) {
            if (Context.getContext().isVersionECMA1()) {
                return object != Undefined.instance;
            }
            if ((object = ((Scriptable)object).getDefaultValue(BooleanClass)) instanceof Scriptable) {
                throw ScriptRuntime.errorWithClassName("msg.primitive.expected", object);
            }
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
        }
        if (object instanceof String) {
            return ((String)object).length() != 0;
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            return d == d && d != 0.0;
        }
        throw ScriptRuntime.errorWithClassName("msg.invalid.type", object);
    }

    public static boolean toBoolean(Object[] objectArray, int n) {
        return n < objectArray.length ? ScriptRuntime.toBoolean(objectArray[n]) : false;
    }

    public static double toNumber(Object object) {
        if (object == null) {
            return 0.0;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof Scriptable) {
            if ((object = ((Scriptable)object).getDefaultValue(NumberClass)) != null && object instanceof Scriptable) {
                throw ScriptRuntime.errorWithClassName("msg.primitive.expected", object);
            }
            if (object instanceof Number) {
                return ((Number)object).doubleValue();
            }
        }
        if (object instanceof String) {
            return ScriptRuntime.toNumber((String)object);
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        throw ScriptRuntime.errorWithClassName("msg.invalid.type", object);
    }

    public static double toNumber(Object[] objectArray, int n) {
        return n < objectArray.length ? ScriptRuntime.toNumber(objectArray[n]) : NaN;
    }

    static double stringToNumber(String string, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = 57;
        int n7 = 97;
        int n8 = 65;
        int n9 = string.length();
        if (n2 < 10) {
            n6 = (char)(48 + n2 - 1);
        }
        if (n2 > 10) {
            n7 = (char)(97 + n2 - 10);
            n8 = (char)(65 + n2 - 10);
        }
        double d = 0.0;
        for (n5 = n; n5 < n9; ++n5) {
            n4 = string.charAt(n5);
            if (48 <= n4 && n4 <= n6) {
                n3 = n4 - 48;
            } else if (97 <= n4 && n4 < n7) {
                n3 = n4 - 97 + 10;
            } else {
                if (65 > n4 || n4 >= n8) break;
                n3 = n4 - 65 + 10;
            }
            d = d * (double)n2 + (double)n3;
        }
        if (n == n5) {
            return NaN;
        }
        if (d >= 9.007199254740992E15) {
            if (n2 == 10) {
                try {
                    return Double.valueOf(string.substring(n, n5));
                }
                catch (NumberFormatException numberFormatException) {
                    return NaN;
                }
            }
            if (n2 == 2 || n2 == 4 || n2 == 8 || n2 == 16 || n2 == 32) {
                n4 = 1;
                n3 = 0;
                int n10 = 0;
                int n11 = 53;
                double d2 = 0.0;
                boolean bl = false;
                boolean bl2 = false;
                while (true) {
                    if (n4 == 1) {
                        if (n == n5) break;
                        n3 = 48 <= (n3 = (int)string.charAt(n++)) && n3 <= 57 ? (n3 -= 48) : (97 <= n3 && n3 <= 122 ? (n3 -= 87) : (n3 -= 55));
                        n4 = n2;
                    }
                    boolean bl3 = (n3 & (n4 >>= 1)) != 0;
                    switch (n10) {
                        case 0: {
                            if (!bl3) break;
                            --n11;
                            d = 1.0;
                            n10 = 1;
                            break;
                        }
                        case 1: {
                            d *= 2.0;
                            if (bl3) {
                                d += 1.0;
                            }
                            if (--n11 != 0) break;
                            bl = bl3;
                            n10 = 2;
                            break;
                        }
                        case 2: {
                            bl2 = bl3;
                            d2 = 2.0;
                            n10 = 3;
                            break;
                        }
                        case 3: {
                            if (bl3) {
                                n10 = 4;
                            }
                        }
                        case 4: {
                            d2 *= 2.0;
                        }
                    }
                }
                switch (n10) {
                    case 0: {
                        d = 0.0;
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: {
                        if (bl2 & bl) {
                            d += 1.0;
                        }
                        d *= d2;
                        break;
                    }
                    case 4: {
                        if (bl2) {
                            d += 1.0;
                        }
                        d *= d2;
                    }
                }
            }
        }
        return d;
    }

    public static double toNumber(String string) {
        char c;
        int n;
        char c2;
        int n2 = string.length();
        int n3 = 0;
        while (true) {
            if (n3 == n2) {
                return 0.0;
            }
            c2 = string.charAt(n3);
            if (!Character.isWhitespace(c2)) break;
            ++n3;
        }
        if (c2 == '0') {
            if (n3 + 2 < n2 && ((n = (int)string.charAt(n3 + 1)) == 120 || n == 88)) {
                return ScriptRuntime.stringToNumber(string, n3 + 2, 16);
            }
        } else if (!(c2 != '+' && c2 != '-' || n3 + 3 >= n2 || string.charAt(n3 + 1) != '0' || (n = (int)string.charAt(n3 + 2)) != 120 && n != 88)) {
            double d = ScriptRuntime.stringToNumber(string, n3 + 3, 16);
            return c2 == '-' ? -d : d;
        }
        n = n2 - 1;
        while (Character.isWhitespace(c = string.charAt(n))) {
            --n;
        }
        if (c == 'y') {
            if (c2 == '+' || c2 == '-') {
                ++n3;
            }
            if (n3 + 7 == n && string.regionMatches(n3, "Infinity", 0, 8)) {
                return c2 == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            return NaN;
        }
        String string2 = string.substring(n3, n + 1);
        for (int i = string2.length() - 1; i >= 0; --i) {
            char c3 = string2.charAt(i);
            if ('0' <= c3 && c3 <= '9' || c3 == '.' || c3 == 'e' || c3 == 'E' || c3 == '+' || c3 == '-') continue;
            return NaN;
        }
        try {
            return Double.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return NaN;
        }
    }

    public static Object[] padArguments(Object[] objectArray, int n) {
        int n2;
        if (n < objectArray.length) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[n];
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            objectArray2[n2] = objectArray[n2];
        }
        while (n2 < n) {
            objectArray2[n2] = Undefined.instance;
            ++n2;
        }
        return objectArray2;
    }

    public static String escapeString(String string) {
        return ScriptRuntime.escapeString(string, '\"');
    }

    public static String escapeString(String string, char c) {
        if (c != '\"' && c != '\'') {
            Kit.codeBug();
        }
        StringBuffer stringBuffer = null;
        int n = string.length();
        for (int i = 0; i != n; ++i) {
            int n2;
            char c2 = string.charAt(i);
            if (' ' <= c2 && c2 <= '~' && c2 != c && c2 != '\\') {
                if (stringBuffer == null) continue;
                stringBuffer.append(c2);
                continue;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(n + 3);
                stringBuffer.append(string);
                stringBuffer.setLength(i);
            }
            int n3 = -1;
            switch (c2) {
                case '\b': {
                    n3 = 98;
                    break;
                }
                case '\f': {
                    n3 = 102;
                    break;
                }
                case '\n': {
                    n3 = 110;
                    break;
                }
                case '\r': {
                    n3 = 114;
                    break;
                }
                case '\t': {
                    n3 = 116;
                    break;
                }
                case '\u000b': {
                    n3 = 118;
                    break;
                }
                case ' ': {
                    n3 = 32;
                    break;
                }
                case '\\': {
                    n3 = 92;
                }
            }
            if (n3 >= 0) {
                stringBuffer.append('\\');
                stringBuffer.append((char)n3);
                continue;
            }
            if (c2 == c) {
                stringBuffer.append('\\');
                stringBuffer.append(c);
                continue;
            }
            if (c2 < '\u0100') {
                stringBuffer.append("\\x");
                n2 = 2;
            } else {
                stringBuffer.append("\\u");
                n2 = 4;
            }
            for (int j = (n2 - 1) * 4; j >= 0; j -= 4) {
                int n4 = 0xF & c2 >> j;
                int n5 = n4 < 10 ? 48 + n4 : 87 + n4;
                stringBuffer.append((char)n5);
            }
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    static boolean isValidIdentifierName(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i != n; ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String toString(Object object) {
        block3: {
            do {
                if (object == null) {
                    return "null";
                }
                if (!(object instanceof Scriptable)) break block3;
            } while ((object = ((Scriptable)object).getDefaultValue(StringClass)) == Undefined.instance || !(object instanceof Scriptable));
            throw ScriptRuntime.errorWithClassName("msg.primitive.expected", object);
        }
        if (object instanceof Number) {
            return ScriptRuntime.numberToString(((Number)object).doubleValue(), 10);
        }
        return object.toString();
    }

    public static String toString(Object[] objectArray, int n) {
        return n < objectArray.length ? ScriptRuntime.toString(objectArray[n]) : "undefined";
    }

    public static String toString(double d) {
        return ScriptRuntime.numberToString(d, 10);
    }

    public static String numberToString(double d, int n) {
        if (d != d) {
            return "NaN";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        if (d == 0.0) {
            return "0";
        }
        if (n < 2 || n > 36) {
            throw Context.reportRuntimeError1("msg.bad.radix", Integer.toString(n));
        }
        if (n != 10) {
            return DToA.JS_dtobasestr(n, d);
        }
        StringBuffer stringBuffer = new StringBuffer();
        DToA.JS_dtostr(stringBuffer, 0, 0, d);
        return stringBuffer.toString();
    }

    static String uneval(Context context, Scriptable scriptable, Object object) throws JavaScriptException {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            String string = ScriptRuntime.escapeString((String)object);
            StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
            stringBuffer.append('\"');
            stringBuffer.append(string);
            stringBuffer.append('\"');
            return stringBuffer.toString();
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (d == 0.0 && 1.0 / d < 0.0) {
                return "-0";
            }
            return ScriptRuntime.toString(d);
        }
        if (object instanceof Boolean) {
            return ScriptRuntime.toString(object);
        }
        if (object == Undefined.instance) {
            return "undefined";
        }
        if (object instanceof Scriptable) {
            Scriptable scriptable2 = (Scriptable)object;
            Object object2 = ScriptableObject.getProperty(scriptable2, "toSource");
            if (object2 instanceof Function) {
                Function function = (Function)object2;
                return ScriptRuntime.toString(function.call(context, scriptable, scriptable2, emptyArgs));
            }
            return ScriptRuntime.toString(object);
        }
        throw ScriptRuntime.errorWithClassName("msg.invalid.type", object);
    }

    public static Scriptable toObject(Scriptable scriptable, Object object) {
        if (object instanceof Scriptable && object != Undefined.instance) {
            return (Scriptable)object;
        }
        return ScriptRuntime.toObject(Context.getContext(), scriptable, object);
    }

    public static Scriptable toObject(Scriptable scriptable, Object object, Class clazz) {
        return ScriptRuntime.toObject(scriptable, object);
    }

    public static Scriptable toObject(Context context, Scriptable scriptable, Object object) {
        String string;
        if (object instanceof Scriptable) {
            if (object == Undefined.instance) {
                throw ScriptRuntime.typeError0("msg.undef.to.object");
            }
            return (Scriptable)object;
        }
        String string2 = object instanceof String ? "String" : (object instanceof Number ? "Number" : (string = object instanceof Boolean ? "Boolean" : null));
        if (string != null) {
            Object[] objectArray = new Object[]{object};
            scriptable = ScriptableObject.getTopLevelScope(scriptable);
            return ScriptRuntime.newObject(context, scriptable, string, objectArray);
        }
        Object object2 = context.getWrapFactory().wrap(context, scriptable, object, null);
        if (object2 instanceof Scriptable) {
            return (Scriptable)object2;
        }
        if (object2 == null) {
            throw ScriptRuntime.typeError0("msg.null.to.object");
        }
        throw ScriptRuntime.errorWithClassName("msg.invalid.type", object);
    }

    public static Scriptable toObject(Context context, Scriptable scriptable, Object object, Class clazz) {
        return ScriptRuntime.toObject(context, scriptable, object);
    }

    public static Scriptable newObject(Context context, Scriptable scriptable, String string, Object[] objectArray) {
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        Function function = ScriptRuntime.getExistingCtor(context, scriptable, string);
        try {
            if (objectArray == null) {
                objectArray = emptyArgs;
            }
            return function.construct(context, scriptable, objectArray);
        }
        catch (JavaScriptException javaScriptException) {
            throw Context.reportRuntimeError(javaScriptException.getMessage());
        }
    }

    public static double toInteger(Object object) {
        return ScriptRuntime.toInteger(ScriptRuntime.toNumber(object));
    }

    public static double toInteger(double d) {
        if (d != d) {
            return 0.0;
        }
        if (d == 0.0 || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return d;
        }
        if (d > 0.0) {
            return Math.floor(d);
        }
        return Math.ceil(d);
    }

    public static double toInteger(Object[] objectArray, int n) {
        return n < objectArray.length ? ScriptRuntime.toInteger(objectArray[n]) : 0.0;
    }

    public static int toInt32(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return ScriptRuntime.toInt32(ScriptRuntime.toNumber(object));
    }

    public static int toInt32(Object[] objectArray, int n) {
        return n < objectArray.length ? ScriptRuntime.toInt32(objectArray[n]) : 0;
    }

    public static int toInt32(double d) {
        int n = (int)d;
        if ((double)n == d) {
            return n;
        }
        if (d != d || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return 0;
        }
        d = d >= 0.0 ? Math.floor(d) : Math.ceil(d);
        double d2 = 4.294967296E9;
        d = Math.IEEEremainder(d, d2);
        long l = (long)d;
        return (int)l;
    }

    public static long toUint32(double d) {
        long l = (long)d;
        if ((double)l == d) {
            return l & 0xFFFFFFFFL;
        }
        if (d != d || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return 0L;
        }
        d = d >= 0.0 ? Math.floor(d) : Math.ceil(d);
        double d2 = 4.294967296E9;
        l = (long)Math.IEEEremainder(d, d2);
        return l & 0xFFFFFFFFL;
    }

    public static long toUint32(Object object) {
        return ScriptRuntime.toUint32(ScriptRuntime.toNumber(object));
    }

    public static char toUint16(Object object) {
        double d = ScriptRuntime.toNumber(object);
        int n = (int)d;
        if ((double)n == d) {
            return (char)n;
        }
        if (d != d || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return '\u0000';
        }
        d = d >= 0.0 ? Math.floor(d) : Math.ceil(d);
        int n2 = 65536;
        n = (int)Math.IEEEremainder(d, n2);
        return (char)n;
    }

    public static Object getCatchObject(Context context, Scriptable scriptable, Throwable throwable) throws JavaScriptException {
        String string;
        String string2;
        EvaluatorException evaluatorException = null;
        if (throwable instanceof EvaluatorException) {
            evaluatorException = (EvaluatorException)throwable;
            while (throwable instanceof WrappedException) {
                throwable = ((WrappedException)throwable).getWrappedException();
            }
        }
        if (throwable instanceof JavaScriptException) {
            return ((JavaScriptException)throwable).getValue();
        }
        if (throwable instanceof EcmaError) {
            EcmaError ecmaError = (EcmaError)throwable;
            String string3 = ecmaError.getName();
            return ScriptRuntime.makeErrorObject(context, scriptable, string3, ecmaError.getMessage(), ecmaError.getSourceName(), ecmaError.getLineNumber());
        }
        if (evaluatorException == null) {
            Kit.codeBug();
        }
        if (throwable != evaluatorException && throwable instanceof EvaluatorException) {
            evaluatorException = (EvaluatorException)throwable;
        }
        if (throwable == evaluatorException) {
            if (evaluatorException instanceof WrappedException) {
                Kit.codeBug();
            }
            string2 = evaluatorException.getMessage();
            string = "InternalError";
        } else {
            string = "JavaException";
            string2 = throwable.getClass().getName() + ": " + throwable.getMessage();
        }
        Scriptable scriptable2 = ScriptRuntime.makeErrorObject(context, scriptable, string, string2, evaluatorException.getSourceName(), evaluatorException.getLineNumber());
        if (throwable != evaluatorException) {
            Object object = context.getWrapFactory().wrap(context, scriptable, throwable, null);
            ScriptableObject.putProperty(scriptable2, "javaException", object);
        }
        return scriptable2;
    }

    private static Scriptable makeErrorObject(Context context, Scriptable scriptable, String string, String string2, String string3, int n) throws JavaScriptException {
        int n2 = n > 0 ? 3 : 2;
        Object[] objectArray = new Object[n2];
        objectArray[0] = string2;
        Object object = objectArray[1] = string3 != null ? string3 : "";
        if (n > 0) {
            objectArray[2] = new Integer(n);
        }
        Scriptable scriptable2 = context.newObject(scriptable, string, objectArray);
        ScriptableObject.putProperty(scriptable2, "name", (Object)string);
        return scriptable2;
    }

    public static Object getProp(Object object, String string, Scriptable scriptable) {
        if (object == null || object == Undefined.instance) {
            throw ScriptRuntime.undefReadError(object, string);
        }
        Scriptable scriptable2 = object instanceof Scriptable ? (Scriptable)object : ScriptRuntime.toObject(scriptable, object);
        Object object2 = ScriptableObject.getProperty(scriptable2, string);
        if (object2 != Scriptable.NOT_FOUND) {
            return object2;
        }
        return Undefined.instance;
    }

    public static Object getTopLevelProp(Scriptable scriptable, String string) {
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        return ScriptableObject.getProperty(scriptable, string);
    }

    static Function getExistingCtor(Context context, Scriptable scriptable, String string) {
        Object object = ScriptableObject.getProperty(scriptable, string);
        if (object instanceof Function) {
            return (Function)object;
        }
        if (object == Scriptable.NOT_FOUND) {
            throw Context.reportRuntimeError1("msg.ctor.not.found", string);
        }
        throw Context.reportRuntimeError1("msg.not.ctor", string);
    }

    public static Scriptable getProto(Object object, Scriptable scriptable) {
        Scriptable scriptable2 = object instanceof Scriptable ? (Scriptable)object : ScriptRuntime.toObject(scriptable, object);
        if (scriptable2 == null) {
            throw ScriptRuntime.typeError0("msg.null.to.object");
        }
        return scriptable2.getPrototype();
    }

    public static Scriptable getParent(Object object) {
        if (!(object instanceof Scriptable)) {
            return null;
        }
        Scriptable scriptable = (Scriptable)object;
        return ScriptRuntime.getThis(scriptable.getParentScope());
    }

    public static Scriptable getParent(Object object, Scriptable scriptable) {
        Scriptable scriptable2 = object instanceof Scriptable ? (Scriptable)object : ScriptRuntime.toObject(scriptable, object);
        if (scriptable2 == null) {
            throw ScriptRuntime.typeError0("msg.null.to.object");
        }
        return scriptable2.getParentScope();
    }

    public static Object setProto(Object object, Object object2, Scriptable scriptable) {
        Scriptable scriptable2;
        Scriptable scriptable3 = ScriptRuntime.toObject(scriptable, object);
        for (Scriptable scriptable4 = scriptable2 = object2 == null ? null : ScriptRuntime.toObject(scriptable, object2); scriptable4 != null; scriptable4 = scriptable4.getPrototype()) {
            if (scriptable4 != scriptable3) continue;
            throw Context.reportRuntimeError1("msg.cyclic.value", "__proto__");
        }
        scriptable3.setPrototype(scriptable2);
        return scriptable2;
    }

    public static Object setParent(Object object, Object object2, Scriptable scriptable) {
        Scriptable scriptable2;
        Scriptable scriptable3 = ScriptRuntime.toObject(scriptable, object);
        for (Scriptable scriptable4 = scriptable2 = object2 == null ? null : ScriptRuntime.toObject(scriptable, object2); scriptable4 != null; scriptable4 = scriptable4.getParentScope()) {
            if (scriptable4 != scriptable3) continue;
            throw Context.reportRuntimeError1("msg.cyclic.value", "__parent__");
        }
        scriptable3.setParentScope(scriptable2);
        return scriptable2;
    }

    public static Object setProp(Object object, String string, Object object2, Scriptable scriptable) {
        if (object == null || object == Undefined.instance) {
            throw ScriptRuntime.undefWriteError(object, string, object2);
        }
        Scriptable scriptable2 = object instanceof Scriptable ? (Scriptable)object : ScriptRuntime.toObject(scriptable, object);
        ScriptableObject.putProperty(scriptable2, string, object2);
        return object2;
    }

    private static long indexFromString(String string) {
        int n = string.length();
        if (n > 0) {
            int n2 = 0;
            boolean bl = false;
            int n3 = string.charAt(0);
            if (n3 == 45 && n > 1) {
                n3 = string.charAt(1);
                n2 = 1;
                bl = true;
            }
            if (0 <= (n3 -= 48) && n3 <= 9 && n <= (bl ? 11 : 10)) {
                int n4 = -n3;
                int n5 = 0;
                ++n2;
                if (n4 != 0) {
                    while (n2 != n && 0 <= (n3 = string.charAt(n2) - 48) && n3 <= 9) {
                        n5 = n4;
                        n4 = 10 * n4 - n3;
                        ++n2;
                    }
                }
                if (n2 == n && (n5 > -214748364 || n5 == -214748364 && n3 <= (bl ? 8 : 7))) {
                    return 0xFFFFFFFFL & (long)(bl ? n4 : -n4);
                }
            }
        }
        return -1L;
    }

    static String getStringId(Object object) {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            int n = (int)d;
            if ((double)n == d) {
                return null;
            }
            return ScriptRuntime.toString(object);
        }
        String string = ScriptRuntime.toString(object);
        long l = ScriptRuntime.indexFromString(string);
        if (l >= 0L) {
            return null;
        }
        return string;
    }

    static int getIntId(Object object) {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            int n = (int)d;
            if ((double)n == d) {
                return n;
            }
            return 0;
        }
        String string = ScriptRuntime.toString(object);
        long l = ScriptRuntime.indexFromString(string);
        if (l >= 0L) {
            return (int)l;
        }
        return 0;
    }

    public static Object getElem(Object object, Object object2, Scriptable scriptable) {
        String string;
        int n;
        if (object2 instanceof Number) {
            double d = ((Number)object2).doubleValue();
            n = (int)d;
            string = (double)n == d ? null : ScriptRuntime.toString(object2);
        } else {
            string = object2 instanceof String ? (String)object2 : ScriptRuntime.toString(object2);
            long l = ScriptRuntime.indexFromString(string);
            if (l >= 0L) {
                n = (int)l;
                string = null;
            } else {
                n = 0;
            }
        }
        if (object == null || object == Undefined.instance) {
            String string2 = string != null ? string : Integer.toString(n);
            throw ScriptRuntime.undefReadError(object, string2);
        }
        Scriptable scriptable2 = ScriptRuntime.toObject(scriptable, object);
        if (string != null) {
            return ScriptRuntime.getStrIdElem(scriptable2, string);
        }
        return ScriptRuntime.getElem(scriptable2, n);
    }

    public static Object getElem(Scriptable scriptable, int n) {
        Object object = ScriptableObject.getProperty(scriptable, n);
        if (object != Scriptable.NOT_FOUND) {
            return object;
        }
        return Undefined.instance;
    }

    static Object getStrIdElem(Scriptable scriptable, String string) {
        Object object;
        int n = string.length();
        if (n == 9) {
            if (string.equals("__proto__")) {
                return scriptable.getPrototype();
            }
        } else if (n == 10 && string.equals("__parent__")) {
            return scriptable.getParentScope();
        }
        if ((object = ScriptableObject.getProperty(scriptable, string)) != Scriptable.NOT_FOUND) {
            return object;
        }
        return Undefined.instance;
    }

    public static Object setElem(Object object, Object object2, Object object3, Scriptable scriptable) {
        String string;
        int n;
        if (object2 instanceof Number) {
            double d = ((Number)object2).doubleValue();
            n = (int)d;
            string = (double)n == d ? null : ScriptRuntime.toString(object2);
        } else {
            string = object2 instanceof String ? (String)object2 : ScriptRuntime.toString(object2);
            long l = ScriptRuntime.indexFromString(string);
            if (l >= 0L) {
                n = (int)l;
                string = null;
            } else {
                n = 0;
            }
        }
        if (object == null || object == Undefined.instance) {
            String string2 = string != null ? string : Integer.toString(n);
            throw ScriptRuntime.undefWriteError(object, string2, object3);
        }
        Scriptable scriptable2 = object instanceof Scriptable ? (Scriptable)object : ScriptRuntime.toObject(scriptable, object);
        if (string != null) {
            return ScriptRuntime.setStrIdElem(scriptable2, string, object3, scriptable);
        }
        return ScriptRuntime.setElem(scriptable2, n, object3);
    }

    public static Object setElem(Scriptable scriptable, int n, Object object) {
        ScriptableObject.putProperty(scriptable, n, object);
        return object;
    }

    static Object setStrIdElem(Scriptable scriptable, String string, Object object, Scriptable scriptable2) {
        int n = string.length();
        if (n == 9) {
            if (string.equals("__proto__")) {
                return ScriptRuntime.setProto(scriptable, object, scriptable2);
            }
        } else if (n == 10 && string.equals("__parent__")) {
            return ScriptRuntime.setParent(scriptable, object, scriptable2);
        }
        ScriptableObject.putProperty(scriptable, string, object);
        return object;
    }

    public static Object delete(Context context, Scriptable scriptable, Object object, Object object2) {
        Scriptable scriptable2 = object instanceof Scriptable ? (Scriptable)object : ScriptRuntime.toObject(context, scriptable, object);
        String string = ScriptRuntime.getStringId(object2);
        boolean bl = string != null ? ScriptableObject.deleteProperty(scriptable2, string) : ScriptableObject.deleteProperty(scriptable2, ScriptRuntime.getIntId(object2));
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object name(Scriptable scriptable, String string) {
        Object object;
        for (Scriptable scriptable2 = scriptable; scriptable2 != null; scriptable2 = scriptable2.getParentScope()) {
            object = ScriptableObject.getProperty(scriptable2, string);
            if (object == Scriptable.NOT_FOUND) continue;
            return object;
        }
        object = ScriptRuntime.getMessage1("msg.is.not.defined", string.toString());
        throw ScriptRuntime.constructError("ReferenceError", (String)object);
    }

    public static Scriptable bind(Scriptable scriptable, String string) {
        while (!ScriptableObject.hasProperty(scriptable, string) && (scriptable = scriptable.getParentScope()) != null) {
        }
        return scriptable;
    }

    public static Scriptable getBase(Scriptable scriptable, String string) {
        Scriptable scriptable2 = ScriptRuntime.bind(scriptable, string);
        if (scriptable2 != null) {
            return scriptable2;
        }
        String string2 = ScriptRuntime.getMessage1("msg.is.not.defined", string);
        throw ScriptRuntime.constructError("ReferenceError", string2);
    }

    public static Scriptable getThis(Scriptable scriptable) {
        while (scriptable instanceof NativeWith) {
            scriptable = scriptable.getPrototype();
        }
        if (scriptable instanceof NativeCall) {
            scriptable = ScriptableObject.getTopLevelScope(scriptable);
        }
        return scriptable;
    }

    public static Object setName(Scriptable scriptable, Object object, Scriptable scriptable2, String string) {
        if (scriptable != null) {
            ScriptableObject.putProperty(scriptable, string, object);
        } else {
            scriptable = ScriptableObject.getTopLevelScope(scriptable2);
            scriptable.put(string, scriptable, object);
        }
        return object;
    }

    public static Object enumInit(Object object, Scriptable scriptable) {
        IdEnumeration idEnumeration = new IdEnumeration();
        if (object != null && object != Undefined.instance) {
            idEnumeration.obj = ScriptRuntime.toObject(scriptable, object);
            ScriptRuntime.enumChangeObject(idEnumeration);
        }
        return idEnumeration;
    }

    public static Boolean enumNext(Object object) {
        block4: {
            int n;
            IdEnumeration idEnumeration = (IdEnumeration)object;
            while (true) {
                if (idEnumeration.obj == null) {
                    return Boolean.FALSE;
                }
                if (idEnumeration.index == idEnumeration.ids.length) {
                    idEnumeration.obj = idEnumeration.obj.getPrototype();
                    ScriptRuntime.enumChangeObject(idEnumeration);
                    continue;
                }
                Object object2 = idEnumeration.ids[idEnumeration.index++];
                if (idEnumeration.used != null && idEnumeration.used.has(object2)) continue;
                if (object2 instanceof String) {
                    String string = (String)object2;
                    if (!idEnumeration.obj.has(string, idEnumeration.obj)) continue;
                    idEnumeration.currentId = string;
                    break block4;
                }
                n = ((Number)object2).intValue();
                if (idEnumeration.obj.has(n, idEnumeration.obj)) break;
            }
            idEnumeration.currentId = String.valueOf(n);
        }
        return Boolean.TRUE;
    }

    public static String enumId(Object object) {
        return ((IdEnumeration)object).currentId;
    }

    private static void enumChangeObject(IdEnumeration idEnumeration) {
        Object[] objectArray = null;
        while (idEnumeration.obj != null && (objectArray = idEnumeration.obj.getIds()).length == 0) {
            idEnumeration.obj = idEnumeration.obj.getPrototype();
        }
        if (idEnumeration.obj != null && idEnumeration.ids != null) {
            Object[] objectArray2 = idEnumeration.ids;
            int n = objectArray2.length;
            if (idEnumeration.used == null) {
                idEnumeration.used = new ObjToIntMap(n);
            }
            for (int i = 0; i != n; ++i) {
                idEnumeration.used.intern(objectArray2[i]);
            }
        }
        idEnumeration.ids = objectArray;
        idEnumeration.index = 0;
    }

    public static Object call(Context context, Object object, Object object2, Object[] objectArray) throws JavaScriptException {
        Scriptable scriptable = null;
        if (object instanceof Scriptable) {
            scriptable = ((Scriptable)object).getParentScope();
        }
        return ScriptRuntime.call(context, object, object2, objectArray, scriptable);
    }

    public static Object call(Context context, Object object, Object object2, Object[] objectArray, Scriptable scriptable) throws JavaScriptException {
        if (!(object instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.isnt.function", ScriptRuntime.toString(object));
        }
        Function function = (Function)object;
        Scriptable scriptable2 = object2 instanceof Scriptable || object2 == null ? (Scriptable)object2 : ScriptRuntime.toObject(context, scriptable, object2);
        return function.call(context, scriptable, scriptable2, objectArray);
    }

    public static Scriptable newObject(Context context, Object object, Object[] objectArray, Scriptable scriptable) throws JavaScriptException {
        if (!(object instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.isnt.function", ScriptRuntime.toString(object));
        }
        Function function = (Function)object;
        return function.construct(context, scriptable, objectArray);
    }

    public static Object callSpecial(Context context, Object object, boolean bl, Object object2, Object[] objectArray, Scriptable scriptable, Scriptable scriptable2, int n, String string, int n2) throws JavaScriptException {
        if (n == 1) {
            if (NativeGlobal.isEvalFunction(object)) {
                if (bl) {
                    throw ScriptRuntime.typeError1("msg.not.ctor", "eval");
                }
                return ScriptRuntime.evalSpecial(context, scriptable, scriptable2, objectArray, string, n2);
            }
        } else if (n == 2) {
            if (NativeWith.isWithFunction(object)) {
                if (!bl) {
                    throw Context.reportRuntimeError1("msg.only.from.new", "With");
                }
                return NativeWith.newWithSpecial(context, scriptable, objectArray);
            }
        } else {
            Kit.codeBug();
        }
        if (bl) {
            return ScriptRuntime.newObject(context, object, objectArray, scriptable);
        }
        return ScriptRuntime.call(context, object, object2, objectArray, scriptable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object evalSpecial(Context context, Scriptable scriptable, Object object, Object[] objectArray, String string, int n) throws JavaScriptException {
        Script script;
        Object object2;
        if (objectArray.length < 1) {
            return Undefined.instance;
        }
        Object object3 = objectArray[0];
        if (!(object3 instanceof String)) {
            String string2 = Context.getMessage0("msg.eval.nonstring");
            Context.reportWarning(string2);
            return object3;
        }
        if (string == null) {
            object2 = new int[1];
            string = Context.getSourcePositionFromStack(object2);
            if (string != null) {
                n = object2[0];
            } else {
                string = "";
            }
        }
        object2 = ScriptRuntime.makeUrlForGeneratedScript(true, string, n);
        int n2 = context.optimizationLevel;
        context.optimizationLevel = -1;
        try {
            script = context.compileString((String)object3, true, (String)object2, 1, null);
        }
        finally {
            context.optimizationLevel = n2;
        }
        if (script == null) {
            String string3 = Context.getMessage0("msg.syntax");
            throw new EvaluatorException(string3, string, n, null, 0);
        }
        Callable callable = (Callable)((Object)script);
        return callable.call(context, scriptable, (Scriptable)object, emptyArgs);
    }

    public static String typeof(Object object) {
        if (object == Undefined.instance) {
            return "undefined";
        }
        if (object == null) {
            return "object";
        }
        if (object instanceof Scriptable) {
            return object instanceof Function ? "function" : "object";
        }
        if (object instanceof String) {
            return "string";
        }
        if (object instanceof Number) {
            return "number";
        }
        if (object instanceof Boolean) {
            return "boolean";
        }
        throw ScriptRuntime.errorWithClassName("msg.invalid.type", object);
    }

    public static String typeofName(Scriptable scriptable, String string) {
        Scriptable scriptable2 = ScriptRuntime.bind(scriptable, string);
        if (scriptable2 == null) {
            return "undefined";
        }
        return ScriptRuntime.typeof(ScriptRuntime.getProp(scriptable2, string, scriptable));
    }

    public static Object add(Object object, Object object2) {
        if (object instanceof Number && object2 instanceof Number) {
            return new Double(((Number)object).doubleValue() + ((Number)object2).doubleValue());
        }
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(null);
        }
        if (object2 instanceof Scriptable) {
            object2 = ((Scriptable)object2).getDefaultValue(null);
        }
        if (!(object instanceof String) && !(object2 instanceof String)) {
            if (object instanceof Number && object2 instanceof Number) {
                return new Double(((Number)object).doubleValue() + ((Number)object2).doubleValue());
            }
            return new Double(ScriptRuntime.toNumber(object) + ScriptRuntime.toNumber(object2));
        }
        return ScriptRuntime.toString(object).concat(ScriptRuntime.toString(object2));
    }

    public static Object postIncrement(Object object) {
        object = object instanceof Number ? new Double(((Number)object).doubleValue() + 1.0) : new Double(ScriptRuntime.toNumber(object) + 1.0);
        return object;
    }

    public static Object postIncrement(Scriptable scriptable, String string) {
        Object object;
        for (Scriptable scriptable2 = scriptable; scriptable2 != null; scriptable2 = scriptable2.getParentScope()) {
            object = scriptable2;
            do {
                Object object2;
                if ((object2 = object.get(string, scriptable2)) == Scriptable.NOT_FOUND) continue;
                Object object3 = object2;
                if (object3 instanceof Number) {
                    object3 = new Double(((Number)object3).doubleValue() + 1.0);
                    object.put(string, scriptable2, object3);
                    return object2;
                }
                object3 = new Double(ScriptRuntime.toNumber(object3) + 1.0);
                object.put(string, scriptable2, object3);
                return new Double(ScriptRuntime.toNumber(object2));
            } while ((object = object.getPrototype()) != null);
        }
        object = ScriptRuntime.getMessage1("msg.is.not.defined", string);
        throw ScriptRuntime.constructError("ReferenceError", (String)object);
    }

    public static Object postIncrement(Object object, String string, Scriptable scriptable) {
        Scriptable scriptable2;
        Scriptable scriptable3 = scriptable2 = ScriptRuntime.toObject(scriptable, object);
        do {
            Object object2;
            if ((object2 = scriptable3.get(string, scriptable2)) == Scriptable.NOT_FOUND) continue;
            Object object3 = object2;
            if (object3 instanceof Number) {
                object3 = new Double(((Number)object3).doubleValue() + 1.0);
                scriptable3.put(string, scriptable2, object3);
                return object2;
            }
            object3 = new Double(ScriptRuntime.toNumber(object3) + 1.0);
            scriptable3.put(string, scriptable2, object3);
            return new Double(ScriptRuntime.toNumber(object2));
        } while ((scriptable3 = scriptable3.getPrototype()) != null);
        return Undefined.instance;
    }

    public static Object postIncrementElem(Object object, Object object2, Scriptable scriptable) {
        Object object3 = ScriptRuntime.getElem(object, object2, scriptable);
        if (object3 == Undefined.instance) {
            return Undefined.instance;
        }
        double d = ScriptRuntime.toNumber(object3);
        Double d2 = new Double(d + 1.0);
        ScriptRuntime.setElem(object, object2, d2, scriptable);
        return new Double(d);
    }

    public static Object postDecrementElem(Object object, Object object2, Scriptable scriptable) {
        Object object3 = ScriptRuntime.getElem(object, object2, scriptable);
        if (object3 == Undefined.instance) {
            return Undefined.instance;
        }
        double d = ScriptRuntime.toNumber(object3);
        Double d2 = new Double(d - 1.0);
        ScriptRuntime.setElem(object, object2, d2, scriptable);
        return new Double(d);
    }

    public static Object postDecrement(Object object) {
        object = object instanceof Number ? new Double(((Number)object).doubleValue() - 1.0) : new Double(ScriptRuntime.toNumber(object) - 1.0);
        return object;
    }

    public static Object postDecrement(Scriptable scriptable, String string) {
        Object object;
        for (Scriptable scriptable2 = scriptable; scriptable2 != null; scriptable2 = scriptable2.getParentScope()) {
            object = scriptable2;
            do {
                Object object2;
                if ((object2 = object.get(string, scriptable2)) == Scriptable.NOT_FOUND) continue;
                Object object3 = object2;
                if (object3 instanceof Number) {
                    object3 = new Double(((Number)object3).doubleValue() - 1.0);
                    object.put(string, scriptable2, object3);
                    return object2;
                }
                object3 = new Double(ScriptRuntime.toNumber(object3) - 1.0);
                object.put(string, scriptable2, object3);
                return new Double(ScriptRuntime.toNumber(object2));
            } while ((object = object.getPrototype()) != null);
        }
        object = ScriptRuntime.getMessage1("msg.is.not.defined", string);
        throw ScriptRuntime.constructError("ReferenceError", (String)object);
    }

    public static Object postDecrement(Object object, String string, Scriptable scriptable) {
        Scriptable scriptable2;
        Scriptable scriptable3 = scriptable2 = ScriptRuntime.toObject(scriptable, object);
        do {
            Object object2;
            if ((object2 = scriptable3.get(string, scriptable2)) == Scriptable.NOT_FOUND) continue;
            Object object3 = object2;
            if (object3 instanceof Number) {
                object3 = new Double(((Number)object3).doubleValue() - 1.0);
                scriptable3.put(string, scriptable2, object3);
                return object2;
            }
            object3 = new Double(ScriptRuntime.toNumber(object3) - 1.0);
            scriptable3.put(string, scriptable2, object3);
            return new Double(ScriptRuntime.toNumber(object2));
        } while ((scriptable3 = scriptable3.getPrototype()) != null);
        return Undefined.instance;
    }

    public static Object toPrimitive(Object object) {
        if (object == null || !(object instanceof Scriptable)) {
            return object;
        }
        Scriptable scriptable = (Scriptable)object;
        Object object2 = scriptable.getDefaultValue(null);
        if (object2 != null && object2 instanceof Scriptable) {
            throw ScriptRuntime.typeError0("msg.bad.default.value");
        }
        return object2;
    }

    private static Class getTypeOfValue(Object object) {
        if (object == null) {
            return ScriptableClass;
        }
        if (object == Undefined.instance) {
            return UndefinedClass;
        }
        if (object instanceof Number) {
            return NumberClass;
        }
        if (object instanceof Scriptable) {
            return ScriptableClass;
        }
        return object.getClass();
    }

    public static boolean eq(Object object, Object object2) {
        Object object3 = object;
        Object object4 = object2;
        while (true) {
            Class clazz;
            Class clazz2;
            if ((clazz2 = ScriptRuntime.getTypeOfValue(object)) == (clazz = ScriptRuntime.getTypeOfValue(object2))) {
                if (clazz2 == UndefinedClass) {
                    return true;
                }
                if (clazz2 == NumberClass) {
                    return ((Number)object).doubleValue() == ((Number)object2).doubleValue();
                }
                if (clazz2 == StringClass || clazz2 == BooleanClass) {
                    return object3.equals(object4);
                }
                if (clazz2 == ScriptableClass) {
                    if (object == object2) {
                        return true;
                    }
                    if (object instanceof Wrapper && object2 instanceof Wrapper) {
                        return ((Wrapper)object).unwrap() == ((Wrapper)object2).unwrap();
                    }
                    return false;
                }
                throw new RuntimeException();
            }
            if (object == null && object2 == Undefined.instance) {
                return true;
            }
            if (object == Undefined.instance && object2 == null) {
                return true;
            }
            if (clazz2 == NumberClass && clazz == StringClass) {
                return ((Number)object).doubleValue() == ScriptRuntime.toNumber(object2);
            }
            if (clazz2 == StringClass && clazz == NumberClass) {
                return ScriptRuntime.toNumber(object) == ((Number)object2).doubleValue();
            }
            if (clazz2 == BooleanClass) {
                object3 = object = new Double(ScriptRuntime.toNumber(object));
                continue;
            }
            if (clazz == BooleanClass) {
                object4 = object2 = new Double(ScriptRuntime.toNumber(object2));
                continue;
            }
            if ((clazz2 == StringClass || clazz2 == NumberClass) && clazz == ScriptableClass && object2 != null) {
                object4 = object2 = ScriptRuntime.toPrimitive(object2);
                continue;
            }
            if (clazz2 != ScriptableClass || object == null || clazz != StringClass && clazz != NumberClass) break;
            object3 = object = ScriptRuntime.toPrimitive(object);
        }
        return false;
    }

    public static Boolean eqB(Object object, Object object2) {
        if (ScriptRuntime.eq(object, object2)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean neB(Object object, Object object2) {
        if (ScriptRuntime.eq(object, object2)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static boolean shallowEq(Object object, Object object2) {
        Class clazz = ScriptRuntime.getTypeOfValue(object);
        if (clazz != ScriptRuntime.getTypeOfValue(object2)) {
            return false;
        }
        if (clazz == StringClass || clazz == BooleanClass) {
            return object.equals(object2);
        }
        if (clazz == NumberClass) {
            return ((Number)object).doubleValue() == ((Number)object2).doubleValue();
        }
        if (clazz == ScriptableClass) {
            if (object == object2) {
                return true;
            }
            if (object instanceof Wrapper && object2 instanceof Wrapper) {
                return ((Wrapper)object).unwrap() == ((Wrapper)object2).unwrap();
            }
            return false;
        }
        return clazz == UndefinedClass;
    }

    public static Boolean seqB(Object object, Object object2) {
        if (ScriptRuntime.shallowEq(object, object2)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean sneB(Object object, Object object2) {
        if (ScriptRuntime.shallowEq(object, object2)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static boolean instanceOf(Object object, Object object2, Scriptable scriptable) {
        if (!(object2 instanceof Scriptable)) {
            throw ScriptRuntime.typeError0("msg.instanceof.not.object");
        }
        if (!(object instanceof Scriptable)) {
            return false;
        }
        return ((Scriptable)object2).hasInstance((Scriptable)object);
    }

    protected static boolean jsDelegatesTo(Scriptable scriptable, Scriptable scriptable2) {
        for (Scriptable scriptable3 = scriptable.getPrototype(); scriptable3 != null; scriptable3 = scriptable3.getPrototype()) {
            if (!scriptable3.equals(scriptable2)) continue;
            return true;
        }
        return false;
    }

    public static boolean in(Object object, Object object2, Scriptable scriptable) {
        if (!(object2 instanceof Scriptable)) {
            throw ScriptRuntime.typeError0("msg.instanceof.not.object");
        }
        String string = ScriptRuntime.getStringId(object);
        return string != null ? ScriptableObject.hasProperty((Scriptable)object2, string) : ScriptableObject.hasProperty((Scriptable)object2, ScriptRuntime.getIntId(object));
    }

    public static Boolean cmp_LTB(Object object, Object object2) {
        if (ScriptRuntime.cmp_LT(object, object2) == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static int cmp_LT(Object object, Object object2) {
        if (object instanceof Number && object2 instanceof Number) {
            double d = ((Number)object).doubleValue();
            double d2 = ((Number)object2).doubleValue();
            if (d != d) {
                return 0;
            }
            if (d2 != d2) {
                return 0;
            }
            return d < d2 ? 1 : 0;
        }
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(NumberClass);
        }
        if (object2 instanceof Scriptable) {
            object2 = ((Scriptable)object2).getDefaultValue(NumberClass);
        }
        if (!(object instanceof String) || !(object2 instanceof String)) {
            double d = ScriptRuntime.toNumber(object);
            if (d != d) {
                return 0;
            }
            double d3 = ScriptRuntime.toNumber(object2);
            if (d3 != d3) {
                return 0;
            }
            return d < d3 ? 1 : 0;
        }
        return ScriptRuntime.toString(object).compareTo(ScriptRuntime.toString(object2)) < 0 ? 1 : 0;
    }

    public static Boolean cmp_LEB(Object object, Object object2) {
        if (ScriptRuntime.cmp_LE(object, object2) == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static int cmp_LE(Object object, Object object2) {
        if (object instanceof Number && object2 instanceof Number) {
            double d = ((Number)object).doubleValue();
            double d2 = ((Number)object2).doubleValue();
            if (d != d) {
                return 0;
            }
            if (d2 != d2) {
                return 0;
            }
            return d <= d2 ? 1 : 0;
        }
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(NumberClass);
        }
        if (object2 instanceof Scriptable) {
            object2 = ((Scriptable)object2).getDefaultValue(NumberClass);
        }
        if (!(object instanceof String) || !(object2 instanceof String)) {
            double d = ScriptRuntime.toNumber(object);
            if (d != d) {
                return 0;
            }
            double d3 = ScriptRuntime.toNumber(object2);
            if (d3 != d3) {
                return 0;
            }
            return d <= d3 ? 1 : 0;
        }
        return ScriptRuntime.toString(object).compareTo(ScriptRuntime.toString(object2)) <= 0 ? 1 : 0;
    }

    private static ScriptableObject getGlobal(Context context) {
        Class clazz = Kit.classOrNull("org.mozilla.javascript.tools.shell.Global");
        if (clazz != null) {
            try {
                Class[] classArray = new Class[]{ContextClass};
                Constructor constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{context};
                return (ScriptableObject)constructor.newInstance(objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return new ImporterTopLevel(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(Script script, String[] stringArray) throws JavaScriptException {
        Context context = Context.enter();
        try {
            ScriptableObject scriptableObject = ScriptRuntime.getGlobal(context);
            Object[] objectArray = new Object[stringArray.length];
            System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
            Scriptable scriptable = context.newArray((Scriptable)scriptableObject, objectArray);
            scriptableObject.defineProperty("arguments", scriptable, 2);
            script.exec(context, scriptableObject);
        }
        finally {
            Context.exit();
        }
    }

    public static void initScript(Context context, Scriptable scriptable, NativeFunction nativeFunction, Scriptable scriptable2, boolean bl) {
        String[] stringArray = nativeFunction.argNames;
        if (stringArray != null) {
            Scriptable scriptable3 = scriptable;
            if (bl) {
                scriptable3 = scriptable;
                while (scriptable3 instanceof NativeWith) {
                    scriptable3 = scriptable3.getParentScope();
                }
            }
            int n = stringArray.length;
            while (n-- != 0) {
                String string = stringArray[n];
                if (ScriptRuntime.hasProp(scriptable, string)) continue;
                if (!bl) {
                    ScriptableObject.defineProperty(scriptable, string, Undefined.instance, 4);
                    continue;
                }
                scriptable3.put(string, scriptable3, (Object)Undefined.instance);
            }
        }
    }

    public static Scriptable runScript(Script script) {
        Context context = Context.enter();
        ScriptableObject scriptableObject = ScriptRuntime.getGlobal(context);
        try {
            script.exec(context, scriptableObject);
        }
        catch (JavaScriptException javaScriptException) {
            throw new Error(javaScriptException.toString());
        }
        finally {
            Context.exit();
        }
        return scriptableObject;
    }

    public static Scriptable initVarObj(Context context, Scriptable scriptable, NativeFunction nativeFunction, Scriptable scriptable2, Object[] objectArray) {
        return new NativeCall(context, scriptable, nativeFunction, scriptable2, objectArray);
    }

    public static void popActivation(Context context) {
        NativeCall nativeCall = context.currentActivation;
        if (nativeCall != null) {
            context.currentActivation = nativeCall.caller;
            nativeCall.caller = null;
        }
    }

    public static Scriptable newCatchScope(String string, Object object) {
        NativeObject nativeObject = new NativeObject();
        ScriptableObject.putProperty((Scriptable)nativeObject, string, object);
        return nativeObject;
    }

    public static Scriptable enterWith(Object object, Scriptable scriptable) {
        return new NativeWith(scriptable, ScriptRuntime.toObject(scriptable, object));
    }

    public static Scriptable leaveWith(Scriptable scriptable) {
        return scriptable.getParentScope();
    }

    public static void setFunctionProtoAndParent(Scriptable scriptable, Function function) {
        function.setPrototype(ScriptableObject.getFunctionPrototype(scriptable));
        function.setParentScope(scriptable);
    }

    public static void initFunction(Context context, Scriptable scriptable, NativeFunction nativeFunction, int n, boolean bl) {
        String string;
        ScriptRuntime.setFunctionProtoAndParent(scriptable, nativeFunction);
        if (n == 1) {
            String string2 = nativeFunction.functionName;
            if (string2 != null && string2.length() != 0) {
                if (!bl) {
                    ScriptableObject.defineProperty(scriptable, string2, nativeFunction, 4);
                } else {
                    scriptable.put(string2, scriptable, (Object)nativeFunction);
                }
            }
        } else if (n == 3 && (string = nativeFunction.functionName) != null && string.length() != 0) {
            while (scriptable instanceof NativeWith) {
                scriptable = scriptable.getParentScope();
            }
            scriptable.put(string, scriptable, (Object)nativeFunction);
        }
    }

    static void checkDeprecated(Context context, String string) {
        int n = context.getLanguageVersion();
        if (n >= 140 || n == 0) {
            String string2 = ScriptRuntime.getMessage1("msg.deprec.ctor", string);
            if (n == 0) {
                Context.reportWarning(string2);
            } else {
                throw Context.reportRuntimeError(string2);
            }
        }
    }

    public static String getMessage0(String string) {
        return Context.getMessage0(string);
    }

    public static String getMessage1(String string, Object object) {
        return Context.getMessage1(string, object);
    }

    public static String getMessage2(String string, Object object, Object object2) {
        return Context.getMessage2(string, object, object2);
    }

    public static String getMessage(String string, Object[] objectArray) {
        return Context.getMessage(string, objectArray);
    }

    public static EcmaError constructError(String string, String string2) {
        int n = 0;
        String string3 = null;
        Context context = Context.getCurrentContext();
        if (context != null) {
            int[] nArray = new int[1];
            string3 = Context.getSourcePositionFromStack(nArray);
            n = nArray[0];
        }
        return ScriptRuntime.constructError(string, string2, string3, n, null, 0);
    }

    public static EcmaError constructError(String string, String string2, String string3, int n, String string4, int n2) {
        return new EcmaError(string, string2, string3, n, string4, n2);
    }

    public static EcmaError typeError0(String string) {
        String string2 = ScriptRuntime.getMessage0(string);
        return ScriptRuntime.constructError("TypeError", string2);
    }

    static EcmaError typeError1(String string, String string2) {
        String string3 = ScriptRuntime.getMessage1(string, string2);
        return ScriptRuntime.constructError("TypeError", string3);
    }

    static EcmaError typeError2(String string, String string2, String string3) {
        String string4 = ScriptRuntime.getMessage2(string, string2, string3);
        return ScriptRuntime.constructError("TypeError", string4);
    }

    static RuntimeException undefReadError(Object object, String string) {
        String string2 = object == null ? "msg.null.prop.read" : "msg.undef.prop.read";
        return ScriptRuntime.typeError1(string2, string);
    }

    static RuntimeException undefWriteError(Object object, String string, Object object2) {
        String string2 = object == null ? "msg.null.prop.write" : "msg.undef.prop.write";
        String string3 = object2 instanceof Scriptable ? object2.toString() : ScriptRuntime.toString(object2);
        String string4 = ScriptRuntime.getMessage2(string2, string, string3);
        return ScriptRuntime.typeError2(string2, string3, string4);
    }

    public static RegExpProxy getRegExpProxy(Context context) {
        return context.getRegExpProxy();
    }

    public static RegExpProxy checkRegExpProxy(Context context) {
        RegExpProxy regExpProxy = ScriptRuntime.getRegExpProxy(context);
        if (regExpProxy == null) {
            throw Context.reportRuntimeError0("msg.no.regexp");
        }
        return regExpProxy;
    }

    public static NativeCall getCurrentActivation(Context context) {
        return context.currentActivation;
    }

    public static void setCurrentActivation(Context context, NativeCall nativeCall) {
        context.currentActivation = nativeCall;
    }

    static boolean hasProp(Scriptable scriptable, String string) {
        Scriptable scriptable2 = scriptable;
        do {
            if (!scriptable2.has(string, scriptable)) continue;
            return true;
        } while ((scriptable2 = scriptable2.getPrototype()) != null);
        return false;
    }

    static String makeUrlForGeneratedScript(boolean bl, String string, int n) {
        if (bl) {
            return string + '#' + n + "(eval)";
        }
        return string + '#' + n + "(Function)";
    }

    static boolean isGeneratedScript(String string) {
        return string.indexOf("(eval)") >= 0 || string.indexOf("(Function)") >= 0;
    }

    private static RuntimeException errorWithClassName(String string, Object object) {
        return Context.reportRuntimeError1(string, object.getClass().getName());
    }

    private static class IdEnumeration {
        Scriptable obj;
        Object[] ids;
        int index;
        ObjToIntMap used;
        String currentId;

        private IdEnumeration() {
        }
    }
}

