/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.Reader;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Decompiler;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.ParserException;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.TokenStream;

public class Parser {
    CompilerEnvirons compilerEnv;
    private TokenStream ts;
    private IRFactory nf;
    private boolean ok;
    private ScriptOrFnNode currentScriptOrFn;
    private int nestingOfWith;
    private Decompiler decompiler;
    private String encodedSource;

    public Parser(CompilerEnvirons compilerEnvirons) {
        this.compilerEnv = compilerEnvirons;
    }

    protected Decompiler createDecompiler(CompilerEnvirons compilerEnvirons) {
        return new Decompiler();
    }

    public ScriptOrFnNode parse(String string, String string2, int n) {
        this.ts = new TokenStream(this.compilerEnv, null, string, string2, n);
        try {
            return this.parse();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage());
        }
    }

    public ScriptOrFnNode parse(Reader reader, String string, int n) throws IOException {
        this.ts = new TokenStream(this.compilerEnv, reader, null, string, n);
        return this.parse();
    }

    private void mustMatchToken(int n, String string) throws IOException, ParserException {
        int n2 = this.ts.getToken();
        if (n2 != n) {
            this.reportError(string);
            this.ts.ungetToken(n2);
        }
    }

    void reportError(String string) {
        this.ok = false;
        this.ts.reportCurrentLineError(Context.getMessage0(string));
        throw new ParserException();
    }

    private ScriptOrFnNode parse() throws IOException {
        int n;
        Object object;
        int n2;
        int n3;
        block8: {
            this.decompiler = this.createDecompiler(this.compilerEnv);
            this.nf = new IRFactory(this);
            this.currentScriptOrFn = this.nf.createScript();
            this.decompiler = this.decompiler;
            n3 = this.decompiler.getCurrentOffset();
            this.encodedSource = null;
            this.decompiler.addToken(118);
            this.ok = true;
            n2 = this.ts.getLineno();
            object = this.nf.createLeaf(107);
            try {
                while (true) {
                    Object object2;
                    block9: {
                        this.ts.flags |= 0x10;
                        n = this.ts.getToken();
                        this.ts.flags &= 0xFFFFFFEF;
                        if (n <= 0) break block8;
                        if (n == 87) {
                            try {
                                object2 = this.function(1);
                                break block9;
                            }
                            catch (ParserException parserException) {
                                this.ok = false;
                                break;
                            }
                        }
                        this.ts.ungetToken(n);
                        object2 = this.statement();
                    }
                    this.nf.addChildToBack(object, object2);
                }
            }
            catch (StackOverflowError stackOverflowError) {
                String string = Context.getMessage0("mag.too.deep.parser.recursion");
                throw Context.reportRuntimeError(string, this.ts.getSourceName(), this.ts.getLineno(), null, 0);
            }
        }
        if (!this.ok) {
            return null;
        }
        this.currentScriptOrFn.setSourceName(this.ts.getSourceName());
        this.currentScriptOrFn.setBaseLineno(n2);
        this.currentScriptOrFn.setEndLineno(this.ts.getLineno());
        n = this.decompiler.getCurrentOffset();
        this.currentScriptOrFn.setEncodedSourceBounds(n3, n);
        this.nf.initScript(this.currentScriptOrFn, object);
        if (this.compilerEnv.isGeneratingSource()) {
            this.encodedSource = this.decompiler.getEncodedSource();
        }
        this.decompiler = null;
        return this.currentScriptOrFn;
    }

    public String getEncodedSource() {
        return this.encodedSource;
    }

    public boolean eof() {
        return this.ts.eof();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object parseFunctionBody() throws IOException {
        int n = this.ts.flags;
        this.ts.flags &= 0xFFFFFFF3;
        this.ts.flags |= 2;
        Object object = this.nf.createBlock(this.ts.getLineno());
        try {
            int n2;
            while ((n2 = this.ts.peekToken()) > 0 && n2 != 74) {
                Object object2;
                if (n2 == 87) {
                    this.ts.getToken();
                    object2 = this.function(1);
                } else {
                    object2 = this.statement();
                }
                this.nf.addChildToBack(object, object2);
            }
        }
        catch (ParserException parserException) {
            this.ok = false;
        }
        finally {
            this.ts.flags = n;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object function(int n) throws IOException, ParserException {
        Object object;
        int n2;
        Object object2;
        String string;
        int n3 = n;
        int n4 = this.ts.getLineno();
        Object object3 = null;
        if (this.ts.matchToken(39)) {
            string = this.ts.getString();
            if (!this.ts.matchToken(75)) {
                if (this.compilerEnv.allowMemberExprAsFunctionName) {
                    this.decompiler.addName(string);
                    Object object4 = this.nf.createName(string);
                    string = "";
                    object3 = this.memberExprTail(false, object4);
                }
                this.mustMatchToken(75, "msg.no.paren.parms");
            }
        } else if (this.ts.matchToken(75)) {
            string = "";
        } else {
            string = "";
            if (this.compilerEnv.allowMemberExprAsFunctionName) {
                object3 = this.memberExpr(false);
            }
            this.mustMatchToken(75, "msg.no.paren.parms");
        }
        if (object3 != null) {
            n3 = 2;
            this.decompiler.addToken(78);
        }
        boolean bl = this.currentScriptOrFn.type == 87;
        FunctionNode functionNode = this.nf.createFunction(string);
        if (bl) {
            functionNode.setCheckThis();
        }
        if (bl || this.nestingOfWith > 0) {
            functionNode.setIgnoreDynamicScope();
        }
        int n5 = this.currentScriptOrFn.addFunction(functionNode);
        int n6 = this.decompiler.markFunctionStart(n3, string);
        ScriptOrFnNode scriptOrFnNode = this.currentScriptOrFn;
        this.currentScriptOrFn = functionNode;
        int n7 = this.nestingOfWith;
        this.nestingOfWith = 0;
        try {
            this.decompiler.addToken(75);
            if (!this.ts.matchToken(76)) {
                boolean bl2 = true;
                do {
                    if (!bl2) {
                        this.decompiler.addToken(77);
                    }
                    bl2 = false;
                    this.mustMatchToken(39, "msg.no.parm");
                    String string2 = this.ts.getString();
                    if (functionNode.hasParamOrVar(string2)) {
                        this.ts.reportCurrentLineWarning(Context.getMessage1("msg.dup.parms", string2));
                    }
                    functionNode.addParam(string2);
                    this.decompiler.addName(string2);
                } while (this.ts.matchToken(77));
                this.mustMatchToken(76, "msg.no.paren.after.parms");
            }
            this.decompiler.addToken(76);
            this.mustMatchToken(73, "msg.no.brace.body");
            this.decompiler.addEOL(73);
            object2 = this.parseFunctionBody();
            this.mustMatchToken(74, "msg.no.brace.after.body");
            this.decompiler.addToken(74);
            n2 = this.decompiler.markFunctionEnd(n6);
            if (n != 2) {
                this.checkWellTerminatedFunction();
                if (object3 == null) {
                    this.decompiler.addToken(1);
                } else {
                    this.decompiler.addEOL(70);
                }
            }
        }
        finally {
            this.currentScriptOrFn = scriptOrFnNode;
            this.nestingOfWith = n7;
        }
        functionNode.setEncodedSourceBounds(n6, n2);
        functionNode.setSourceName(this.ts.getSourceName());
        functionNode.setBaseLineno(n4);
        functionNode.setEndLineno(this.ts.getLineno());
        if (object3 == null) {
            object = this.nf.initFunction(functionNode, n5, object2, n3);
            if (n == 3) {
                object = this.nf.createExprStatementNoReturn(object, n4);
            }
        } else {
            object = this.nf.initFunction(functionNode, n5, object2, n3);
            object = this.nf.createAssignment(object3, object);
            if (n != 2) {
                object = this.nf.createExprStatement(object, n4);
            }
        }
        return object;
    }

    private Object statements() throws IOException {
        int n;
        Object object = this.nf.createBlock(this.ts.getLineno());
        while ((n = this.ts.peekToken()) > 0 && n != 74) {
            this.nf.addChildToBack(object, this.statement());
        }
        return object;
    }

    private Object condition() throws IOException, ParserException {
        this.mustMatchToken(75, "msg.no.paren.cond");
        this.decompiler.addToken(75);
        Object object = this.expr(false);
        this.mustMatchToken(76, "msg.no.paren.after.cond");
        this.decompiler.addToken(76);
        return object;
    }

    private void checkWellTerminated() throws IOException, ParserException {
        int n = this.ts.peekTokenSameLine();
        switch (n) {
            case -1: 
            case 0: 
            case 1: 
            case 70: 
            case 74: {
                return;
            }
            case 87: {
                if (this.compilerEnv.languageVersion >= 120) break;
                return;
            }
        }
        this.reportError("msg.no.semi.stmt");
    }

    private void checkWellTerminatedFunction() throws IOException, ParserException {
        if (this.compilerEnv.languageVersion < 120) {
            return;
        }
        this.checkWellTerminated();
    }

    private String matchLabel() throws IOException, ParserException {
        int n = this.ts.getLineno();
        String string = null;
        int n2 = this.ts.peekTokenSameLine();
        if (n2 == 39) {
            this.ts.getToken();
            string = this.ts.getString();
        }
        if (n == this.ts.getLineno()) {
            this.checkWellTerminated();
        }
        return string;
    }

    private Object statement() throws IOException {
        try {
            return this.statementHelper();
        }
        catch (ParserException parserException) {
            int n;
            int n2 = this.ts.getLineno();
            while ((n = this.ts.getToken()) != 70 && n != 1 && n != 0 && n != -1) {
            }
            return this.nf.createExprStatement(this.nf.createName("error"), n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object statementHelper() throws IOException, ParserException {
        Object object = null;
        boolean bl = false;
        int n = this.ts.getToken();
        switch (n) {
            case 90: {
                bl = true;
                this.decompiler.addToken(90);
                int n2 = this.ts.getLineno();
                Object object2 = this.condition();
                this.decompiler.addEOL(73);
                Object object3 = this.statement();
                Object object4 = null;
                if (this.ts.matchToken(91)) {
                    this.decompiler.addToken(74);
                    this.decompiler.addToken(91);
                    this.decompiler.addEOL(73);
                    object4 = this.statement();
                }
                this.decompiler.addEOL(74);
                object = this.nf.createIf(object2, object3, object4, n2);
                break;
            }
            case 92: {
                bl = true;
                this.decompiler.addToken(92);
                object = this.nf.createSwitch(this.ts.getLineno());
                Object object5 = null;
                this.mustMatchToken(75, "msg.no.paren.switch");
                this.decompiler.addToken(75);
                this.nf.addChildToBack(object, this.expr(false));
                this.mustMatchToken(76, "msg.no.paren.after.switch");
                this.decompiler.addToken(76);
                this.mustMatchToken(73, "msg.no.brace.switch");
                this.decompiler.addEOL(73);
                while ((n = this.ts.getToken()) != 74 && n != 0) {
                    switch (n) {
                        case 93: {
                            this.decompiler.addToken(93);
                            object5 = this.nf.createUnary(93, this.expr(false));
                            this.decompiler.addEOL(81);
                            break;
                        }
                        case 94: {
                            object5 = this.nf.createLeaf(94);
                            this.decompiler.addToken(94);
                            this.decompiler.addEOL(81);
                            break;
                        }
                        default: {
                            this.reportError("msg.bad.switch");
                        }
                    }
                    this.mustMatchToken(81, "msg.no.colon.case");
                    Object object6 = this.nf.createLeaf(107);
                    while ((n = this.ts.peekToken()) != 74 && n != 93 && n != 94 && n != 0) {
                        this.nf.addChildToBack(object6, this.statement());
                    }
                    this.nf.addChildToBack(object5, object6);
                    this.nf.addChildToBack(object, object5);
                }
                this.decompiler.addEOL(74);
                break;
            }
            case 95: {
                bl = true;
                this.decompiler.addToken(95);
                int n3 = this.ts.getLineno();
                Object object7 = this.condition();
                this.decompiler.addEOL(73);
                Object object8 = this.statement();
                this.decompiler.addEOL(74);
                object = this.nf.createWhile(object7, object8, n3);
                break;
            }
            case 96: {
                this.decompiler.addToken(96);
                this.decompiler.addEOL(73);
                int n4 = this.ts.getLineno();
                Object object9 = this.statement();
                this.decompiler.addToken(74);
                this.mustMatchToken(95, "msg.no.while.do");
                this.decompiler.addToken(95);
                Object object10 = this.condition();
                object = this.nf.createDoWhile(object9, object10, n4);
                break;
            }
            case 97: {
                Object object11;
                Object object12;
                bl = true;
                this.decompiler.addToken(97);
                int n5 = this.ts.getLineno();
                Object object13 = null;
                this.mustMatchToken(75, "msg.no.paren.for");
                this.decompiler.addToken(75);
                n = this.ts.peekToken();
                if (n == 70) {
                    object12 = this.nf.createLeaf(106);
                } else if (n == 100) {
                    this.ts.getToken();
                    object12 = this.variables(true);
                } else {
                    object12 = this.expr(true);
                }
                if (this.ts.matchToken(54)) {
                    this.decompiler.addToken(54);
                    object11 = this.expr(false);
                } else {
                    this.mustMatchToken(70, "msg.no.semi.for");
                    this.decompiler.addToken(70);
                    object11 = this.ts.peekToken() == 70 ? this.nf.createLeaf(106) : this.expr(false);
                    this.mustMatchToken(70, "msg.no.semi.for.cond");
                    this.decompiler.addToken(70);
                    object13 = this.ts.peekToken() == 76 ? this.nf.createLeaf(106) : this.expr(false);
                }
                this.mustMatchToken(76, "msg.no.paren.for.ctrl");
                this.decompiler.addToken(76);
                this.decompiler.addEOL(73);
                Object object14 = this.statement();
                this.decompiler.addEOL(74);
                if (object13 == null) {
                    object = this.nf.createForIn(object12, object11, object14, n5);
                    break;
                }
                object = this.nf.createFor(object12, object11, object13, object14, n5);
                break;
            }
            case 69: {
                int n6 = this.ts.getLineno();
                Object object15 = null;
                Object object16 = null;
                bl = true;
                this.decompiler.addToken(69);
                this.decompiler.addEOL(73);
                Object object17 = this.statement();
                this.decompiler.addEOL(74);
                object15 = this.nf.createLeaf(107);
                boolean bl2 = false;
                int n7 = this.ts.peekToken();
                if (n7 == 102) {
                    while (this.ts.matchToken(102)) {
                        if (bl2) {
                            this.reportError("msg.catch.unreachable");
                        }
                        this.decompiler.addToken(102);
                        this.mustMatchToken(75, "msg.no.paren.catch");
                        this.decompiler.addToken(75);
                        this.mustMatchToken(39, "msg.bad.catchcond");
                        String string = this.ts.getString();
                        this.decompiler.addName(string);
                        Object object18 = null;
                        if (this.ts.matchToken(90)) {
                            this.decompiler.addToken(90);
                            object18 = this.expr(false);
                        } else {
                            bl2 = true;
                        }
                        this.mustMatchToken(76, "msg.bad.catchcond");
                        this.decompiler.addToken(76);
                        this.mustMatchToken(73, "msg.no.brace.catchblock");
                        this.decompiler.addEOL(73);
                        this.nf.addChildToBack(object15, this.nf.createCatch(string, object18, this.statements(), this.ts.getLineno()));
                        this.mustMatchToken(74, "msg.no.brace.after.body");
                        this.decompiler.addEOL(74);
                    }
                } else if (n7 != 103) {
                    this.mustMatchToken(103, "msg.try.no.catchfinally");
                }
                if (this.ts.matchToken(103)) {
                    this.decompiler.addToken(103);
                    this.decompiler.addEOL(73);
                    object16 = this.statement();
                    this.decompiler.addEOL(74);
                }
                object = this.nf.createTryCatchFinally(object17, object15, object16, n6);
                break;
            }
            case 53: {
                int n8 = this.ts.getLineno();
                this.decompiler.addToken(53);
                object = this.nf.createThrow(this.expr(false), n8);
                if (n8 != this.ts.getLineno()) break;
                this.checkWellTerminated();
                break;
            }
            case 98: {
                int n9 = this.ts.getLineno();
                this.decompiler.addToken(98);
                String string = this.matchLabel();
                if (string != null) {
                    this.decompiler.addName(string);
                }
                object = this.nf.createBreak(string, n9);
                break;
            }
            case 99: {
                int n10 = this.ts.getLineno();
                this.decompiler.addToken(99);
                String string = this.matchLabel();
                if (string != null) {
                    this.decompiler.addName(string);
                }
                object = this.nf.createContinue(string, n10);
                break;
            }
            case 101: {
                Object object19;
                bl = true;
                this.decompiler.addToken(101);
                int n11 = this.ts.getLineno();
                this.mustMatchToken(75, "msg.no.paren.with");
                this.decompiler.addToken(75);
                Object object20 = this.expr(false);
                this.mustMatchToken(76, "msg.no.paren.after.with");
                this.decompiler.addToken(76);
                this.decompiler.addEOL(73);
                ++this.nestingOfWith;
                try {
                    object19 = this.statement();
                }
                finally {
                    --this.nestingOfWith;
                }
                this.decompiler.addEOL(74);
                object = this.nf.createWith(object20, object19, n11);
                break;
            }
            case 100: {
                int n12 = this.ts.getLineno();
                object = this.variables(false);
                if (this.ts.getLineno() != n12) break;
                this.checkWellTerminated();
                break;
            }
            case 5: {
                Object object21 = null;
                this.decompiler.addToken(5);
                if ((this.ts.flags & 2) == 0) {
                    this.reportError("msg.bad.return");
                }
                this.ts.flags |= 0x10;
                n = this.ts.peekTokenSameLine();
                this.ts.flags &= ~16;
                int n13 = this.ts.getLineno();
                if (n != 0 && n != 1 && n != 70 && n != 74) {
                    object21 = this.expr(false);
                    if (this.ts.getLineno() == n13) {
                        this.checkWellTerminated();
                    }
                    this.ts.flags |= 4;
                } else {
                    this.ts.flags |= 8;
                }
                object = this.nf.createReturn(object21, n13);
                break;
            }
            case 73: {
                bl = true;
                object = this.statements();
                this.mustMatchToken(74, "msg.no.brace.block");
                break;
            }
            case -1: 
            case 1: 
            case 70: {
                object = this.nf.createLeaf(106);
                bl = true;
                break;
            }
            case 87: {
                object = this.function(3);
                break;
            }
            default: {
                int n14 = n;
                int n15 = this.ts.getTokenno();
                this.ts.ungetToken(n);
                int n16 = this.ts.getLineno();
                object = this.expr(false);
                if (this.ts.peekToken() == 81) {
                    if (n14 != 39 || this.ts.getTokenno() != n15) {
                        this.reportError("msg.bad.label");
                    }
                    this.ts.getToken();
                    String string = this.ts.getString();
                    object = this.nf.createLabel(string, n16);
                    this.decompiler.addEOL(81);
                    return object;
                }
                object = this.nf.createExprStatement(object, n16);
                if (this.ts.getLineno() != n16) break;
                this.checkWellTerminated();
                break;
            }
        }
        this.ts.matchToken(70);
        if (!bl) {
            this.decompiler.addEOL(70);
        }
        return object;
    }

    private Object variables(boolean bl) throws IOException, ParserException {
        Object object = this.nf.createVariables(this.ts.getLineno());
        boolean bl2 = true;
        this.decompiler.addToken(100);
        do {
            this.mustMatchToken(39, "msg.bad.var");
            String string = this.ts.getString();
            if (!bl2) {
                this.decompiler.addToken(77);
            }
            bl2 = false;
            this.decompiler.addName(string);
            this.currentScriptOrFn.addVar(string);
            Object object2 = this.nf.createName(string);
            if (this.ts.matchToken(78)) {
                this.decompiler.addToken(78);
                Object object3 = this.assignExpr(bl);
                this.nf.addChildToBack(object2, object3);
            }
            this.nf.addChildToBack(object, object2);
        } while (this.ts.matchToken(77));
        return object;
    }

    private Object expr(boolean bl) throws IOException, ParserException {
        Object object = this.assignExpr(bl);
        while (this.ts.matchToken(77)) {
            this.decompiler.addToken(77);
            object = this.nf.createBinary(77, object, this.assignExpr(bl));
        }
        return object;
    }

    private Object assignExpr(boolean bl) throws IOException, ParserException {
        Object object = this.condExpr(bl);
        int n = this.ts.peekToken();
        if (n == 78) {
            this.ts.getToken();
            this.decompiler.addToken(78);
            object = this.nf.createAssignment(object, this.assignExpr(bl));
        } else if (n == 79) {
            this.ts.getToken();
            int n2 = this.ts.getOp();
            this.decompiler.addAssignOp(n2);
            object = this.nf.createAssignmentOp(n2, object, this.assignExpr(bl));
        }
        return object;
    }

    private Object condExpr(boolean bl) throws IOException, ParserException {
        Object object = this.orExpr(bl);
        if (this.ts.matchToken(80)) {
            this.decompiler.addToken(80);
            Object object2 = this.assignExpr(false);
            this.mustMatchToken(81, "msg.no.colon.cond");
            this.decompiler.addToken(81);
            Object object3 = this.assignExpr(bl);
            return this.nf.createCondExpr(object, object2, object3);
        }
        return object;
    }

    private Object orExpr(boolean bl) throws IOException, ParserException {
        Object object = this.andExpr(bl);
        if (this.ts.matchToken(82)) {
            this.decompiler.addToken(82);
            object = this.nf.createBinary(82, object, this.orExpr(bl));
        }
        return object;
    }

    private Object andExpr(boolean bl) throws IOException, ParserException {
        Object object = this.bitOrExpr(bl);
        if (this.ts.matchToken(83)) {
            this.decompiler.addToken(83);
            object = this.nf.createBinary(83, object, this.andExpr(bl));
        }
        return object;
    }

    private Object bitOrExpr(boolean bl) throws IOException, ParserException {
        Object object = this.bitXorExpr(bl);
        while (this.ts.matchToken(10)) {
            this.decompiler.addToken(10);
            object = this.nf.createBinary(10, object, this.bitXorExpr(bl));
        }
        return object;
    }

    private Object bitXorExpr(boolean bl) throws IOException, ParserException {
        Object object = this.bitAndExpr(bl);
        while (this.ts.matchToken(11)) {
            this.decompiler.addToken(11);
            object = this.nf.createBinary(11, object, this.bitAndExpr(bl));
        }
        return object;
    }

    private Object bitAndExpr(boolean bl) throws IOException, ParserException {
        Object object = this.eqExpr(bl);
        while (this.ts.matchToken(12)) {
            this.decompiler.addToken(12);
            object = this.nf.createBinary(12, object, this.eqExpr(bl));
        }
        return object;
    }

    private Object eqExpr(boolean bl) throws IOException, ParserException {
        Object object = this.relExpr(bl);
        block9: while (true) {
            int n = this.ts.peekToken();
            switch (n) {
                case 13: 
                case 14: 
                case 48: 
                case 49: {
                    this.ts.getToken();
                    int n2 = n;
                    int n3 = n;
                    if (this.compilerEnv.languageVersion == 120) {
                        switch (n) {
                            case 13: {
                                n3 = 48;
                                break;
                            }
                            case 14: {
                                n3 = 49;
                                break;
                            }
                            case 48: {
                                n2 = 13;
                                break;
                            }
                            case 49: {
                                n2 = 14;
                            }
                        }
                    }
                    this.decompiler.addToken(n2);
                    object = this.nf.createBinary(n3, object, this.relExpr(bl));
                    continue block9;
                }
            }
            break;
        }
        return object;
    }

    private Object relExpr(boolean bl) throws IOException, ParserException {
        Object object = this.shiftExpr();
        block4: while (true) {
            int n = this.ts.peekToken();
            switch (n) {
                case 54: {
                    if (bl) break block4;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 55: {
                    this.ts.getToken();
                    this.decompiler.addToken(n);
                    object = this.nf.createBinary(n, object, this.shiftExpr());
                    continue block4;
                }
            }
            break;
        }
        return object;
    }

    private Object shiftExpr() throws IOException, ParserException {
        Object object = this.addExpr();
        block3: while (true) {
            int n = this.ts.peekToken();
            switch (n) {
                case 19: 
                case 20: 
                case 21: {
                    this.ts.getToken();
                    this.decompiler.addToken(n);
                    object = this.nf.createBinary(n, object, this.addExpr());
                    continue block3;
                }
            }
            break;
        }
        return object;
    }

    private Object addExpr() throws IOException, ParserException {
        int n;
        Object object = this.mulExpr();
        while ((n = this.ts.peekToken()) == 22 || n == 23) {
            this.ts.getToken();
            this.decompiler.addToken(n);
            object = this.nf.createBinary(n, object, this.mulExpr());
        }
        return object;
    }

    private Object mulExpr() throws IOException, ParserException {
        Object object = this.unaryExpr();
        block3: while (true) {
            int n = this.ts.peekToken();
            switch (n) {
                case 24: 
                case 25: 
                case 26: {
                    this.ts.getToken();
                    this.decompiler.addToken(n);
                    object = this.nf.createBinary(n, object, this.unaryExpr());
                    continue block3;
                }
            }
            break;
        }
        return object;
    }

    private Object unaryExpr() throws IOException, ParserException {
        this.ts.flags |= 0x10;
        int n = this.ts.getToken();
        this.ts.flags &= ~16;
        switch (n) {
            case 27: 
            case 28: 
            case 33: 
            case 104: {
                this.decompiler.addToken(n);
                return this.nf.createUnary(n, this.unaryExpr());
            }
            case 22: {
                this.decompiler.addToken(29);
                return this.nf.createUnary(29, this.unaryExpr());
            }
            case 23: {
                this.decompiler.addToken(30);
                return this.nf.createUnary(30, this.unaryExpr());
            }
            case 84: 
            case 85: {
                this.decompiler.addToken(n);
                return this.nf.createIncDec(n, false, this.memberExpr(true));
            }
            case 32: {
                this.decompiler.addToken(32);
                return this.nf.createUnary(32, this.unaryExpr());
            }
            case -1: {
                break;
            }
            default: {
                this.ts.ungetToken(n);
                int n2 = this.ts.getLineno();
                Object object = this.memberExpr(true);
                int n3 = this.ts.peekToken();
                if ((n3 == 84 || n3 == 85) && this.ts.getLineno() == n2) {
                    int n4 = this.ts.getToken();
                    this.decompiler.addToken(n4);
                    return this.nf.createIncDec(n4, true, object);
                }
                return object;
            }
        }
        return this.nf.createName("err");
    }

    private Object argumentList(Object object) throws IOException, ParserException {
        this.ts.flags |= 0x10;
        boolean bl = this.ts.matchToken(76);
        this.ts.flags &= ~16;
        if (!bl) {
            boolean bl2 = true;
            do {
                if (!bl2) {
                    this.decompiler.addToken(77);
                }
                bl2 = false;
                this.nf.addChildToBack(object, this.assignExpr(false));
            } while (this.ts.matchToken(77));
            this.mustMatchToken(76, "msg.no.paren.arg");
        }
        this.decompiler.addToken(76);
        return object;
    }

    private Object memberExpr(boolean bl) throws IOException, ParserException {
        Object object;
        this.ts.flags |= 0x10;
        int n = this.ts.peekToken();
        this.ts.flags &= ~16;
        if (n == 31) {
            this.ts.getToken();
            this.decompiler.addToken(31);
            object = this.nf.createLeaf(31);
            this.nf.addChildToBack(object, this.memberExpr(false));
            if (this.ts.matchToken(75)) {
                this.decompiler.addToken(75);
                object = this.argumentList(object);
            }
            if ((n = this.ts.peekToken()) == 73) {
                this.nf.addChildToBack(object, this.primaryExpr());
            }
        } else {
            object = this.primaryExpr();
        }
        return this.memberExprTail(bl, object);
    }

    private Object memberExprTail(boolean bl, Object object) throws IOException, ParserException {
        int n;
        while ((n = this.ts.getToken()) > 0) {
            if (n == 86) {
                this.decompiler.addToken(86);
                this.mustMatchToken(39, "msg.no.name.after.dot");
                String string = this.ts.getString();
                this.decompiler.addName(string);
                object = this.nf.createBinary(86, object, this.nf.createName(this.ts.getString()));
                continue;
            }
            if (n == 71) {
                this.decompiler.addToken(71);
                object = this.nf.createBinary(71, object, this.expr(false));
                this.mustMatchToken(72, "msg.no.bracket.index");
                this.decompiler.addToken(72);
                continue;
            }
            if (bl && n == 75) {
                object = this.nf.createUnary(38, object);
                this.decompiler.addToken(75);
                object = this.argumentList(object);
                continue;
            }
            this.ts.ungetToken(n);
            break;
        }
        return object;
    }

    private Object primaryExpr() throws IOException, ParserException {
        this.ts.flags |= 0x10;
        int n = this.ts.getToken();
        this.ts.flags &= ~16;
        switch (n) {
            case 87: {
                return this.function(2);
            }
            case 71: {
                this.decompiler.addToken(71);
                Object object = this.nf.createLeaf(108);
                this.ts.flags |= 0x10;
                boolean bl = this.ts.matchToken(72);
                this.ts.flags &= ~16;
                if (!bl) {
                    boolean bl2 = true;
                    do {
                        this.ts.flags |= 0x10;
                        n = this.ts.peekToken();
                        this.ts.flags &= ~16;
                        if (!bl2) {
                            this.decompiler.addToken(77);
                        } else {
                            bl2 = false;
                        }
                        if (n == 72) break;
                        if (n == 77) {
                            this.nf.addChildToBack(object, this.nf.createLeaf(61));
                            continue;
                        }
                        this.nf.addChildToBack(object, this.assignExpr(false));
                    } while (this.ts.matchToken(77));
                    this.mustMatchToken(72, "msg.no.bracket.arg");
                }
                this.decompiler.addToken(72);
                return this.nf.createArrayLiteral(object);
            }
            case 73: {
                Object object = this.nf.createLeaf(109);
                this.decompiler.addToken(73);
                if (!this.ts.matchToken(74)) {
                    boolean bl = true;
                    block19: do {
                        Object object2;
                        if (!bl) {
                            this.decompiler.addToken(77);
                        } else {
                            bl = false;
                        }
                        n = this.ts.getToken();
                        switch (n) {
                            case 39: 
                            case 41: {
                                String string = this.ts.getString();
                                this.decompiler.addName(string);
                                object2 = this.nf.createString(this.ts.getString());
                                break;
                            }
                            case 40: {
                                double d = this.ts.getNumber();
                                this.decompiler.addNumber(d);
                                object2 = this.nf.createNumber(d);
                                break;
                            }
                            case 74: {
                                this.ts.ungetToken(n);
                                break block19;
                            }
                            default: {
                                this.reportError("msg.bad.prop");
                                break block19;
                            }
                        }
                        this.mustMatchToken(81, "msg.no.colon.prop");
                        this.decompiler.addToken(109);
                        this.nf.addChildToBack(object, object2);
                        this.nf.addChildToBack(object, this.assignExpr(false));
                    } while (this.ts.matchToken(77));
                    this.mustMatchToken(74, "msg.no.brace.prop");
                }
                this.decompiler.addToken(74);
                return this.nf.createObjectLiteral(object);
            }
            case 75: {
                this.decompiler.addToken(75);
                Object object = this.expr(false);
                this.decompiler.addToken(76);
                this.mustMatchToken(76, "msg.no.paren");
                return object;
            }
            case 39: {
                String string = this.ts.getString();
                this.decompiler.addName(string);
                return this.nf.createName(string);
            }
            case 40: {
                double d = this.ts.getNumber();
                this.decompiler.addNumber(d);
                return this.nf.createNumber(d);
            }
            case 41: {
                String string = this.ts.getString();
                this.decompiler.addString(string);
                return this.nf.createString(string);
            }
            case 50: {
                String string = this.ts.regExpFlags;
                this.ts.regExpFlags = null;
                String string2 = this.ts.getString();
                this.decompiler.addRegexp(string2, string);
                int n2 = this.currentScriptOrFn.addRegexp(string2, string);
                return this.nf.createRegExp(n2);
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                this.decompiler.addToken(n);
                return this.nf.createLeaf(n);
            }
            case 105: {
                this.reportError("msg.reserved.id");
                break;
            }
            case -1: {
                break;
            }
            default: {
                this.reportError("msg.syntax");
            }
        }
        return null;
    }
}

