/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Method;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class NativeJavaMethod
extends BaseFunction {
    private static final int PREFERENCE_EQUAL = 0;
    private static final int PREFERENCE_FIRST_ARG = 1;
    private static final int PREFERENCE_SECOND_ARG = 2;
    private static final int PREFERENCE_AMBIGUOUS = 3;
    private static final boolean debug = false;
    MemberBox[] methods;

    NativeJavaMethod(MemberBox[] memberBoxArray) {
        this.functionName = memberBoxArray[0].getName();
        this.methods = memberBoxArray;
    }

    NativeJavaMethod(MemberBox memberBox, String string) {
        this.functionName = string;
        this.methods = new MemberBox[]{memberBox};
    }

    public NativeJavaMethod(Method method, String string) {
        this(new MemberBox(method, null), string);
    }

    private static String scriptSignature(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Boolean) {
            return "boolean";
        }
        if (object instanceof String) {
            return "string";
        }
        if (object instanceof Number) {
            return "number";
        }
        if (object instanceof Scriptable) {
            if (object instanceof Undefined) {
                return "undefined";
            }
            if (object instanceof Wrapper) {
                Object object2 = ((Wrapper)object).unwrap();
                return object2.getClass().getName();
            }
            if (object instanceof Function) {
                return "function";
            }
            return "object";
        }
        return JavaMembers.javaSignature(object.getClass());
    }

    static String scriptSignature(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(NativeJavaMethod.scriptSignature(objectArray[i]));
        }
        return stringBuffer.toString();
    }

    String decompile(int n, int n2) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = bl = 0 != (n2 & 1);
        if (!bl) {
            stringBuffer.append("function ");
            stringBuffer.append(this.getFunctionName());
            stringBuffer.append("() {");
        }
        stringBuffer.append("/*\n");
        this.toString(stringBuffer);
        stringBuffer.append(bl ? "*/\n" : "*/}\n");
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toString(stringBuffer);
        return stringBuffer.toString();
    }

    private void toString(StringBuffer stringBuffer) {
        int n = this.methods.length;
        for (int i = 0; i != n; ++i) {
            Method method = this.methods[i].method();
            stringBuffer.append(JavaMembers.javaSignature(method.getReturnType()));
            stringBuffer.append(' ');
            stringBuffer.append(method.getName());
            stringBuffer.append(JavaMembers.liveConnectSignature(this.methods[i].argTypes));
            stringBuffer.append('\n');
        }
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        Object object;
        Object object2;
        Object object3;
        if (this.methods.length == 0) {
            throw new RuntimeException("No methods defined for call");
        }
        int n = NativeJavaMethod.findFunction(context, this.methods, objectArray);
        if (n < 0) {
            Class<?> clazz = this.methods[0].method().getDeclaringClass();
            String string = clazz.getName() + '.' + this.functionName + '(' + NativeJavaMethod.scriptSignature(objectArray) + ')';
            throw Context.reportRuntimeError1("msg.java.no_such_method", string);
        }
        MemberBox memberBox = this.methods[n];
        Class[] classArray = memberBox.argTypes;
        Object[] objectArray2 = objectArray;
        for (int i = 0; i < objectArray.length; ++i) {
            object3 = objectArray[i];
            object2 = NativeJavaObject.coerceType(classArray[i], object3, true);
            if (object2 == object3) continue;
            if (objectArray2 == objectArray) {
                objectArray = (Object[])objectArray.clone();
            }
            objectArray[i] = object2;
        }
        if (memberBox.isStatic()) {
            object = null;
        } else {
            object3 = scriptable2;
            object2 = memberBox.getDeclaringClass();
            while (true) {
                if (object3 == null) {
                    throw Context.reportRuntimeError3("msg.nonjava.method", this.functionName, ScriptRuntime.toString(scriptable2), ((Class)object2).getName());
                }
                if (object3 instanceof Wrapper && ((Class)object2).isInstance(object = ((Wrapper)object3).unwrap())) break;
                object3 = object3.getPrototype();
            }
        }
        object3 = memberBox.invoke(object, objectArray);
        object2 = memberBox.method().getReturnType();
        Object object4 = context.getWrapFactory().wrap(context, scriptable, object3, (Class)object2);
        if (object4 == Undefined.instance) {
            return object4;
        }
        if (object4 == null && object2 == Void.TYPE) {
            return Undefined.instance;
        }
        return object4;
    }

    static int findFunction(Context context, MemberBox[] memberBoxArray, Object[] objectArray) {
        Object object;
        int n;
        if (memberBoxArray.length == 0) {
            return -1;
        }
        if (memberBoxArray.length == 1) {
            MemberBox memberBox = memberBoxArray[0];
            Class[] classArray = memberBox.argTypes;
            int n2 = classArray.length;
            if (n2 != objectArray.length) {
                return -1;
            }
            for (int i = 0; i != n2; ++i) {
                if (NativeJavaObject.canConvert(objectArray[i], classArray[i])) continue;
                return -1;
            }
            return 0;
        }
        int n3 = -1;
        Class[] classArray = null;
        int[] nArray = null;
        int n4 = 0;
        for (n = 0; n < memberBoxArray.length; ++n) {
            int n5;
            MemberBox memberBox = memberBoxArray[n];
            Class[] classArray2 = memberBox.argTypes;
            if (classArray2.length != objectArray.length) continue;
            if (n3 < 0) {
                for (n5 = 0; n5 < classArray2.length && NativeJavaObject.canConvert(objectArray[n5], classArray2[n5]); ++n5) {
                }
                if (n5 != classArray2.length) continue;
                n3 = n;
                classArray = classArray2;
                continue;
            }
            n5 = NativeJavaMethod.preferSignature(objectArray, classArray2, classArray);
            if (n5 == 3) {
                if (nArray == null) {
                    nArray = new int[memberBoxArray.length];
                }
                nArray[n4++] = n;
                continue;
            }
            if (n5 == 1) {
                n3 = n;
                classArray = classArray2;
                continue;
            }
            if (n5 == 2) continue;
            if (n5 != 0) {
                Kit.codeBug();
            }
            if (!((MemberBox)(object = memberBoxArray[n3])).isStatic() || !((MemberBox)object).getDeclaringClass().isAssignableFrom(memberBox.getDeclaringClass())) continue;
            n3 = n;
            classArray = classArray2;
        }
        if (n4 == 0) {
            return n3;
        }
        n = 0;
        for (int i = 0; i != n4; ++i) {
            void var9_16 = nArray[i];
            MemberBox memberBox = memberBoxArray[var9_16];
            object = memberBox.argTypes;
            int n6 = NativeJavaMethod.preferSignature(objectArray, (Class[])object, classArray);
            if (n6 == 1) {
                n3 = var9_16;
                classArray = object;
                nArray[i] = -1;
                ++n;
                continue;
            }
            if (n6 != 2) continue;
            nArray[i] = -1;
            ++n;
        }
        if (n == n4) {
            return n3;
        }
        StringBuffer stringBuffer = new StringBuffer();
        nArray[n4++] = n3;
        boolean bl = true;
        for (int i = 0; i < n4; ++i) {
            int n7 = nArray[i];
            if (n7 < 0) continue;
            if (!bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(memberBoxArray[n7].toJavaDeclaration());
            bl = false;
        }
        MemberBox memberBox = memberBoxArray[n3];
        if (memberBoxArray[0].isMethod()) {
            throw Context.reportRuntimeError3("msg.constructor.ambiguous", memberBox.getName(), NativeJavaMethod.scriptSignature(objectArray), stringBuffer.toString());
        }
        throw Context.reportRuntimeError4("msg.method.ambiguous", memberBox.getDeclaringClass().getName(), memberBox.getName(), NativeJavaMethod.scriptSignature(objectArray), stringBuffer.toString());
    }

    private static int preferSignature(Object[] objectArray, Class[] classArray, Class[] classArray2) {
        Class clazz;
        Class clazz2;
        int n = 0;
        for (int i = 0; i < objectArray.length && ((clazz2 = classArray[i]) == (clazz = classArray2[i]) || (n |= NativeJavaMethod.preferConversion(objectArray[i], clazz2, clazz)) != 3); ++i) {
        }
        return n;
    }

    private static int preferConversion(Object object, Class clazz, Class clazz2) {
        int n = NativeJavaObject.getConversionWeight(object, clazz);
        int n2 = NativeJavaObject.getConversionWeight(object, clazz2);
        if (n == 0 && n2 == 0) {
            if (clazz.isAssignableFrom(clazz2)) {
                return 2;
            }
            if (clazz2.isAssignableFrom(clazz)) {
                return 1;
            }
        } else {
            if (n < n2) {
                return 1;
            }
            if (n > n2) {
                return 2;
            }
        }
        return 3;
    }

    private static void printDebug(String string, MemberBox memberBox, Object[] objectArray) {
    }
}

