/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdFunctionMaster;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UniqueTag;

public abstract class IdScriptable
extends ScriptableObject
implements IdFunctionMaster {
    private int maxId;
    private Object[] idMapData;
    private static final boolean CACHE_NAMES = true;
    private int lastIdCache;

    public boolean has(String string, Scriptable scriptable) {
        int n;
        if (this.maxId != 0 && (n = this.mapNameToId_writeCached(string)) != 0) {
            return this.hasValue(n);
        }
        return super.has(string, scriptable);
    }

    public Object get(String string, Scriptable scriptable) {
        int n;
        if (this.maxId != 0 && (n = this.mapNameToId_writeCached(string)) != 0) {
            Object[] objectArray = this.idMapData;
            if (objectArray == null) {
                return this.getIdValue(n);
            }
            Object object = objectArray[n - 1];
            if (object == null) {
                object = this.getIdValue(n);
            } else if (object == UniqueTag.NULL_VALUE) {
                object = null;
            }
            return object;
        }
        return super.get(string, scriptable);
    }

    public void put(String string, Scriptable scriptable, Object object) {
        int n;
        if (this.maxId != 0 && (n = this.mapNameToId_cached(string)) != 0) {
            if (scriptable == this && this.isSealed()) {
                throw Context.reportRuntimeError1("msg.modify.sealed", string);
            }
            int n2 = this.getIdAttributes(n);
            if ((n2 & 1) == 0) {
                if (scriptable == this) {
                    this.setIdValue(n, object);
                } else {
                    scriptable.put(string, scriptable, object);
                }
            }
            return;
        }
        super.put(string, scriptable, object);
    }

    public void delete(String string) {
        int n;
        if (this.maxId != 0 && (n = this.mapNameToId(string)) != 0 && !this.isSealed()) {
            int n2 = this.getIdAttributes(n);
            if ((n2 & 4) == 0) {
                this.deleteIdValue(n);
            }
            return;
        }
        super.delete(string);
    }

    public int getAttributes(String string) {
        int n;
        if (this.maxId != 0 && (n = this.mapNameToId(string)) != 0 && this.hasValue(n)) {
            return this.getIdAttributes(n);
        }
        return super.getAttributes(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(String string, int n) {
        int n2;
        if (this.maxId != 0 && (n2 = this.mapNameToId(string)) != 0) {
            IdScriptable idScriptable = this;
            synchronized (idScriptable) {
                if (this.hasValue(n2)) {
                    this.setIdAttributes(n2, n);
                    return;
                }
            }
        }
        super.setAttributes(string, n);
    }

    public void defineProperty(String string, Object object, int n) {
        int n2;
        if (this.maxId != 0 && (n2 = this.mapNameToId(string)) != 0) {
            int n3 = this.getIdAttributes(n2);
            if ((n3 & 1) != 0) {
                throw new RuntimeException("Attempt to redefine read-only id " + string);
            }
            this.setIdAttributes(n2, n);
            this.setIdValue(n2, object);
            return;
        }
        super.defineProperty(string, object, n);
    }

    Object[] getIds(boolean bl) {
        Object[] objectArray = super.getIds(bl);
        if (this.maxId != 0) {
            Object[] objectArray2 = null;
            int n = 0;
            for (int i = this.maxId; i != 0; --i) {
                if (!this.hasValue(i) || !bl && (this.getIdAttributes(i) & 2) != 0) continue;
                if (n == 0) {
                    objectArray2 = new Object[i];
                }
                objectArray2[n++] = this.getIdName(i);
            }
            if (n != 0) {
                if (objectArray.length == 0 && objectArray2.length == n) {
                    objectArray = objectArray2;
                } else {
                    Object[] objectArray3 = new Object[objectArray.length + n];
                    System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
                    System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, n);
                    objectArray = objectArray3;
                }
            }
        }
        return objectArray;
    }

    private int mapNameToId_cached(String string) {
        int n;
        Object[] objectArray = this.idMapData;
        if (objectArray != null && objectArray[(n = this.lastIdCache) - 1 + this.maxId] == string) {
            return n;
        }
        return this.mapNameToId(string);
    }

    private int mapNameToId_writeCached(String string) {
        Object[] objectArray = this.idMapData;
        if (objectArray != null) {
            int n = this.lastIdCache;
            if (objectArray[n - 1 + this.maxId] == string) {
                return n;
            }
            n = this.mapNameToId(string);
            if (n != 0) {
                objectArray[n - 1 + this.maxId] = string;
                this.lastIdCache = n;
            }
            return n;
        }
        return this.mapNameToId(string);
    }

    protected abstract int mapNameToId(String var1);

    protected abstract String getIdName(int var1);

    protected int getIdAttributes(int n) {
        return 2;
    }

    protected void setIdAttributes(int n, int n2) {
        int n3 = this.getIdAttributes(n);
        if (n2 != n3) {
            throw new RuntimeException("Change of attributes for this id is not supported");
        }
    }

    protected boolean hasIdValue(int n) {
        return true;
    }

    protected Object getIdValue(int n) {
        IdFunction idFunction = this.newIdFunction(n);
        idFunction.setParentScope(this.getParentScope());
        return this.cacheIdValue(n, idFunction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setIdValue(int n, Object object) {
        IdScriptable idScriptable = this;
        synchronized (idScriptable) {
            Object[] objectArray = this.ensureIdData();
            objectArray[n - 1] = object != null ? object : UniqueTag.NULL_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object cacheIdValue(int n, Object object) {
        IdScriptable idScriptable = this;
        synchronized (idScriptable) {
            Object[] objectArray = this.ensureIdData();
            Object object2 = objectArray[n - 1];
            if (object2 == null) {
                objectArray[n - 1] = object != null ? object : UniqueTag.NULL_VALUE;
            } else {
                object = object2;
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteIdValue(int n) {
        IdScriptable idScriptable = this;
        synchronized (idScriptable) {
            this.ensureIdData()[n - 1] = NOT_FOUND;
        }
    }

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        throw IdFunction.onBadMethodId(this, n);
    }

    public int methodArity(int n) {
        return -1;
    }

    protected final int getMaxId() {
        return this.maxId;
    }

    protected final void setMaxId(int n) {
        if (n < this.maxId) {
            Kit.codeBug();
        }
        this.maxId = n;
    }

    public void addAsPrototype(int n, Context context, Scriptable scriptable, boolean bl) {
        this.setMaxId(n);
        int n2 = this.mapNameToId("constructor");
        if (n2 == 0) {
            throw new RuntimeException("No id for constructor property");
        }
        IdFunction idFunction = this.newIdFunction(this.getClassName(), n2);
        idFunction.initAsConstructor(scriptable, this);
        this.fillConstructorProperties(context, idFunction, bl);
        if (bl) {
            idFunction.sealObject();
        }
        this.setParentScope(idFunction);
        this.setPrototype(IdScriptable.getObjectPrototype(scriptable));
        this.cacheIdValue(n2, idFunction);
        if (bl) {
            this.sealObject();
        }
        IdScriptable.defineProperty(scriptable, this.getClassName(), idFunction, 2);
    }

    protected void fillConstructorProperties(Context context, IdFunction idFunction, boolean bl) {
    }

    protected void addIdFunctionProperty(Scriptable scriptable, int n, boolean bl) {
        IdFunction idFunction = this.newIdFunction(n);
        if (bl) {
            idFunction.sealObject();
        }
        IdScriptable.defineProperty(scriptable, this.getIdName(n), idFunction, 2);
    }

    protected static EcmaError incompatibleCallError(IdFunction idFunction) {
        throw ScriptRuntime.typeError1("msg.incompat.call", idFunction.getFunctionName());
    }

    protected IdFunction newIdFunction(int n) {
        return this.newIdFunction(this.getIdName(n), n);
    }

    protected IdFunction newIdFunction(String string, int n) {
        IdFunction idFunction = new IdFunction(this, string, n);
        if (this.isSealed()) {
            idFunction.sealObject();
        }
        return idFunction;
    }

    protected final Object wrap_double(double d) {
        return d == d ? new Double(d) : ScriptRuntime.NaNobj;
    }

    protected final Object wrap_int(int n) {
        byte by = (byte)n;
        if (by == n) {
            return new Byte(by);
        }
        return new Integer(n);
    }

    protected final Object wrap_long(long l) {
        int n = (int)l;
        if ((long)n == l) {
            return this.wrap_int(n);
        }
        return new Long(l);
    }

    protected final Object wrap_boolean(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    private boolean hasValue(int n) {
        Object object;
        Object[] objectArray = this.idMapData;
        if (objectArray == null || (object = objectArray[n - 1]) == null) {
            return this.hasIdValue(n);
        }
        return object != NOT_FOUND;
    }

    private Object[] ensureIdData() {
        Object[] objectArray = this.idMapData;
        if (objectArray == null) {
            objectArray = new Object[this.maxId * 2];
            this.idMapData = objectArray;
        }
        return objectArray;
    }
}

